package org.freedesktop.gstreamer;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GStreamer {
    private static native void nativeInit(Context context) throws Exception;

    public static void init(Context context) throws Exception {
        nativeInit(context);
    }

    private static void copyFonts(Context context) {
        AssetManager assets = context.getAssets();
        File file = new File(context.getFilesDir(), "fontconfig");
        File file2 = new File(file, "fonts");
        File file3 = new File(file, "fonts.conf");
        file2.mkdirs();
        try {
            copyFile(assets, "fontconfig/fonts.conf", file3);
            String[] list = assets.list("fontconfig/fonts/truetype");
            for (String str : list) {
                copyFile(assets, "fontconfig/fonts/truetype/" + str, new File(file2, str));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyCaCertificates(Context context) {
        AssetManager assets = context.getAssets();
        File file = new File(new File(context.getFilesDir(), "ssl"), "certs");
        File file2 = new File(file, "ca-certificates.crt");
        file.mkdirs();
        try {
            copyFile(assets, "ssl/certs/ca-certificates.crt", file2);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyFile(AssetManager assetManager, String str, File file) throws IOException {
        byte[] bArr = new byte[1024];
        if (file.exists()) {
            file.delete();
        }
        InputStream open = assetManager.open(str);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while (true) {
            int read = open.read(bArr);
            if (read != -1) {
                fileOutputStream.write(bArr, 0, read);
            } else {
                open.close();
                fileOutputStream.flush();
                fileOutputStream.close();
                return;
            }
        }
    }
}
