package com.fishsemi.sdk.rcservice;

public class SwitchConfig extends ConfigItem {
    public SwitchConfig(int i) {
        this.mType = 1;
        this.mId = i;
    }

    public SwitchConfig(int i, int i2, int i3, int i4, int i5, int i6) {
        this.mType = 1;
        this.mId = i;
        setConfig(i2, i3, i4, i5, i6);
    }

    public SwitchConfig(ConfigItem configItem) {
        super(configItem);
    }

    public void setConfig(int i, int i2, int i3, int i4, int i5) {
        this.mSbusId = i;
        this.mChannelId = i2;
        this.mValue1 = i3;
        this.mValue2 = i4;
        this.mValue3 = i5;
    }

    public int switchId() {
        return this.mId;
    }

    public int leftValue() {
        return this.mValue1;
    }

    public int middleValue() {
        return this.mValue2;
    }

    public int rightValue() {
        return this.mValue3;
    }

    public void setLeftValue(int i) {
        this.mValue1 = i;
    }

    public void setMiddleValue(int i) {
        this.mValue2 = i;
    }

    public void setRightValue(int i) {
        this.mValue3 = i;
    }

    @Override // com.fishsemi.sdk.rcservice.ConfigItem
    public boolean configComplete() {
        return super.configComplete() && this.mValue1 >= 0 && this.mValue2 >= 0 && this.mValue3 >= 0;
    }
}
