package com.fishsemi.sdk.rcservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.fishsemi.rcservice.IRcListener;
import com.fishsemi.rcservice.IRcService;
import java.util.ArrayList;
import java.util.List;

public class RcService {
    public static final int CONFIG_TYPE_BUTTON = 0;
    public static final int CONFIG_TYPE_DIAL = 2;
    public static final int CONFIG_TYPE_SWITCH = 1;
    public static final int JOYSTICK_MODE_AMERICAN_HAND = 2;
    public static final int JOYSTICK_MODE_JAPANESE_HAND = 1;
    private static final String TAG = "RcService";
    private List<ConfigItem> mConfigItems;
    private ServiceConnection mConnection = new ServiceConnection() {
        /* class com.fishsemi.sdk.rcservice.RcService.AnonymousClass2 */

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.v(RcService.TAG, "RcService connected.");
            RcService.this.mRcService = IRcService.Stub.asInterface(iBinder);
            if (RcService.this.mRcService == null) {
                Log.v(RcService.TAG, "RcService is null!");
                return;
            }
            try {
                RcService.this.mRcService.registerRcListener(RcService.this.mRcListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                RcService.this.mConfigItems = RcService.this.mRcService.loadConfigs();
                if (RcService.this.mListener != null) {
                    RcService.this.mListener.onRcServiceReady(true);
                }
                RcService.this.mRcService.updateStatus();
            } catch (RemoteException e2) {
                e2.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.v(RcService.TAG, "RcService disconnected");
            RcService.this.mRcService = null;
            if (RcService.this.mListener != null) {
                RcService.this.mListener.onRcServiceReady(false);
            }
        }
    };
    private Context mContext;
    private Handler mHandler;
    private RcListener mListener;
    private IRcListener mRcListener;
    private IRcService mRcService = null;

    public RcService(Context context, RcListener rcListener) {
        this.mListener = rcListener;
        this.mContext = context;
        this.mHandler = new Handler(this.mContext.getMainLooper());
        this.mRcListener = new IRcListener.Stub() {
            /* class com.fishsemi.sdk.rcservice.RcService.AnonymousClass1 */

            @Override // com.fishsemi.rcservice.IRcListener
            public void onConfigChanged() throws RemoteException {
                RcService rcService = RcService.this;
                rcService.mConfigItems = rcService.mRcService.loadConfigs();
            }

            @Override // com.fishsemi.rcservice.IRcListener
            public void onSbusChannelChanged(final int i, final int i2, final int i3) throws RemoteException {
                RcService.this.mHandler.post(new Runnable() {
                    /* class com.fishsemi.sdk.rcservice.RcService.AnonymousClass1.AnonymousClass1 */

                    public void run() {
                        if (RcService.this.mListener != null) {
                            RcService.this.mHandler.post(new Runnable() {
                                /* class com.fishsemi.sdk.rcservice.RcService.AnonymousClass1.AnonymousClass1.AnonymousClass1 */

                                public void run() {
                                    RcService.this.mListener.onSbusChannelValueChanged(i, i2, i3);
                                }
                            });
                        }
                    }
                });
            }
        };
    }

    public void start() {
        bindRcService();
    }

    public void stop() {
        unbindRcService();
    }

    public int getJoystickMode() {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return 2;
        }
        try {
            return iRcService.getJoystickMode();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 2;
        }
    }

    public boolean setJoystickMode(int i) {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return false;
        }
        try {
            return iRcService.setJoystickMode(i);
        } catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getButtonCount() {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return 0;
        }
        try {
            return iRcService.getButtonCount();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getSwitchCount() {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return 0;
        }
        try {
            return iRcService.getSwitchCount();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getDialCount() {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return 0;
        }
        try {
            return iRcService.getDialCount();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public List<ButtonConfig> getButtonConfigs() {
        ArrayList arrayList = new ArrayList();
        List<ConfigItem> list = this.mConfigItems;
        if (list != null) {
            for (ConfigItem configItem : list) {
                if (configItem.type() == 0) {
                    arrayList.add(new ButtonConfig(configItem));
                }
            }
        }
        return arrayList;
    }

    public List<SwitchConfig> getSwitchConfigs() {
        ArrayList arrayList = new ArrayList();
        List<ConfigItem> list = this.mConfigItems;
        if (list != null) {
            for (ConfigItem configItem : list) {
                if (configItem.type() == 1) {
                    arrayList.add((SwitchConfig) configItem);
                }
            }
        }
        return arrayList;
    }

    public List<DialConfig> getDialConfigs() {
        ArrayList arrayList = new ArrayList();
        List<ConfigItem> list = this.mConfigItems;
        if (list != null) {
            for (ConfigItem configItem : list) {
                if (configItem.type() == 2) {
                    arrayList.add((DialConfig) configItem);
                }
            }
        }
        return arrayList;
    }

    public List<ConfigItem> getConfigs() {
        return this.mConfigItems;
    }

    public boolean setConfig(ConfigItem configItem) {
        IRcService iRcService = this.mRcService;
        if (iRcService == null) {
            return false;
        }
        try {
            return iRcService.saveConfig(configItem);
        } catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    /* access modifiers changed from: protected */
    public void bindRcService() {
        Log.d(TAG, "bindRcService");
        Intent intent = new Intent();
        intent.setClassName("com.fishsemi.rcsetting", "com.fishsemi.rcservice.RcServiceImp");
        this.mContext.bindService(intent, this.mConnection, 1);
    }

    /* access modifiers changed from: protected */
    public void unbindRcService() {
        Log.v(TAG, "unbindRcService");
        IRcService iRcService = this.mRcService;
        if (iRcService != null) {
            try {
                iRcService.unregisterRcListener(this.mRcListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.mContext.unbindService(this.mConnection);
        this.mRcService = null;
    }
}
