package com.fishsemi.sdk.rcservice;

import android.os.Parcel;
import android.os.Parcelable;

public class ConfigItem implements Parcelable {
    public static final Parcelable.Creator<ConfigItem> CREATOR = new Parcelable.Creator<ConfigItem>() {
        /* class com.fishsemi.sdk.rcservice.ConfigItem.AnonymousClass1 */

        @Override // android.os.Parcelable.Creator
        public ConfigItem createFromParcel(Parcel parcel) {
            return new ConfigItem(parcel);
        }

        @Override // android.os.Parcelable.Creator
        public ConfigItem[] newArray(int i) {
            return new ConfigItem[i];
        }
    };
    protected int mChannelId = 0;
    protected int mId = 0;
    protected String mName = null;
    protected int mReverted = 0;
    protected int mSbusId = 0;
    protected int mType = -1;
    protected int mValue1 = -1;
    protected int mValue2 = -1;
    protected int mValue3 = -1;

    public int describeContents() {
        return 0;
    }

    public ConfigItem() {
    }

    public ConfigItem(ConfigItem configItem) {
        clone(configItem);
    }

    public int type() {
        return this.mType;
    }

    public int id() {
        return this.mId;
    }

    public String name() {
        return this.mName;
    }

    public boolean reverted() {
        return this.mReverted == 1;
    }

    public int sbusId() {
        return this.mSbusId;
    }

    public int channelId() {
        return this.mChannelId;
    }

    public void setSbusId(int i) {
        this.mSbusId = i;
    }

    public void setChannelId(int i) {
        this.mChannelId = i;
    }

    public void setReverted(boolean z) {
        this.mReverted = z ? 1 : 0;
    }

    public boolean configComplete() {
        int i;
        int i2 = this.mSbusId;
        return i2 > 0 && i2 <= 2 && (i = this.mChannelId) > 0 && i <= 16;
    }

    public void clone(ConfigItem configItem) {
        this.mType = configItem.mType;
        this.mId = configItem.mId;
        this.mSbusId = configItem.mSbusId;
        this.mChannelId = configItem.mChannelId;
        this.mValue1 = configItem.mValue1;
        this.mValue2 = configItem.mValue2;
        this.mValue3 = configItem.mValue3;
        this.mReverted = configItem.mReverted;
        this.mName = configItem.mName;
    }

    protected ConfigItem(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mId = parcel.readInt();
        this.mSbusId = parcel.readInt();
        this.mChannelId = parcel.readInt();
        this.mValue1 = parcel.readInt();
        this.mValue2 = parcel.readInt();
        this.mValue3 = parcel.readInt();
        this.mReverted = parcel.readInt();
        this.mName = parcel.readString();
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mSbusId);
        parcel.writeInt(this.mChannelId);
        parcel.writeInt(this.mValue1);
        parcel.writeInt(this.mValue2);
        parcel.writeInt(this.mValue3);
        parcel.writeInt(this.mReverted);
        parcel.writeString(this.mName);
    }
}
