package com.fishsemi.sdk.rcservice;

public class ButtonConfig extends ConfigItem {
    public static final int MODE_CLICK_SET = 0;
    public static final int MODE_CLICK_TOGGLE = 1;
    public static final int MODE_PRESS_HOLD = 2;

    public ButtonConfig(int i) {
        this.mType = 0;
        this.mId = i;
    }

    public ButtonConfig(ConfigItem configItem) {
        super(configItem);
    }

    public ButtonConfig(int i, int i2, int i3, int i4, int i5, int i6) {
        this.mType = 0;
        this.mId = i;
        setConfig(i2, i3, i4, i5, i6);
    }

    public void setConfig(int i, int i2, int i3, int i4, int i5) {
        this.mSbusId = i;
        this.mChannelId = i2;
        this.mValue1 = i3;
        this.mValue2 = i4;
        this.mValue3 = i5;
    }

    public int buttonId() {
        return this.mId;
    }

    public int defaultValue() {
        return this.mValue1;
    }

    public int value() {
        return this.mValue2;
    }

    public int switchMode() {
        return this.mValue3;
    }

    public void setDefaultValue(int i) {
        this.mValue1 = i;
    }

    public void setValue(int i) {
        this.mValue2 = i;
    }

    public int setSwitchMode(int i) {
        this.mValue3 = i;
        return i;
    }

    @Override // com.fishsemi.sdk.rcservice.ConfigItem
    public boolean configComplete() {
        return super.configComplete() && this.mValue1 >= 0 && this.mValue2 >= 0 && this.mValue3 >= 0;
    }
}
