package com.fishsemi.sdk.d2dcontrol;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.d2d.ID2DInfoListener;
import com.android.internal.telephony.d2d.ID2DService;

public class D2dController {
    private static final int INVALID = Integer.MAX_VALUE;
    private static final String TAG = "D2dController";
    private int mAirMasterRsrp = 0;
    private int mAirSlaveRsrp = 0;
    private ServiceConnection mConnection = new ServiceConnection() {
        /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass2 */

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.v(D2dController.TAG, "D2DService connected");
            D2dController.this.mD2DService = ID2DService.Stub.asInterface(iBinder);
            try {
                D2dController.this.mD2DService.registerForD2dInfoChanged(D2dController.this.mD2DInfoListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                D2dController.this.mD2DService.requestGetD2dInfo();
            } catch (RemoteException e2) {
                e2.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.v(D2dController.TAG, "D2DService disconnected");
            D2dController.this.mD2DService = null;
        }
    };
    private Context mContext;
    private int mControllerMasterRsrp = 0;
    private int mControllerSlaveRsrp = 0;
    ID2DInfoListener mD2DInfoListener = new ID2DInfoListener.Stub() {
        /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1 */

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DAgcGcsChanged(int i, int i2) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DAgcUavChanged(int i, int i2) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DFrequencyListReceived() throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DInterferenceListReceived() throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DRadioPowerChanged(boolean z) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestConfigBandwidthDone(int i) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestFreqHopCtrlDone(int i) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestFreqResetDone(int i) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestGetDlFrequencyPointDone(int i, int i2) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestGetFreqHopStateDone(int i, int i2, int i3) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestSendCtrlCmdDone(int i) throws RemoteException {
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DServiceStatusChanged(ServiceState serviceState) throws RemoteException {
            Log.v(D2dController.TAG, "onD2DServiceStatusChanged: service state = " + serviceState);
            if (serviceState.getState() == 0) {
                D2dController.this.mD2DLinkConnected = true;
            } else {
                D2dController.this.mD2DLinkConnected = false;
            }
            D2dController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass1 */

                public void run() {
                    D2dController.this.mListener.onLinkConnectionChanged(D2dController.this.mD2DLinkConnected);
                }
            });
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DSignalStrengthChanged(SignalStrength signalStrength) throws RemoteException {
            try {
                int intValue = ((Integer) signalStrength.getClass().getMethod("getLteRsrq", new Class[0]).invoke(signalStrength, new Object[0])).intValue();
                int intValue2 = ((Integer) signalStrength.getClass().getMethod("getLteRsrp", new Class[0]).invoke(signalStrength, new Object[0])).intValue();
                int intValue3 = ((Integer) signalStrength.getClass().getMethod("getLteSignalStrength", new Class[0]).invoke(signalStrength, new Object[0])).intValue();
                if (intValue == D2dController.INVALID) {
                    if (intValue2 != D2dController.INVALID) {
                        D2dController.this.mAirMasterRsrp = intValue2;
                    }
                    if (intValue3 != 99) {
                        D2dController.this.mAirSlaveRsrp = intValue3 * -1;
                    }
                    if (D2dController.this.mD2DLinkConnected) {
                        D2dController.this.mHandler.post(new Runnable() {
                            /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass2 */

                            public void run() {
                                D2dController.this.mListener.onAirSignalChanged(D2dController.this.mAirMasterRsrp, D2dController.this.mAirSlaveRsrp);
                            }
                        });
                        return;
                    }
                    return;
                }
                if (intValue2 != D2dController.INVALID) {
                    D2dController.this.mControllerMasterRsrp = intValue2;
                }
                if (intValue3 != 99) {
                    D2dController.this.mControllerSlaveRsrp = intValue3 * -1;
                }
                if (D2dController.this.mD2DLinkConnected) {
                    D2dController.this.mHandler.post(new Runnable() {
                        /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass3 */

                        public void run() {
                            D2dController.this.mListener.onControllerSignalChanged(D2dController.this.mControllerMasterRsrp, D2dController.this.mControllerSlaveRsrp);
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DULSpeedChanged(final int i, final int i2) throws RemoteException {
            if (D2dController.this.mD2DLinkConnected) {
                D2dController.this.mHandler.post(new Runnable() {
                    /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass4 */

                    public void run() {
                        D2dController.this.mListener.onSpeedChanged(i, i2);
                    }
                });
            }
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DSnrGcsChanged(final int i, final int i2) throws RemoteException {
            if (D2dController.this.mD2DLinkConnected) {
                D2dController.this.mHandler.post(new Runnable() {
                    /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass5 */

                    public void run() {
                        D2dController.this.mListener.onControllerSnrChanged(i, i2);
                    }
                });
            }
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DSnrUavChanged(final int i, final int i2) throws RemoteException {
            if (D2dController.this.mD2DLinkConnected) {
                D2dController.this.mHandler.post(new Runnable() {
                    /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass6 */

                    public void run() {
                        D2dController.this.mListener.onAirSnrChanged(i, i2);
                    }
                });
            }
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onD2DDnegcChanged(int i) throws RemoteException {
            Log.d(D2dController.TAG, "onD2DDnegcChanged " + i);
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestFreqNegotiationDone(final int i) throws RemoteException {
            Log.d(D2dController.TAG, "Pair is done " + i);
            D2dController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.d2dcontrol.D2dController.AnonymousClass1.AnonymousClass7 */

                public void run() {
                    D2dController.this.mListener.onPairAirDone(i == 0);
                }
            });
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestConfigD2dDNEGCsaveDone(int i) throws RemoteException {
            Log.d(D2dController.TAG, "onRequestConfigD2dDNEGCsaveDone " + i);
        }

        @Override // com.android.internal.telephony.d2d.ID2DInfoListener
        public void onRequestConfigD2dDNEGCloadDone(int i) throws RemoteException {
            Log.d(D2dController.TAG, "onRequestConfigD2dDNEGCloadDone " + i);
        }
    };
    boolean mD2DLinkConnected = false;
    private ID2DService mD2DService = null;
    private Handler mHandler;
    private D2dControlListener mListener;

    public D2dController(Context context, D2dControlListener d2dControlListener) {
        this.mListener = d2dControlListener;
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper());
    }

    public void start() {
        bindToD2DService();
    }

    public void stop() {
        unbindToD2DService();
    }

    public void requestPairAir() {
        try {
            this.mD2DService.requestD2dFreqNegotiation();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void savePairInfo(int i) {
        try {
            this.mD2DService.requestConfigD2dDNEGCsave(String.valueOf(i));
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void loadPairInfo(int i) {
        try {
            this.mD2DService.requestConfigD2dDNEGCload(String.valueOf(i));
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void bindToD2DService() {
        Log.v(TAG, "bindToD2DService");
        if (this.mD2DService != null) {
            Log.v(TAG, "Already bindToD2DService");
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.pinecone.telephony", "com.pinecone.telephony.D2DService");
        this.mContext.bindService(intent, this.mConnection, 1);
    }

    private void unbindToD2DService() {
        Log.v(TAG, "unbindToD2DService");
        ID2DService iD2DService = this.mD2DService;
        if (iD2DService != null) {
            try {
                iD2DService.unregisterCallback(this.mD2DInfoListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.mContext.unbindService(this.mConnection);
        this.mD2DService = null;
    }
}
