package com.fishsemi.sdk.aircontrol;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.fishsemi.sdk.aircontrol.Types;
import org.freedesktop.gstreamer.GStreamer;

public class VideoStream {
    private static final String TAG = "VideoStream";
    private boolean isPlaying = false;
    private AirController mAirController = null;
    private Handler mHandler = null;
    private VideoStreamListener mListener = null;
    private int mStreamId = -1;
    private String mStreamUrl = null;
    private VideoCapture mVideoCapture = null;
    private long native_custom_data;

    private static native boolean nativeClassInit();

    private native void nativeFinalize();

    private native boolean nativeInit();

    private native boolean nativePlay(String str);

    private native boolean nativeRecording(boolean z, String str);

    private native void nativeStop();

    private native void nativeSurfaceFinalize();

    private native void nativeSurfaceInit(Object obj);

    public VideoStream(Context context, String str, VideoStreamListener videoStreamListener) {
        initLibraries(context);
        this.mStreamUrl = str;
        this.mListener = videoStreamListener;
        this.mHandler = new Handler(context.getMainLooper());
        if (str != null) {
            this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass1 */

                public void run() {
                    if (VideoStream.this.mListener != null) {
                        VideoStream.this.mListener.onPlayReady(true);
                    }
                }
            });
        }
    }

    public VideoStream(AirController airController, VideoStreamListener videoStreamListener) {
        initLibraries(airController.getContext());
        this.mListener = videoStreamListener;
        this.mStreamId = 1;
        setAirController(airController);
        this.mHandler = new Handler(airController.getContext().getMainLooper());
    }

    public VideoStream(AirController airController, int i, VideoStreamListener videoStreamListener) {
        initLibraries(airController.getContext());
        this.mStreamId = i;
        this.mListener = videoStreamListener;
        setAirController(airController);
        this.mHandler = new Handler(airController.getContext().getMainLooper());
    }

    public VideoStreamListener getListener() {
        return this.mListener;
    }

    public String getStreamUrl() {
        return this.mStreamUrl;
    }

    public void setStreamUrl(String str) {
        setStreamId(-1);
        setStreamUrlInternal(str);
    }

    public void setStreamUrlInternal(String str) {
        if (this.mStreamUrl != null || str == null) {
            String str2 = this.mStreamUrl;
            if (str2 != null && !str2.equals(str)) {
                this.mStreamUrl = str;
                if (this.isPlaying) {
                    stop();
                    if (this.mStreamUrl != null) {
                        play();
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
        this.mStreamUrl = str;
        this.mHandler.post(new Runnable() {
            /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass2 */

            public void run() {
                if (VideoStream.this.mListener != null) {
                    VideoStream.this.mListener.onPlayReady(true);
                }
            }
        });
    }

    public int getStreamId() {
        return this.mStreamId;
    }

    public void setStreamId(int i) {
        setStreamIdInternal(i);
        if (i == -1 && this.mStreamId != i) {
            this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass3 */

                public void run() {
                    if (VideoStream.this.mListener != null) {
                        VideoStream.this.mListener.onVideoStreamResolutionChanged(Types.Resolution.UNKNOWN);
                    }
                }
            });
        }
    }

    public void setStreamIdInternal(int i) {
        if (this.mStreamId != i) {
            this.mStreamId = i;
            AirController airController = this.mAirController;
            if (airController != null) {
                airController.addVideoStream(this);
            }
            VideoCapture videoCapture = this.mVideoCapture;
            if (videoCapture != null) {
                videoCapture.setStreamIdInternal(this.mStreamId);
            }
            this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass4 */

                public void run() {
                    if (VideoStream.this.mListener != null) {
                        VideoStream.this.mListener.onVideoStreamIdChanged(VideoStream.this.mStreamId);
                    }
                }
            });
        }
    }

    public void setAirController(AirController airController) {
        this.mAirController = airController;
        AirController airController2 = this.mAirController;
        if (airController2 != null) {
            airController2.addVideoStream(this);
        }
    }

    public void setVideoCapture(VideoCapture videoCapture) {
        this.mVideoCapture = videoCapture;
        if (this.mVideoCapture != null) {
            videoCapture.setStreamIdInternal(this.mStreamId);
        }
    }

    public void setSurface(Surface surface) {
        nativeSurfaceInit(surface);
    }

    public void play() {
        if (!this.isPlaying) {
            if (this.mStreamUrl == null) {
                Log.e(TAG, "url is not set, play failed");
                return;
            }
            AirController airController = this.mAirController;
            if (airController != null) {
                int i = this.mStreamId;
                if (i == -1) {
                    Log.e(TAG, "streamId not set, play failed");
                    return;
                }
                airController.forceChangeStreamId(i);
            }
            this.isPlaying = nativePlay(this.mStreamUrl);
            this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass5 */

                public void run() {
                    if (VideoStream.this.mListener != null) {
                        VideoStream.this.mListener.onPlayStateChanged(VideoStream.this.isPlaying);
                    }
                }
            });
        }
    }

    public void stop() {
        if (this.isPlaying) {
            nativeStop();
        }
        this.isPlaying = false;
        this.mHandler.post(new Runnable() {
            /* class com.fishsemi.sdk.aircontrol.VideoStream.AnonymousClass6 */

            public void run() {
                if (VideoStream.this.mListener != null) {
                    VideoStream.this.mListener.onPlayStateChanged(false);
                }
            }
        });
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    /* access modifiers changed from: protected */
    public void initLibraries(Context context) {
        System.loadLibrary("gstreamer_android");
        System.loadLibrary("songrtspclient");
        nativeClassInit();
        Log.d(TAG, "nativeClassInit done");
        try {
            GStreamer.init(context);
            if (!nativeInit()) {
                Log.e(TAG, "initLibraries failed on nativeInit");
                return;
            }
            Log.i(TAG, "initLibraries done. (custom data:" + this.native_custom_data + ")");
        } catch (Exception e) {
            Log.e(TAG, "initLibraries failed " + e);
        }
    }

    /* access modifiers changed from: protected */
    public void finalize() {
        nativeFinalize();
    }

    private void onGStreamerInitialized() {
        Log.i(TAG, "VideoStream surface has been set and thread is ready");
    }

    private void setMessage(String str) {
        Log.d(TAG, str);
    }

    private void onMediaSizeChanged(int i, int i2) {
        Log.d(TAG, "width:" + i + "height" + i2);
    }
}
