package com.fishsemi.sdk.aircontrol;

import android.os.RemoteException;
import android.util.Log;
import com.fishsemi.sdk.aircontrol.Types;

public class VideoCapture {
    private static final String TAG = "VideoCapture";
    private AirController mAirController = null;
    private VideoCaptureListener mListener;
    private boolean mReady;
    private int mStreamId;
    private VideoStream mVideoStream = null;

    public VideoCapture(AirController airController, int i, VideoCaptureListener videoCaptureListener) {
        this.mListener = videoCaptureListener;
        this.mStreamId = i;
        this.mAirController = airController;
        AirController airController2 = this.mAirController;
        if (airController2 != null) {
            airController2.addVideoCapture(this);
        }
    }

    public VideoCapture(AirController airController, VideoStream videoStream, VideoCaptureListener videoCaptureListener) {
        this.mListener = videoCaptureListener;
        this.mStreamId = videoStream.getStreamId();
        if (videoStream != null) {
            this.mVideoStream = videoStream;
            this.mVideoStream.setVideoCapture(this);
        }
        this.mAirController = airController;
        AirController airController2 = this.mAirController;
        if (airController2 != null) {
            airController2.addVideoCapture(this);
        }
    }

    public void setStreamId(int i) {
        if (this.mVideoStream == null || i == this.mStreamId) {
            setStreamIdInternal(i);
        } else {
            Log.e(TAG, "video stream is set, can not set other stream id");
        }
    }

    public void setStreamIdInternal(int i) {
        if (this.mStreamId != i) {
            this.mStreamId = i;
            AirController airController = this.mAirController;
            if (airController != null) {
                airController.addVideoCapture(this);
            }
        }
    }

    public void setVideoStream(VideoStream videoStream) {
        VideoStream videoStream2 = this.mVideoStream;
        if (videoStream2 != null) {
            videoStream2.setVideoCapture(null);
        }
        if (videoStream != null) {
            this.mVideoStream = videoStream;
            this.mVideoStream.setVideoCapture(this);
            AirController airController = this.mAirController;
            if (airController != null) {
                airController.addVideoCapture(this);
            }
        }
    }

    public int getStreamId() {
        return this.mStreamId;
    }

    public VideoCaptureListener getListener() {
        return this.mListener;
    }

    public Types.CaptureMode getCaptureMode() {
        AirController airController = this.mAirController;
        if (airController == null || airController.getAirControlService() == null) {
            return Types.CaptureMode.UNKNOWN;
        }
        try {
            if (this.mAirController.getAirControlService().isPhotoCaptureMode()) {
                return Types.CaptureMode.PHOTO;
            }
            if (this.mAirController.getAirControlService().isVideoCaptureMode()) {
                return Types.CaptureMode.VIDEO;
            }
            return Types.CaptureMode.UNKNOWN;
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public Types.RetValue toggleCaptureMode(Types.CaptureMode captureMode) {
        AirController airController = this.mAirController;
        if (airController == null || airController.getAirControlService() == null || !this.mReady) {
            return Types.RetValue.NOT_READY;
        }
        if (captureMode == Types.CaptureMode.UNKNOWN) {
            return Types.RetValue.UNKNOWN;
        }
        try {
            return AirController.toRetValue(this.mAirController.getAirControlService().toggleCameraMode(AirController.toInt(captureMode)));
        } catch (RemoteException e) {
            e.printStackTrace();
            return Types.RetValue.REMOTE_ERROR;
        }
    }

    public Types.RetValue takePhoto() {
        AirController airController = this.mAirController;
        if (airController == null || airController.getAirControlService() == null || !this.mReady) {
            return Types.RetValue.NOT_READY;
        }
        try {
            return AirController.toRetValue(this.mAirController.getAirControlService().takePhoto());
        } catch (RemoteException e) {
            e.printStackTrace();
            return Types.RetValue.REMOTE_ERROR;
        }
    }

    public Types.RetValue startVideoRecording() {
        AirController airController = this.mAirController;
        if (airController == null || airController.getAirControlService() == null || !this.mReady) {
            return Types.RetValue.NOT_READY;
        }
        try {
            return AirController.toRetValue(this.mAirController.getAirControlService().startVideoRecording());
        } catch (RemoteException e) {
            e.printStackTrace();
            return Types.RetValue.REMOTE_ERROR;
        }
    }

    public Types.RetValue stopVideoRecording() {
        AirController airController = this.mAirController;
        if (airController == null || airController.getAirControlService() == null || !this.mReady) {
            return Types.RetValue.NOT_READY;
        }
        try {
            return AirController.toRetValue(this.mAirController.getAirControlService().stopVideoRecording());
        } catch (RemoteException e) {
            e.printStackTrace();
            return Types.RetValue.REMOTE_ERROR;
        }
    }

    public int getFreeSpace() {
        AirController airController = this.mAirController;
        if (!(airController == null || airController.getAirControlService() == null)) {
            try {
                return this.mAirController.getAirControlService().getFreeSpace();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public void onCaptureReady(boolean z) {
        this.mReady = z;
        VideoCaptureListener videoCaptureListener = this.mListener;
        if (videoCaptureListener != null) {
            videoCaptureListener.onCaptureReady(z);
        }
    }
}
