package com.fishsemi.sdk.aircontrol;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.fishsemi.aircontrol.IAirControlListener;
import com.fishsemi.aircontrol.IAirControlService;
import com.fishsemi.sdk.aircontrol.Types;
import java.util.Iterator;
import java.util.Vector;

public class AirController {
    public static final int CAP_MODE_PHOTO = 1;
    public static final int CAP_MODE_VIDEO = 2;
    public static final int RESOLUTION_1080P = 1;
    public static final int RESOLUTION_720P = 0;
    public static final int RES_CAP_NOT_READY = 5;
    public static final int RES_FAIL = 3;
    public static final int RES_NOT_READY = 1;
    public static final int RES_NO_FREE_MEM = 6;
    public static final int RES_SUCCESS = 0;
    public static final int RES_TIMEOUT = 4;
    public static final int RES_WAIT_PENDING = 2;
    public static final int UNKNOWN = -1;
    public static final int VERSION = 1;
    private final String TAG = "AirController";
    private IAirControlListener mAirControlListener = new IAirControlListener.Stub() {
        /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2 */

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public int getVersion() throws RemoteException {
            return 1;
        }

        /* access modifiers changed from: private */
        /* access modifiers changed from: public */
        private Types.Result toResult(int i) {
            if (i == 0) {
                return Types.Result.SUCCESS;
            }
            if (i == 3) {
                return Types.Result.FAIL;
            }
            if (i != 4) {
                return Types.Result.UNKNOWN;
            }
            return Types.Result.TIMEOUT;
        }

        /* access modifiers changed from: private */
        /* access modifiers changed from: public */
        private Types.CaptureMode toCaptureMode(int i) {
            if (i == 1) {
                return Types.CaptureMode.PHOTO;
            }
            if (i != 2) {
                return Types.CaptureMode.UNKNOWN;
            }
            return Types.CaptureMode.VIDEO;
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onCameraReady(final boolean z) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass1 */

                public void run() {
                    Log.d("AirController", "onCameraReady:" + z);
                    if (AirController.this.mVideoStreams.size() == 1) {
                        try {
                            if (AirController.this.mAirControlService.getVideoStreamCount() > 1) {
                                AirController.this.forceChangeStreamId(((VideoStream) AirController.this.mVideoStreams.firstElement()).getStreamId());
                            }
                        } catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onCaptureReady(final boolean z) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass2 */

                public void run() {
                    Log.d("AirController", "onCaptureReady:" + z);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (videoCapture.getStreamId() == AirController.this.mCurrentStreamId && AirController.this.mCurrentStreamId != -1) {
                            videoCapture.onCaptureReady(z);
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onToggleCaptureModeDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass3 */

                public void run() {
                    Log.d("AirController", "onToggleCaptureModeDone:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onToggleCaptureModeDone(AnonymousClass2.this.toResult(i));
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onUartReady(final boolean z) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass4 */

                public void run() {
                    Log.d("AirController", "onUartReady:" + z);
                    Iterator it = AirController.this.mDataStreams.iterator();
                    while (it.hasNext()) {
                        DataStream dataStream = (DataStream) it.next();
                        if (dataStream.getListener() != null) {
                            dataStream.getListener().onUartReady(z);
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onTakePhotoDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass5 */

                public void run() {
                    Log.d("AirController", "onTakePhotoDone:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onTakePhotoDone(AnonymousClass2.this.toResult(i));
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onStartVideoRecordingDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass6 */

                public void run() {
                    Log.d("AirController", "onStartVideoRecordingDone:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onStartVideoRecordingDone(AnonymousClass2.this.toResult(i));
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onStopVideoRecordingDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass7 */

                public void run() {
                    Log.d("AirController", "onStopVideoRecordingDone:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onStopVideoRecordingDone(AnonymousClass2.this.toResult(i));
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onSetVideoStreamIdDone(int i) throws RemoteException {
            Log.d("AirController", "onSetVideoStreamIdDone:" + i);
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onVideoStreamIdChanged(int i) throws RemoteException {
            StringBuilder sb = new StringBuilder();
            sb.append("onVideoStreamIdChanged:");
            int i2 = i + 1;
            sb.append(i2);
            Log.d("AirController", sb.toString());
            AirController.this.mCurrentStreamId = i2;
            if (AirController.this.mForcedStreamId != -1 && AirController.this.mCurrentStreamId != AirController.this.mForcedStreamId) {
                AirController airController = AirController.this;
                airController.forceChangeStreamId(airController.mForcedStreamId);
            }
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onSetUartBaudrateDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass8 */

                public void run() {
                    Log.d("AirController", "onSetUartBaudrateDone:" + i);
                    Iterator it = AirController.this.mDataStreams.iterator();
                    while (it.hasNext()) {
                        ((DataStream) it.next()).onSetUartBaudrateDone(AnonymousClass2.this.toResult(i));
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onSetVideoStreamResolutionDone(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass9 */

                public void run() {
                    Log.d("AirController", "onSetVideoStreamResolutionDone:" + i);
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onVideoRecordingStatusChanged(final boolean z) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass10 */

                public void run() {
                    Log.d("AirController", "onVideoRecordingStatusChanged:" + z);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onVideoRecordingStatusChanged(z);
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onCaptureModeChanged(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass11 */

                public void run() {
                    Log.d("AirController", "onCaptureModeChanged:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (!(videoCapture.getStreamId() != AirController.this.mCurrentStreamId || AirController.this.mCurrentStreamId == -1 || videoCapture.getListener() == null)) {
                            videoCapture.getListener().onCaptureModeChanged(AnonymousClass2.this.toCaptureMode(i));
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onFreeSpaceChanged(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass12 */

                public void run() {
                    Log.d("AirController", "onFreeSpaceChanged:" + i);
                    Iterator it = AirController.this.mVideoCaptures.iterator();
                    while (it.hasNext()) {
                        VideoCapture videoCapture = (VideoCapture) it.next();
                        if (videoCapture.getListener() != null) {
                            videoCapture.getListener().onFreeSpaceChanged(i);
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onCameraReset() throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass13 */

                public void run() {
                    Log.d("AirController", "onCameraReset");
                    if (AirController.this.mListener != null) {
                        AirController.this.mListener.onCameraReset();
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onVideoStreamUrlChanged(final String str) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass14 */

                public void run() {
                    Log.d("AirController", "onVideoStreamUrlChanged:" + str);
                    Iterator it = AirController.this.mVideoStreams.iterator();
                    while (it.hasNext()) {
                        VideoStream videoStream = (VideoStream) it.next();
                        if (videoStream.getStreamId() == AirController.this.mCurrentStreamId && AirController.this.mCurrentStreamId != -1) {
                            videoStream.setStreamUrlInternal(str);
                        }
                    }
                }
            });
        }

        @Override // com.fishsemi.aircontrol.IAirControlListener
        public void onVideoStreamResolutionChanged(final int i) throws RemoteException {
            AirController.this.mHandler.post(new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass2.AnonymousClass15 */

                public void run() {
                    Log.d("AirController", "onVideoStreamResolutionChanged:" + i);
                    Iterator it = AirController.this.mVideoStreams.iterator();
                    while (it.hasNext()) {
                        VideoStream videoStream = (VideoStream) it.next();
                        if (videoStream.getStreamId() == AirController.this.mCurrentStreamId && AirController.this.mCurrentStreamId != -1) {
                            videoStream.getListener().onVideoStreamResolutionChanged(AirController.toResolution(i));
                        }
                    }
                }
            });
        }
    };
    private IAirControlService mAirControlService = null;
    private ServiceConnection mConnection = new ServiceConnection() {
        /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass1 */

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.v("AirController", "AirControlService connected");
            AirController.this.mAirControlService = IAirControlService.Stub.asInterface(iBinder);
            try {
                AirController.this.mAirControlService.registerAirControlListener(AirController.this.mAirControlListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                AirController.this.mAirControlService.updateStatus();
            } catch (RemoteException e2) {
                e2.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.v("AirController", "AirControlService disconnected");
            AirController.this.mAirControlService = null;
        }
    };
    private Context mContext;
    private int mCurrentStreamId = -1;
    private Vector<DataStream> mDataStreams = new Vector<>();
    private int mForcedStreamId = -1;
    private Handler mHandler;
    private AirControlListener mListener;
    private Runnable mSetStreamIdRunnable = null;
    private Vector<VideoCapture> mVideoCaptures = new Vector<>();
    private Vector<VideoStream> mVideoStreams = new Vector<>();

    public AirController(Context context, AirControlListener airControlListener) {
        this.mListener = airControlListener;
        this.mContext = context;
        this.mHandler = new Handler(this.mContext.getMainLooper());
    }

    public void start() {
        bindAirControlService();
    }

    public void stop() {
        unbindAirControlService();
    }

    public int getVideoStreamCount() {
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService == null) {
            return 0;
        }
        try {
            return iAirControlService.getVideoStreamCount();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getUartCount() {
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService == null) {
            return 0;
        }
        try {
            return iAirControlService.getUartCount();
        } catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getVideoStreamId() {
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService == null) {
            return -1;
        }
        try {
            return iAirControlService.getVideoStreamId();
        } catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Types.RetValue setVideoStreamId(int i) {
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService == null) {
            return Types.RetValue.NOT_READY;
        }
        try {
            return toRetValue(iAirControlService.setVideoStreamId(i));
        } catch (RemoteException e) {
            e.printStackTrace();
            return Types.RetValue.REMOTE_ERROR;
        }
    }

    public IAirControlService getAirControlService() {
        return this.mAirControlService;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void addVideoStream(VideoStream videoStream) {
        if (!this.mVideoStreams.contains(videoStream)) {
            this.mVideoStreams.add(videoStream);
        }
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService != null) {
            try {
                iAirControlService.updateStatus();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void addVideoCapture(VideoCapture videoCapture) {
        if (!this.mVideoCaptures.contains(videoCapture)) {
            this.mVideoCaptures.add(videoCapture);
        }
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService != null) {
            try {
                iAirControlService.updateStatus();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void addDataStream(DataStream dataStream) {
        if (!this.mDataStreams.contains(dataStream)) {
            this.mDataStreams.add(dataStream);
        }
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService != null) {
            try {
                iAirControlService.updateStatus();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    /* access modifiers changed from: protected */
    public boolean forceChangeStreamId(int i) {
        Log.d("AirController", "force stream id to " + i);
        this.mForcedStreamId = i;
        if (this.mForcedStreamId == this.mCurrentStreamId) {
            return true;
        }
        if (this.mSetStreamIdRunnable == null) {
            this.mSetStreamIdRunnable = new Runnable() {
                /* class com.fishsemi.sdk.aircontrol.AirController.AnonymousClass3 */

                public void run() {
                    if (AirController.this.mForcedStreamId != AirController.this.mCurrentStreamId) {
                        Log.d("AirController", "try to set stream id to " + AirController.this.mForcedStreamId);
                        AirController airController = AirController.this;
                        airController.setVideoStreamId(airController.mForcedStreamId + -1);
                        AirController.this.mHandler.postDelayed(this, 2000);
                        return;
                    }
                    Log.d("AirController", "update status after set stream id");
                    try {
                        AirController.this.mAirControlService.updateStatus();
                    } catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mSetStreamIdRunnable);
        this.mHandler.post(this.mSetStreamIdRunnable);
        return true;
    }

    /* access modifiers changed from: protected */
    public void bindAirControlService() {
        Log.d("AirController", "bindAirControlService");
        Intent intent = new Intent();
        intent.setClassName("com.fishsemi.aircontrol", "com.fishsemi.aircontrol.AirControlService");
        this.mContext.bindService(intent, this.mConnection, 1);
    }

    /* access modifiers changed from: protected */
    public void unbindAirControlService() {
        Log.v("AirController", "unbindAirControlService");
        IAirControlService iAirControlService = this.mAirControlService;
        if (iAirControlService != null) {
            try {
                iAirControlService.unregisterAirControlListener(this.mAirControlListener);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.mContext.unbindService(this.mConnection);
        this.mAirControlService = null;
    }

    public static Types.RetValue toRetValue(int i) {
        if (i == 0) {
            return Types.RetValue.OK;
        }
        if (i == 1) {
            return Types.RetValue.NOT_READY;
        }
        if (i == 2) {
            return Types.RetValue.WAIT_PENDING;
        }
        if (i == 5) {
            return Types.RetValue.CAP_NOT_READY;
        }
        if (i != 6) {
            return Types.RetValue.UNKNOWN;
        }
        return Types.RetValue.NO_FREE_MEM;
    }

    public static int toInt(Types.CaptureMode captureMode) {
        int i = AnonymousClass4.$SwitchMap$com$fishsemi$sdk$aircontrol$Types$CaptureMode[captureMode.ordinal()];
        int i2 = 1;
        if (i != 1) {
            i2 = 2;
            if (i != 2) {
                return -1;
            }
        }
        return i2;
    }

    public static Types.Resolution toResolution(int i) {
        if (i == 0) {
            return Types.Resolution.HD_720P;
        }
        if (i != 1) {
            return Types.Resolution.UNKNOWN;
        }
        return Types.Resolution.FHD_1080P;
    }

    /* access modifiers changed from: package-private */
    /* renamed from: com.fishsemi.sdk.aircontrol.AirController$4  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass4 {
        static final /* synthetic */ int[] $SwitchMap$com$fishsemi$sdk$aircontrol$Types$CaptureMode = new int[Types.CaptureMode.values().length];
        static final /* synthetic */ int[] $SwitchMap$com$fishsemi$sdk$aircontrol$Types$Resolution = new int[Types.Resolution.values().length];

        /* JADX WARNING: Can't wrap try/catch for region: R(11:0|1|2|3|(2:5|6)|7|9|10|11|12|14) */
        /* JADX WARNING: Code restructure failed: missing block: B:15:?, code lost:
            return;
         */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x0032 */
        static {
            try {
                $SwitchMap$com$fishsemi$sdk$aircontrol$Types$Resolution[Types.Resolution.HD_720P.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                $SwitchMap$com$fishsemi$sdk$aircontrol$Types$Resolution[Types.Resolution.FHD_1080P.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            $SwitchMap$com$fishsemi$sdk$aircontrol$Types$CaptureMode[Types.CaptureMode.PHOTO.ordinal()] = 1;
            $SwitchMap$com$fishsemi$sdk$aircontrol$Types$CaptureMode[Types.CaptureMode.VIDEO.ordinal()] = 2;
        }
    }

    public static int toInt(Types.Resolution resolution) {
        int i = AnonymousClass4.$SwitchMap$com$fishsemi$sdk$aircontrol$Types$Resolution[resolution.ordinal()];
        if (i != 1) {
            return i != 2 ? -1 : 1;
        }
        return 0;
    }
}
