package com.fishsemi.rcservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.fishsemi.rcservice.IRcListener;
import com.fishsemi.sdk.rcservice.ConfigItem;
import java.util.List;

public interface IRcService extends IInterface {
    int getButtonCount() throws RemoteException;

    int getDialCount() throws RemoteException;

    int getJoystickMode() throws RemoteException;

    int getSwitchCount() throws RemoteException;

    boolean getUseSbusValue() throws RemoteException;

    List<ConfigItem> loadConfigs() throws RemoteException;

    void registerRcListener(IRcListener iRcListener) throws RemoteException;

    boolean saveConfig(ConfigItem configItem) throws RemoteException;

    boolean setJoystickMode(int i) throws RemoteException;

    boolean setUseSbusValue(boolean z) throws RemoteException;

    void unregisterRcListener(IRcListener iRcListener) throws RemoteException;

    void updateStatus() throws RemoteException;

    public static abstract class Stub extends Binder implements IRcService {
        private static final String DESCRIPTOR = "com.fishsemi.rcservice.IRcService";
        static final int TRANSACTION_getButtonCount = 6;
        static final int TRANSACTION_getDialCount = 8;
        static final int TRANSACTION_getJoystickMode = 11;
        static final int TRANSACTION_getSwitchCount = 7;
        static final int TRANSACTION_getUseSbusValue = 9;
        static final int TRANSACTION_loadConfigs = 4;
        static final int TRANSACTION_registerRcListener = 1;
        static final int TRANSACTION_saveConfig = 5;
        static final int TRANSACTION_setJoystickMode = 12;
        static final int TRANSACTION_setUseSbusValue = 10;
        static final int TRANSACTION_unregisterRcListener = 2;
        static final int TRANSACTION_updateStatus = 3;

        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static IRcService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (queryLocalInterface == null || !(queryLocalInterface instanceof IRcService)) {
                return new Proxy(iBinder);
            }
            return (IRcService) queryLocalInterface;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        registerRcListener(IRcListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        unregisterRcListener(IRcListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        updateStatus();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        List<ConfigItem> loadConfigs = loadConfigs();
                        parcel2.writeNoException();
                        parcel2.writeTypedList(loadConfigs);
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean saveConfig = saveConfig(parcel.readInt() != 0 ? ConfigItem.CREATOR.createFromParcel(parcel) : null);
                        parcel2.writeNoException();
                        parcel2.writeInt(saveConfig ? 1 : 0);
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        int buttonCount = getButtonCount();
                        parcel2.writeNoException();
                        parcel2.writeInt(buttonCount);
                        return true;
                    case TRANSACTION_getSwitchCount /*{ENCODED_INT: 7}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int switchCount = getSwitchCount();
                        parcel2.writeNoException();
                        parcel2.writeInt(switchCount);
                        return true;
                    case TRANSACTION_getDialCount /*{ENCODED_INT: 8}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int dialCount = getDialCount();
                        parcel2.writeNoException();
                        parcel2.writeInt(dialCount);
                        return true;
                    case TRANSACTION_getUseSbusValue /*{ENCODED_INT: 9}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean useSbusValue = getUseSbusValue();
                        parcel2.writeNoException();
                        parcel2.writeInt(useSbusValue ? 1 : 0);
                        return true;
                    case TRANSACTION_setUseSbusValue /*{ENCODED_INT: 10}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean useSbusValue2 = setUseSbusValue(parcel.readInt() != 0);
                        parcel2.writeNoException();
                        parcel2.writeInt(useSbusValue2 ? 1 : 0);
                        return true;
                    case TRANSACTION_getJoystickMode /*{ENCODED_INT: 11}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int joystickMode = getJoystickMode();
                        parcel2.writeNoException();
                        parcel2.writeInt(joystickMode);
                        return true;
                    case TRANSACTION_setJoystickMode /*{ENCODED_INT: 12}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean joystickMode2 = setJoystickMode(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(joystickMode2 ? 1 : 0);
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }

        private static class Proxy implements IRcService {
            private IBinder mRemote;

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.fishsemi.rcservice.IRcService
            public void registerRcListener(IRcListener iRcListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iRcListener != null ? iRcListener.asBinder() : null);
                    this.mRemote.transact(1, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public void unregisterRcListener(IRcListener iRcListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iRcListener != null ? iRcListener.asBinder() : null);
                    this.mRemote.transact(2, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public void updateStatus() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public List<ConfigItem> loadConfigs() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.createTypedArrayList(ConfigItem.CREATOR);
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public boolean saveConfig(ConfigItem configItem) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = true;
                    if (configItem != null) {
                        obtain.writeInt(1);
                        configItem.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    this.mRemote.transact(5, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() == 0) {
                        z = false;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public int getButtonCount() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public int getSwitchCount() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getSwitchCount, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public int getDialCount() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getDialCount, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public boolean getUseSbusValue() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_getUseSbusValue, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public boolean setUseSbusValue(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z2 = true;
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(Stub.TRANSACTION_setUseSbusValue, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() == 0) {
                        z2 = false;
                    }
                    return z2;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public int getJoystickMode() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getJoystickMode, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.rcservice.IRcService
            public boolean setJoystickMode(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_setJoystickMode, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }
    }
}
