package com.fishsemi.d2dsetting;

import android.util.Log;

public class SystemProperties {
    public static final String PROP_AUTO_SWITCH_VIDEO_SHARE = "persist.auto.switch.videoshare";
    public static final String PROP_FPV_PROXY = "sys.fpv.proxy";
    public static final String PROP_SUPPORT_SAVE_PAIR = "ro.support.save.pair";
    private static final String TAG = "SystemProperties";

    public static boolean getBoolean(String str, boolean z) {
        try {
            return ((Boolean) Class.forName("android.os.SystemProperties").getMethod("getBoolean", String.class, Boolean.TYPE).invoke(null, str, Boolean.valueOf(z))).booleanValue();
        } catch (Exception e) {
            Log.e(TAG, "Error getting boolean for  " + str, e);
            return z;
        }
    }

    public static int getInt(String str, int i) {
        try {
            return ((Integer) Class.forName("android.os.SystemProperties").getMethod("getInt", String.class, Integer.TYPE).invoke(null, str, Integer.valueOf(i))).intValue();
        } catch (Exception e) {
            Log.e(TAG, "Error getting int for  " + str, e);
            return i;
        }
    }

    public static String getString(String str, String str2) {
        try {
            return (String) Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, str, str2);
        } catch (Exception e) {
            Log.e(TAG, "Error getting string for  " + str, e);
            return str2;
        }
    }

    public static void set(String str, String str2) {
        try {
            Class.forName("android.os.SystemProperties").getMethod("set", String.class, String.class).invoke(null, str, str2);
        } catch (Exception e) {
            Log.e(TAG, "Error set value for  " + str + " value: " + str2, e);
        }
    }
}
