package com.fishsemi.d2dsetting;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class SystemMessageReceiver extends BroadcastReceiver {
    private static final String TAG = "SystemMessageReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.net.wifi.WIFI_AP_STATE_CHANGED".equals(action)) {
            int intExtra = intent.getIntExtra("wifi_state", 0);
            if (intExtra == 13) {
                openVideoShare();
            } else if (intExtra == 11) {
                closeVideoShare();
            }
            Log.i(TAG, "wifi ap state= " + intExtra);
        } else if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
            Log.i(TAG, "check whether to enable float window");
            MainActivity.checkFloatWindow(context);
        }
    }

    /* access modifiers changed from: package-private */
    public void openVideoShare() {
        if (SystemProperties.getBoolean(SystemProperties.PROP_AUTO_SWITCH_VIDEO_SHARE, false) && SystemProperties.getInt(SystemProperties.PROP_FPV_PROXY, 0) == 0) {
            SystemProperties.set(SystemProperties.PROP_FPV_PROXY, "1");
        }
    }

    /* access modifiers changed from: package-private */
    public void closeVideoShare() {
        if (SystemProperties.getBoolean(SystemProperties.PROP_AUTO_SWITCH_VIDEO_SHARE, false) && SystemProperties.getInt(SystemProperties.PROP_FPV_PROXY, 0) == 1) {
            SystemProperties.set(SystemProperties.PROP_FPV_PROXY, "0");
        }
    }
}
