package com.fishsemi.d2dsetting;

import android.app.ActionBar;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.os.Process;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.SwitchPreference;
import android.text.InputFilter;
import android.util.Log;
import android.view.MenuItem;
import android.widget.EditText;
import com.fishsemi.sdk.d2dcontrol.D2dControlListener;
import com.fishsemi.sdk.d2dcontrol.D2dController;
import java.util.List;
import java.util.Map;

public class MainActivity extends PreferenceActivity {
    private final String TAG = "MainActivity";
    private int mAirMasterRsrp = 0;
    private int mAirMasterSnr = 0;
    private Preference mAirSignal;
    private int mAirSlaveRsrp = 0;
    private int mAirSlaveSnr = 0;
    private Preference mConfig;
    private boolean mConnected = false;
    private Preference mConnection;
    private int mControllerMasterRsrp = 0;
    private int mControllerMasterSnr = 0;
    private Preference mControllerSignal;
    private int mControllerSlaveRsrp = 0;
    private int mControllerSlaveSnr = 0;
    private D2dController mD2dController;
    private SwitchPreference mFloatWindow;
    private int mLoadedId = 0;
    private ListPreference mMode;
    private Preference mPair;
    private boolean mPairing = false;
    private PreferenceCategory mSavedPairs;
    private boolean mShowFloatWindowSwitch = false;
    private Preference mSpeed;

    /* access modifiers changed from: protected */
    public void onCreate(Bundle bundle) {
        String str;
        String str2;
        super.onCreate(bundle);
        addPreferencesFromResource(R.xml.activity_main);
        this.mConnection = findPreference("connection");
        this.mSpeed = findPreference("transport_speed");
        this.mAirSignal = findPreference("air_signal");
        this.mControllerSignal = findPreference("controller_signal");
        this.mFloatWindow = (SwitchPreference) findPreference("float_window");
        this.mSavedPairs = (PreferenceCategory) findPreference("saved_pairs");
        this.mMode = (ListPreference) findPreference("mode");
        this.mMode.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass1 */

            public boolean onPreferenceChange(Preference preference, final Object obj) {
                int findIndexOfValue = MainActivity.this.mMode.findIndexOfValue((String) obj);
                if (MainActivity.this.mMode.getValue().equals(obj) || findIndexOfValue == -1) {
                    return false;
                }
                final String charSequence = MainActivity.this.mMode.getEntries()[findIndexOfValue].toString();
                new AlertDialog.Builder(MainActivity.this).setTitle(R.string.reboot).setMessage(String.format(MainActivity.this.getString(R.string.prompt_confirm_reboot), charSequence)).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass1.AnonymousClass1 */

                    public void onClick(DialogInterface dialogInterface, int i) {
                        MainActivity.this.saveControllerMode((String) obj);
                        MainActivity.this.mMode.setSummary(charSequence);
                        new Handler().post(new Runnable() {
                            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass1.AnonymousClass1.AnonymousClass1 */

                            public void run() {
                                MainActivity.this.rebootController();
                            }
                        });
                    }
                }).setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null).create().show();
                return false;
            }
        });
        this.mPair = findPreference("pair");
        this.mPair.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass2 */

            public boolean onPreferenceClick(Preference preference) {
                if (MainActivity.this.mConnected) {
                    new AlertDialog.Builder(MainActivity.this).setTitle(R.string.prompt_disconnect).setMessage(R.string.prompt_confirm_disconnect).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                        /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass2.AnonymousClass1 */

                        public void onClick(DialogInterface dialogInterface, int i) {
                            MainActivity.this.mD2dController.requestPairAir();
                            MainActivity.this.mPairing = true;
                            MainActivity.this.mPair.setSummary(R.string.prompt_result_d2d_pair_waiting);
                        }
                    }).setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null).create().show();
                    return true;
                }
                if (!MainActivity.this.mPairing) {
                    MainActivity.this.mD2dController.requestPairAir();
                    MainActivity.this.mPairing = true;
                    MainActivity.this.mPair.setSummary(R.string.prompt_result_d2d_pair_waiting);
                }
                return true;
            }
        });
        if (SystemProperties.getBoolean("ro.boot.one-to-n", false)) {
            str = getString(R.string.d2d_config_d2r);
        } else {
            str = getString(R.string.d2d_config_d2d);
        }
        if (SystemProperties.getBoolean("ro.boot.distance", false)) {
            str2 = getString(R.string.d2d_config_long_distance);
        } else {
            str2 = getString(R.string.d2d_config_short_distance);
        }
        this.mConfig = findPreference("d2d_config");
        Preference preference = this.mConfig;
        preference.setSummary(str + " / " + str2);
        this.mFloatWindow.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass3 */

            public boolean onPreferenceChange(Preference preference, Object obj) {
                MainActivity.this.saveFloatWindowStatus(((Boolean) obj).booleanValue());
                return true;
            }
        });
        this.mShowFloatWindowSwitch = isFloatWindowPackageExisted();
        if (!this.mShowFloatWindowSwitch) {
            getPreferenceScreen().removePreference(this.mFloatWindow);
        }
        this.mAirMasterRsrp = 0;
        this.mAirSlaveRsrp = 0;
        this.mControllerMasterRsrp = 0;
        this.mControllerSlaveRsrp = 0;
        this.mAirMasterSnr = 0;
        this.mAirSlaveSnr = 0;
        this.mControllerMasterSnr = 0;
        this.mControllerSlaveSnr = 0;
        ActionBar actionBar = getActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        this.mD2dController = new D2dController(this, new D2dControlListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass4 */

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onLinkConnectionChanged(boolean z) {
                MainActivity.this.mConnected = z;
                if (z) {
                    MainActivity.this.mConnection.setSummary(R.string.info_connected);
                    return;
                }
                MainActivity.this.mConnection.setSummary(R.string.info_disconnected);
                if (MainActivity.this.mAirSignal != null) {
                    MainActivity.this.mAirSignal.setSummary(R.string.info_not_available);
                }
                if (MainActivity.this.mControllerSignal != null) {
                    MainActivity.this.mControllerSignal.setSummary(R.string.info_not_available);
                }
                if (MainActivity.this.mSpeed != null) {
                    MainActivity.this.mSpeed.setSummary(R.string.info_not_available);
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onAirSignalChanged(int i, int i2) {
                if (MainActivity.this.mAirSignal != null) {
                    MainActivity.this.mAirMasterRsrp = i;
                    MainActivity.this.mAirSlaveRsrp = i2;
                    if (MainActivity.this.mConnected) {
                        Preference preference = MainActivity.this.mAirSignal;
                        preference.setSummary(String.format(MainActivity.this.getString(R.string.info_signal_master_slave), Integer.valueOf(MainActivity.this.mAirMasterRsrp), Integer.valueOf(MainActivity.this.mAirSlaveRsrp)) + "\n" + String.format(MainActivity.this.getString(R.string.info_snr_master_slave), Integer.valueOf(MainActivity.this.mAirMasterSnr), Integer.valueOf(MainActivity.this.mAirSlaveSnr)));
                    }
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onControllerSignalChanged(int i, int i2) {
                if (MainActivity.this.mControllerSignal != null) {
                    MainActivity.this.mControllerMasterRsrp = i;
                    MainActivity.this.mControllerSlaveRsrp = i2;
                    if (MainActivity.this.mConnected) {
                        Preference preference = MainActivity.this.mControllerSignal;
                        preference.setSummary(String.format(MainActivity.this.getString(R.string.info_signal_master_slave), Integer.valueOf(MainActivity.this.mControllerMasterRsrp), Integer.valueOf(MainActivity.this.mControllerSlaveRsrp)) + "\n" + String.format(MainActivity.this.getString(R.string.info_snr_master_slave), Integer.valueOf(MainActivity.this.mControllerMasterSnr), Integer.valueOf(MainActivity.this.mControllerSlaveSnr)));
                    }
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onAirSnrChanged(int i, int i2) {
                if (MainActivity.this.mAirSignal != null) {
                    MainActivity.this.mAirMasterSnr = i;
                    MainActivity.this.mAirSlaveSnr = i2;
                    if (MainActivity.this.mConnected) {
                        Preference preference = MainActivity.this.mAirSignal;
                        preference.setSummary(String.format(MainActivity.this.getString(R.string.info_signal_master_slave), Integer.valueOf(MainActivity.this.mAirMasterRsrp), Integer.valueOf(MainActivity.this.mAirSlaveRsrp)) + "\n" + String.format(MainActivity.this.getString(R.string.info_snr_master_slave), Integer.valueOf(MainActivity.this.mAirMasterSnr), Integer.valueOf(MainActivity.this.mAirSlaveSnr)));
                    }
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onControllerSnrChanged(int i, int i2) {
                if (MainActivity.this.mControllerSignal != null) {
                    MainActivity.this.mControllerMasterSnr = i;
                    MainActivity.this.mControllerSlaveSnr = i2;
                    if (MainActivity.this.mConnected) {
                        Preference preference = MainActivity.this.mControllerSignal;
                        preference.setSummary(String.format(MainActivity.this.getString(R.string.info_signal_master_slave), Integer.valueOf(MainActivity.this.mControllerMasterRsrp), Integer.valueOf(MainActivity.this.mControllerSlaveRsrp)) + "\n" + String.format(MainActivity.this.getString(R.string.info_snr_master_slave), Integer.valueOf(MainActivity.this.mControllerMasterSnr), Integer.valueOf(MainActivity.this.mControllerSlaveSnr)));
                    }
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onSpeedChanged(int i, int i2) {
                if (MainActivity.this.mSpeed != null && MainActivity.this.mConnected) {
                    MainActivity.this.mSpeed.setSummary(String.format(MainActivity.this.getString(R.string.info_bandwidth_speed), Integer.valueOf(i), Integer.valueOf(i2)));
                }
            }

            @Override // com.fishsemi.sdk.d2dcontrol.D2dControlListener
            public void onPairAirDone(boolean z) {
                MainActivity.this.mPairing = false;
                MainActivity.this.mPair.setSummary(R.string.info_d2d_pair);
                if (!SystemProperties.getBoolean(SystemProperties.PROP_SUPPORT_SAVE_PAIR, false) || MainActivity.this.getAvailablePairId() < 0 || !z) {
                    new AlertDialog.Builder(MainActivity.this).setTitle(R.string.action_d2d_pair).setMessage(z ? R.string.prompt_result_d2d_pair_succeed : R.string.prompt_result_d2d_pair_fail).setPositiveButton(R.string.ok, (DialogInterface.OnClickListener) null).create().show();
                    return;
                }
                new AlertDialog.Builder(MainActivity.this).setTitle(R.string.action_d2d_pair).setMessage(R.string.prompt_to_save).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass4.AnonymousClass1 */

                    public void onClick(DialogInterface dialogInterface, int i) {
                        MainActivity.this.savePairResult();
                    }
                }).setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null).create().show();
                if (z) {
                    MainActivity.this.mLoadedId = 0;
                    MainActivity.this.updateSavedPairs();
                }
            }
        });
        this.mD2dController.start();
        updateControllerMode();
        updateFloatWindowStatus();
        simplifyUI();
        this.mLoadedId = SystemProperties.getInt("persist.sys.dnegc_id", 0);
        updateSavedPairs();
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    public void onDestroy() {
        this.mD2dController.stop();
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() != 16908332) {
            return super.onOptionsItemSelected(menuItem);
        }
        finish();
        return true;
    }

    private void updateControllerMode() {
        int i;
        if (!SystemProperties.getBoolean("ro.show.control.mode", false)) {
            getPreferenceScreen().removePreference(this.mMode);
            return;
        }
        this.mMode.setValueIndex(0);
        if (SystemProperties.getInt("persist.song.d2r.mode", 0) == 1 && ((i = SystemProperties.getInt("persist.fpv.device.id", 0)) == 1 || i == 2)) {
            this.mMode.setValueIndex(i);
        }
        ListPreference listPreference = this.mMode;
        listPreference.setSummary(listPreference.getEntry());
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void saveControllerMode(String str) {
        Log.d("MainActivity", "Save new controller mode: " + str);
        if ("1".equals(str) || "2".equals(str)) {
            SystemProperties.set("persist.song.d2r.mode", "1");
            SystemProperties.set("persist.fpv.device.id", str);
            SystemProperties.set("persist.song.d2d.mode", "1");
            SystemProperties.set("persist.fpv.tdd.config", "4");
        } else {
            SystemProperties.set("persist.song.d2r.mode", "0");
            SystemProperties.set("persist.song.d2d.mode", "0");
            SystemProperties.set("persist.fpv.tdd.config", "0");
        }
        SystemProperties.set("persist.sys.d2d.calibrated", "-1");
    }

    private void updateFloatWindowStatus() {
        this.mFloatWindow.setChecked(SystemProperties.getBoolean("persist.show.d2d.floatwindow", false));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void saveFloatWindowStatus(boolean z) {
        Log.d("MainActivity", "Save new float window status: " + z);
        SystemProperties.set("persist.show.d2d.floatwindow", z ? "true" : "false");
        startOrStopFBService(this, z);
        if (!z) {
            List<ActivityManager.RunningAppProcessInfo> runningAppProcesses = ((ActivityManager) getSystemService("activity")).getRunningAppProcesses();
            for (int i = 0; i < runningAppProcesses.size(); i++) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = runningAppProcesses.get(i);
                if (runningAppProcessInfo.processName.equalsIgnoreCase("com.pinecone.d2dinfofloatball")) {
                    Process.killProcess(runningAppProcessInfo.pid);
                    return;
                }
            }
        }
    }

    public boolean isFloatWindowPackageExisted() {
        for (ApplicationInfo applicationInfo : getPackageManager().getInstalledApplications(0)) {
            if (applicationInfo.packageName.equals("com.pinecone.d2dinfofloatball")) {
                return true;
            }
        }
        return false;
    }

    public static void checkFloatWindow(Context context) {
        if (SystemProperties.getBoolean("persist.show.d2d.floatwindow", false)) {
            startOrStopFBService(context, true);
        }
    }

    public static void startOrStopFBService(Context context, boolean z) {
        Intent intent = new Intent();
        intent.setClassName("com.pinecone.d2dinfofloatball", "com.pinecone.d2dinfofloatball.D2DInfoFBService");
        if (z) {
            context.startService(intent);
        } else {
            context.stopService(intent);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rebootController() {
        Log.d("MainActivity", "reboot to apply new controller mode");
        ((PowerManager) getSystemService("power")).reboot("Controller mode changed");
    }

    private void simplifyUI() {
        getPreferenceScreen().removePreference(this.mAirSignal);
        this.mAirSignal = null;
        getPreferenceScreen().removePreference(this.mControllerSignal);
        this.mControllerSignal = null;
        getPreferenceScreen().removePreference(this.mSpeed);
        this.mSpeed = null;
        if ("optimus".equals(SystemProperties.getString("ro.boot.hardware", ""))) {
            getPreferenceScreen().removePreference(this.mConfig);
            this.mConfig = null;
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void updateSavedPairs() {
        PreferenceCategory preferenceCategory = this.mSavedPairs;
        if (preferenceCategory != null) {
            preferenceCategory.removeAll();
        }
        for (Map.Entry<String, ?> entry : getSharedPreferences("savedPairs", 0).getAll().entrySet()) {
            PairPreference pairPreference = new PairPreference(this);
            pairPreference.setTitle(entry.getKey());
            pairPreference.setId(((Integer) entry.getValue()).intValue());
            pairPreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {
                /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass5 */

                public boolean onPreferenceClick(Preference preference) {
                    MainActivity.this.showSavedPairOptions((PairPreference) preference);
                    return false;
                }
            });
            if (this.mSavedPairs == null) {
                this.mSavedPairs = new PreferenceCategory(this);
                this.mSavedPairs.setTitle(R.string.saved_pair);
                getPreferenceScreen().addPreference(this.mSavedPairs);
            }
            this.mSavedPairs.addPreference(pairPreference);
            if (this.mLoadedId == pairPreference.getId()) {
                pairPreference.setSummary(R.string.summary_in_use);
            }
        }
        PreferenceCategory preferenceCategory2 = this.mSavedPairs;
        if (preferenceCategory2 != null && preferenceCategory2.getPreferenceCount() <= 0) {
            getPreferenceScreen().removePreference(this.mSavedPairs);
            this.mSavedPairs = null;
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void tryToSavePair(final PairPreference pairPreference, final String str, final int i) {
        Log.d("MainActivity", "save " + str + " id: " + i);
        if (str != null && i >= 0) {
            for (Map.Entry<String, ?> entry : getSharedPreferences("savedPairs", 0).getAll().entrySet()) {
                if (str.equals(entry.getKey()) && i != ((Integer) entry.getValue()).intValue()) {
                    new AlertDialog.Builder(this).setTitle(R.string.action_d2d_pair).setMessage(R.string.prompt_to_confirm_overwrite).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                        /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass6 */

                        public void onClick(DialogInterface dialogInterface, int i) {
                            MainActivity.this.savePair(str, i);
                            PairPreference pairPreference = pairPreference;
                            if (pairPreference != null) {
                                MainActivity.this.deletePair(pairPreference);
                            }
                        }
                    }).setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null).create().show();
                    return;
                }
            }
            savePair(str, i);
            if (pairPreference != null) {
                deletePair(pairPreference);
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void savePair(String str, int i) {
        this.mD2dController.savePairInfo(i);
        SharedPreferences.Editor edit = getSharedPreferences("savedPairs", 0).edit();
        edit.putInt(str, i);
        edit.commit();
        updateSavedPairs();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int getAvailablePairId() {
        int i = 0;
        for (Map.Entry<String, ?> entry : getSharedPreferences("savedPairs", 0).getAll().entrySet()) {
            int intValue = ((Integer) entry.getValue()).intValue() - 1;
            if (intValue >= 0 && intValue < 8) {
                i |= 1 << intValue;
            }
        }
        for (int i2 = 0; i2 < 8; i2++) {
            if (((1 << i2) & i) == 0) {
                return i2 + 1;
            }
        }
        return -1;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void savePairResult() {
        this.mLoadedId = getAvailablePairId();
        rename(null, this.mLoadedId);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rename(final PairPreference pairPreference, final int i) {
        final String title = pairPreference == null ? "" : pairPreference.getTitle();
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(R.string.input_name);
        final EditText editText = new EditText(this);
        editText.setInputType(1);
        editText.setHint(R.string.unnamed_air);
        editText.setText(title);
        editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(80)});
        builder.setView(editText);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass7 */

            public void onClick(DialogInterface dialogInterface, int i) {
                String obj = editText.getText().toString();
                if (obj.trim().isEmpty()) {
                    obj = MainActivity.this.getString(R.string.unnamed_air);
                }
                if (!title.equals(obj)) {
                    MainActivity.this.tryToSavePair(pairPreference, obj, i);
                }
            }
        });
        builder.setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null);
        builder.show();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void tryToDeletePair(final PairPreference pairPreference) {
        new AlertDialog.Builder(this).setTitle(R.string.action_delete).setMessage(R.string.prompt_to_confirm_delete).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass8 */

            public void onClick(DialogInterface dialogInterface, int i) {
                MainActivity.this.deletePair(pairPreference);
            }
        }).setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) null).create().show();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void deletePair(PairPreference pairPreference) {
        if (pairPreference != null) {
            SharedPreferences.Editor edit = getSharedPreferences("savedPairs", 0).edit();
            edit.remove(pairPreference.getTitle().toString());
            edit.commit();
            if (pairPreference.getId() == this.mLoadedId) {
                this.mLoadedId = 0;
                SystemProperties.set("persist.sys.d2d.calibrated", "-1");
            }
            updateSavedPairs();
        }
    }

    /* access modifiers changed from: package-private */
    public void showSavedPairOptions(final PairPreference pairPreference) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setItems(new String[]{getString(R.string.action_connect), getString(R.string.action_rename), getString(R.string.action_delete)}, new DialogInterface.OnClickListener() {
            /* class com.fishsemi.d2dsetting.MainActivity.AnonymousClass9 */

            public void onClick(DialogInterface dialogInterface, int i) {
                if (i == 0) {
                    MainActivity.this.mLoadedId = pairPreference.getId();
                    MainActivity.this.mD2dController.loadPairInfo(MainActivity.this.mLoadedId);
                    MainActivity.this.updateSavedPairs();
                } else if (i == 1) {
                    MainActivity mainActivity = MainActivity.this;
                    PairPreference pairPreference = pairPreference;
                    mainActivity.rename(pairPreference, pairPreference.getId());
                } else if (i == 2) {
                    MainActivity.this.tryToDeletePair(pairPreference);
                }
            }
        });
        builder.create().show();
    }
}
