package com.fishsemi.aircontrol;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.fishsemi.aircontrol.IAirControlListener;

public interface IAirControlService extends IInterface {
    int getFreeSpace() throws RemoteException;

    int getUartBaudrate(int i) throws RemoteException;

    int getUartCount() throws RemoteException;

    int getVersion() throws RemoteException;

    int getVideoStreamCount() throws RemoteException;

    int getVideoStreamId() throws RemoteException;

    int getVideoStreamResolution() throws RemoteException;

    boolean isCameraReady() throws RemoteException;

    boolean isCaptureReady() throws RemoteException;

    boolean isInVideoRecording() throws RemoteException;

    boolean isPhotoCaptureMode() throws RemoteException;

    boolean isUartReady() throws RemoteException;

    boolean isVideoCaptureMode() throws RemoteException;

    int registerAirControlListener(IAirControlListener iAirControlListener) throws RemoteException;

    int setUartBaudrate(int i, int i2) throws RemoteException;

    int setVideoStreamId(int i) throws RemoteException;

    int setVideoStreamResolution(int i) throws RemoteException;

    int startVideoRecording() throws RemoteException;

    int stopVideoRecording() throws RemoteException;

    int takePhoto() throws RemoteException;

    int toggleCameraMode(int i) throws RemoteException;

    void unregisterAirControlListener(IAirControlListener iAirControlListener) throws RemoteException;

    void updateStatus() throws RemoteException;

    public static abstract class Stub extends Binder implements IAirControlService {
        private static final String DESCRIPTOR = "com.fishsemi.aircontrol.IAirControlService";
        static final int TRANSACTION_getFreeSpace = 14;
        static final int TRANSACTION_getUartBaudrate = 19;
        static final int TRANSACTION_getUartCount = 18;
        static final int TRANSACTION_getVersion = 21;
        static final int TRANSACTION_getVideoStreamCount = 15;
        static final int TRANSACTION_getVideoStreamId = 16;
        static final int TRANSACTION_getVideoStreamResolution = 22;
        static final int TRANSACTION_isCameraReady = 4;
        static final int TRANSACTION_isCaptureReady = 5;
        static final int TRANSACTION_isInVideoRecording = 13;
        static final int TRANSACTION_isPhotoCaptureMode = 7;
        static final int TRANSACTION_isUartReady = 6;
        static final int TRANSACTION_isVideoCaptureMode = 8;
        static final int TRANSACTION_registerAirControlListener = 1;
        static final int TRANSACTION_setUartBaudrate = 20;
        static final int TRANSACTION_setVideoStreamId = 17;
        static final int TRANSACTION_setVideoStreamResolution = 23;
        static final int TRANSACTION_startVideoRecording = 11;
        static final int TRANSACTION_stopVideoRecording = 12;
        static final int TRANSACTION_takePhoto = 10;
        static final int TRANSACTION_toggleCameraMode = 9;
        static final int TRANSACTION_unregisterAirControlListener = 2;
        static final int TRANSACTION_updateStatus = 3;

        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static IAirControlService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (queryLocalInterface == null || !(queryLocalInterface instanceof IAirControlService)) {
                return new Proxy(iBinder);
            }
            return (IAirControlService) queryLocalInterface;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        int registerAirControlListener = registerAirControlListener(IAirControlListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        parcel2.writeInt(registerAirControlListener);
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        unregisterAirControlListener(IAirControlListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        updateStatus();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isCameraReady = isCameraReady();
                        parcel2.writeNoException();
                        parcel2.writeInt(isCameraReady ? 1 : 0);
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isCaptureReady = isCaptureReady();
                        parcel2.writeNoException();
                        parcel2.writeInt(isCaptureReady ? 1 : 0);
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isUartReady = isUartReady();
                        parcel2.writeNoException();
                        parcel2.writeInt(isUartReady ? 1 : 0);
                        return true;
                    case TRANSACTION_isPhotoCaptureMode /*{ENCODED_INT: 7}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isPhotoCaptureMode = isPhotoCaptureMode();
                        parcel2.writeNoException();
                        parcel2.writeInt(isPhotoCaptureMode ? 1 : 0);
                        return true;
                    case TRANSACTION_isVideoCaptureMode /*{ENCODED_INT: 8}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isVideoCaptureMode = isVideoCaptureMode();
                        parcel2.writeNoException();
                        parcel2.writeInt(isVideoCaptureMode ? 1 : 0);
                        return true;
                    case TRANSACTION_toggleCameraMode /*{ENCODED_INT: 9}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int i3 = toggleCameraMode(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(i3);
                        return true;
                    case TRANSACTION_takePhoto /*{ENCODED_INT: 10}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int takePhoto = takePhoto();
                        parcel2.writeNoException();
                        parcel2.writeInt(takePhoto);
                        return true;
                    case TRANSACTION_startVideoRecording /*{ENCODED_INT: 11}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int startVideoRecording = startVideoRecording();
                        parcel2.writeNoException();
                        parcel2.writeInt(startVideoRecording);
                        return true;
                    case TRANSACTION_stopVideoRecording /*{ENCODED_INT: 12}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int stopVideoRecording = stopVideoRecording();
                        parcel2.writeNoException();
                        parcel2.writeInt(stopVideoRecording);
                        return true;
                    case TRANSACTION_isInVideoRecording /*{ENCODED_INT: 13}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isInVideoRecording = isInVideoRecording();
                        parcel2.writeNoException();
                        parcel2.writeInt(isInVideoRecording ? 1 : 0);
                        return true;
                    case TRANSACTION_getFreeSpace /*{ENCODED_INT: 14}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int freeSpace = getFreeSpace();
                        parcel2.writeNoException();
                        parcel2.writeInt(freeSpace);
                        return true;
                    case TRANSACTION_getVideoStreamCount /*{ENCODED_INT: 15}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int videoStreamCount = getVideoStreamCount();
                        parcel2.writeNoException();
                        parcel2.writeInt(videoStreamCount);
                        return true;
                    case TRANSACTION_getVideoStreamId /*{ENCODED_INT: 16}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int videoStreamId = getVideoStreamId();
                        parcel2.writeNoException();
                        parcel2.writeInt(videoStreamId);
                        return true;
                    case TRANSACTION_setVideoStreamId /*{ENCODED_INT: 17}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int videoStreamId2 = setVideoStreamId(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(videoStreamId2);
                        return true;
                    case TRANSACTION_getUartCount /*{ENCODED_INT: 18}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int uartCount = getUartCount();
                        parcel2.writeNoException();
                        parcel2.writeInt(uartCount);
                        return true;
                    case TRANSACTION_getUartBaudrate /*{ENCODED_INT: 19}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int uartBaudrate = getUartBaudrate(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(uartBaudrate);
                        return true;
                    case TRANSACTION_setUartBaudrate /*{ENCODED_INT: 20}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int uartBaudrate2 = setUartBaudrate(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(uartBaudrate2);
                        return true;
                    case TRANSACTION_getVersion /*{ENCODED_INT: 21}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int version = getVersion();
                        parcel2.writeNoException();
                        parcel2.writeInt(version);
                        return true;
                    case TRANSACTION_getVideoStreamResolution /*{ENCODED_INT: 22}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int videoStreamResolution = getVideoStreamResolution();
                        parcel2.writeNoException();
                        parcel2.writeInt(videoStreamResolution);
                        return true;
                    case TRANSACTION_setVideoStreamResolution /*{ENCODED_INT: 23}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int videoStreamResolution2 = setVideoStreamResolution(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(videoStreamResolution2);
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }

        private static class Proxy implements IAirControlService {
            private IBinder mRemote;

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int registerAirControlListener(IAirControlListener iAirControlListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iAirControlListener != null ? iAirControlListener.asBinder() : null);
                    this.mRemote.transact(1, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public void unregisterAirControlListener(IAirControlListener iAirControlListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iAirControlListener != null ? iAirControlListener.asBinder() : null);
                    this.mRemote.transact(2, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public void updateStatus() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isCameraReady() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(4, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isCaptureReady() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(5, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isUartReady() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(6, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isPhotoCaptureMode() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_isPhotoCaptureMode, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isVideoCaptureMode() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_isVideoCaptureMode, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int toggleCameraMode(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_toggleCameraMode, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int takePhoto() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_takePhoto, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int startVideoRecording() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_startVideoRecording, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int stopVideoRecording() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_stopVideoRecording, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public boolean isInVideoRecording() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_isInVideoRecording, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getFreeSpace() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getFreeSpace, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getVideoStreamCount() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getVideoStreamCount, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getVideoStreamId() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getVideoStreamId, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int setVideoStreamId(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_setVideoStreamId, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getUartCount() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getUartCount, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getUartBaudrate(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_getUartBaudrate, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int setUartBaudrate(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(Stub.TRANSACTION_setUartBaudrate, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getVersion() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getVersion, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int getVideoStreamResolution() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getVideoStreamResolution, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlService
            public int setVideoStreamResolution(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_setVideoStreamResolution, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }
    }
}
