package com.fishsemi.aircontrol;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAirControlListener extends IInterface {
    int getVersion() throws RemoteException;

    void onCameraReady(boolean z) throws RemoteException;

    void onCameraReset() throws RemoteException;

    void onCaptureModeChanged(int i) throws RemoteException;

    void onCaptureReady(boolean z) throws RemoteException;

    void onFreeSpaceChanged(int i) throws RemoteException;

    void onSetUartBaudrateDone(int i) throws RemoteException;

    void onSetVideoStreamIdDone(int i) throws RemoteException;

    void onSetVideoStreamResolutionDone(int i) throws RemoteException;

    void onStartVideoRecordingDone(int i) throws RemoteException;

    void onStopVideoRecordingDone(int i) throws RemoteException;

    void onTakePhotoDone(int i) throws RemoteException;

    void onToggleCaptureModeDone(int i) throws RemoteException;

    void onUartReady(boolean z) throws RemoteException;

    void onVideoRecordingStatusChanged(boolean z) throws RemoteException;

    void onVideoStreamIdChanged(int i) throws RemoteException;

    void onVideoStreamResolutionChanged(int i) throws RemoteException;

    void onVideoStreamUrlChanged(String str) throws RemoteException;

    public static abstract class Stub extends Binder implements IAirControlListener {
        private static final String DESCRIPTOR = "com.fishsemi.aircontrol.IAirControlListener";
        static final int TRANSACTION_getVersion = 15;
        static final int TRANSACTION_onCameraReady = 1;
        static final int TRANSACTION_onCameraReset = 16;
        static final int TRANSACTION_onCaptureModeChanged = 10;
        static final int TRANSACTION_onCaptureReady = 2;
        static final int TRANSACTION_onFreeSpaceChanged = 11;
        static final int TRANSACTION_onSetUartBaudrateDone = 13;
        static final int TRANSACTION_onSetVideoStreamIdDone = 7;
        static final int TRANSACTION_onSetVideoStreamResolutionDone = 14;
        static final int TRANSACTION_onStartVideoRecordingDone = 5;
        static final int TRANSACTION_onStopVideoRecordingDone = 6;
        static final int TRANSACTION_onTakePhotoDone = 4;
        static final int TRANSACTION_onToggleCaptureModeDone = 3;
        static final int TRANSACTION_onUartReady = 12;
        static final int TRANSACTION_onVideoRecordingStatusChanged = 9;
        static final int TRANSACTION_onVideoStreamIdChanged = 8;
        static final int TRANSACTION_onVideoStreamResolutionChanged = 18;
        static final int TRANSACTION_onVideoStreamUrlChanged = 17;

        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static IAirControlListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (queryLocalInterface == null || !(queryLocalInterface instanceof IAirControlListener)) {
                return new Proxy(iBinder);
            }
            return (IAirControlListener) queryLocalInterface;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                boolean z = false;
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onCameraReady(z);
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onCaptureReady(z);
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        onToggleCaptureModeDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        onTakePhotoDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        onStartVideoRecordingDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        onStopVideoRecordingDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onSetVideoStreamIdDone /*{ENCODED_INT: 7}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onSetVideoStreamIdDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onVideoStreamIdChanged /*{ENCODED_INT: 8}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onVideoStreamIdChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onVideoRecordingStatusChanged /*{ENCODED_INT: 9}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onVideoRecordingStatusChanged(z);
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onCaptureModeChanged /*{ENCODED_INT: 10}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onCaptureModeChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onFreeSpaceChanged /*{ENCODED_INT: 11}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onFreeSpaceChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onUartReady /*{ENCODED_INT: 12}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onUartReady(z);
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onSetUartBaudrateDone /*{ENCODED_INT: 13}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onSetUartBaudrateDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onSetVideoStreamResolutionDone /*{ENCODED_INT: 14}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onSetVideoStreamResolutionDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_getVersion /*{ENCODED_INT: 15}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        int version = getVersion();
                        parcel2.writeNoException();
                        parcel2.writeInt(version);
                        return true;
                    case TRANSACTION_onCameraReset /*{ENCODED_INT: 16}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onCameraReset();
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onVideoStreamUrlChanged /*{ENCODED_INT: 17}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onVideoStreamUrlChanged(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onVideoStreamResolutionChanged /*{ENCODED_INT: 18}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onVideoStreamResolutionChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }

        private static class Proxy implements IAirControlListener {
            private IBinder mRemote;

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onCameraReady(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(1, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onCaptureReady(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(2, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onToggleCaptureModeDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(3, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onTakePhotoDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(4, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onStartVideoRecordingDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(5, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onStopVideoRecordingDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(6, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onSetVideoStreamIdDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onSetVideoStreamIdDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onVideoStreamIdChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onVideoStreamIdChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onVideoRecordingStatusChanged(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(Stub.TRANSACTION_onVideoRecordingStatusChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onCaptureModeChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onCaptureModeChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onFreeSpaceChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onFreeSpaceChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onUartReady(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(Stub.TRANSACTION_onUartReady, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onSetUartBaudrateDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onSetUartBaudrateDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onSetVideoStreamResolutionDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onSetVideoStreamResolutionDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public int getVersion() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_getVersion, obtain, obtain2, 0);
                    obtain2.readException();
                    return obtain2.readInt();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onCameraReset() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_onCameraReset, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onVideoStreamUrlChanged(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    this.mRemote.transact(Stub.TRANSACTION_onVideoStreamUrlChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.fishsemi.aircontrol.IAirControlListener
            public void onVideoStreamResolutionChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onVideoStreamResolutionChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }
    }
}
