package com.android.internal.telephony.d2d;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.telephony.d2d.ID2DInfoListener;

public interface ID2DService extends IInterface {
    void onD2dInfoChanged(int i) throws RemoteException;

    void onD2dRequestDone(int i, int i2) throws RemoteException;

    void registerForD2dInfoChanged(ID2DInfoListener iD2DInfoListener) throws RemoteException;

    void requestConfigD2dBandwidth(boolean z, int i) throws RemoteException;

    void requestConfigD2dDNEGCload(String str) throws RemoteException;

    void requestConfigD2dDNEGCsave(String str) throws RemoteException;

    void requestD2dFreqHopCtrl(String str, String str2) throws RemoteException;

    void requestD2dFreqNegotiation() throws RemoteException;

    void requestD2dFreqReset(String str) throws RemoteException;

    void requestGetD2dDlFrequencyPoint() throws RemoteException;

    void requestGetD2dFreqHopState() throws RemoteException;

    void requestGetD2dInfo() throws RemoteException;

    boolean requestGetRadioPower() throws RemoteException;

    void requestSendD2DCtrlCmd(String str) throws RemoteException;

    void unregisterCallback(ID2DInfoListener iD2DInfoListener) throws RemoteException;

    public static abstract class Stub extends Binder implements ID2DService {
        private static final String DESCRIPTOR = "com.android.internal.telephony.d2d.ID2DService";
        static final int TRANSACTION_onD2dInfoChanged = 12;
        static final int TRANSACTION_onD2dRequestDone = 13;
        static final int TRANSACTION_registerForD2dInfoChanged = 1;
        static final int TRANSACTION_requestConfigD2dBandwidth = 10;
        static final int TRANSACTION_requestConfigD2dDNEGCload = 15;
        static final int TRANSACTION_requestConfigD2dDNEGCsave = 14;
        static final int TRANSACTION_requestD2dFreqHopCtrl = 7;
        static final int TRANSACTION_requestD2dFreqNegotiation = 4;
        static final int TRANSACTION_requestD2dFreqReset = 5;
        static final int TRANSACTION_requestGetD2dDlFrequencyPoint = 8;
        static final int TRANSACTION_requestGetD2dFreqHopState = 6;
        static final int TRANSACTION_requestGetD2dInfo = 3;
        static final int TRANSACTION_requestGetRadioPower = 11;
        static final int TRANSACTION_requestSendD2DCtrlCmd = 9;
        static final int TRANSACTION_unregisterCallback = 2;

        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static ID2DService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (queryLocalInterface == null || !(queryLocalInterface instanceof ID2DService)) {
                return new Proxy(iBinder);
            }
            return (ID2DService) queryLocalInterface;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        registerForD2dInfoChanged(ID2DInfoListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        unregisterCallback(ID2DInfoListener.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestGetD2dInfo();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestD2dFreqNegotiation();
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestD2dFreqReset(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestGetD2dFreqHopState();
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestD2dFreqHopCtrl /*{ENCODED_INT: 7}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestD2dFreqHopCtrl(parcel.readString(), parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestGetD2dDlFrequencyPoint /*{ENCODED_INT: 8}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestGetD2dDlFrequencyPoint();
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestSendD2DCtrlCmd /*{ENCODED_INT: 9}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestSendD2DCtrlCmd(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestConfigD2dBandwidth /*{ENCODED_INT: 10}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestConfigD2dBandwidth(parcel.readInt() != 0, parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestGetRadioPower /*{ENCODED_INT: 11}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean requestGetRadioPower = requestGetRadioPower();
                        parcel2.writeNoException();
                        parcel2.writeInt(requestGetRadioPower ? 1 : 0);
                        return true;
                    case TRANSACTION_onD2dInfoChanged /*{ENCODED_INT: 12}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2dInfoChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2dRequestDone /*{ENCODED_INT: 13}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2dRequestDone(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestConfigD2dDNEGCsave /*{ENCODED_INT: 14}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestConfigD2dDNEGCsave(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_requestConfigD2dDNEGCload /*{ENCODED_INT: 15}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        requestConfigD2dDNEGCload(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }

        /* access modifiers changed from: private */
        public static class Proxy implements ID2DService {
            private IBinder mRemote;

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void registerForD2dInfoChanged(ID2DInfoListener iD2DInfoListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iD2DInfoListener != null ? iD2DInfoListener.asBinder() : null);
                    this.mRemote.transact(1, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void unregisterCallback(ID2DInfoListener iD2DInfoListener) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(iD2DInfoListener != null ? iD2DInfoListener.asBinder() : null);
                    this.mRemote.transact(2, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestGetD2dInfo() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestD2dFreqNegotiation() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestD2dFreqReset(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    this.mRemote.transact(5, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestGetD2dFreqHopState() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestD2dFreqHopCtrl(String str, String str2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    this.mRemote.transact(Stub.TRANSACTION_requestD2dFreqHopCtrl, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestGetD2dDlFrequencyPoint() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_requestGetD2dDlFrequencyPoint, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestSendD2DCtrlCmd(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    this.mRemote.transact(Stub.TRANSACTION_requestSendD2DCtrlCmd, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestConfigD2dBandwidth(boolean z, int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_requestConfigD2dBandwidth, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public boolean requestGetRadioPower() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean z = false;
                    this.mRemote.transact(Stub.TRANSACTION_requestGetRadioPower, obtain, obtain2, 0);
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void onD2dInfoChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onD2dInfoChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void onD2dRequestDone(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(Stub.TRANSACTION_onD2dRequestDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestConfigD2dDNEGCsave(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    this.mRemote.transact(Stub.TRANSACTION_requestConfigD2dDNEGCsave, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DService
            public void requestConfigD2dDNEGCload(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    this.mRemote.transact(Stub.TRANSACTION_requestConfigD2dDNEGCload, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }
    }
}
