package com.android.internal.telephony.d2d;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;

public interface ID2DInfoListener extends IInterface {
    void onD2DAgcGcsChanged(int i, int i2) throws RemoteException;

    void onD2DAgcUavChanged(int i, int i2) throws RemoteException;

    void onD2DDnegcChanged(int i) throws RemoteException;

    void onD2DFrequencyListReceived() throws RemoteException;

    void onD2DInterferenceListReceived() throws RemoteException;

    void onD2DRadioPowerChanged(boolean z) throws RemoteException;

    void onD2DServiceStatusChanged(ServiceState serviceState) throws RemoteException;

    void onD2DSignalStrengthChanged(SignalStrength signalStrength) throws RemoteException;

    void onD2DSnrGcsChanged(int i, int i2) throws RemoteException;

    void onD2DSnrUavChanged(int i, int i2) throws RemoteException;

    void onD2DULSpeedChanged(int i, int i2) throws RemoteException;

    void onRequestConfigBandwidthDone(int i) throws RemoteException;

    void onRequestConfigD2dDNEGCloadDone(int i) throws RemoteException;

    void onRequestConfigD2dDNEGCsaveDone(int i) throws RemoteException;

    void onRequestFreqHopCtrlDone(int i) throws RemoteException;

    void onRequestFreqNegotiationDone(int i) throws RemoteException;

    void onRequestFreqResetDone(int i) throws RemoteException;

    void onRequestGetDlFrequencyPointDone(int i, int i2) throws RemoteException;

    void onRequestGetFreqHopStateDone(int i, int i2, int i3) throws RemoteException;

    void onRequestSendCtrlCmdDone(int i) throws RemoteException;

    public static abstract class Stub extends Binder implements ID2DInfoListener {
        private static final String DESCRIPTOR = "com.android.internal.telephony.d2d.ID2DInfoListener";
        static final int TRANSACTION_onD2DAgcGcsChanged = 7;
        static final int TRANSACTION_onD2DAgcUavChanged = 8;
        static final int TRANSACTION_onD2DDnegcChanged = 20;
        static final int TRANSACTION_onD2DFrequencyListReceived = 3;
        static final int TRANSACTION_onD2DInterferenceListReceived = 9;
        static final int TRANSACTION_onD2DRadioPowerChanged = 10;
        static final int TRANSACTION_onD2DServiceStatusChanged = 1;
        static final int TRANSACTION_onD2DSignalStrengthChanged = 2;
        static final int TRANSACTION_onD2DSnrGcsChanged = 5;
        static final int TRANSACTION_onD2DSnrUavChanged = 6;
        static final int TRANSACTION_onD2DULSpeedChanged = 4;
        static final int TRANSACTION_onRequestConfigBandwidthDone = 17;
        static final int TRANSACTION_onRequestConfigD2dDNEGCloadDone = 19;
        static final int TRANSACTION_onRequestConfigD2dDNEGCsaveDone = 18;
        static final int TRANSACTION_onRequestFreqHopCtrlDone = 13;
        static final int TRANSACTION_onRequestFreqNegotiationDone = 11;
        static final int TRANSACTION_onRequestFreqResetDone = 12;
        static final int TRANSACTION_onRequestGetDlFrequencyPointDone = 15;
        static final int TRANSACTION_onRequestGetFreqHopStateDone = 14;
        static final int TRANSACTION_onRequestSendCtrlCmdDone = 16;

        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static ID2DInfoListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (queryLocalInterface == null || !(queryLocalInterface instanceof ID2DInfoListener)) {
                return new Proxy(iBinder);
            }
            return (ID2DInfoListener) queryLocalInterface;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                ServiceState serviceState = null;
                SignalStrength signalStrength = null;
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            serviceState = (ServiceState) ServiceState.CREATOR.createFromParcel(parcel);
                        }
                        onD2DServiceStatusChanged(serviceState);
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            signalStrength = SignalStrength.CREATOR.createFromParcel(parcel);
                        }
                        onD2DSignalStrengthChanged(signalStrength);
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DFrequencyListReceived();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DULSpeedChanged(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DSnrGcsChanged(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DSnrUavChanged(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2DAgcGcsChanged /*{ENCODED_INT: 7}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DAgcGcsChanged(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2DAgcUavChanged /*{ENCODED_INT: 8}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DAgcUavChanged(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2DInterferenceListReceived /*{ENCODED_INT: 9}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DInterferenceListReceived();
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2DRadioPowerChanged /*{ENCODED_INT: 10}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DRadioPowerChanged(parcel.readInt() != 0);
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestFreqNegotiationDone /*{ENCODED_INT: 11}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestFreqNegotiationDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestFreqResetDone /*{ENCODED_INT: 12}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestFreqResetDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestFreqHopCtrlDone /*{ENCODED_INT: 13}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestFreqHopCtrlDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestGetFreqHopStateDone /*{ENCODED_INT: 14}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestGetFreqHopStateDone(parcel.readInt(), parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestGetDlFrequencyPointDone /*{ENCODED_INT: 15}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestGetDlFrequencyPointDone(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestSendCtrlCmdDone /*{ENCODED_INT: 16}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestSendCtrlCmdDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestConfigBandwidthDone /*{ENCODED_INT: 17}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestConfigBandwidthDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestConfigD2dDNEGCsaveDone /*{ENCODED_INT: 18}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestConfigD2dDNEGCsaveDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onRequestConfigD2dDNEGCloadDone /*{ENCODED_INT: 19}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onRequestConfigD2dDNEGCloadDone(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case TRANSACTION_onD2DDnegcChanged /*{ENCODED_INT: 20}*/:
                        parcel.enforceInterface(DESCRIPTOR);
                        onD2DDnegcChanged(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }

        private static class Proxy implements ID2DInfoListener {
            private IBinder mRemote;

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DServiceStatusChanged(ServiceState serviceState) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (serviceState != null) {
                        obtain.writeInt(1);
                        serviceState.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    this.mRemote.transact(1, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DSignalStrengthChanged(SignalStrength signalStrength) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (signalStrength != null) {
                        obtain.writeInt(1);
                        signalStrength.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    this.mRemote.transact(2, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DFrequencyListReceived() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DULSpeedChanged(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(4, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DSnrGcsChanged(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(5, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DSnrUavChanged(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(6, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DAgcGcsChanged(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(Stub.TRANSACTION_onD2DAgcGcsChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DAgcUavChanged(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(Stub.TRANSACTION_onD2DAgcUavChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DInterferenceListReceived() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(Stub.TRANSACTION_onD2DInterferenceListReceived, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DRadioPowerChanged(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    this.mRemote.transact(Stub.TRANSACTION_onD2DRadioPowerChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestFreqNegotiationDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestFreqNegotiationDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestFreqResetDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestFreqResetDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestFreqHopCtrlDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestFreqHopCtrlDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestGetFreqHopStateDone(int i, int i2, int i3) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    obtain.writeInt(i3);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestGetFreqHopStateDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestGetDlFrequencyPointDone(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestGetDlFrequencyPointDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestSendCtrlCmdDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestSendCtrlCmdDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestConfigBandwidthDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestConfigBandwidthDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestConfigD2dDNEGCsaveDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestConfigD2dDNEGCsaveDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onRequestConfigD2dDNEGCloadDone(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onRequestConfigD2dDNEGCloadDone, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.android.internal.telephony.d2d.ID2DInfoListener
            public void onD2DDnegcChanged(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    this.mRemote.transact(Stub.TRANSACTION_onD2DDnegcChanged, obtain, obtain2, 0);
                    obtain2.readException();
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }
    }
}
