package w;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import w.r;
/* loaded from: classes.dex */
public class l {

    /* renamed from: d  reason: collision with root package name */
    private static int f14167d;

    /* renamed from: a  reason: collision with root package name */
    private final AccessibilityNodeInfo f14168a;

    /* renamed from: b  reason: collision with root package name */
    public int f14169b = -1;

    /* renamed from: c  reason: collision with root package name */
    private int f14170c = -1;

    /* loaded from: classes.dex */
    public static class a {
        public static final a A;
        public static final a B;
        public static final a C;
        public static final a D;
        public static final a E;
        public static final a F;
        public static final a G;
        public static final a H;
        public static final a I;
        public static final a J;
        public static final a K;
        public static final a L;
        public static final a M;
        public static final a N;
        public static final a O;
        public static final a P;
        public static final a Q;
        public static final a R;
        public static final a S;
        public static final a T;
        public static final a U;
        public static final a V;

        /* renamed from: e  reason: collision with root package name */
        public static final a f14171e = new a(1, null);

        /* renamed from: f  reason: collision with root package name */
        public static final a f14172f = new a(2, null);

        /* renamed from: g  reason: collision with root package name */
        public static final a f14173g = new a(4, null);

        /* renamed from: h  reason: collision with root package name */
        public static final a f14174h = new a(8, null);

        /* renamed from: i  reason: collision with root package name */
        public static final a f14175i = new a(16, null);

        /* renamed from: j  reason: collision with root package name */
        public static final a f14176j = new a(32, null);

        /* renamed from: k  reason: collision with root package name */
        public static final a f14177k = new a(64, null);

        /* renamed from: l  reason: collision with root package name */
        public static final a f14178l = new a(128, null);

        /* renamed from: m  reason: collision with root package name */
        public static final a f14179m = new a(256, null, r.b.class);

        /* renamed from: n  reason: collision with root package name */
        public static final a f14180n = new a(512, null, r.b.class);

        /* renamed from: o  reason: collision with root package name */
        public static final a f14181o = new a(1024, null, r.c.class);

        /* renamed from: p  reason: collision with root package name */
        public static final a f14182p = new a(2048, null, r.c.class);

        /* renamed from: q  reason: collision with root package name */
        public static final a f14183q = new a(4096, null);

        /* renamed from: r  reason: collision with root package name */
        public static final a f14184r = new a(8192, null);

        /* renamed from: s  reason: collision with root package name */
        public static final a f14185s = new a(16384, null);

        /* renamed from: t  reason: collision with root package name */
        public static final a f14186t = new a(32768, null);

        /* renamed from: u  reason: collision with root package name */
        public static final a f14187u = new a(65536, null);

        /* renamed from: v  reason: collision with root package name */
        public static final a f14188v = new a(131072, null, r.g.class);

        /* renamed from: w  reason: collision with root package name */
        public static final a f14189w = new a(262144, null);

        /* renamed from: x  reason: collision with root package name */
        public static final a f14190x = new a(524288, null);

        /* renamed from: y  reason: collision with root package name */
        public static final a f14191y = new a(1048576, null);

        /* renamed from: z  reason: collision with root package name */
        public static final a f14192z = new a(2097152, null, r.h.class);

        /* renamed from: a  reason: collision with root package name */
        final Object f14193a;

        /* renamed from: b  reason: collision with root package name */
        private final int f14194b;

        /* renamed from: c  reason: collision with root package name */
        private final Class f14195c;

        /* renamed from: d  reason: collision with root package name */
        protected final r f14196d;

        static {
            int i10 = Build.VERSION.SDK_INT;
            A = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SHOW_ON_SCREEN : null, 16908342, null, null, null);
            B = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_TO_POSITION : null, 16908343, null, null, r.e.class);
            C = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP : null, 16908344, null, null, null);
            D = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_LEFT : null, 16908345, null, null, null);
            E = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN : null, 16908346, null, null, null);
            F = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_RIGHT : null, 16908347, null, null, null);
            G = new a(i10 >= 29 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_UP : null, 16908358, null, null, null);
            H = new a(i10 >= 29 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_DOWN : null, 16908359, null, null, null);
            I = new a(i10 >= 29 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_LEFT : null, 16908360, null, null, null);
            J = new a(i10 >= 29 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_RIGHT : null, 16908361, null, null, null);
            K = new a(i10 >= 23 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_CONTEXT_CLICK : null, 16908348, null, null, null);
            L = new a(i10 >= 24 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_PROGRESS : null, 16908349, null, null, r.f.class);
            M = new a(i10 >= 26 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_MOVE_WINDOW : null, 16908354, null, null, r.d.class);
            N = new a(i10 >= 28 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SHOW_TOOLTIP : null, 16908356, null, null, null);
            O = new a(i10 >= 28 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_HIDE_TOOLTIP : null, 16908357, null, null, null);
            P = new a(i10 >= 30 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_PRESS_AND_HOLD : null, 16908362, null, null, null);
            Q = new a(i10 >= 30 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_IME_ENTER : null, 16908372, null, null, null);
            R = new a(i10 >= 32 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_DRAG_START : null, 16908373, null, null, null);
            S = new a(i10 >= 32 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_DRAG_DROP : null, 16908374, null, null, null);
            T = new a(i10 >= 32 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_DRAG_CANCEL : null, 16908375, null, null, null);
            U = new a(i10 >= 33 ? AccessibilityNodeInfo.AccessibilityAction.ACTION_SHOW_TEXT_SUGGESTIONS : null, 16908376, null, null, null);
            V = new a(i10 >= 34 ? d.a() : null, 16908382, null, null, null);
        }

        public a(int i10, CharSequence charSequence) {
            this(null, i10, charSequence, null, null);
        }

        private a(int i10, CharSequence charSequence, Class cls) {
            this(null, i10, charSequence, null, cls);
        }

        a(Object obj) {
            this(obj, 0, null, null, null);
        }

        a(Object obj, int i10, CharSequence charSequence, r rVar, Class cls) {
            this.f14194b = i10;
            this.f14196d = rVar;
            this.f14193a = obj == null ? new AccessibilityNodeInfo.AccessibilityAction(i10, charSequence) : obj;
            this.f14195c = cls;
        }

        public a a(CharSequence charSequence, r rVar) {
            return new a(null, this.f14194b, charSequence, rVar, this.f14195c);
        }

        public int b() {
            return ((AccessibilityNodeInfo.AccessibilityAction) this.f14193a).getId();
        }

        public CharSequence c() {
            return ((AccessibilityNodeInfo.AccessibilityAction) this.f14193a).getLabel();
        }

        public boolean d(View view, Bundle bundle) {
            if (this.f14196d != null) {
                Class cls = this.f14195c;
                if (cls != null) {
                    try {
                        android.support.v4.media.session.b.a(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        throw null;
                    } catch (Exception e10) {
                        Class cls2 = this.f14195c;
                        String name = cls2 == null ? "null" : cls2.getName();
                        Log.e("A11yActionCompat", "Failed to execute command with argument class ViewCommandArgument: " + name, e10);
                    }
                }
                return this.f14196d.a(view, null);
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj != null && (obj instanceof a)) {
                Object obj2 = this.f14193a;
                Object obj3 = ((a) obj).f14193a;
                return obj2 == null ? obj3 == null : obj2.equals(obj3);
            }
            return false;
        }

        public int hashCode() {
            Object obj = this.f14193a;
            if (obj != null) {
                return obj.hashCode();
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AccessibilityActionCompat: ");
            String i10 = l.i(this.f14194b);
            if (i10.equals("ACTION_UNKNOWN") && c() != null) {
                i10 = c().toString();
            }
            sb.append(i10);
            return sb.toString();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b {
        public static Object a(int i10, float f10, float f11, float f12) {
            return new AccessibilityNodeInfo.RangeInfo(i10, f10, f11, f12);
        }

        public static CharSequence b(AccessibilityNodeInfo accessibilityNodeInfo) {
            CharSequence stateDescription;
            stateDescription = accessibilityNodeInfo.getStateDescription();
            return stateDescription;
        }

        public static void c(AccessibilityNodeInfo accessibilityNodeInfo, CharSequence charSequence) {
            accessibilityNodeInfo.setStateDescription(charSequence);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c {
        public static f a(boolean z9, int i10, int i11, int i12, int i13, boolean z10, String str, String str2) {
            return new f(new AccessibilityNodeInfo.CollectionItemInfo.Builder().setHeading(z9).setColumnIndex(i10).setRowIndex(i11).setColumnSpan(i12).setRowSpan(i13).setSelected(z10).setRowTitle(str).setColumnTitle(str2).build());
        }

        public static l b(AccessibilityNodeInfo accessibilityNodeInfo, int i10, int i11) {
            return l.I0(accessibilityNodeInfo.getChild(i10, i11));
        }

        public static String c(Object obj) {
            return ((AccessibilityNodeInfo.CollectionItemInfo) obj).getColumnTitle();
        }

        public static String d(Object obj) {
            return ((AccessibilityNodeInfo.CollectionItemInfo) obj).getRowTitle();
        }

        public static AccessibilityNodeInfo.ExtraRenderingInfo e(AccessibilityNodeInfo accessibilityNodeInfo) {
            AccessibilityNodeInfo.ExtraRenderingInfo extraRenderingInfo;
            extraRenderingInfo = accessibilityNodeInfo.getExtraRenderingInfo();
            return extraRenderingInfo;
        }

        public static l f(AccessibilityNodeInfo accessibilityNodeInfo, int i10) {
            return l.I0(accessibilityNodeInfo.getParent(i10));
        }

        public static String g(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.getUniqueId();
        }

        public static boolean h(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.isTextSelectable();
        }

        public static void i(AccessibilityNodeInfo accessibilityNodeInfo, boolean z9) {
            accessibilityNodeInfo.setTextSelectable(z9);
        }

        public static void j(AccessibilityNodeInfo accessibilityNodeInfo, String str) {
            accessibilityNodeInfo.setUniqueId(str);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d {
        public static AccessibilityNodeInfo.AccessibilityAction a() {
            return AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_IN_DIRECTION;
        }

        public static void b(AccessibilityNodeInfo accessibilityNodeInfo, Rect rect) {
            accessibilityNodeInfo.getBoundsInWindow(rect);
        }

        public static CharSequence c(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.getContainerTitle();
        }

        public static long d(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.getMinDurationBetweenContentChanges().toMillis();
        }

        public static boolean e(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.hasRequestInitialAccessibilityFocus();
        }

        public static boolean f(AccessibilityNodeInfo accessibilityNodeInfo) {
            return accessibilityNodeInfo.isAccessibilityDataSensitive();
        }

        public static void g(AccessibilityNodeInfo accessibilityNodeInfo, boolean z9) {
            accessibilityNodeInfo.setAccessibilityDataSensitive(z9);
        }

        public static void h(AccessibilityNodeInfo accessibilityNodeInfo, Rect rect) {
            accessibilityNodeInfo.setBoundsInWindow(rect);
        }

        public static void i(AccessibilityNodeInfo accessibilityNodeInfo, CharSequence charSequence) {
            accessibilityNodeInfo.setContainerTitle(charSequence);
        }

        public static void j(AccessibilityNodeInfo accessibilityNodeInfo, long j10) {
            accessibilityNodeInfo.setMinDurationBetweenContentChanges(Duration.ofMillis(j10));
        }

        public static void k(AccessibilityNodeInfo accessibilityNodeInfo, View view, boolean z9) {
            accessibilityNodeInfo.setQueryFromAppProcessEnabled(view, z9);
        }

        public static void l(AccessibilityNodeInfo accessibilityNodeInfo, boolean z9) {
            accessibilityNodeInfo.setRequestInitialAccessibilityFocus(z9);
        }
    }

    /* loaded from: classes.dex */
    public static class e {

        /* renamed from: a  reason: collision with root package name */
        final Object f14197a;

        e(Object obj) {
            this.f14197a = obj;
        }

        public static e a(int i10, int i11, boolean z9, int i12) {
            return new e(AccessibilityNodeInfo.CollectionInfo.obtain(i10, i11, z9, i12));
        }
    }

    /* loaded from: classes.dex */
    public static class f {

        /* renamed from: a  reason: collision with root package name */
        final Object f14198a;

        f(Object obj) {
            this.f14198a = obj;
        }

        public static f a(int i10, int i11, int i12, int i13, boolean z9, boolean z10) {
            return new f(AccessibilityNodeInfo.CollectionItemInfo.obtain(i10, i11, i12, i13, z9, z10));
        }
    }

    private l(AccessibilityNodeInfo accessibilityNodeInfo) {
        this.f14168a = accessibilityNodeInfo;
    }

    public l(Object obj) {
        this.f14168a = (AccessibilityNodeInfo) obj;
    }

    private boolean E() {
        return !g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY").isEmpty();
    }

    private int F(ClickableSpan clickableSpan, SparseArray sparseArray) {
        if (sparseArray != null) {
            for (int i10 = 0; i10 < sparseArray.size(); i10++) {
                if (clickableSpan.equals((ClickableSpan) ((WeakReference) sparseArray.valueAt(i10)).get())) {
                    return sparseArray.keyAt(i10);
                }
            }
        }
        int i11 = f14167d;
        f14167d = i11 + 1;
        return i11;
    }

    public static l H0(AccessibilityNodeInfo accessibilityNodeInfo) {
        return new l(accessibilityNodeInfo);
    }

    static l I0(Object obj) {
        if (obj != null) {
            return new l(obj);
        }
        return null;
    }

    public static l X() {
        return H0(AccessibilityNodeInfo.obtain());
    }

    public static l Y(View view) {
        return H0(AccessibilityNodeInfo.obtain(view));
    }

    public static l Z(l lVar) {
        return H0(AccessibilityNodeInfo.obtain(lVar.f14168a));
    }

    private void c0(View view) {
        SparseArray y9 = y(view);
        if (y9 != null) {
            ArrayList arrayList = new ArrayList();
            for (int i10 = 0; i10 < y9.size(); i10++) {
                if (((WeakReference) y9.valueAt(i10)).get() == null) {
                    arrayList.add(Integer.valueOf(i10));
                }
            }
            for (int i11 = 0; i11 < arrayList.size(); i11++) {
                y9.remove(((Integer) arrayList.get(i11)).intValue());
            }
        }
    }

    private void d(ClickableSpan clickableSpan, Spanned spanned, int i10) {
        g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY").add(Integer.valueOf(spanned.getSpanStart(clickableSpan)));
        g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_END_KEY").add(Integer.valueOf(spanned.getSpanEnd(clickableSpan)));
        g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_FLAGS_KEY").add(Integer.valueOf(spanned.getSpanFlags(clickableSpan)));
        g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ID_KEY").add(Integer.valueOf(i10));
    }

    private void e0(int i10, boolean z9) {
        Bundle u9 = u();
        if (u9 != null) {
            int i11 = u9.getInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.BOOLEAN_PROPERTY_KEY", 0) & (~i10);
            if (!z9) {
                i10 = 0;
            }
            u9.putInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.BOOLEAN_PROPERTY_KEY", i10 | i11);
        }
    }

    private void f() {
        this.f14168a.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY");
        this.f14168a.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_END_KEY");
        this.f14168a.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_FLAGS_KEY");
        this.f14168a.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ID_KEY");
    }

    private List g(String str) {
        ArrayList<Integer> integerArrayList = this.f14168a.getExtras().getIntegerArrayList(str);
        if (integerArrayList == null) {
            ArrayList<Integer> arrayList = new ArrayList<>();
            this.f14168a.getExtras().putIntegerArrayList(str, arrayList);
            return arrayList;
        }
        return integerArrayList;
    }

    static String i(int i10) {
        if (i10 != 1) {
            if (i10 != 2) {
                switch (i10) {
                    case 4:
                        return "ACTION_SELECT";
                    case 8:
                        return "ACTION_CLEAR_SELECTION";
                    case 16:
                        return "ACTION_CLICK";
                    case 32:
                        return "ACTION_LONG_CLICK";
                    case 64:
                        return "ACTION_ACCESSIBILITY_FOCUS";
                    case 128:
                        return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
                    case 256:
                        return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
                    case 512:
                        return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
                    case 1024:
                        return "ACTION_NEXT_HTML_ELEMENT";
                    case 2048:
                        return "ACTION_PREVIOUS_HTML_ELEMENT";
                    case 4096:
                        return "ACTION_SCROLL_FORWARD";
                    case 8192:
                        return "ACTION_SCROLL_BACKWARD";
                    case 16384:
                        return "ACTION_COPY";
                    case 32768:
                        return "ACTION_PASTE";
                    case 65536:
                        return "ACTION_CUT";
                    case 131072:
                        return "ACTION_SET_SELECTION";
                    case 262144:
                        return "ACTION_EXPAND";
                    case 524288:
                        return "ACTION_COLLAPSE";
                    case 2097152:
                        return "ACTION_SET_TEXT";
                    case 16908354:
                        return "ACTION_MOVE_WINDOW";
                    case 16908382:
                        return "ACTION_SCROLL_IN_DIRECTION";
                    default:
                        switch (i10) {
                            case 16908342:
                                return "ACTION_SHOW_ON_SCREEN";
                            case 16908343:
                                return "ACTION_SCROLL_TO_POSITION";
                            case 16908344:
                                return "ACTION_SCROLL_UP";
                            case 16908345:
                                return "ACTION_SCROLL_LEFT";
                            case 16908346:
                                return "ACTION_SCROLL_DOWN";
                            case 16908347:
                                return "ACTION_SCROLL_RIGHT";
                            case 16908348:
                                return "ACTION_CONTEXT_CLICK";
                            case 16908349:
                                return "ACTION_SET_PROGRESS";
                            default:
                                switch (i10) {
                                    case 16908356:
                                        return "ACTION_SHOW_TOOLTIP";
                                    case 16908357:
                                        return "ACTION_HIDE_TOOLTIP";
                                    case 16908358:
                                        return "ACTION_PAGE_UP";
                                    case 16908359:
                                        return "ACTION_PAGE_DOWN";
                                    case 16908360:
                                        return "ACTION_PAGE_LEFT";
                                    case 16908361:
                                        return "ACTION_PAGE_RIGHT";
                                    case 16908362:
                                        return "ACTION_PRESS_AND_HOLD";
                                    default:
                                        switch (i10) {
                                            case 16908372:
                                                return "ACTION_IME_ENTER";
                                            case 16908373:
                                                return "ACTION_DRAG_START";
                                            case 16908374:
                                                return "ACTION_DRAG_DROP";
                                            case 16908375:
                                                return "ACTION_DRAG_CANCEL";
                                            default:
                                                return "ACTION_UNKNOWN";
                                        }
                                }
                        }
                }
            }
            return "ACTION_CLEAR_FOCUS";
        }
        return "ACTION_FOCUS";
    }

    private boolean k(int i10) {
        Bundle u9 = u();
        return u9 != null && (u9.getInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.BOOLEAN_PROPERTY_KEY", 0) & i10) == i10;
    }

    public static ClickableSpan[] q(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            return (ClickableSpan[]) ((Spanned) charSequence).getSpans(0, charSequence.length(), ClickableSpan.class);
        }
        return null;
    }

    private SparseArray w(View view) {
        SparseArray y9 = y(view);
        if (y9 == null) {
            SparseArray sparseArray = new SparseArray();
            view.setTag(q.b.I, sparseArray);
            return sparseArray;
        }
        return y9;
    }

    private SparseArray y(View view) {
        return (SparseArray) view.getTag(q.b.I);
    }

    public CharSequence A() {
        if (E()) {
            List g10 = g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY");
            List g11 = g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_END_KEY");
            List g12 = g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_FLAGS_KEY");
            List g13 = g("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ID_KEY");
            SpannableString spannableString = new SpannableString(TextUtils.substring(this.f14168a.getText(), 0, this.f14168a.getText().length()));
            for (int i10 = 0; i10 < g10.size(); i10++) {
                spannableString.setSpan(new w.a(((Integer) g13.get(i10)).intValue(), this, u().getInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ACTION_ID_KEY")), ((Integer) g10.get(i10)).intValue(), ((Integer) g11.get(i10)).intValue(), ((Integer) g12.get(i10)).intValue());
            }
            return spannableString;
        }
        return this.f14168a.getText();
    }

    public void A0(boolean z9) {
        this.f14168a.setScrollable(z9);
    }

    public CharSequence B() {
        CharSequence tooltipText;
        if (Build.VERSION.SDK_INT >= 28) {
            tooltipText = this.f14168a.getTooltipText();
            return tooltipText;
        }
        return this.f14168a.getExtras().getCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.TOOLTIP_TEXT_KEY");
    }

    public void B0(boolean z9) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.f14168a.setShowingHintText(z9);
        } else {
            e0(4, z9);
        }
    }

    public String C() {
        return Build.VERSION.SDK_INT >= 33 ? c.g(this.f14168a) : this.f14168a.getExtras().getString("androidx.view.accessibility.AccessibilityNodeInfoCompat.UNIQUE_ID_KEY");
    }

    public void C0(View view, int i10) {
        this.f14170c = i10;
        this.f14168a.setSource(view, i10);
    }

    public String D() {
        return this.f14168a.getViewIdResourceName();
    }

    public void D0(CharSequence charSequence) {
        if (Build.VERSION.SDK_INT >= 30) {
            b.c(this.f14168a, charSequence);
        } else {
            this.f14168a.getExtras().putCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.STATE_DESCRIPTION_KEY", charSequence);
        }
    }

    public void E0(CharSequence charSequence) {
        this.f14168a.setText(charSequence);
    }

    public void F0(boolean z9) {
        this.f14168a.setVisibleToUser(z9);
    }

    public boolean G() {
        return Build.VERSION.SDK_INT >= 34 ? d.f(this.f14168a) : k(64);
    }

    public AccessibilityNodeInfo G0() {
        return this.f14168a;
    }

    public boolean H() {
        return this.f14168a.isCheckable();
    }

    public boolean I() {
        return this.f14168a.isChecked();
    }

    public boolean J() {
        return this.f14168a.isClickable();
    }

    public boolean K() {
        boolean isContextClickable;
        if (Build.VERSION.SDK_INT >= 23) {
            isContextClickable = this.f14168a.isContextClickable();
            return isContextClickable;
        }
        return false;
    }

    public boolean L() {
        return this.f14168a.isEnabled();
    }

    public boolean M() {
        return this.f14168a.isFocusable();
    }

    public boolean N() {
        return this.f14168a.isFocused();
    }

    public boolean O() {
        return k(67108864);
    }

    public boolean P() {
        boolean isImportantForAccessibility;
        if (Build.VERSION.SDK_INT >= 24) {
            isImportantForAccessibility = this.f14168a.isImportantForAccessibility();
            return isImportantForAccessibility;
        }
        return true;
    }

    public boolean Q() {
        return this.f14168a.isLongClickable();
    }

    public boolean R() {
        return this.f14168a.isPassword();
    }

    public boolean S() {
        return this.f14168a.isScrollable();
    }

    public boolean T() {
        return this.f14168a.isSelected();
    }

    public boolean U() {
        boolean isShowingHintText;
        if (Build.VERSION.SDK_INT >= 26) {
            isShowingHintText = this.f14168a.isShowingHintText();
            return isShowingHintText;
        }
        return k(4);
    }

    public boolean V() {
        return Build.VERSION.SDK_INT >= 33 ? c.h(this.f14168a) : k(8388608);
    }

    public boolean W() {
        return this.f14168a.isVisibleToUser();
    }

    public void a(int i10) {
        this.f14168a.addAction(i10);
    }

    public boolean a0(int i10, Bundle bundle) {
        return this.f14168a.performAction(i10, bundle);
    }

    public void b(a aVar) {
        this.f14168a.addAction((AccessibilityNodeInfo.AccessibilityAction) aVar.f14193a);
    }

    public void b0() {
    }

    public void c(View view, int i10) {
        this.f14168a.addChild(view, i10);
    }

    public void d0(boolean z9) {
        this.f14168a.setAccessibilityFocused(z9);
    }

    public void e(CharSequence charSequence, View view) {
        if (Build.VERSION.SDK_INT < 26) {
            f();
            c0(view);
            ClickableSpan[] q10 = q(charSequence);
            if (q10 == null || q10.length <= 0) {
                return;
            }
            u().putInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ACTION_ID_KEY", q.b.f11963a);
            SparseArray w9 = w(view);
            for (int i10 = 0; i10 < q10.length; i10++) {
                int F = F(q10[i10], w9);
                w9.put(F, new WeakReference(q10[i10]));
                d(q10[i10], (Spanned) charSequence, F);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && (obj instanceof l)) {
            l lVar = (l) obj;
            AccessibilityNodeInfo accessibilityNodeInfo = this.f14168a;
            if (accessibilityNodeInfo == null) {
                if (lVar.f14168a != null) {
                    return false;
                }
            } else if (!accessibilityNodeInfo.equals(lVar.f14168a)) {
                return false;
            }
            return this.f14170c == lVar.f14170c && this.f14169b == lVar.f14169b;
        }
        return false;
    }

    public void f0(Rect rect) {
        this.f14168a.setBoundsInParent(rect);
    }

    public void g0(Rect rect) {
        this.f14168a.setBoundsInScreen(rect);
    }

    public List h() {
        List<AccessibilityNodeInfo.AccessibilityAction> actionList = this.f14168a.getActionList();
        if (actionList != null) {
            ArrayList arrayList = new ArrayList();
            int size = actionList.size();
            for (int i10 = 0; i10 < size; i10++) {
                arrayList.add(new a(actionList.get(i10)));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void h0(boolean z9) {
        this.f14168a.setCheckable(z9);
    }

    public int hashCode() {
        AccessibilityNodeInfo accessibilityNodeInfo = this.f14168a;
        if (accessibilityNodeInfo == null) {
            return 0;
        }
        return accessibilityNodeInfo.hashCode();
    }

    public void i0(boolean z9) {
        this.f14168a.setChecked(z9);
    }

    public int j() {
        return this.f14168a.getActions();
    }

    public void j0(CharSequence charSequence) {
        this.f14168a.setClassName(charSequence);
    }

    public void k0(boolean z9) {
        this.f14168a.setClickable(z9);
    }

    public void l(Rect rect) {
        this.f14168a.getBoundsInParent(rect);
    }

    public void l0(Object obj) {
        this.f14168a.setCollectionInfo(obj == null ? null : (AccessibilityNodeInfo.CollectionInfo) ((e) obj).f14197a);
    }

    public void m(Rect rect) {
        this.f14168a.getBoundsInScreen(rect);
    }

    public void m0(Object obj) {
        this.f14168a.setCollectionItemInfo(obj == null ? null : (AccessibilityNodeInfo.CollectionItemInfo) ((f) obj).f14198a);
    }

    public void n(Rect rect) {
        if (Build.VERSION.SDK_INT >= 34) {
            d.b(this.f14168a, rect);
            return;
        }
        Rect rect2 = (Rect) this.f14168a.getExtras().getParcelable("androidx.view.accessibility.AccessibilityNodeInfoCompat.BOUNDS_IN_WINDOW_KEY");
        if (rect2 != null) {
            rect.set(rect2.left, rect2.top, rect2.right, rect2.bottom);
        }
    }

    public void n0(CharSequence charSequence) {
        this.f14168a.setContentDescription(charSequence);
    }

    public int o() {
        return this.f14168a.getChildCount();
    }

    public void o0(boolean z9) {
        this.f14168a.setContentInvalid(z9);
    }

    public CharSequence p() {
        return this.f14168a.getClassName();
    }

    public void p0(boolean z9) {
        this.f14168a.setEnabled(z9);
    }

    public void q0(CharSequence charSequence) {
        this.f14168a.setError(charSequence);
    }

    public CharSequence r() {
        return Build.VERSION.SDK_INT >= 34 ? d.c(this.f14168a) : this.f14168a.getExtras().getCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.CONTAINER_TITLE_KEY");
    }

    public void r0(boolean z9) {
        this.f14168a.setFocusable(z9);
    }

    public CharSequence s() {
        return this.f14168a.getContentDescription();
    }

    public void s0(boolean z9) {
        this.f14168a.setFocused(z9);
    }

    public CharSequence t() {
        return this.f14168a.getError();
    }

    public void t0(boolean z9) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.f14168a.setHeading(z9);
        } else {
            e0(2, z9);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Rect rect = new Rect();
        l(rect);
        sb.append("; boundsInParent: " + rect);
        m(rect);
        sb.append("; boundsInScreen: " + rect);
        n(rect);
        sb.append("; boundsInWindow: " + rect);
        sb.append("; packageName: ");
        sb.append(x());
        sb.append("; className: ");
        sb.append(p());
        sb.append("; text: ");
        sb.append(A());
        sb.append("; error: ");
        sb.append(t());
        sb.append("; maxTextLength: ");
        sb.append(v());
        sb.append("; stateDescription: ");
        sb.append(z());
        sb.append("; contentDescription: ");
        sb.append(s());
        sb.append("; tooltipText: ");
        sb.append(B());
        sb.append("; viewIdResName: ");
        sb.append(D());
        sb.append("; uniqueId: ");
        sb.append(C());
        sb.append("; checkable: ");
        sb.append(H());
        sb.append("; checked: ");
        sb.append(I());
        sb.append("; focusable: ");
        sb.append(M());
        sb.append("; focused: ");
        sb.append(N());
        sb.append("; selected: ");
        sb.append(T());
        sb.append("; clickable: ");
        sb.append(J());
        sb.append("; longClickable: ");
        sb.append(Q());
        sb.append("; contextClickable: ");
        sb.append(K());
        sb.append("; enabled: ");
        sb.append(L());
        sb.append("; password: ");
        sb.append(R());
        sb.append("; scrollable: " + S());
        sb.append("; containerTitle: ");
        sb.append(r());
        sb.append("; granularScrollingSupported: ");
        sb.append(O());
        sb.append("; importantForAccessibility: ");
        sb.append(P());
        sb.append("; visible: ");
        sb.append(W());
        sb.append("; isTextSelectable: ");
        sb.append(V());
        sb.append("; accessibilityDataSensitive: ");
        sb.append(G());
        sb.append("; [");
        List h10 = h();
        for (int i10 = 0; i10 < h10.size(); i10++) {
            a aVar = (a) h10.get(i10);
            String i11 = i(aVar.b());
            if (i11.equals("ACTION_UNKNOWN") && aVar.c() != null) {
                i11 = aVar.c().toString();
            }
            sb.append(i11);
            if (i10 != h10.size() - 1) {
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public Bundle u() {
        return this.f14168a.getExtras();
    }

    public void u0(CharSequence charSequence) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.f14168a.setHintText(charSequence);
        } else {
            this.f14168a.getExtras().putCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.HINT_TEXT_KEY", charSequence);
        }
    }

    public int v() {
        return this.f14168a.getMaxTextLength();
    }

    public void v0(CharSequence charSequence) {
        this.f14168a.setPackageName(charSequence);
    }

    public void w0(CharSequence charSequence) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.f14168a.setPaneTitle(charSequence);
        } else {
            this.f14168a.getExtras().putCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.PANE_TITLE_KEY", charSequence);
        }
    }

    public CharSequence x() {
        return this.f14168a.getPackageName();
    }

    public void x0(View view) {
        this.f14169b = -1;
        this.f14168a.setParent(view);
    }

    public void y0(View view, int i10) {
        this.f14169b = i10;
        this.f14168a.setParent(view, i10);
    }

    public CharSequence z() {
        return Build.VERSION.SDK_INT >= 30 ? b.b(this.f14168a) : this.f14168a.getExtras().getCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.STATE_DESCRIPTION_KEY");
    }

    public void z0(boolean z9) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.f14168a.setScreenReaderFocusable(z9);
        } else {
            e0(1, z9);
        }
    }
}
