package vn.hunghd.flutterdownloader;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import androidx.core.app.n0;
import androidx.work.b;
import g8.q;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.g;
import kotlin.jvm.internal.k;
import r3.d;
import r3.n;
import r3.p;
import r3.y;
import r3.z;
import r9.i;
/* loaded from: classes.dex */
public final class a implements MethodChannel.MethodCallHandler, FlutterPlugin {

    /* renamed from: o  reason: collision with root package name */
    public static final C0243a f14153o = new C0243a(null);

    /* renamed from: g  reason: collision with root package name */
    private MethodChannel f14154g;

    /* renamed from: h  reason: collision with root package name */
    private i f14155h;

    /* renamed from: i  reason: collision with root package name */
    private Context f14156i;

    /* renamed from: j  reason: collision with root package name */
    private long f14157j;

    /* renamed from: k  reason: collision with root package name */
    private int f14158k;

    /* renamed from: l  reason: collision with root package name */
    private int f14159l;

    /* renamed from: m  reason: collision with root package name */
    private int f14160m;

    /* renamed from: n  reason: collision with root package name */
    private final Object f14161n = new Object();

    /* renamed from: vn.hunghd.flutterdownloader.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static final class C0243a {
        private C0243a() {
        }

        public /* synthetic */ C0243a(g gVar) {
            this();
        }
    }

    private final z a(String str, String str2, String str3, String str4, boolean z9, boolean z10, boolean z11, boolean z12, boolean z13, int i10, boolean z14) {
        p.a aVar = (p.a) ((p.a) ((p.a) new p.a(DownloadWorker.class).j(new d.a().c(z12).b(z14 ? n.CONNECTED : n.UNMETERED).a())).a("flutter_download_task")).i(r3.a.EXPONENTIAL, 10L, TimeUnit.SECONDS);
        androidx.work.b a10 = new b.a().h("url", str).h("saved_file", str2).h("file_name", str3).h("headers", str4).e("show_notification", z9).e("open_file_from_notification", z10).e("is_resume", z11).g("callback_handle", this.f14157j).f("step", this.f14158k).e("debug", this.f14159l == 1).e("ignoreSsl", this.f14160m == 1).e("save_in_public_storage", z13).f("timeout", i10).a();
        k.d(a10, "Builder()\n              …                 .build()");
        return ((p.a) aVar.l(a10)).b();
    }

    private final void b(MethodCall methodCall, MethodChannel.Result result) {
        y.e(o()).b(UUID.fromString((String) n(methodCall, "task_id")));
        result.success(null);
    }

    private final void c(MethodChannel.Result result) {
        y.e(o()).a("flutter_download_task");
        result.success(null);
    }

    private final void d(File file) {
        String[] strArr = {"_id"};
        String absolutePath = file.getAbsolutePath();
        k.d(absolutePath, "file.absolutePath");
        String[] strArr2 = {absolutePath};
        Uri EXTERNAL_CONTENT_URI = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        k.d(EXTERNAL_CONTENT_URI, "EXTERNAL_CONTENT_URI");
        ContentResolver contentResolver = o().getContentResolver();
        k.d(contentResolver, "requireContext().contentResolver");
        Cursor query = contentResolver.query(EXTERNAL_CONTENT_URI, strArr, "_data = ?", strArr2, null);
        if (query == null || !query.moveToFirst()) {
            Cursor query2 = contentResolver.query(EXTERNAL_CONTENT_URI, strArr, "_data = ?", strArr2, null);
            if (query2 != null && query2.moveToFirst()) {
                Uri withAppendedId = ContentUris.withAppendedId(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, query2.getLong(query2.getColumnIndexOrThrow("_id")));
                k.d(withAppendedId, "withAppendedId(MediaStor…EXTERNAL_CONTENT_URI, id)");
                contentResolver.delete(withAppendedId, null, null);
            }
            if (query2 != null) {
                query2.close();
            }
        } else {
            Uri withAppendedId2 = ContentUris.withAppendedId(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, query.getLong(query.getColumnIndexOrThrow("_id")));
            k.d(withAppendedId2, "withAppendedId(MediaStor…EXTERNAL_CONTENT_URI, id)");
            contentResolver.delete(withAppendedId2, null, null);
        }
        if (query != null) {
            query.close();
        }
    }

    private final void e(MethodCall methodCall, MethodChannel.Result result) {
        String str = (String) n(methodCall, "url");
        String str2 = (String) n(methodCall, "saved_dir");
        String str3 = (String) methodCall.argument("file_name");
        String str4 = (String) n(methodCall, "headers");
        int intValue = ((Number) n(methodCall, "timeout")).intValue();
        boolean booleanValue = ((Boolean) n(methodCall, "show_notification")).booleanValue();
        boolean booleanValue2 = ((Boolean) n(methodCall, "open_file_from_notification")).booleanValue();
        boolean booleanValue3 = ((Boolean) n(methodCall, "requires_storage_not_low")).booleanValue();
        boolean booleanValue4 = ((Boolean) n(methodCall, "save_in_public_storage")).booleanValue();
        boolean booleanValue5 = ((Boolean) n(methodCall, "allow_cellular")).booleanValue();
        z a10 = a(str, str2, str3, str4, booleanValue, booleanValue2, false, booleanValue3, booleanValue4, intValue, booleanValue5);
        y.e(o()).d(a10);
        String uuid = a10.a().toString();
        k.d(uuid, "request.id.toString()");
        result.success(uuid);
        r9.a aVar = r9.a.ENQUEUED;
        r(uuid, aVar, 0);
        i iVar = this.f14155h;
        k.b(iVar);
        iVar.b(uuid, str, aVar, 0, str3, str2, str4, booleanValue, booleanValue2, booleanValue4, booleanValue5);
    }

    private final void f(MethodCall methodCall, MethodChannel.Result result) {
        SharedPreferences.Editor edit;
        SharedPreferences.Editor putLong;
        Object obj = methodCall.arguments;
        k.c(obj, "null cannot be cast to non-null type kotlin.collections.List<*>");
        List list = (List) obj;
        long parseLong = Long.parseLong(String.valueOf(list.get(0)));
        this.f14159l = Integer.parseInt(String.valueOf(list.get(1)));
        this.f14160m = Integer.parseInt(String.valueOf(list.get(2)));
        Context context = this.f14156i;
        SharedPreferences sharedPreferences = context != null ? context.getSharedPreferences("vn.hunghd.downloader.pref", 0) : null;
        if (sharedPreferences != null && (edit = sharedPreferences.edit()) != null && (putLong = edit.putLong("callback_dispatcher_handle_key", parseLong)) != null) {
            putLong.apply();
        }
        result.success(null);
    }

    private final void g(MethodChannel.Result result) {
        i iVar = this.f14155h;
        k.b(iVar);
        List<r9.b> c10 = iVar.c();
        ArrayList arrayList = new ArrayList();
        for (r9.b bVar : c10) {
            HashMap hashMap = new HashMap();
            hashMap.put("task_id", bVar.m());
            hashMap.put("status", Integer.valueOf(bVar.l().ordinal()));
            hashMap.put("progress", Integer.valueOf(bVar.g()));
            hashMap.put("url", bVar.o());
            hashMap.put("file_name", bVar.b());
            hashMap.put("saved_dir", bVar.j());
            hashMap.put("time_created", Long.valueOf(bVar.n()));
            hashMap.put("allow_cellular", Boolean.valueOf(bVar.a()));
            arrayList.add(hashMap);
        }
        result.success(arrayList);
    }

    private final void h(MethodCall methodCall, MethodChannel.Result result) {
        i iVar = this.f14155h;
        k.b(iVar);
        List<r9.b> e10 = iVar.e((String) n(methodCall, "query"));
        ArrayList arrayList = new ArrayList();
        for (r9.b bVar : e10) {
            HashMap hashMap = new HashMap();
            hashMap.put("task_id", bVar.m());
            hashMap.put("status", Integer.valueOf(bVar.l().ordinal()));
            hashMap.put("progress", Integer.valueOf(bVar.g()));
            hashMap.put("url", bVar.o());
            hashMap.put("file_name", bVar.b());
            hashMap.put("saved_dir", bVar.j());
            hashMap.put("time_created", Long.valueOf(bVar.n()));
            hashMap.put("allow_cellular", Boolean.valueOf(bVar.a()));
            arrayList.add(hashMap);
        }
        result.success(arrayList);
    }

    private final void i(Context context, BinaryMessenger binaryMessenger) {
        synchronized (this.f14161n) {
            if (this.f14154g != null) {
                return;
            }
            this.f14156i = context;
            MethodChannel methodChannel = new MethodChannel(binaryMessenger, "vn.hunghd/downloader");
            this.f14154g = methodChannel;
            methodChannel.setMethodCallHandler(this);
            this.f14155h = new i(b.f14162g.a(this.f14156i));
            q qVar = q.f8031a;
        }
    }

    private final void j(MethodCall methodCall, MethodChannel.Result result) {
        Boolean bool;
        int I;
        String str = (String) n(methodCall, "task_id");
        i iVar = this.f14155h;
        k.b(iVar);
        r9.b d10 = iVar.d(str);
        if (d10 == null) {
            result.error("invalid_task_id", "not found task with id " + str, null);
        } else if (d10.l() != r9.a.COMPLETE) {
            result.error("invalid_status", "only completed tasks can be opened", null);
        } else {
            String o10 = d10.o();
            String j10 = d10.j();
            String b10 = d10.b();
            if (b10 == null) {
                I = y8.n.I(o10, "/", 0, false, 6, null);
                b10 = o10.substring(I + 1, o10.length());
                k.d(b10, "this as java.lang.String…ing(startIndex, endIndex)");
            }
            Intent c10 = r9.g.f12700a.c(o(), j10 + File.separator + b10, d10.d());
            if (c10 != null) {
                o().startActivity(c10);
                bool = Boolean.TRUE;
            } else {
                bool = Boolean.FALSE;
            }
            result.success(bool);
        }
    }

    private final void k(MethodCall methodCall, MethodChannel.Result result) {
        String str = (String) n(methodCall, "task_id");
        i iVar = this.f14155h;
        k.b(iVar);
        iVar.j(str, true);
        y.e(o()).b(UUID.fromString(str));
        result.success(null);
    }

    private final void l(MethodCall methodCall, MethodChannel.Result result) {
        Object obj = methodCall.arguments;
        k.c(obj, "null cannot be cast to non-null type kotlin.collections.List<*>");
        List list = (List) obj;
        this.f14157j = Long.parseLong(String.valueOf(list.get(0)));
        this.f14158k = Integer.parseInt(String.valueOf(list.get(1)));
        result.success(null);
    }

    private final void m(MethodCall methodCall, MethodChannel.Result result) {
        int I;
        String str = (String) n(methodCall, "task_id");
        boolean booleanValue = ((Boolean) n(methodCall, "should_delete_content")).booleanValue();
        i iVar = this.f14155h;
        k.b(iVar);
        r9.b d10 = iVar.d(str);
        if (d10 == null) {
            result.error("invalid_task_id", "not found task corresponding to given task id", null);
            return;
        }
        if (d10.l() == r9.a.ENQUEUED || d10.l() == r9.a.RUNNING) {
            y.e(o()).b(UUID.fromString(str));
        }
        if (booleanValue) {
            String b10 = d10.b();
            if (b10 == null) {
                String o10 = d10.o();
                I = y8.n.I(d10.o(), "/", 0, false, 6, null);
                b10 = o10.substring(I + 1, d10.o().length());
                k.d(b10, "this as java.lang.String…ing(startIndex, endIndex)");
            }
            File file = new File(d10.j() + File.separator + b10);
            if (file.exists()) {
                try {
                    d(file);
                } catch (SecurityException unused) {
                    Log.d("FlutterDownloader", "Failed to delete file in media store, will fall back to normal delete()");
                }
                file.delete();
            }
        }
        i iVar2 = this.f14155h;
        k.b(iVar2);
        iVar2.a(str);
        n0.e(o()).b(d10.f());
        result.success(null);
    }

    private final Object n(MethodCall methodCall, String str) {
        Object argument = methodCall.argument(str);
        if (argument != null) {
            return argument;
        }
        throw new IllegalArgumentException(("Required key '" + str + "' was null").toString());
    }

    private final Context o() {
        Context context = this.f14156i;
        if (context != null) {
            return context;
        }
        throw new IllegalArgumentException("Required value was null.".toString());
    }

    private final void p(MethodCall methodCall, MethodChannel.Result result) {
        String str;
        String str2;
        int I;
        String str3 = (String) n(methodCall, "task_id");
        i iVar = this.f14155h;
        k.b(iVar);
        r9.b d10 = iVar.d(str3);
        boolean booleanValue = ((Boolean) n(methodCall, "requires_storage_not_low")).booleanValue();
        int intValue = ((Number) n(methodCall, "timeout")).intValue();
        if (d10 == null) {
            str = "invalid_task_id";
            str2 = "not found task corresponding to given task id";
        } else if (d10.l() == r9.a.PAUSED) {
            String b10 = d10.b();
            if (b10 == null) {
                String o10 = d10.o();
                I = y8.n.I(d10.o(), "/", 0, false, 6, null);
                b10 = o10.substring(I + 1, d10.o().length());
                k.d(b10, "this as java.lang.String…ing(startIndex, endIndex)");
            }
            if (new File(d10.j() + File.separator + b10).exists()) {
                z a10 = a(d10.o(), d10.j(), d10.b(), d10.c(), d10.k(), d10.e(), true, booleanValue, d10.i(), intValue, d10.a());
                String uuid = a10.a().toString();
                k.d(uuid, "request.id.toString()");
                result.success(uuid);
                r9.a aVar = r9.a.RUNNING;
                r(uuid, aVar, d10.g());
                i iVar2 = this.f14155h;
                k.b(iVar2);
                iVar2.h(str3, uuid, aVar, d10.g(), false);
                y.e(o()).d(a10);
                return;
            }
            i iVar3 = this.f14155h;
            k.b(iVar3);
            iVar3.j(str3, false);
            str = "invalid_data";
            str2 = "not found partial downloaded data, this task cannot be resumed";
        } else {
            str = "invalid_status";
            str2 = "only paused task can be resumed";
        }
        result.error(str, str2, null);
    }

    private final void q(MethodCall methodCall, MethodChannel.Result result) {
        String str;
        String str2;
        String str3 = (String) n(methodCall, "task_id");
        i iVar = this.f14155h;
        k.b(iVar);
        r9.b d10 = iVar.d(str3);
        boolean booleanValue = ((Boolean) n(methodCall, "requires_storage_not_low")).booleanValue();
        int intValue = ((Number) n(methodCall, "timeout")).intValue();
        if (d10 == null) {
            str = "invalid_task_id";
            str2 = "not found task corresponding to given task id";
        } else if (d10.l() == r9.a.FAILED || d10.l() == r9.a.CANCELED) {
            z a10 = a(d10.o(), d10.j(), d10.b(), d10.c(), d10.k(), d10.e(), false, booleanValue, d10.i(), intValue, d10.a());
            String uuid = a10.a().toString();
            k.d(uuid, "request.id.toString()");
            result.success(uuid);
            r9.a aVar = r9.a.ENQUEUED;
            r(uuid, aVar, d10.g());
            i iVar2 = this.f14155h;
            k.b(iVar2);
            iVar2.h(str3, uuid, aVar, d10.g(), false);
            y.e(o()).d(a10);
            return;
        } else {
            str = "invalid_status";
            str2 = "only failed and canceled task can be retried";
        }
        result.error(str, str2, null);
    }

    private final void r(String str, r9.a aVar, int i10) {
        HashMap hashMap = new HashMap();
        hashMap.put("task_id", str);
        hashMap.put("status", Integer.valueOf(aVar.ordinal()));
        hashMap.put("progress", Integer.valueOf(i10));
        MethodChannel methodChannel = this.f14154g;
        if (methodChannel != null) {
            methodChannel.invokeMethod("updateProgress", hashMap);
        }
    }

    @Override // io.flutter.embedding.engine.plugins.FlutterPlugin
    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        k.e(binding, "binding");
        Context applicationContext = binding.getApplicationContext();
        BinaryMessenger binaryMessenger = binding.getBinaryMessenger();
        k.d(binaryMessenger, "binding.binaryMessenger");
        i(applicationContext, binaryMessenger);
    }

    @Override // io.flutter.embedding.engine.plugins.FlutterPlugin
    public void onDetachedFromEngine(FlutterPlugin.FlutterPluginBinding binding) {
        k.e(binding, "binding");
        this.f14156i = null;
        MethodChannel methodChannel = this.f14154g;
        if (methodChannel != null) {
            methodChannel.setMethodCallHandler(null);
        }
        this.f14154g = null;
    }

    @Override // io.flutter.plugin.common.MethodChannel.MethodCallHandler
    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        k.e(call, "call");
        k.e(result, "result");
        String str = call.method;
        if (str != null) {
            switch (str.hashCode()) {
                case -1594257912:
                    if (str.equals("enqueue")) {
                        e(call, result);
                        return;
                    }
                    break;
                case -1367724422:
                    if (str.equals("cancel")) {
                        b(call, result);
                        return;
                    }
                    break;
                case -934610812:
                    if (str.equals("remove")) {
                        m(call, result);
                        return;
                    }
                    break;
                case -934426579:
                    if (str.equals("resume")) {
                        p(call, result);
                        return;
                    }
                    break;
                case -403218424:
                    if (str.equals("registerCallback")) {
                        l(call, result);
                        return;
                    }
                    break;
                case 3417674:
                    if (str.equals("open")) {
                        j(call, result);
                        return;
                    }
                    break;
                case 106440182:
                    if (str.equals("pause")) {
                        k(call, result);
                        return;
                    }
                    break;
                case 108405416:
                    if (str.equals("retry")) {
                        q(call, result);
                        return;
                    }
                    break;
                case 230377166:
                    if (str.equals("loadTasksWithRawQuery")) {
                        h(call, result);
                        return;
                    }
                    break;
                case 476547271:
                    if (str.equals("cancelAll")) {
                        c(result);
                        return;
                    }
                    break;
                case 871091088:
                    if (str.equals("initialize")) {
                        f(call, result);
                        return;
                    }
                    break;
                case 1378870856:
                    if (str.equals("loadTasks")) {
                        g(result);
                        return;
                    }
                    break;
            }
        }
        result.notImplemented();
    }
}
