package u0;

import android.net.Uri;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import r6.u0;
import s0.j0;
import u0.g;
import u0.m;
/* loaded from: classes.dex */
public class m extends u0.b {

    /* renamed from: e  reason: collision with root package name */
    private final boolean f13554e;

    /* renamed from: f  reason: collision with root package name */
    private final boolean f13555f;

    /* renamed from: g  reason: collision with root package name */
    private final int f13556g;

    /* renamed from: h  reason: collision with root package name */
    private final int f13557h;

    /* renamed from: i  reason: collision with root package name */
    private final String f13558i;

    /* renamed from: j  reason: collision with root package name */
    private final u f13559j;

    /* renamed from: k  reason: collision with root package name */
    private final u f13560k;

    /* renamed from: l  reason: collision with root package name */
    private final q6.n f13561l;

    /* renamed from: m  reason: collision with root package name */
    private final boolean f13562m;

    /* renamed from: n  reason: collision with root package name */
    private k f13563n;

    /* renamed from: o  reason: collision with root package name */
    private HttpURLConnection f13564o;

    /* renamed from: p  reason: collision with root package name */
    private InputStream f13565p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f13566q;

    /* renamed from: r  reason: collision with root package name */
    private int f13567r;

    /* renamed from: s  reason: collision with root package name */
    private long f13568s;

    /* renamed from: t  reason: collision with root package name */
    private long f13569t;

    /* loaded from: classes.dex */
    public static final class b implements g.a {

        /* renamed from: b  reason: collision with root package name */
        private y f13571b;

        /* renamed from: c  reason: collision with root package name */
        private q6.n f13572c;

        /* renamed from: d  reason: collision with root package name */
        private String f13573d;

        /* renamed from: g  reason: collision with root package name */
        private boolean f13576g;

        /* renamed from: h  reason: collision with root package name */
        private boolean f13577h;

        /* renamed from: i  reason: collision with root package name */
        private boolean f13578i;

        /* renamed from: a  reason: collision with root package name */
        private final u f13570a = new u();

        /* renamed from: e  reason: collision with root package name */
        private int f13574e = 8000;

        /* renamed from: f  reason: collision with root package name */
        private int f13575f = 8000;

        @Override // u0.g.a
        /* renamed from: b */
        public m a() {
            m mVar = new m(this.f13573d, this.f13574e, this.f13575f, this.f13576g, this.f13577h, this.f13570a, this.f13572c, this.f13578i);
            y yVar = this.f13571b;
            if (yVar != null) {
                mVar.l(yVar);
            }
            return mVar;
        }

        public b c(boolean z9) {
            this.f13576g = z9;
            return this;
        }

        public b d(Map map) {
            this.f13570a.a(map);
            return this;
        }

        public b e(String str) {
            this.f13573d = str;
            return this;
        }
    }

    /* loaded from: classes.dex */
    private static class c extends r6.q {

        /* renamed from: g  reason: collision with root package name */
        private final Map f13579g;

        public c(Map map) {
            this.f13579g = map;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static /* synthetic */ boolean i(Map.Entry entry) {
            return entry.getKey() != null;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static /* synthetic */ boolean j(String str) {
            return str != null;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // r6.r
        /* renamed from: b */
        public Map a() {
            return this.f13579g;
        }

        @Override // r6.q, java.util.Map
        public boolean containsKey(Object obj) {
            return obj != null && super.containsKey(obj);
        }

        @Override // java.util.Map
        public boolean containsValue(Object obj) {
            return super.c(obj);
        }

        @Override // r6.q, java.util.Map
        public Set entrySet() {
            return u0.b(super.entrySet(), new q6.n() { // from class: u0.n
                @Override // q6.n
                public final boolean apply(Object obj) {
                    boolean i10;
                    i10 = m.c.i((Map.Entry) obj);
                    return i10;
                }
            });
        }

        @Override // java.util.Map
        public boolean equals(Object obj) {
            return obj != null && super.d(obj);
        }

        @Override // r6.q, java.util.Map
        /* renamed from: h */
        public List get(Object obj) {
            if (obj == null) {
                return null;
            }
            return (List) super.get(obj);
        }

        @Override // java.util.Map
        public int hashCode() {
            return super.e();
        }

        @Override // r6.q, java.util.Map
        public boolean isEmpty() {
            if (super.isEmpty()) {
                return true;
            }
            return super.size() == 1 && super.containsKey(null);
        }

        @Override // r6.q, java.util.Map
        public Set keySet() {
            return u0.b(super.keySet(), new q6.n() { // from class: u0.o
                @Override // q6.n
                public final boolean apply(Object obj) {
                    boolean j10;
                    j10 = m.c.j((String) obj);
                    return j10;
                }
            });
        }

        @Override // r6.q, java.util.Map
        public int size() {
            return super.size() - (super.containsKey(null) ? 1 : 0);
        }
    }

    private m(String str, int i10, int i11, boolean z9, boolean z10, u uVar, q6.n nVar, boolean z11) {
        super(true);
        this.f13558i = str;
        this.f13556g = i10;
        this.f13557h = i11;
        this.f13554e = z9;
        this.f13555f = z10;
        if (z9 && z10) {
            throw new IllegalArgumentException("crossProtocolRedirectsForceOriginal should not be set if allowCrossProtocolRedirects is true");
        }
        this.f13559j = uVar;
        this.f13561l = nVar;
        this.f13560k = new u();
        this.f13562m = z11;
    }

    private HttpURLConnection A(URL url, int i10, byte[] bArr, long j10, long j11, boolean z9, boolean z10, Map map) {
        HttpURLConnection D = D(url);
        D.setConnectTimeout(this.f13556g);
        D.setReadTimeout(this.f13557h);
        HashMap hashMap = new HashMap();
        u uVar = this.f13559j;
        if (uVar != null) {
            hashMap.putAll(uVar.b());
        }
        hashMap.putAll(this.f13560k.b());
        hashMap.putAll(map);
        for (Map.Entry entry : hashMap.entrySet()) {
            D.setRequestProperty((String) entry.getKey(), (String) entry.getValue());
        }
        String a10 = v.a(j10, j11);
        if (a10 != null) {
            D.setRequestProperty("Range", a10);
        }
        String str = this.f13558i;
        if (str != null) {
            D.setRequestProperty("User-Agent", str);
        }
        D.setRequestProperty("Accept-Encoding", z9 ? "gzip" : "identity");
        D.setInstanceFollowRedirects(z10);
        D.setDoOutput(bArr != null);
        D.setRequestMethod(k.c(i10));
        if (bArr != null) {
            D.setFixedLengthStreamingMode(bArr.length);
            D.connect();
            OutputStream outputStream = D.getOutputStream();
            outputStream.write(bArr);
            outputStream.close();
        } else {
            D.connect();
        }
        return D;
    }

    private HttpURLConnection B(k kVar) {
        HttpURLConnection A;
        URL url;
        URL url2 = new URL(kVar.f13519a.toString());
        int i10 = kVar.f13521c;
        byte[] bArr = kVar.f13522d;
        long j10 = kVar.f13525g;
        long j11 = kVar.f13526h;
        boolean d10 = kVar.d(1);
        if (this.f13554e || this.f13555f || this.f13562m) {
            URL url3 = url2;
            int i11 = i10;
            byte[] bArr2 = bArr;
            int i12 = 0;
            while (true) {
                int i13 = i12 + 1;
                if (i12 > 20) {
                    throw new r(new NoRouteToHostException("Too many redirects: " + i13), kVar, 2001, 1);
                }
                long j12 = j10;
                long j13 = j10;
                int i14 = i11;
                URL url4 = url3;
                long j14 = j11;
                A = A(url3, i11, bArr2, j12, j11, d10, false, kVar.f13523e);
                int responseCode = A.getResponseCode();
                String headerField = A.getHeaderField("Location");
                if ((i14 == 1 || i14 == 3) && (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307 || responseCode == 308)) {
                    A.disconnect();
                    url3 = y(url4, headerField, kVar);
                    i11 = i14;
                } else if (i14 != 2 || (responseCode != 300 && responseCode != 301 && responseCode != 302 && responseCode != 303)) {
                    break;
                } else {
                    A.disconnect();
                    if (this.f13562m && responseCode == 302) {
                        i11 = i14;
                        url = url4;
                    } else {
                        bArr2 = null;
                        url = url4;
                        i11 = 1;
                    }
                    url3 = y(url, headerField, kVar);
                }
                i12 = i13;
                j10 = j13;
                j11 = j14;
            }
            return A;
        }
        return A(url2, i10, bArr, j10, j11, d10, true, kVar.f13523e);
    }

    private static void C(HttpURLConnection httpURLConnection, long j10) {
        if (httpURLConnection != null && j0.f12742a <= 20) {
            try {
                InputStream inputStream = httpURLConnection.getInputStream();
                if (j10 == -1) {
                    if (inputStream.read() == -1) {
                        return;
                    }
                } else if (j10 <= 2048) {
                    return;
                }
                String name = inputStream.getClass().getName();
                if (!"com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream".equals(name) && !"com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream".equals(name)) {
                    return;
                }
                Method declaredMethod = ((Class) s0.a.e(inputStream.getClass().getSuperclass())).getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                declaredMethod.setAccessible(true);
                declaredMethod.invoke(inputStream, new Object[0]);
            } catch (Exception unused) {
            }
        }
    }

    private int E(byte[] bArr, int i10, int i11) {
        if (i11 == 0) {
            return 0;
        }
        long j10 = this.f13568s;
        if (j10 != -1) {
            long j11 = j10 - this.f13569t;
            if (j11 == 0) {
                return -1;
            }
            i11 = (int) Math.min(i11, j11);
        }
        int read = ((InputStream) j0.i(this.f13565p)).read(bArr, i10, i11);
        if (read == -1) {
            return -1;
        }
        this.f13569t += read;
        t(read);
        return read;
    }

    private void F(long j10, k kVar) {
        if (j10 == 0) {
            return;
        }
        byte[] bArr = new byte[4096];
        while (j10 > 0) {
            int read = ((InputStream) j0.i(this.f13565p)).read(bArr, 0, (int) Math.min(j10, 4096));
            if (Thread.currentThread().isInterrupted()) {
                throw new r(new InterruptedIOException(), kVar, 2000, 1);
            }
            if (read == -1) {
                throw new r(kVar, 2008, 1);
            }
            j10 -= read;
            t(read);
        }
    }

    private void x() {
        HttpURLConnection httpURLConnection = this.f13564o;
        if (httpURLConnection != null) {
            try {
                httpURLConnection.disconnect();
            } catch (Exception e10) {
                s0.o.d("DefaultHttpDataSource", "Unexpected error while disconnecting", e10);
            }
            this.f13564o = null;
        }
    }

    private URL y(URL url, String str, k kVar) {
        if (str != null) {
            try {
                URL url2 = new URL(url, str);
                String protocol = url2.getProtocol();
                if (!"https".equals(protocol) && !"http".equals(protocol)) {
                    throw new r("Unsupported protocol redirect: " + protocol, kVar, 2001, 1);
                } else if (this.f13554e || protocol.equals(url.getProtocol())) {
                    return url2;
                } else {
                    if (this.f13555f) {
                        try {
                            return new URL(url2.toString().replaceFirst(protocol, url.getProtocol()));
                        } catch (MalformedURLException e10) {
                            throw new r(e10, kVar, 2001, 1);
                        }
                    }
                    throw new r("Disallowed cross-protocol redirect (" + url.getProtocol() + " to " + protocol + ")", kVar, 2001, 1);
                }
            } catch (MalformedURLException e11) {
                throw new r(e11, kVar, 2001, 1);
            }
        }
        throw new r("Null location redirect", kVar, 2001, 1);
    }

    private static boolean z(HttpURLConnection httpURLConnection) {
        return "gzip".equalsIgnoreCase(httpURLConnection.getHeaderField("Content-Encoding"));
    }

    HttpURLConnection D(URL url) {
        return (HttpURLConnection) url.openConnection();
    }

    @Override // u0.g
    public void close() {
        try {
            InputStream inputStream = this.f13565p;
            if (inputStream != null) {
                long j10 = this.f13568s;
                long j11 = -1;
                if (j10 != -1) {
                    j11 = j10 - this.f13569t;
                }
                C(this.f13564o, j11);
                try {
                    inputStream.close();
                } catch (IOException e10) {
                    throw new r(e10, (k) j0.i(this.f13563n), 2000, 3);
                }
            }
        } finally {
            this.f13565p = null;
            x();
            if (this.f13566q) {
                this.f13566q = false;
                u();
            }
        }
    }

    @Override // u0.g
    public long k(k kVar) {
        byte[] bArr;
        this.f13563n = kVar;
        long j10 = 0;
        this.f13569t = 0L;
        this.f13568s = 0L;
        v(kVar);
        try {
            HttpURLConnection B = B(kVar);
            this.f13564o = B;
            this.f13567r = B.getResponseCode();
            String responseMessage = B.getResponseMessage();
            int i10 = this.f13567r;
            if (i10 < 200 || i10 > 299) {
                Map<String, List<String>> headerFields = B.getHeaderFields();
                if (this.f13567r == 416) {
                    if (kVar.f13525g == v.c(B.getHeaderField("Content-Range"))) {
                        this.f13566q = true;
                        w(kVar);
                        long j11 = kVar.f13526h;
                        if (j11 != -1) {
                            return j11;
                        }
                        return 0L;
                    }
                }
                InputStream errorStream = B.getErrorStream();
                try {
                    bArr = errorStream != null ? s6.a.b(errorStream) : j0.f12747f;
                } catch (IOException unused) {
                    bArr = j0.f12747f;
                }
                byte[] bArr2 = bArr;
                x();
                throw new t(this.f13567r, responseMessage, this.f13567r == 416 ? new h(2008) : null, headerFields, kVar, bArr2);
            }
            String contentType = B.getContentType();
            q6.n nVar = this.f13561l;
            if (nVar != null && !nVar.apply(contentType)) {
                x();
                throw new s(contentType, kVar);
            }
            if (this.f13567r == 200) {
                long j12 = kVar.f13525g;
                if (j12 != 0) {
                    j10 = j12;
                }
            }
            boolean z9 = z(B);
            if (z9) {
                this.f13568s = kVar.f13526h;
            } else {
                long j13 = kVar.f13526h;
                if (j13 != -1) {
                    this.f13568s = j13;
                } else {
                    long b10 = v.b(B.getHeaderField("Content-Length"), B.getHeaderField("Content-Range"));
                    this.f13568s = b10 != -1 ? b10 - j10 : -1L;
                }
            }
            try {
                this.f13565p = B.getInputStream();
                if (z9) {
                    this.f13565p = new GZIPInputStream(this.f13565p);
                }
                this.f13566q = true;
                w(kVar);
                try {
                    F(j10, kVar);
                    return this.f13568s;
                } catch (IOException e10) {
                    x();
                    if (e10 instanceof r) {
                        throw ((r) e10);
                    }
                    throw new r(e10, kVar, 2000, 1);
                }
            } catch (IOException e11) {
                x();
                throw new r(e11, kVar, 2000, 1);
            }
        } catch (IOException e12) {
            x();
            throw r.c(e12, kVar, 1);
        }
    }

    @Override // u0.b, u0.g
    public Map n() {
        HttpURLConnection httpURLConnection = this.f13564o;
        return httpURLConnection == null ? r6.x.j() : new c(httpURLConnection.getHeaderFields());
    }

    @Override // u0.g
    public Uri r() {
        HttpURLConnection httpURLConnection = this.f13564o;
        if (httpURLConnection == null) {
            return null;
        }
        return Uri.parse(httpURLConnection.getURL().toString());
    }

    @Override // p0.h
    public int read(byte[] bArr, int i10, int i11) {
        try {
            return E(bArr, i10, i11);
        } catch (IOException e10) {
            throw r.c(e10, (k) j0.i(this.f13563n), 2);
        }
    }
}
