package p4;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import g4.g;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
/* loaded from: classes.dex */
public class z implements g4.j {

    /* renamed from: d  reason: collision with root package name */
    public static final g4.g f11794d = g4.g.a("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.TargetFrame", -1L, new a());

    /* renamed from: e  reason: collision with root package name */
    public static final g4.g f11795e = g4.g.a("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.FrameOption", 2, new b());

    /* renamed from: f  reason: collision with root package name */
    private static final f f11796f = new f();

    /* renamed from: g  reason: collision with root package name */
    private static final List f11797g = Collections.unmodifiableList(Arrays.asList("TP1A", "TD1A.220804.031"));

    /* renamed from: a  reason: collision with root package name */
    private final e f11798a;

    /* renamed from: b  reason: collision with root package name */
    private final j4.d f11799b;

    /* renamed from: c  reason: collision with root package name */
    private final f f11800c;

    /* loaded from: classes.dex */
    class a implements g.b {

        /* renamed from: a  reason: collision with root package name */
        private final ByteBuffer f11801a = ByteBuffer.allocate(8);

        a() {
        }

        @Override // g4.g.b
        /* renamed from: b */
        public void a(byte[] bArr, Long l10, MessageDigest messageDigest) {
            messageDigest.update(bArr);
            synchronized (this.f11801a) {
                this.f11801a.position(0);
                messageDigest.update(this.f11801a.putLong(l10.longValue()).array());
            }
        }
    }

    /* loaded from: classes.dex */
    class b implements g.b {

        /* renamed from: a  reason: collision with root package name */
        private final ByteBuffer f11802a = ByteBuffer.allocate(4);

        b() {
        }

        @Override // g4.g.b
        /* renamed from: b */
        public void a(byte[] bArr, Integer num, MessageDigest messageDigest) {
            if (num == null) {
                return;
            }
            messageDigest.update(bArr);
            synchronized (this.f11802a) {
                this.f11802a.position(0);
                messageDigest.update(this.f11802a.putInt(num.intValue()).array());
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class c implements e {
        private c() {
        }

        /* synthetic */ c(a aVar) {
            this();
        }

        @Override // p4.z.e
        /* renamed from: c */
        public void a(MediaExtractor mediaExtractor, AssetFileDescriptor assetFileDescriptor) {
            mediaExtractor.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
        }

        @Override // p4.z.e
        /* renamed from: d */
        public void b(MediaMetadataRetriever mediaMetadataRetriever, AssetFileDescriptor assetFileDescriptor) {
            mediaMetadataRetriever.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
        }
    }

    /* loaded from: classes.dex */
    static final class d implements e {

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a extends MediaDataSource {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ ByteBuffer f11803g;

            a(ByteBuffer byteBuffer) {
                this.f11803g = byteBuffer;
            }

            @Override // java.io.Closeable, java.lang.AutoCloseable
            public void close() {
            }

            public long getSize() {
                return this.f11803g.limit();
            }

            public int readAt(long j10, byte[] bArr, int i10, int i11) {
                if (j10 >= this.f11803g.limit()) {
                    return -1;
                }
                this.f11803g.position((int) j10);
                int min = Math.min(i11, this.f11803g.remaining());
                this.f11803g.get(bArr, i10, min);
                return min;
            }
        }

        d() {
        }

        private MediaDataSource c(ByteBuffer byteBuffer) {
            return new a(byteBuffer);
        }

        @Override // p4.z.e
        /* renamed from: d */
        public void a(MediaExtractor mediaExtractor, ByteBuffer byteBuffer) {
            mediaExtractor.setDataSource(c(byteBuffer));
        }

        @Override // p4.z.e
        /* renamed from: e */
        public void b(MediaMetadataRetriever mediaMetadataRetriever, ByteBuffer byteBuffer) {
            mediaMetadataRetriever.setDataSource(c(byteBuffer));
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface e {
        void a(MediaExtractor mediaExtractor, Object obj);

        void b(MediaMetadataRetriever mediaMetadataRetriever, Object obj);
    }

    /* loaded from: classes.dex */
    static class f {
        f() {
        }

        public MediaMetadataRetriever a() {
            return new MediaMetadataRetriever();
        }
    }

    /* loaded from: classes.dex */
    static final class g implements e {
        g() {
        }

        @Override // p4.z.e
        /* renamed from: c */
        public void a(MediaExtractor mediaExtractor, ParcelFileDescriptor parcelFileDescriptor) {
            mediaExtractor.setDataSource(parcelFileDescriptor.getFileDescriptor());
        }

        @Override // p4.z.e
        /* renamed from: d */
        public void b(MediaMetadataRetriever mediaMetadataRetriever, ParcelFileDescriptor parcelFileDescriptor) {
            mediaMetadataRetriever.setDataSource(parcelFileDescriptor.getFileDescriptor());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class h extends RuntimeException {
        h() {
            super("MediaMetadataRetriever failed to retrieve a frame without throwing, check the adb logs for .*MetadataRetriever.* prior to this exception for details");
        }
    }

    z(j4.d dVar, e eVar) {
        this(dVar, eVar, f11796f);
    }

    z(j4.d dVar, e eVar, f fVar) {
        this.f11799b = dVar;
        this.f11798a = eVar;
        this.f11800c = fVar;
    }

    public static g4.j c(j4.d dVar) {
        return new z(dVar, new c(null));
    }

    public static g4.j d(j4.d dVar) {
        return new z(dVar, new d());
    }

    private static Bitmap e(MediaMetadataRetriever mediaMetadataRetriever, Bitmap bitmap) {
        if (j()) {
            boolean z9 = false;
            try {
                if (i(mediaMetadataRetriever)) {
                    if (Math.abs(Integer.parseInt(mediaMetadataRetriever.extractMetadata(24))) == 180) {
                        z9 = true;
                    }
                }
            } catch (NumberFormatException unused) {
                if (Log.isLoggable("VideoDecoder", 3)) {
                    Log.d("VideoDecoder", "Exception trying to extract HDR transfer function or rotation");
                }
            }
            if (z9) {
                if (Log.isLoggable("VideoDecoder", 3)) {
                    Log.d("VideoDecoder", "Applying HDR 180 deg thumbnail correction");
                }
                Matrix matrix = new Matrix();
                matrix.postRotate(180.0f, bitmap.getWidth() / 2.0f, bitmap.getHeight() / 2.0f);
                return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
            }
            return bitmap;
        }
        return bitmap;
    }

    private Bitmap f(Object obj, MediaMetadataRetriever mediaMetadataRetriever, long j10, int i10, int i11, int i12, i iVar) {
        if (l(obj, mediaMetadataRetriever)) {
            throw new IllegalStateException("Cannot decode VP8 video on CrOS.");
        }
        Bitmap bitmap = null;
        if (Build.VERSION.SDK_INT >= 27 && i11 != Integer.MIN_VALUE && i12 != Integer.MIN_VALUE && iVar != i.f11728f) {
            bitmap = h(mediaMetadataRetriever, j10, i10, i11, i12, iVar);
        }
        if (bitmap == null) {
            bitmap = g(mediaMetadataRetriever, j10, i10);
        }
        Bitmap e10 = e(mediaMetadataRetriever, bitmap);
        if (e10 != null) {
            return e10;
        }
        throw new h();
    }

    private static Bitmap g(MediaMetadataRetriever mediaMetadataRetriever, long j10, int i10) {
        return mediaMetadataRetriever.getFrameAtTime(j10, i10);
    }

    private static Bitmap h(MediaMetadataRetriever mediaMetadataRetriever, long j10, int i10, int i11, int i12, i iVar) {
        Bitmap scaledFrameAtTime;
        try {
            int parseInt = Integer.parseInt(mediaMetadataRetriever.extractMetadata(18));
            int parseInt2 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(19));
            int parseInt3 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(24));
            if (parseInt3 == 90 || parseInt3 == 270) {
                parseInt2 = parseInt;
                parseInt = parseInt2;
            }
            float b10 = iVar.b(parseInt, parseInt2, i11, i12);
            scaledFrameAtTime = mediaMetadataRetriever.getScaledFrameAtTime(j10, i10, Math.round(parseInt * b10), Math.round(b10 * parseInt2));
            return scaledFrameAtTime;
        } catch (Throwable th) {
            if (Log.isLoggable("VideoDecoder", 3)) {
                Log.d("VideoDecoder", "Exception trying to decode a scaled frame on oreo+, falling back to a fullsize frame", th);
                return null;
            }
            return null;
        }
    }

    private static boolean i(MediaMetadataRetriever mediaMetadataRetriever) {
        String extractMetadata = mediaMetadataRetriever.extractMetadata(36);
        String extractMetadata2 = mediaMetadataRetriever.extractMetadata(35);
        int parseInt = Integer.parseInt(extractMetadata);
        return (parseInt == 7 || parseInt == 6) && Integer.parseInt(extractMetadata2) == 6;
    }

    static boolean j() {
        if (Build.MODEL.startsWith("Pixel") && Build.VERSION.SDK_INT == 33) {
            return k();
        }
        int i10 = Build.VERSION.SDK_INT;
        return i10 >= 30 && i10 < 33;
    }

    private static boolean k() {
        for (String str : f11797g) {
            if (Build.ID.startsWith(str)) {
                return true;
            }
        }
        return false;
    }

    private boolean l(Object obj, MediaMetadataRetriever mediaMetadataRetriever) {
        String str = Build.DEVICE;
        if (str != null && str.matches(".+_cheets|cheets_.+")) {
            MediaExtractor mediaExtractor = null;
            try {
            } catch (Throwable th) {
                th = th;
            }
            if ("video/webm".equals(mediaMetadataRetriever.extractMetadata(12))) {
                MediaExtractor mediaExtractor2 = new MediaExtractor();
                try {
                    this.f11798a.a(mediaExtractor2, obj);
                    int trackCount = mediaExtractor2.getTrackCount();
                    for (int i10 = 0; i10 < trackCount; i10++) {
                        if ("video/x-vnd.on2.vp8".equals(mediaExtractor2.getTrackFormat(i10).getString("mime"))) {
                            mediaExtractor2.release();
                            return true;
                        }
                    }
                    mediaExtractor2.release();
                } catch (Throwable th2) {
                    th = th2;
                    mediaExtractor = mediaExtractor2;
                    try {
                        if (Log.isLoggable("VideoDecoder", 3)) {
                            Log.d("VideoDecoder", "Exception trying to extract track info for a webm video on CrOS.", th);
                        }
                        return false;
                    } finally {
                        if (mediaExtractor != null) {
                            mediaExtractor.release();
                        }
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static g4.j m(j4.d dVar) {
        return new z(dVar, new g());
    }

    @Override // g4.j
    public boolean a(Object obj, g4.h hVar) {
        return true;
    }

    @Override // g4.j
    public i4.v b(Object obj, int i10, int i11, g4.h hVar) {
        long longValue = ((Long) hVar.c(f11794d)).longValue();
        if (longValue < 0 && longValue != -1) {
            throw new IllegalArgumentException("Requested frame must be non-negative, or DEFAULT_FRAME, given: " + longValue);
        }
        Integer num = (Integer) hVar.c(f11795e);
        if (num == null) {
            num = 2;
        }
        i iVar = (i) hVar.c(i.f11730h);
        if (iVar == null) {
            iVar = i.f11729g;
        }
        i iVar2 = iVar;
        MediaMetadataRetriever a10 = this.f11800c.a();
        try {
            this.f11798a.b(a10, obj);
            return p4.e.e(f(obj, a10, longValue, num.intValue(), i10, i11, iVar2), this.f11799b);
        } finally {
            if (Build.VERSION.SDK_INT >= 29) {
                a10.close();
            } else {
                a10.release();
            }
        }
    }
}
