package p4;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.DisplayMetrics;
import android.util.Log;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.data.ParcelFileDescriptorRewinder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import p4.i;
import p4.o;
/* loaded from: classes.dex */
public final class j {

    /* renamed from: f  reason: collision with root package name */
    public static final g4.g f11735f = g4.g.f("com.bumptech.glide.load.resource.bitmap.Downsampler.DecodeFormat", g4.b.f7971i);

    /* renamed from: g  reason: collision with root package name */
    public static final g4.g f11736g = g4.g.e("com.bumptech.glide.load.resource.bitmap.Downsampler.PreferredColorSpace");

    /* renamed from: h  reason: collision with root package name */
    public static final g4.g f11737h = i.f11730h;

    /* renamed from: i  reason: collision with root package name */
    public static final g4.g f11738i;

    /* renamed from: j  reason: collision with root package name */
    public static final g4.g f11739j;

    /* renamed from: k  reason: collision with root package name */
    private static final Set f11740k;

    /* renamed from: l  reason: collision with root package name */
    private static final b f11741l;

    /* renamed from: m  reason: collision with root package name */
    private static final Set f11742m;

    /* renamed from: n  reason: collision with root package name */
    private static final Queue f11743n;

    /* renamed from: a  reason: collision with root package name */
    private final j4.d f11744a;

    /* renamed from: b  reason: collision with root package name */
    private final DisplayMetrics f11745b;

    /* renamed from: c  reason: collision with root package name */
    private final j4.b f11746c;

    /* renamed from: d  reason: collision with root package name */
    private final List f11747d;

    /* renamed from: e  reason: collision with root package name */
    private final n f11748e = n.b();

    /* loaded from: classes.dex */
    class a implements b {
        a() {
        }

        @Override // p4.j.b
        public void a(j4.d dVar, Bitmap bitmap) {
        }

        @Override // p4.j.b
        public void b() {
        }
    }

    /* loaded from: classes.dex */
    public interface b {
        void a(j4.d dVar, Bitmap bitmap);

        void b();
    }

    static {
        Boolean bool = Boolean.FALSE;
        f11738i = g4.g.f("com.bumptech.glide.load.resource.bitmap.Downsampler.FixBitmapSize", bool);
        f11739j = g4.g.f("com.bumptech.glide.load.resource.bitmap.Downsampler.AllowHardwareDecode", bool);
        f11740k = Collections.unmodifiableSet(new HashSet(Arrays.asList("image/vnd.wap.wbmp", "image/x-ico")));
        f11741l = new a();
        f11742m = Collections.unmodifiableSet(EnumSet.of(ImageHeaderParser.ImageType.JPEG, ImageHeaderParser.ImageType.PNG_A, ImageHeaderParser.ImageType.PNG));
        f11743n = b5.l.f(0);
    }

    public j(List list, DisplayMetrics displayMetrics, j4.d dVar, j4.b bVar) {
        this.f11747d = list;
        this.f11745b = (DisplayMetrics) b5.k.d(displayMetrics);
        this.f11744a = (j4.d) b5.k.d(dVar);
        this.f11746c = (j4.b) b5.k.d(bVar);
    }

    private static int a(double d10) {
        int l10 = l(d10);
        int x9 = x(l10 * d10);
        return x((d10 / (x9 / l10)) * x9);
    }

    private void b(o oVar, g4.b bVar, boolean z9, boolean z10, BitmapFactory.Options options, int i10, int i11) {
        if (this.f11748e.i(i10, i11, options, z9, z10)) {
            return;
        }
        if (bVar == g4.b.PREFER_ARGB_8888) {
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return;
        }
        boolean z11 = false;
        try {
            z11 = oVar.d().hasAlpha();
        } catch (IOException e10) {
            if (Log.isLoggable("Downsampler", 3)) {
                Log.d("Downsampler", "Cannot determine whether the image has alpha or not from header, format " + bVar, e10);
            }
        }
        Bitmap.Config config = z11 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        options.inPreferredConfig = config;
        if (config == Bitmap.Config.RGB_565) {
            options.inDither = true;
        }
    }

    private static void c(ImageHeaderParser.ImageType imageType, o oVar, b bVar, j4.d dVar, i iVar, int i10, int i11, int i12, int i13, int i14, BitmapFactory.Options options) {
        int i15;
        int i16;
        int i17;
        int floor;
        int floor2;
        if (i11 <= 0 || i12 <= 0) {
            if (Log.isLoggable("Downsampler", 3)) {
                Log.d("Downsampler", "Unable to determine dimensions for: " + imageType + " with target [" + i13 + "x" + i14 + "]");
                return;
            }
            return;
        }
        if (r(i10)) {
            i16 = i11;
            i15 = i12;
        } else {
            i15 = i11;
            i16 = i12;
        }
        float b10 = iVar.b(i15, i16, i13, i14);
        if (b10 <= 0.0f) {
            throw new IllegalArgumentException("Cannot scale with factor: " + b10 + " from: " + iVar + ", source: [" + i11 + "x" + i12 + "], target: [" + i13 + "x" + i14 + "]");
        }
        i.g a10 = iVar.a(i15, i16, i13, i14);
        if (a10 == null) {
            throw new IllegalArgumentException("Cannot round with null rounding");
        }
        float f10 = i15;
        float f11 = i16;
        int x9 = i15 / x(b10 * f10);
        int x10 = i16 / x(b10 * f11);
        i.g gVar = i.g.MEMORY;
        int max = a10 == gVar ? Math.max(x9, x10) : Math.min(x9, x10);
        int i18 = Build.VERSION.SDK_INT;
        if (i18 > 23 || !f11740k.contains(options.outMimeType)) {
            int max2 = Math.max(1, Integer.highestOneBit(max));
            if (a10 == gVar && max2 < 1.0f / b10) {
                max2 <<= 1;
            }
            i17 = max2;
        } else {
            i17 = 1;
        }
        options.inSampleSize = i17;
        if (imageType == ImageHeaderParser.ImageType.JPEG) {
            float min = Math.min(i17, 8);
            floor = (int) Math.ceil(f10 / min);
            floor2 = (int) Math.ceil(f11 / min);
            int i19 = i17 / 8;
            if (i19 > 0) {
                floor /= i19;
                floor2 /= i19;
            }
        } else {
            if (imageType != ImageHeaderParser.ImageType.PNG && imageType != ImageHeaderParser.ImageType.PNG_A) {
                if (imageType.isWebp()) {
                    if (i18 >= 24) {
                        float f12 = i17;
                        floor = Math.round(f10 / f12);
                        floor2 = Math.round(f11 / f12);
                    }
                } else if (i15 % i17 == 0 && i16 % i17 == 0) {
                    floor = i15 / i17;
                    floor2 = i16 / i17;
                } else {
                    int[] m10 = m(oVar, options, bVar, dVar);
                    floor = m10[0];
                    floor2 = m10[1];
                }
            }
            float f13 = i17;
            floor = (int) Math.floor(f10 / f13);
            floor2 = (int) Math.floor(f11 / f13);
        }
        double b11 = iVar.b(floor, floor2, i13, i14);
        options.inTargetDensity = a(b11);
        options.inDensity = l(b11);
        if (s(options)) {
            options.inScaled = true;
        } else {
            options.inTargetDensity = 0;
            options.inDensity = 0;
        }
        if (Log.isLoggable("Downsampler", 2)) {
            Log.v("Downsampler", "Calculate scaling, source: [" + i11 + "x" + i12 + "], degreesToRotate: " + i10 + ", target: [" + i13 + "x" + i14 + "], power of two scaled: [" + floor + "x" + floor2 + "], exact scale factor: " + b10 + ", power of 2 sample size: " + i17 + ", adjusted scale factor: " + b11 + ", target density: " + options.inTargetDensity + ", density: " + options.inDensity);
        }
    }

    private i4.v g(o oVar, int i10, int i11, g4.h hVar, b bVar) {
        byte[] bArr = (byte[]) this.f11746c.d(65536, byte[].class);
        BitmapFactory.Options k10 = k();
        k10.inTempStorage = bArr;
        g4.b bVar2 = (g4.b) hVar.c(f11735f);
        g4.i iVar = (g4.i) hVar.c(f11736g);
        i iVar2 = (i) hVar.c(i.f11730h);
        boolean booleanValue = ((Boolean) hVar.c(f11738i)).booleanValue();
        g4.g gVar = f11739j;
        try {
            return e.e(h(oVar, k10, iVar2, bVar2, iVar, hVar.c(gVar) != null && ((Boolean) hVar.c(gVar)).booleanValue(), i10, i11, booleanValue, bVar), this.f11744a);
        } finally {
            v(k10);
            this.f11746c.put(bArr);
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:51:0x0164, code lost:
        if (r0 >= 26) goto L36;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private Bitmap h(o oVar, BitmapFactory.Options options, i iVar, g4.b bVar, g4.i iVar2, boolean z9, int i10, int i11, boolean z10, b bVar2) {
        int i12;
        int i13;
        String str;
        ColorSpace.Named named;
        ColorSpace colorSpace;
        int round;
        int round2;
        long b10 = b5.g.b();
        int[] m10 = m(oVar, options, bVar2, this.f11744a);
        boolean z11 = false;
        int i14 = m10[0];
        int i15 = m10[1];
        String str2 = options.outMimeType;
        boolean z12 = (i14 == -1 || i15 == -1) ? false : z9;
        int a10 = oVar.a();
        int d10 = v.d(a10);
        boolean g10 = v.g(a10);
        if (i10 == Integer.MIN_VALUE) {
            i12 = i11;
            i13 = r(d10) ? i15 : i14;
        } else {
            i12 = i11;
            i13 = i10;
        }
        int i16 = i12 == Integer.MIN_VALUE ? r(d10) ? i14 : i15 : i12;
        ImageHeaderParser.ImageType d11 = oVar.d();
        c(d11, oVar, bVar2, this.f11744a, iVar, d10, i14, i15, i13, i16, options);
        b(oVar, bVar, z12, g10, options, i13, i16);
        int i17 = Build.VERSION.SDK_INT;
        int i18 = options.inSampleSize;
        if (z(d11)) {
            if (i14 < 0 || i15 < 0 || !z10) {
                float f10 = s(options) ? options.inTargetDensity / options.inDensity : 1.0f;
                int i19 = options.inSampleSize;
                float f11 = i19;
                round = Math.round(((int) Math.ceil(i14 / f11)) * f10);
                round2 = Math.round(((int) Math.ceil(i15 / f11)) * f10);
                str = "Downsampler";
                if (Log.isLoggable(str, 2)) {
                    Log.v(str, "Calculated target [" + round + "x" + round2 + "] for source [" + i14 + "x" + i15 + "], sampleSize: " + i19 + ", targetDensity: " + options.inTargetDensity + ", density: " + options.inDensity + ", density multiplier: " + f10);
                }
            } else {
                str = "Downsampler";
                round = i13;
                round2 = i16;
            }
            if (round > 0 && round2 > 0) {
                y(options, this.f11744a, round, round2);
            }
        } else {
            str = "Downsampler";
        }
        if (iVar2 != null) {
            if (i17 >= 28) {
                if (iVar2 == g4.i.DISPLAY_P3 && (colorSpace = options.outColorSpace) != null && colorSpace.isWideGamut()) {
                    z11 = true;
                }
                if (z11) {
                    named = ColorSpace.Named.DISPLAY_P3;
                    options.inPreferredColorSpace = ColorSpace.get(named);
                }
            }
            named = ColorSpace.Named.SRGB;
            options.inPreferredColorSpace = ColorSpace.get(named);
        }
        Bitmap i20 = i(oVar, options, bVar2, this.f11744a);
        bVar2.a(this.f11744a, i20);
        if (Log.isLoggable(str, 2)) {
            t(i14, i15, str2, options, i20, i10, i11, b10);
        }
        Bitmap bitmap = null;
        if (i20 != null) {
            i20.setDensity(this.f11745b.densityDpi);
            bitmap = v.h(this.f11744a, i20, a10);
            if (!i20.equals(bitmap)) {
                this.f11744a.c(i20);
            }
        }
        return bitmap;
    }

    private static Bitmap i(o oVar, BitmapFactory.Options options, b bVar, j4.d dVar) {
        if (!options.inJustDecodeBounds) {
            bVar.b();
            oVar.c();
        }
        int i10 = options.outWidth;
        int i11 = options.outHeight;
        String str = options.outMimeType;
        v.c().lock();
        try {
            try {
                Bitmap b10 = oVar.b(options);
                v.c().unlock();
                return b10;
            } catch (IllegalArgumentException e10) {
                IOException u9 = u(e10, i10, i11, str, options);
                if (Log.isLoggable("Downsampler", 3)) {
                    Log.d("Downsampler", "Failed to decode with inBitmap, trying again without Bitmap re-use", u9);
                }
                Bitmap bitmap = options.inBitmap;
                if (bitmap != null) {
                    try {
                        dVar.c(bitmap);
                        options.inBitmap = null;
                        Bitmap i12 = i(oVar, options, bVar, dVar);
                        v.c().unlock();
                        return i12;
                    } catch (IOException unused) {
                        throw u9;
                    }
                }
                throw u9;
            }
        } catch (Throwable th) {
            v.c().unlock();
            throw th;
        }
    }

    private static String j(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return "[" + bitmap.getWidth() + "x" + bitmap.getHeight() + "] " + bitmap.getConfig() + (" (" + bitmap.getAllocationByteCount() + ")");
    }

    private static synchronized BitmapFactory.Options k() {
        BitmapFactory.Options options;
        synchronized (j.class) {
            Queue queue = f11743n;
            synchronized (queue) {
                options = (BitmapFactory.Options) queue.poll();
            }
            if (options == null) {
                options = new BitmapFactory.Options();
                w(options);
            }
        }
        return options;
    }

    private static int l(double d10) {
        if (d10 > 1.0d) {
            d10 = 1.0d / d10;
        }
        return (int) Math.round(d10 * 2.147483647E9d);
    }

    private static int[] m(o oVar, BitmapFactory.Options options, b bVar, j4.d dVar) {
        options.inJustDecodeBounds = true;
        i(oVar, options, bVar, dVar);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, options.outHeight};
    }

    private static String n(BitmapFactory.Options options) {
        return j(options.inBitmap);
    }

    private static boolean r(int i10) {
        return i10 == 90 || i10 == 270;
    }

    private static boolean s(BitmapFactory.Options options) {
        int i10;
        int i11 = options.inTargetDensity;
        return i11 > 0 && (i10 = options.inDensity) > 0 && i11 != i10;
    }

    private static void t(int i10, int i11, String str, BitmapFactory.Options options, Bitmap bitmap, int i12, int i13, long j10) {
        Log.v("Downsampler", "Decoded " + j(bitmap) + " from [" + i10 + "x" + i11 + "] " + str + " with inBitmap " + n(options) + " for [" + i12 + "x" + i13 + "], sample size: " + options.inSampleSize + ", density: " + options.inDensity + ", target density: " + options.inTargetDensity + ", thread: " + Thread.currentThread().getName() + ", duration: " + b5.g.a(j10));
    }

    private static IOException u(IllegalArgumentException illegalArgumentException, int i10, int i11, String str, BitmapFactory.Options options) {
        return new IOException("Exception decoding bitmap, outWidth: " + i10 + ", outHeight: " + i11 + ", outMimeType: " + str + ", inBitmap: " + n(options), illegalArgumentException);
    }

    private static void v(BitmapFactory.Options options) {
        w(options);
        Queue queue = f11743n;
        synchronized (queue) {
            queue.offer(options);
        }
    }

    private static void w(BitmapFactory.Options options) {
        options.inTempStorage = null;
        options.inDither = false;
        options.inScaled = false;
        options.inSampleSize = 1;
        options.inPreferredConfig = null;
        options.inJustDecodeBounds = false;
        options.inDensity = 0;
        options.inTargetDensity = 0;
        if (Build.VERSION.SDK_INT >= 26) {
            options.inPreferredColorSpace = null;
            options.outColorSpace = null;
            options.outConfig = null;
        }
        options.outWidth = 0;
        options.outHeight = 0;
        options.outMimeType = null;
        options.inBitmap = null;
        options.inMutable = true;
    }

    private static int x(double d10) {
        return (int) (d10 + 0.5d);
    }

    private static void y(BitmapFactory.Options options, j4.d dVar, int i10, int i11) {
        Bitmap.Config config;
        if (Build.VERSION.SDK_INT < 26) {
            config = null;
        } else if (options.inPreferredConfig == Bitmap.Config.HARDWARE) {
            return;
        } else {
            config = options.outConfig;
        }
        if (config == null) {
            config = options.inPreferredConfig;
        }
        options.inBitmap = dVar.e(i10, i11, config);
    }

    private boolean z(ImageHeaderParser.ImageType imageType) {
        return true;
    }

    public i4.v d(ParcelFileDescriptor parcelFileDescriptor, int i10, int i11, g4.h hVar) {
        return g(new o.c(parcelFileDescriptor, this.f11747d, this.f11746c), i10, i11, hVar, f11741l);
    }

    public i4.v e(InputStream inputStream, int i10, int i11, g4.h hVar, b bVar) {
        return g(new o.b(inputStream, this.f11747d, this.f11746c), i10, i11, hVar, bVar);
    }

    public i4.v f(ByteBuffer byteBuffer, int i10, int i11, g4.h hVar) {
        return g(new o.a(byteBuffer, this.f11747d, this.f11746c), i10, i11, hVar, f11741l);
    }

    public boolean o(ParcelFileDescriptor parcelFileDescriptor) {
        return ParcelFileDescriptorRewinder.c();
    }

    public boolean p(InputStream inputStream) {
        return true;
    }

    public boolean q(ByteBuffer byteBuffer) {
        return true;
    }
}
