package m4;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.util.Log;
import java.io.InputStream;
import java.util.List;
import m4.n;
/* loaded from: classes.dex */
public final class t implements n {

    /* renamed from: a  reason: collision with root package name */
    private final Context f10167a;

    /* renamed from: b  reason: collision with root package name */
    private final n f10168b;

    /* loaded from: classes.dex */
    private static final class a implements o {

        /* renamed from: a  reason: collision with root package name */
        private final Context f10169a;

        a(Context context) {
            this.f10169a = context;
        }

        @Override // m4.o
        public n d(r rVar) {
            return new t(this.f10169a, rVar.d(Integer.class, AssetFileDescriptor.class));
        }
    }

    /* loaded from: classes.dex */
    private static final class b implements o {

        /* renamed from: a  reason: collision with root package name */
        private final Context f10170a;

        b(Context context) {
            this.f10170a = context;
        }

        @Override // m4.o
        public n d(r rVar) {
            return new t(this.f10170a, rVar.d(Integer.class, InputStream.class));
        }
    }

    t(Context context, n nVar) {
        this.f10167a = context.getApplicationContext();
        this.f10168b = nVar;
    }

    public static o e(Context context) {
        return new a(context);
    }

    public static o f(Context context) {
        return new b(context);
    }

    private n.a g(Uri uri, int i10, int i11, g4.h hVar) {
        try {
            int parseInt = Integer.parseInt(uri.getPathSegments().get(0));
            if (parseInt == 0) {
                if (Log.isLoggable("ResourceUriLoader", 5)) {
                    Log.w("ResourceUriLoader", "Failed to parse a valid non-0 resource id from: " + uri);
                }
                return null;
            }
            return this.f10168b.b(Integer.valueOf(parseInt), i10, i11, hVar);
        } catch (NumberFormatException e10) {
            if (Log.isLoggable("ResourceUriLoader", 5)) {
                Log.w("ResourceUriLoader", "Failed to parse resource id from: " + uri, e10);
            }
            return null;
        }
    }

    private n.a h(Uri uri, int i10, int i11, g4.h hVar) {
        List<String> pathSegments = uri.getPathSegments();
        String str = pathSegments.get(1);
        int identifier = this.f10167a.getResources().getIdentifier(str, pathSegments.get(0), this.f10167a.getPackageName());
        if (identifier == 0) {
            if (Log.isLoggable("ResourceUriLoader", 5)) {
                Log.w("ResourceUriLoader", "Failed to find resource id for: " + uri);
                return null;
            }
            return null;
        }
        return this.f10168b.b(Integer.valueOf(identifier), i10, i11, hVar);
    }

    @Override // m4.n
    /* renamed from: c */
    public n.a b(Uri uri, int i10, int i11, g4.h hVar) {
        List<String> pathSegments = uri.getPathSegments();
        if (pathSegments.size() == 1) {
            return g(uri, i10, i11, hVar);
        }
        if (pathSegments.size() == 2) {
            return h(uri, i10, i11, hVar);
        }
        if (Log.isLoggable("ResourceUriLoader", 5)) {
            Log.w("ResourceUriLoader", "Failed to parse resource uri: " + uri);
            return null;
        }
        return null;
    }

    @Override // m4.n
    /* renamed from: d */
    public boolean a(Uri uri) {
        return "android.resource".equals(uri.getScheme()) && this.f10167a.getPackageName().equals(uri.getAuthority());
    }
}
