package l9;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
/* loaded from: classes.dex */
public class j extends View implements g {

    /* renamed from: v  reason: collision with root package name */
    private static final int[] f9595v = {0, 64, 128, 192, 255, 192, 128, 64};

    /* renamed from: g  reason: collision with root package name */
    private Rect f9596g;

    /* renamed from: h  reason: collision with root package name */
    private int f9597h;

    /* renamed from: i  reason: collision with root package name */
    private final int f9598i;

    /* renamed from: j  reason: collision with root package name */
    private final int f9599j;

    /* renamed from: k  reason: collision with root package name */
    private final int f9600k;

    /* renamed from: l  reason: collision with root package name */
    private final int f9601l;

    /* renamed from: m  reason: collision with root package name */
    private final int f9602m;

    /* renamed from: n  reason: collision with root package name */
    protected Paint f9603n;

    /* renamed from: o  reason: collision with root package name */
    protected Paint f9604o;

    /* renamed from: p  reason: collision with root package name */
    protected Paint f9605p;

    /* renamed from: q  reason: collision with root package name */
    protected int f9606q;

    /* renamed from: r  reason: collision with root package name */
    protected boolean f9607r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f9608s;

    /* renamed from: t  reason: collision with root package name */
    private float f9609t;

    /* renamed from: u  reason: collision with root package name */
    private int f9610u;

    public j(Context context) {
        super(context);
        this.f9598i = getResources().getColor(h.viewfinder_laser);
        this.f9599j = getResources().getColor(h.viewfinder_mask);
        this.f9600k = getResources().getColor(h.viewfinder_border);
        this.f9601l = getResources().getInteger(i.viewfinder_border_width);
        this.f9602m = getResources().getInteger(i.viewfinder_border_length);
        this.f9610u = 0;
        e();
    }

    private void e() {
        Paint paint = new Paint();
        this.f9603n = paint;
        paint.setColor(this.f9598i);
        this.f9603n.setStyle(Paint.Style.FILL);
        Paint paint2 = new Paint();
        this.f9604o = paint2;
        paint2.setColor(this.f9599j);
        Paint paint3 = new Paint();
        this.f9605p = paint3;
        paint3.setColor(this.f9600k);
        this.f9605p.setStyle(Paint.Style.STROKE);
        this.f9605p.setStrokeWidth(this.f9601l);
        this.f9605p.setAntiAlias(true);
        this.f9606q = this.f9602m;
    }

    @Override // l9.g
    public void a() {
        f();
        invalidate();
    }

    public void b(Canvas canvas) {
        Rect framingRect = getFramingRect();
        Paint paint = this.f9603n;
        int[] iArr = f9595v;
        paint.setAlpha(iArr[this.f9597h]);
        this.f9597h = (this.f9597h + 1) % iArr.length;
        int height = (framingRect.height() / 2) + framingRect.top;
        canvas.drawRect(framingRect.left + 2, height - 1, framingRect.right - 1, height + 2, this.f9603n);
        postInvalidateDelayed(80L, framingRect.left - 10, framingRect.top - 10, framingRect.right + 10, framingRect.bottom + 10);
    }

    public void c(Canvas canvas) {
        Rect framingRect = getFramingRect();
        Path path = new Path();
        path.moveTo(framingRect.left, framingRect.top + this.f9606q);
        path.lineTo(framingRect.left, framingRect.top);
        path.lineTo(framingRect.left + this.f9606q, framingRect.top);
        canvas.drawPath(path, this.f9605p);
        path.moveTo(framingRect.right, framingRect.top + this.f9606q);
        path.lineTo(framingRect.right, framingRect.top);
        path.lineTo(framingRect.right - this.f9606q, framingRect.top);
        canvas.drawPath(path, this.f9605p);
        path.moveTo(framingRect.right, framingRect.bottom - this.f9606q);
        path.lineTo(framingRect.right, framingRect.bottom);
        path.lineTo(framingRect.right - this.f9606q, framingRect.bottom);
        canvas.drawPath(path, this.f9605p);
        path.moveTo(framingRect.left, framingRect.bottom - this.f9606q);
        path.lineTo(framingRect.left, framingRect.bottom);
        path.lineTo(framingRect.left + this.f9606q, framingRect.bottom);
        canvas.drawPath(path, this.f9605p);
    }

    public void d(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        Rect framingRect = getFramingRect();
        float f10 = width;
        canvas.drawRect(0.0f, 0.0f, f10, framingRect.top, this.f9604o);
        canvas.drawRect(0.0f, framingRect.top, framingRect.left, framingRect.bottom + 1, this.f9604o);
        canvas.drawRect(framingRect.right + 1, framingRect.top, f10, framingRect.bottom + 1, this.f9604o);
        canvas.drawRect(0.0f, framingRect.bottom + 1, f10, height, this.f9604o);
    }

    public synchronized void f() {
        int width;
        int i10;
        Point point = new Point(getWidth(), getHeight());
        int a10 = f.a(getContext());
        if (this.f9607r) {
            width = (int) ((a10 != 1 ? getHeight() : getWidth()) * 0.625f);
            i10 = width;
        } else if (a10 != 1) {
            int height = (int) (getHeight() * 0.625f);
            i10 = height;
            width = (int) (height * 1.4f);
        } else {
            width = (int) (getWidth() * 0.75f);
            i10 = (int) (width * 0.75f);
        }
        if (width > getWidth()) {
            width = getWidth() - 50;
        }
        if (i10 > getHeight()) {
            i10 = getHeight() - 50;
        }
        int i11 = (point.x - width) / 2;
        int i12 = (point.y - i10) / 2;
        int i13 = this.f9610u;
        this.f9596g = new Rect(i11 + i13, i12 + i13, (i11 + width) - i13, (i12 + i10) - i13);
    }

    @Override // l9.g
    public Rect getFramingRect() {
        return this.f9596g;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        if (getFramingRect() == null) {
            return;
        }
        d(canvas);
        c(canvas);
        if (this.f9608s) {
            b(canvas);
        }
    }

    @Override // android.view.View
    protected void onSizeChanged(int i10, int i11, int i12, int i13) {
        f();
    }

    @Override // l9.g
    public void setBorderAlpha(float f10) {
        this.f9609t = f10;
        this.f9605p.setAlpha((int) (255.0f * f10));
    }

    @Override // l9.g
    public void setBorderColor(int i10) {
        this.f9605p.setColor(i10);
    }

    @Override // l9.g
    public void setBorderCornerRadius(int i10) {
        this.f9605p.setPathEffect(new CornerPathEffect(i10));
    }

    @Override // l9.g
    public void setBorderCornerRounded(boolean z9) {
        Paint paint;
        Paint.Join join;
        if (z9) {
            paint = this.f9605p;
            join = Paint.Join.ROUND;
        } else {
            paint = this.f9605p;
            join = Paint.Join.BEVEL;
        }
        paint.setStrokeJoin(join);
    }

    @Override // l9.g
    public void setBorderLineLength(int i10) {
        this.f9606q = i10;
    }

    @Override // l9.g
    public void setBorderStrokeWidth(int i10) {
        this.f9605p.setStrokeWidth(i10);
    }

    @Override // l9.g
    public void setLaserColor(int i10) {
        this.f9603n.setColor(i10);
    }

    @Override // l9.g
    public void setLaserEnabled(boolean z9) {
        this.f9608s = z9;
    }

    @Override // l9.g
    public void setMaskColor(int i10) {
        this.f9604o.setColor(i10);
    }

    @Override // l9.g
    public void setSquareViewFinder(boolean z9) {
        this.f9607r = z9;
    }

    public void setViewFinderOffset(int i10) {
        this.f9610u = i10;
    }
}
