package l9;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
/* loaded from: classes.dex */
public abstract class a extends FrameLayout implements Camera.PreviewCallback {

    /* renamed from: g  reason: collision with root package name */
    private e f9556g;

    /* renamed from: h  reason: collision with root package name */
    private c f9557h;

    /* renamed from: i  reason: collision with root package name */
    private g f9558i;

    /* renamed from: j  reason: collision with root package name */
    private Rect f9559j;

    /* renamed from: k  reason: collision with root package name */
    private b f9560k;

    /* renamed from: l  reason: collision with root package name */
    private Boolean f9561l;

    /* renamed from: m  reason: collision with root package name */
    private boolean f9562m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f9563n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f9564o;

    /* renamed from: p  reason: collision with root package name */
    private int f9565p;

    /* renamed from: q  reason: collision with root package name */
    private int f9566q;

    /* renamed from: r  reason: collision with root package name */
    private int f9567r;

    /* renamed from: s  reason: collision with root package name */
    private int f9568s;

    /* renamed from: t  reason: collision with root package name */
    private int f9569t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f9570u;

    /* renamed from: v  reason: collision with root package name */
    private int f9571v;

    /* renamed from: w  reason: collision with root package name */
    private boolean f9572w;

    /* renamed from: x  reason: collision with root package name */
    private float f9573x;

    /* renamed from: y  reason: collision with root package name */
    private int f9574y;

    /* renamed from: z  reason: collision with root package name */
    private float f9575z;

    public a(Context context) {
        super(context);
        this.f9562m = true;
        this.f9563n = true;
        this.f9564o = true;
        this.f9565p = getResources().getColor(h.viewfinder_laser);
        this.f9566q = getResources().getColor(h.viewfinder_border);
        this.f9567r = getResources().getColor(h.viewfinder_mask);
        this.f9568s = getResources().getInteger(i.viewfinder_border_width);
        this.f9569t = getResources().getInteger(i.viewfinder_border_length);
        this.f9570u = false;
        this.f9571v = 0;
        this.f9572w = false;
        this.f9573x = 1.0f;
        this.f9574y = 0;
        this.f9575z = 0.1f;
        d();
    }

    private void d() {
        this.f9558i = a(getContext());
    }

    protected g a(Context context) {
        j jVar = new j(context);
        jVar.setBorderColor(this.f9566q);
        jVar.setLaserColor(this.f9565p);
        jVar.setLaserEnabled(this.f9564o);
        jVar.setBorderStrokeWidth(this.f9568s);
        jVar.setBorderLineLength(this.f9569t);
        jVar.setMaskColor(this.f9567r);
        jVar.setBorderCornerRounded(this.f9570u);
        jVar.setBorderCornerRadius(this.f9571v);
        jVar.setSquareViewFinder(this.f9572w);
        jVar.setViewFinderOffset(this.f9574y);
        return jVar;
    }

    public synchronized Rect b(int i10, int i11) {
        if (this.f9559j == null) {
            Rect framingRect = this.f9558i.getFramingRect();
            int width = this.f9558i.getWidth();
            int height = this.f9558i.getHeight();
            if (framingRect != null && width != 0 && height != 0) {
                Rect rect = new Rect(framingRect);
                if (i10 < width) {
                    rect.left = (rect.left * i10) / width;
                    rect.right = (rect.right * i10) / width;
                }
                if (i11 < height) {
                    rect.top = (rect.top * i11) / height;
                    rect.bottom = (rect.bottom * i11) / height;
                }
                this.f9559j = rect;
            }
            return null;
        }
        return this.f9559j;
    }

    public byte[] c(byte[] bArr, Camera camera) {
        Camera.Size previewSize = camera.getParameters().getPreviewSize();
        int i10 = previewSize.width;
        int i11 = previewSize.height;
        int rotationCount = getRotationCount();
        if (rotationCount == 1 || rotationCount == 3) {
            int i12 = 0;
            while (i12 < rotationCount) {
                byte[] bArr2 = new byte[bArr.length];
                for (int i13 = 0; i13 < i11; i13++) {
                    for (int i14 = 0; i14 < i10; i14++) {
                        bArr2[(((i14 * i11) + i11) - i13) - 1] = bArr[(i13 * i10) + i14];
                    }
                }
                i12++;
                bArr = bArr2;
                int i15 = i10;
                i10 = i11;
                i11 = i15;
            }
        }
        return bArr;
    }

    public void e() {
        f(d.b());
    }

    public void f(int i10) {
        if (this.f9560k == null) {
            this.f9560k = new b(this);
        }
        this.f9560k.b(i10);
    }

    public void g() {
        if (this.f9556g != null) {
            this.f9557h.o();
            this.f9557h.k(null, null);
            this.f9556g.f9593a.release();
            this.f9556g = null;
        }
        b bVar = this.f9560k;
        if (bVar != null) {
            bVar.quit();
            this.f9560k = null;
        }
    }

    public boolean getFlash() {
        e eVar = this.f9556g;
        return eVar != null && d.c(eVar.f9593a) && this.f9556g.f9593a.getParameters().getFlashMode().equals("torch");
    }

    public int getRotationCount() {
        return this.f9557h.getDisplayOrientation() / 90;
    }

    public void h() {
        c cVar = this.f9557h;
        if (cVar != null) {
            cVar.o();
        }
    }

    public void i() {
        e eVar = this.f9556g;
        if (eVar == null || !d.c(eVar.f9593a)) {
            return;
        }
        Camera.Parameters parameters = this.f9556g.f9593a.getParameters();
        if (parameters.getFlashMode().equals("torch")) {
            parameters.setFlashMode("off");
        } else {
            parameters.setFlashMode("torch");
        }
        this.f9556g.f9593a.setParameters(parameters);
    }

    public void setAspectTolerance(float f10) {
        this.f9575z = f10;
    }

    public void setAutoFocus(boolean z9) {
        this.f9562m = z9;
        c cVar = this.f9557h;
        if (cVar != null) {
            cVar.setAutoFocus(z9);
        }
    }

    public void setBorderAlpha(float f10) {
        this.f9573x = f10;
        this.f9558i.setBorderAlpha(f10);
        this.f9558i.a();
    }

    public void setBorderColor(int i10) {
        this.f9566q = i10;
        this.f9558i.setBorderColor(i10);
        this.f9558i.a();
    }

    public void setBorderCornerRadius(int i10) {
        this.f9571v = i10;
        this.f9558i.setBorderCornerRadius(i10);
        this.f9558i.a();
    }

    public void setBorderLineLength(int i10) {
        this.f9569t = i10;
        this.f9558i.setBorderLineLength(i10);
        this.f9558i.a();
    }

    public void setBorderStrokeWidth(int i10) {
        this.f9568s = i10;
        this.f9558i.setBorderStrokeWidth(i10);
        this.f9558i.a();
    }

    public void setFlash(boolean z9) {
        String str;
        this.f9561l = Boolean.valueOf(z9);
        e eVar = this.f9556g;
        if (eVar == null || !d.c(eVar.f9593a)) {
            return;
        }
        Camera.Parameters parameters = this.f9556g.f9593a.getParameters();
        if (z9) {
            str = "torch";
            if (parameters.getFlashMode().equals("torch")) {
                return;
            }
        } else {
            str = "off";
            if (parameters.getFlashMode().equals("off")) {
                return;
            }
        }
        parameters.setFlashMode(str);
        this.f9556g.f9593a.setParameters(parameters);
    }

    public void setIsBorderCornerRounded(boolean z9) {
        this.f9570u = z9;
        this.f9558i.setBorderCornerRounded(z9);
        this.f9558i.a();
    }

    public void setLaserColor(int i10) {
        this.f9565p = i10;
        this.f9558i.setLaserColor(i10);
        this.f9558i.a();
    }

    public void setLaserEnabled(boolean z9) {
        this.f9564o = z9;
        this.f9558i.setLaserEnabled(z9);
        this.f9558i.a();
    }

    public void setMaskColor(int i10) {
        this.f9567r = i10;
        this.f9558i.setMaskColor(i10);
        this.f9558i.a();
    }

    public void setShouldScaleToFill(boolean z9) {
        this.f9563n = z9;
    }

    public void setSquareViewFinder(boolean z9) {
        this.f9572w = z9;
        this.f9558i.setSquareViewFinder(z9);
        this.f9558i.a();
    }

    public void setupCameraPreview(e eVar) {
        this.f9556g = eVar;
        if (eVar != null) {
            setupLayout(eVar);
            this.f9558i.a();
            Boolean bool = this.f9561l;
            if (bool != null) {
                setFlash(bool.booleanValue());
            }
            setAutoFocus(this.f9562m);
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    public final void setupLayout(e eVar) {
        c cVar;
        removeAllViews();
        c cVar2 = new c(getContext(), eVar, this);
        this.f9557h = cVar2;
        cVar2.setAspectTolerance(this.f9575z);
        this.f9557h.setShouldScaleToFill(this.f9563n);
        if (this.f9563n) {
            cVar = this.f9557h;
        } else {
            RelativeLayout relativeLayout = new RelativeLayout(getContext());
            relativeLayout.setGravity(17);
            relativeLayout.setBackgroundColor(-16777216);
            relativeLayout.addView(this.f9557h);
            cVar = relativeLayout;
        }
        addView(cVar);
        g gVar = this.f9558i;
        if (!(gVar instanceof View)) {
            throw new IllegalArgumentException("IViewFinder object returned by 'createViewFinderView()' should be instance of android.view.View");
        }
        addView((View) gVar);
    }
}
