package l0;

import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import l0.e;
/* loaded from: classes.dex */
public final class f implements AutoCloseable {

    /* renamed from: g  reason: collision with root package name */
    private final int f9403g;

    /* renamed from: h  reason: collision with root package name */
    private final HandlerThread f9404h;

    /* renamed from: i  reason: collision with root package name */
    private final Handler f9405i;

    /* renamed from: j  reason: collision with root package name */
    int f9406j;

    /* renamed from: k  reason: collision with root package name */
    final int f9407k;

    /* renamed from: l  reason: collision with root package name */
    final int f9408l;

    /* renamed from: m  reason: collision with root package name */
    final int f9409m;

    /* renamed from: o  reason: collision with root package name */
    MediaMuxer f9411o;

    /* renamed from: p  reason: collision with root package name */
    private e f9412p;

    /* renamed from: r  reason: collision with root package name */
    int[] f9414r;

    /* renamed from: s  reason: collision with root package name */
    int f9415s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f9416t;

    /* renamed from: n  reason: collision with root package name */
    final d f9410n = new d();

    /* renamed from: q  reason: collision with root package name */
    final AtomicBoolean f9413q = new AtomicBoolean(false);

    /* renamed from: u  reason: collision with root package name */
    private final List f9417u = new ArrayList();

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            try {
                f.this.k();
            } catch (Exception unused) {
            }
        }
    }

    /* loaded from: classes.dex */
    public static final class b {

        /* renamed from: a  reason: collision with root package name */
        private final String f9419a;

        /* renamed from: b  reason: collision with root package name */
        private final FileDescriptor f9420b;

        /* renamed from: c  reason: collision with root package name */
        private final int f9421c;

        /* renamed from: d  reason: collision with root package name */
        private final int f9422d;

        /* renamed from: e  reason: collision with root package name */
        private final int f9423e;

        /* renamed from: f  reason: collision with root package name */
        private boolean f9424f;

        /* renamed from: g  reason: collision with root package name */
        private int f9425g;

        /* renamed from: h  reason: collision with root package name */
        private int f9426h;

        /* renamed from: i  reason: collision with root package name */
        private int f9427i;

        /* renamed from: j  reason: collision with root package name */
        private int f9428j;

        /* renamed from: k  reason: collision with root package name */
        private Handler f9429k;

        public b(String str, int i10, int i11, int i12) {
            this(str, null, i10, i11, i12);
        }

        private b(String str, FileDescriptor fileDescriptor, int i10, int i11, int i12) {
            this.f9424f = true;
            this.f9425g = 100;
            this.f9426h = 1;
            this.f9427i = 0;
            this.f9428j = 0;
            if (i10 <= 0 || i11 <= 0) {
                throw new IllegalArgumentException("Invalid image size: " + i10 + "x" + i11);
            }
            this.f9419a = str;
            this.f9420b = fileDescriptor;
            this.f9421c = i10;
            this.f9422d = i11;
            this.f9423e = i12;
        }

        public f a() {
            return new f(this.f9419a, this.f9420b, this.f9421c, this.f9422d, this.f9428j, this.f9424f, this.f9425g, this.f9426h, this.f9427i, this.f9423e, this.f9429k);
        }

        public b b(int i10) {
            if (i10 > 0) {
                this.f9426h = i10;
                return this;
            }
            throw new IllegalArgumentException("Invalid maxImage: " + i10);
        }

        public b c(int i10) {
            if (i10 >= 0 && i10 <= 100) {
                this.f9425g = i10;
                return this;
            }
            throw new IllegalArgumentException("Invalid quality: " + i10);
        }
    }

    /* loaded from: classes.dex */
    class c extends e.c {

        /* renamed from: a  reason: collision with root package name */
        private boolean f9430a;

        c() {
        }

        private void e(Exception exc) {
            if (this.f9430a) {
                return;
            }
            this.f9430a = true;
            f.this.f9410n.a(exc);
        }

        @Override // l0.e.c
        public void a(e eVar) {
            e(null);
        }

        @Override // l0.e.c
        public void b(e eVar, ByteBuffer byteBuffer) {
            if (this.f9430a) {
                return;
            }
            f fVar = f.this;
            if (fVar.f9414r == null) {
                e(new IllegalStateException("Output buffer received before format info"));
                return;
            }
            if (fVar.f9415s < fVar.f9408l * fVar.f9406j) {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                bufferInfo.set(byteBuffer.position(), byteBuffer.remaining(), 0L, 0);
                f fVar2 = f.this;
                fVar2.f9411o.writeSampleData(fVar2.f9414r[fVar2.f9415s / fVar2.f9406j], byteBuffer, bufferInfo);
            }
            f fVar3 = f.this;
            int i10 = fVar3.f9415s + 1;
            fVar3.f9415s = i10;
            if (i10 == fVar3.f9408l * fVar3.f9406j) {
                e(null);
            }
        }

        @Override // l0.e.c
        public void c(e eVar, MediaCodec.CodecException codecException) {
            e(codecException);
        }

        @Override // l0.e.c
        public void d(e eVar, MediaFormat mediaFormat) {
            if (this.f9430a) {
                return;
            }
            if (f.this.f9414r != null) {
                e(new IllegalStateException("Output format changed after muxer started"));
                return;
            }
            try {
                f.this.f9406j = mediaFormat.getInteger("grid-rows") * mediaFormat.getInteger("grid-cols");
            } catch (ClassCastException | NullPointerException unused) {
                f.this.f9406j = 1;
            }
            f fVar = f.this;
            fVar.f9414r = new int[fVar.f9408l];
            if (fVar.f9407k > 0) {
                Log.d("HeifWriter", "setting rotation: " + f.this.f9407k);
                f fVar2 = f.this;
                fVar2.f9411o.setOrientationHint(fVar2.f9407k);
            }
            int i10 = 0;
            while (true) {
                f fVar3 = f.this;
                if (i10 >= fVar3.f9414r.length) {
                    fVar3.f9411o.start();
                    f.this.f9413q.set(true);
                    f.this.m();
                    return;
                }
                mediaFormat.setInteger("is-default", i10 == fVar3.f9409m ? 1 : 0);
                f fVar4 = f.this;
                fVar4.f9414r[i10] = fVar4.f9411o.addTrack(mediaFormat);
                i10++;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class d {

        /* renamed from: a  reason: collision with root package name */
        private boolean f9432a;

        /* renamed from: b  reason: collision with root package name */
        private Exception f9433b;

        d() {
        }

        synchronized void a(Exception exc) {
            if (!this.f9432a) {
                this.f9432a = true;
                this.f9433b = exc;
                notifyAll();
            }
        }

        synchronized void b(long j10) {
            int i10 = (j10 > 0L ? 1 : (j10 == 0L ? 0 : -1));
            if (i10 < 0) {
                throw new IllegalArgumentException("timeoutMs is negative");
            }
            if (i10 == 0) {
                while (!this.f9432a) {
                    try {
                        wait();
                    } catch (InterruptedException unused) {
                    }
                }
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                while (!this.f9432a && j10 > 0) {
                    try {
                        wait(j10);
                    } catch (InterruptedException unused2) {
                    }
                    j10 -= System.currentTimeMillis() - currentTimeMillis;
                }
            }
            if (!this.f9432a) {
                this.f9432a = true;
                this.f9433b = new TimeoutException("timed out waiting for result");
            }
            Exception exc = this.f9433b;
            if (exc != null) {
                throw exc;
            }
        }
    }

    f(String str, FileDescriptor fileDescriptor, int i10, int i11, int i12, boolean z9, int i13, int i14, int i15, int i16, Handler handler) {
        if (i15 >= i14) {
            throw new IllegalArgumentException("Invalid maxImages (" + i14 + ") or primaryIndex (" + i15 + ")");
        }
        MediaFormat.createVideoFormat("image/vnd.android.heic", i10, i11);
        this.f9406j = 1;
        this.f9407k = i12;
        this.f9403g = i16;
        this.f9408l = i14;
        this.f9409m = i15;
        Looper looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            HandlerThread handlerThread = new HandlerThread("HeifEncoderThread", -2);
            this.f9404h = handlerThread;
            handlerThread.start();
            looper = handlerThread.getLooper();
        } else {
            this.f9404h = null;
        }
        Handler handler2 = new Handler(looper);
        this.f9405i = handler2;
        this.f9411o = str != null ? new MediaMuxer(str, 3) : new MediaMuxer(fileDescriptor, 3);
        this.f9412p = new e(i10, i11, z9, i13, i16, handler2, new c());
    }

    private void b(int i10) {
        if (this.f9403g == i10) {
            return;
        }
        throw new IllegalStateException("Not valid in input mode " + this.f9403g);
    }

    private void c(boolean z9) {
        if (this.f9416t != z9) {
            throw new IllegalStateException("Already started");
        }
    }

    private void g(int i10) {
        c(true);
        b(i10);
    }

    public void a(Bitmap bitmap) {
        g(2);
        synchronized (this) {
            e eVar = this.f9412p;
            if (eVar != null) {
                eVar.b(bitmap);
            }
        }
    }

    @Override // java.lang.AutoCloseable
    public void close() {
        this.f9405i.postAtFrontOfQueue(new a());
    }

    void k() {
        MediaMuxer mediaMuxer = this.f9411o;
        if (mediaMuxer != null) {
            mediaMuxer.stop();
            this.f9411o.release();
            this.f9411o = null;
        }
        e eVar = this.f9412p;
        if (eVar != null) {
            eVar.close();
            synchronized (this) {
                this.f9412p = null;
            }
        }
    }

    void m() {
        Pair pair;
        if (!this.f9413q.get()) {
            return;
        }
        while (true) {
            synchronized (this.f9417u) {
                if (this.f9417u.isEmpty()) {
                    return;
                }
                pair = (Pair) this.f9417u.remove(0);
            }
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            bufferInfo.set(((ByteBuffer) pair.second).position(), ((ByteBuffer) pair.second).remaining(), 0L, 16);
            this.f9411o.writeSampleData(this.f9414r[((Integer) pair.first).intValue()], (ByteBuffer) pair.second, bufferInfo);
        }
    }

    public void n() {
        c(false);
        this.f9416t = true;
        this.f9412p.y();
    }

    public void u(long j10) {
        c(true);
        synchronized (this) {
            e eVar = this.f9412p;
            if (eVar != null) {
                eVar.A();
            }
        }
        this.f9410n.b(j10);
        m();
        k();
    }
}
