package l0;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
/* loaded from: classes.dex */
public final class e implements AutoCloseable, SurfaceTexture.OnFrameAvailableListener {
    C0159e B;
    private SurfaceTexture C;
    private Surface D;
    private Surface E;
    private l0.b F;
    private l0.a G;
    private int H;

    /* renamed from: g  reason: collision with root package name */
    MediaCodec f9370g;

    /* renamed from: h  reason: collision with root package name */
    final c f9371h;

    /* renamed from: i  reason: collision with root package name */
    private final HandlerThread f9372i;

    /* renamed from: j  reason: collision with root package name */
    final Handler f9373j;

    /* renamed from: k  reason: collision with root package name */
    private final int f9374k;

    /* renamed from: l  reason: collision with root package name */
    final int f9375l;

    /* renamed from: m  reason: collision with root package name */
    final int f9376m;

    /* renamed from: n  reason: collision with root package name */
    final int f9377n;

    /* renamed from: o  reason: collision with root package name */
    final int f9378o;

    /* renamed from: p  reason: collision with root package name */
    final int f9379p;

    /* renamed from: q  reason: collision with root package name */
    final int f9380q;

    /* renamed from: r  reason: collision with root package name */
    private final int f9381r;

    /* renamed from: s  reason: collision with root package name */
    final boolean f9382s;

    /* renamed from: t  reason: collision with root package name */
    private int f9383t;

    /* renamed from: u  reason: collision with root package name */
    boolean f9384u;

    /* renamed from: v  reason: collision with root package name */
    private final Rect f9385v;

    /* renamed from: w  reason: collision with root package name */
    private final Rect f9386w;

    /* renamed from: x  reason: collision with root package name */
    private ByteBuffer f9387x;

    /* renamed from: y  reason: collision with root package name */
    private final ArrayList f9388y = new ArrayList();

    /* renamed from: z  reason: collision with root package name */
    private final ArrayList f9389z = new ArrayList();
    final ArrayList A = new ArrayList();
    private final float[] I = new float[16];

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            e.this.u();
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            e.this.C();
        }
    }

    /* loaded from: classes.dex */
    public static abstract class c {
        public abstract void a(e eVar);

        public abstract void b(e eVar, ByteBuffer byteBuffer);

        public abstract void c(e eVar, MediaCodec.CodecException codecException);

        public abstract void d(e eVar, MediaFormat mediaFormat);
    }

    /* loaded from: classes.dex */
    class d extends MediaCodec.Callback {

        /* renamed from: a  reason: collision with root package name */
        private boolean f9392a;

        d() {
        }

        private void a(MediaCodec.CodecException codecException) {
            e.this.C();
            if (codecException == null) {
                e eVar = e.this;
                eVar.f9371h.a(eVar);
                return;
            }
            e eVar2 = e.this;
            eVar2.f9371h.c(eVar2, codecException);
        }

        @Override // android.media.MediaCodec.Callback
        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            if (mediaCodec != e.this.f9370g) {
                return;
            }
            Log.e("HeifEncoder", "onError: " + codecException);
            a(codecException);
        }

        @Override // android.media.MediaCodec.Callback
        public void onInputBufferAvailable(MediaCodec mediaCodec, int i10) {
            e eVar = e.this;
            if (mediaCodec != eVar.f9370g || eVar.f9384u) {
                return;
            }
            eVar.A.add(Integer.valueOf(i10));
            e.this.u();
        }

        @Override // android.media.MediaCodec.Callback
        public void onOutputBufferAvailable(MediaCodec mediaCodec, int i10, MediaCodec.BufferInfo bufferInfo) {
            if (mediaCodec != e.this.f9370g || this.f9392a) {
                return;
            }
            if (bufferInfo.size > 0 && (bufferInfo.flags & 2) == 0) {
                ByteBuffer outputBuffer = mediaCodec.getOutputBuffer(i10);
                outputBuffer.position(bufferInfo.offset);
                outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
                C0159e c0159e = e.this.B;
                if (c0159e != null) {
                    c0159e.e(bufferInfo.presentationTimeUs);
                }
                e eVar = e.this;
                eVar.f9371h.b(eVar, outputBuffer);
            }
            this.f9392a = ((bufferInfo.flags & 4) != 0) | this.f9392a;
            mediaCodec.releaseOutputBuffer(i10, false);
            if (this.f9392a) {
                a(null);
            }
        }

        @Override // android.media.MediaCodec.Callback
        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            if (mediaCodec != e.this.f9370g) {
                return;
            }
            if (!"image/vnd.android.heic".equals(mediaFormat.getString("mime"))) {
                mediaFormat.setString("mime", "image/vnd.android.heic");
                mediaFormat.setInteger("width", e.this.f9375l);
                mediaFormat.setInteger("height", e.this.f9376m);
                e eVar = e.this;
                if (eVar.f9382s) {
                    mediaFormat.setInteger("tile-width", eVar.f9377n);
                    mediaFormat.setInteger("tile-height", e.this.f9378o);
                    mediaFormat.setInteger("grid-rows", e.this.f9379p);
                    mediaFormat.setInteger("grid-cols", e.this.f9380q);
                }
            }
            e eVar2 = e.this;
            eVar2.f9371h.d(eVar2, mediaFormat);
        }
    }

    /* renamed from: l0.e$e  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    private class C0159e {

        /* renamed from: a  reason: collision with root package name */
        final boolean f9394a;

        /* renamed from: b  reason: collision with root package name */
        long f9395b = -1;

        /* renamed from: c  reason: collision with root package name */
        long f9396c = -1;

        /* renamed from: d  reason: collision with root package name */
        long f9397d = -1;

        /* renamed from: e  reason: collision with root package name */
        long f9398e = -1;

        /* renamed from: f  reason: collision with root package name */
        long f9399f = -1;

        /* renamed from: g  reason: collision with root package name */
        boolean f9400g;

        /* JADX INFO: Access modifiers changed from: package-private */
        /* renamed from: l0.e$e$a */
        /* loaded from: classes.dex */
        public class a implements Runnable {
            a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                MediaCodec mediaCodec = e.this.f9370g;
                if (mediaCodec != null) {
                    mediaCodec.signalEndOfInputStream();
                }
            }
        }

        C0159e(boolean z9) {
            this.f9394a = z9;
        }

        private void a() {
            e.this.f9373j.post(new a());
            this.f9400g = true;
        }

        private void b() {
            if (this.f9400g) {
                return;
            }
            if (this.f9397d < 0) {
                long j10 = this.f9395b;
                if (j10 >= 0 && this.f9396c >= j10) {
                    long j11 = this.f9398e;
                    if (j11 < 0) {
                        a();
                        return;
                    }
                    this.f9397d = j11;
                }
            }
            long j12 = this.f9397d;
            if (j12 < 0 || j12 > this.f9399f) {
                return;
            }
            a();
        }

        synchronized void c(long j10) {
            if (this.f9394a) {
                if (this.f9395b < 0) {
                    this.f9395b = j10;
                }
            } else if (this.f9397d < 0) {
                this.f9397d = j10 / 1000;
            }
            b();
        }

        /* JADX WARN: Removed duplicated region for block: B:11:0x0013 A[Catch: all -> 0x001c, TryCatch #0 {, blocks: (B:3:0x0001, B:11:0x0013, B:12:0x0015), top: B:18:0x0001 }] */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        synchronized boolean d(long j10, long j11) {
            boolean z9;
            long j12 = this.f9395b;
            if (j12 >= 0 && j10 > j12) {
                z9 = false;
                if (z9) {
                    this.f9398e = j11;
                }
                this.f9396c = j10;
                b();
            }
            z9 = true;
            if (z9) {
            }
            this.f9396c = j10;
            b();
            return z9;
        }

        synchronized void e(long j10) {
            this.f9399f = j10;
            b();
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:71:0x01f7  */
    /* JADX WARN: Removed duplicated region for block: B:79:0x023e  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public e(int i10, int i11, boolean z9, int i12, int i13, Handler handler, c cVar) {
        MediaCodecInfo.CodecCapabilities capabilitiesForType;
        boolean z10;
        int i14;
        int i15;
        int i16;
        String str;
        int i17;
        boolean z11;
        Range qualityRange;
        if (i10 < 0 || i11 < 0 || i12 < 0 || i12 > 100) {
            throw new IllegalArgumentException("invalid encoder inputs");
        }
        int i18 = 512;
        int i19 = 1;
        boolean z12 = z9 & (i10 > 512 || i11 > 512);
        try {
            MediaCodec createEncoderByType = MediaCodec.createEncoderByType("image/vnd.android.heic");
            this.f9370g = createEncoderByType;
            capabilitiesForType = createEncoderByType.getCodecInfo().getCapabilitiesForType("image/vnd.android.heic");
        } catch (Exception unused) {
            MediaCodec createEncoderByType2 = MediaCodec.createEncoderByType("video/hevc");
            this.f9370g = createEncoderByType2;
            capabilitiesForType = createEncoderByType2.getCodecInfo().getCapabilitiesForType("video/hevc");
            z12 |= !capabilitiesForType.getVideoCapabilities().isSizeSupported(i10, i11);
            z10 = false;
        }
        if (!capabilitiesForType.getVideoCapabilities().isSizeSupported(i10, i11)) {
            this.f9370g.release();
            this.f9370g = null;
            throw new Exception();
        }
        z10 = true;
        this.f9374k = i13;
        this.f9371h = cVar;
        Looper looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            HandlerThread handlerThread = new HandlerThread("HeifEncoderThread", -2);
            this.f9372i = handlerThread;
            handlerThread.start();
            looper = handlerThread.getLooper();
        } else {
            this.f9372i = null;
        }
        Handler handler2 = new Handler(looper);
        this.f9373j = handler2;
        boolean z13 = i13 == 1 || i13 == 2;
        int i20 = z13 ? 2130708361 : 2135033992;
        this.f9375l = i10;
        this.f9376m = i11;
        this.f9382s = z12;
        if (z12) {
            i19 = ((i10 + 512) - 1) / 512;
            i15 = ((i11 + 512) - 1) / 512;
            i14 = 512;
        } else {
            i18 = i10;
            i14 = i11;
            i15 = 1;
        }
        MediaFormat createVideoFormat = z10 ? MediaFormat.createVideoFormat("image/vnd.android.heic", i10, i11) : MediaFormat.createVideoFormat("video/hevc", i18, i14);
        if (z12) {
            createVideoFormat.setInteger("tile-width", i18);
            createVideoFormat.setInteger("tile-height", i14);
            createVideoFormat.setInteger("grid-cols", i19);
            createVideoFormat.setInteger("grid-rows", i15);
        }
        if (z10) {
            this.f9377n = i10;
            this.f9378o = i11;
            this.f9379p = 1;
            this.f9380q = 1;
        } else {
            this.f9377n = i18;
            this.f9378o = i14;
            this.f9379p = i15;
            this.f9380q = i19;
        }
        int i21 = this.f9379p * this.f9380q;
        this.f9381r = i21;
        createVideoFormat.setInteger("i-frame-interval", 0);
        createVideoFormat.setInteger("color-format", i20);
        createVideoFormat.setInteger("frame-rate", i21);
        createVideoFormat.setInteger("capture-rate", i21 * 30);
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = capabilitiesForType.getEncoderCapabilities();
        if (encoderCapabilities.isBitrateModeSupported(0)) {
            Log.d("HeifEncoder", "Setting bitrate mode to constant quality");
            qualityRange = encoderCapabilities.getQualityRange();
            Log.d("HeifEncoder", "Quality range: " + qualityRange);
            createVideoFormat.setInteger("bitrate-mode", 0);
            i16 = (int) (((double) ((Integer) qualityRange.getLower()).intValue()) + (((double) ((((Integer) qualityRange.getUpper()).intValue() - ((Integer) qualityRange.getLower()).intValue()) * i12)) / 100.0d));
            str = "quality";
        } else {
            if (encoderCapabilities.isBitrateModeSupported(2)) {
                Log.d("HeifEncoder", "Setting bitrate mode to constant bitrate");
                createVideoFormat.setInteger("bitrate-mode", 2);
            } else {
                Log.d("HeifEncoder", "Setting bitrate mode to variable bitrate");
                createVideoFormat.setInteger("bitrate-mode", 1);
            }
            i16 = (int) ((((((i10 * i11) * 1.5d) * 8.0d) * 0.25d) * i12) / 100.0d);
            str = "bitrate";
        }
        createVideoFormat.setInteger(str, i16);
        this.f9370g.setCallback(new d(), handler2);
        this.f9370g.configure(createVideoFormat, (Surface) null, (MediaCrypto) null, 1);
        if (z13) {
            this.E = this.f9370g.createInputSurface();
            if (!z12 || z10) {
                i17 = i13;
                if (i17 != 2) {
                    z11 = false;
                    this.B = new C0159e(z11);
                    if (z11) {
                        this.D = this.E;
                    } else {
                        l0.b bVar = new l0.b(this.E);
                        this.F = bVar;
                        bVar.f();
                        l0.a aVar = new l0.a(new g(i17 == 2 ? 0 : 1), i10, i11);
                        this.G = aVar;
                        this.H = aVar.c();
                        if (i17 == 1) {
                            SurfaceTexture surfaceTexture = new SurfaceTexture(this.H, true);
                            this.C = surfaceTexture;
                            surfaceTexture.setOnFrameAvailableListener(this);
                            this.C.setDefaultBufferSize(i10, i11);
                            this.D = new Surface(this.C);
                        }
                        this.F.g();
                    }
                }
            } else {
                i17 = i13;
            }
            z11 = true;
            this.B = new C0159e(z11);
            if (z11) {
            }
        } else {
            for (int i22 = 0; i22 < 2; i22++) {
                this.f9388y.add(ByteBuffer.allocateDirect(((this.f9375l * this.f9376m) * 3) / 2));
            }
        }
        this.f9386w = new Rect(0, 0, this.f9377n, this.f9378o);
        this.f9385v = new Rect();
    }

    private ByteBuffer a() {
        ByteBuffer byteBuffer;
        synchronized (this.f9388y) {
            while (!this.f9384u && this.f9388y.isEmpty()) {
                try {
                    this.f9388y.wait();
                } catch (InterruptedException unused) {
                }
            }
            byteBuffer = this.f9384u ? null : (ByteBuffer) this.f9388y.remove(0);
        }
        return byteBuffer;
    }

    private void c(byte[] bArr) {
        ByteBuffer a10 = a();
        if (a10 == null) {
            return;
        }
        a10.clear();
        if (bArr != null) {
            a10.put(bArr);
        }
        a10.flip();
        synchronized (this.f9389z) {
            this.f9389z.add(a10);
        }
        this.f9373j.post(new a());
    }

    private long g(int i10) {
        return ((i10 * 1000000) / this.f9381r) + 132;
    }

    private static void k(ByteBuffer byteBuffer, Image image, int i10, int i11, Rect rect, Rect rect2) {
        int i12;
        int i13;
        if (rect.width() != rect2.width() || rect.height() != rect2.height()) {
            throw new IllegalArgumentException("src and dst rect size are different!");
        }
        if (i10 % 2 != 0 || i11 % 2 != 0 || rect.left % 2 != 0 || rect.top % 2 != 0 || rect.right % 2 != 0 || rect.bottom % 2 != 0 || rect2.left % 2 != 0 || rect2.top % 2 != 0 || rect2.right % 2 != 0 || rect2.bottom % 2 != 0) {
            throw new IllegalArgumentException("src or dst are not aligned!");
        }
        Image.Plane[] planes = image.getPlanes();
        for (int i14 = 0; i14 < planes.length; i14++) {
            ByteBuffer buffer = planes[i14].getBuffer();
            int pixelStride = planes[i14].getPixelStride();
            int min = Math.min(rect.width(), i10 - rect.left);
            int min2 = Math.min(rect.height(), i11 - rect.top);
            if (i14 > 0) {
                i12 = ((i10 * i11) * (i14 + 3)) / 4;
                i13 = 2;
            } else {
                i12 = 0;
                i13 = 1;
            }
            for (int i15 = 0; i15 < min2 / i13; i15++) {
                byteBuffer.position(((((rect.top / i13) + i15) * i10) / i13) + i12 + (rect.left / i13));
                buffer.position((((rect2.top / i13) + i15) * planes[i14].getRowStride()) + ((rect2.left * pixelStride) / i13));
                int i16 = 0;
                while (true) {
                    int i17 = min / i13;
                    if (i16 < i17) {
                        buffer.put(byteBuffer.get());
                        if (pixelStride > 1 && i16 != i17 - 1) {
                            buffer.position((buffer.position() + pixelStride) - 1);
                        }
                        i16++;
                    }
                }
            }
        }
    }

    private void m() {
        GLES20.glViewport(0, 0, this.f9377n, this.f9378o);
        for (int i10 = 0; i10 < this.f9379p; i10++) {
            for (int i11 = 0; i11 < this.f9380q; i11++) {
                int i12 = this.f9377n;
                int i13 = i11 * i12;
                int i14 = this.f9378o;
                int i15 = i10 * i14;
                this.f9385v.set(i13, i15, i12 + i13, i14 + i15);
                this.G.a(this.H, g.f9435i, this.f9385v);
                l0.b bVar = this.F;
                int i16 = this.f9383t;
                this.f9383t = i16 + 1;
                bVar.i(g(i16) * 1000);
                this.F.j();
            }
        }
    }

    private ByteBuffer n() {
        if (!this.f9384u && this.f9387x == null) {
            synchronized (this.f9389z) {
                this.f9387x = this.f9389z.isEmpty() ? null : (ByteBuffer) this.f9389z.remove(0);
            }
        }
        if (this.f9384u) {
            return null;
        }
        return this.f9387x;
    }

    private void v(boolean z9) {
        synchronized (this.f9388y) {
            this.f9384u = z9 | this.f9384u;
            this.f9388y.add(this.f9387x);
            this.f9388y.notifyAll();
        }
        this.f9387x = null;
    }

    public void A() {
        int i10 = this.f9374k;
        if (i10 == 2) {
            this.B.c(0L);
        } else if (i10 == 0) {
            c(null);
        }
    }

    void C() {
        MediaCodec mediaCodec = this.f9370g;
        if (mediaCodec != null) {
            mediaCodec.stop();
            this.f9370g.release();
            this.f9370g = null;
        }
        synchronized (this.f9388y) {
            this.f9384u = true;
            this.f9388y.notifyAll();
        }
        synchronized (this) {
            l0.a aVar = this.G;
            if (aVar != null) {
                aVar.e(false);
                this.G = null;
            }
            l0.b bVar = this.F;
            if (bVar != null) {
                bVar.h();
                this.F = null;
            }
            SurfaceTexture surfaceTexture = this.C;
            if (surfaceTexture != null) {
                surfaceTexture.release();
                this.C = null;
            }
        }
    }

    public void b(Bitmap bitmap) {
        if (this.f9374k != 2) {
            throw new IllegalStateException("addBitmap is only allowed in bitmap input mode");
        }
        if (this.B.d(g(this.f9383t) * 1000, g((this.f9383t + this.f9381r) - 1))) {
            synchronized (this) {
                l0.b bVar = this.F;
                if (bVar == null) {
                    return;
                }
                bVar.f();
                this.G.d(this.H, bitmap);
                m();
                this.F.g();
            }
        }
    }

    @Override // java.lang.AutoCloseable
    public void close() {
        synchronized (this.f9388y) {
            this.f9384u = true;
            this.f9388y.notifyAll();
        }
        this.f9373j.postAtFrontOfQueue(new b());
    }

    @Override // android.graphics.SurfaceTexture.OnFrameAvailableListener
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        synchronized (this) {
            l0.b bVar = this.F;
            if (bVar == null) {
                return;
            }
            bVar.f();
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(this.I);
            if (this.B.d(surfaceTexture.getTimestamp(), g((this.f9383t + this.f9381r) - 1))) {
                m();
            }
            surfaceTexture.releaseTexImage();
            this.F.g();
        }
    }

    void u() {
        while (true) {
            ByteBuffer n10 = n();
            if (n10 == null || this.A.isEmpty()) {
                return;
            }
            int intValue = ((Integer) this.A.remove(0)).intValue();
            boolean z9 = this.f9383t % this.f9381r == 0 && n10.remaining() == 0;
            if (!z9) {
                Image inputImage = this.f9370g.getInputImage(intValue);
                int i10 = this.f9377n;
                int i11 = this.f9383t;
                int i12 = this.f9380q;
                int i13 = (i11 % i12) * i10;
                int i14 = this.f9378o;
                int i15 = ((i11 / i12) % this.f9379p) * i14;
                this.f9385v.set(i13, i15, i10 + i13, i14 + i15);
                k(n10, inputImage, this.f9375l, this.f9376m, this.f9385v, this.f9386w);
            }
            MediaCodec mediaCodec = this.f9370g;
            int capacity = z9 ? 0 : mediaCodec.getInputBuffer(intValue).capacity();
            int i16 = this.f9383t;
            this.f9383t = i16 + 1;
            mediaCodec.queueInputBuffer(intValue, 0, capacity, g(i16), z9 ? 4 : 0);
            if (z9 || this.f9383t % this.f9381r == 0) {
                v(z9);
            }
        }
    }

    public void y() {
        this.f9370g.start();
    }
}
