package j4;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
/* loaded from: classes.dex */
public class j implements d {

    /* renamed from: k  reason: collision with root package name */
    private static final Bitmap.Config f9103k = Bitmap.Config.ARGB_8888;

    /* renamed from: a  reason: collision with root package name */
    private final k f9104a;

    /* renamed from: b  reason: collision with root package name */
    private final Set f9105b;

    /* renamed from: c  reason: collision with root package name */
    private final long f9106c;

    /* renamed from: d  reason: collision with root package name */
    private final a f9107d;

    /* renamed from: e  reason: collision with root package name */
    private long f9108e;

    /* renamed from: f  reason: collision with root package name */
    private long f9109f;

    /* renamed from: g  reason: collision with root package name */
    private int f9110g;

    /* renamed from: h  reason: collision with root package name */
    private int f9111h;

    /* renamed from: i  reason: collision with root package name */
    private int f9112i;

    /* renamed from: j  reason: collision with root package name */
    private int f9113j;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface a {
        void a(Bitmap bitmap);

        void b(Bitmap bitmap);
    }

    /* loaded from: classes.dex */
    private static final class b implements a {
        b() {
        }

        @Override // j4.j.a
        public void a(Bitmap bitmap) {
        }

        @Override // j4.j.a
        public void b(Bitmap bitmap) {
        }
    }

    public j(long j10) {
        this(j10, l(), k());
    }

    j(long j10, k kVar, Set set) {
        this.f9106c = j10;
        this.f9108e = j10;
        this.f9104a = kVar;
        this.f9105b = set;
        this.f9107d = new b();
    }

    private static void f(Bitmap.Config config) {
        if (Build.VERSION.SDK_INT >= 26 && config == Bitmap.Config.HARDWARE) {
            throw new IllegalArgumentException("Cannot create a mutable Bitmap with config: " + config + ". Consider setting Downsampler#ALLOW_HARDWARE_CONFIG to false in your RequestOptions and/or in GlideBuilder.setDefaultRequestOptions");
        }
    }

    private static Bitmap g(int i10, int i11, Bitmap.Config config) {
        if (config == null) {
            config = f9103k;
        }
        return Bitmap.createBitmap(i10, i11, config);
    }

    private void h() {
        if (Log.isLoggable("LruBitmapPool", 2)) {
            i();
        }
    }

    private void i() {
        Log.v("LruBitmapPool", "Hits=" + this.f9110g + ", misses=" + this.f9111h + ", puts=" + this.f9112i + ", evictions=" + this.f9113j + ", currentSize=" + this.f9109f + ", maxSize=" + this.f9108e + "\nStrategy=" + this.f9104a);
    }

    private void j() {
        q(this.f9108e);
    }

    private static Set k() {
        HashSet hashSet = new HashSet(Arrays.asList(Bitmap.Config.values()));
        int i10 = Build.VERSION.SDK_INT;
        hashSet.add(null);
        if (i10 >= 26) {
            hashSet.remove(Bitmap.Config.HARDWARE);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static k l() {
        return new m();
    }

    private synchronized Bitmap m(int i10, int i11, Bitmap.Config config) {
        Bitmap d10;
        f(config);
        d10 = this.f9104a.d(i10, i11, config != null ? config : f9103k);
        if (d10 == null) {
            if (Log.isLoggable("LruBitmapPool", 3)) {
                Log.d("LruBitmapPool", "Missing bitmap=" + this.f9104a.a(i10, i11, config));
            }
            this.f9111h++;
        } else {
            this.f9110g++;
            this.f9109f -= this.f9104a.b(d10);
            this.f9107d.a(d10);
            p(d10);
        }
        if (Log.isLoggable("LruBitmapPool", 2)) {
            Log.v("LruBitmapPool", "Get bitmap=" + this.f9104a.a(i10, i11, config));
        }
        h();
        return d10;
    }

    private static void o(Bitmap bitmap) {
        bitmap.setPremultiplied(true);
    }

    private static void p(Bitmap bitmap) {
        bitmap.setHasAlpha(true);
        o(bitmap);
    }

    private synchronized void q(long j10) {
        while (this.f9109f > j10) {
            Bitmap removeLast = this.f9104a.removeLast();
            if (removeLast == null) {
                if (Log.isLoggable("LruBitmapPool", 5)) {
                    Log.w("LruBitmapPool", "Size mismatch, resetting");
                    i();
                }
                this.f9109f = 0L;
                return;
            }
            this.f9107d.a(removeLast);
            this.f9109f -= this.f9104a.b(removeLast);
            this.f9113j++;
            if (Log.isLoggable("LruBitmapPool", 3)) {
                Log.d("LruBitmapPool", "Evicting bitmap=" + this.f9104a.e(removeLast));
            }
            h();
            removeLast.recycle();
        }
    }

    @Override // j4.d
    public void a(int i10) {
        if (Log.isLoggable("LruBitmapPool", 3)) {
            Log.d("LruBitmapPool", "trimMemory, level=" + i10);
        }
        if (i10 >= 40 || (Build.VERSION.SDK_INT >= 23 && i10 >= 20)) {
            b();
        } else if (i10 >= 20 || i10 == 15) {
            q(n() / 2);
        }
    }

    @Override // j4.d
    public void b() {
        if (Log.isLoggable("LruBitmapPool", 3)) {
            Log.d("LruBitmapPool", "clearMemory");
        }
        q(0L);
    }

    @Override // j4.d
    public synchronized void c(Bitmap bitmap) {
        try {
            if (bitmap == null) {
                throw new NullPointerException("Bitmap must not be null");
            }
            if (bitmap.isRecycled()) {
                throw new IllegalStateException("Cannot pool recycled bitmap");
            }
            if (bitmap.isMutable() && this.f9104a.b(bitmap) <= this.f9108e && this.f9105b.contains(bitmap.getConfig())) {
                int b10 = this.f9104a.b(bitmap);
                this.f9104a.c(bitmap);
                this.f9107d.b(bitmap);
                this.f9112i++;
                this.f9109f += b10;
                if (Log.isLoggable("LruBitmapPool", 2)) {
                    Log.v("LruBitmapPool", "Put bitmap in pool=" + this.f9104a.e(bitmap));
                }
                h();
                j();
                return;
            }
            if (Log.isLoggable("LruBitmapPool", 2)) {
                Log.v("LruBitmapPool", "Reject bitmap from pool, bitmap: " + this.f9104a.e(bitmap) + ", is mutable: " + bitmap.isMutable() + ", is allowed config: " + this.f9105b.contains(bitmap.getConfig()));
            }
            bitmap.recycle();
        } catch (Throwable th) {
            throw th;
        }
    }

    @Override // j4.d
    public Bitmap d(int i10, int i11, Bitmap.Config config) {
        Bitmap m10 = m(i10, i11, config);
        if (m10 != null) {
            m10.eraseColor(0);
            return m10;
        }
        return g(i10, i11, config);
    }

    @Override // j4.d
    public Bitmap e(int i10, int i11, Bitmap.Config config) {
        Bitmap m10 = m(i10, i11, config);
        return m10 == null ? g(i10, i11, config) : m10;
    }

    public long n() {
        return this.f9108e;
    }
}
