package io.flutter.plugins.webviewflutter;

import android.util.Log;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugins.webviewflutter.GeneratedAndroidWebView;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
public class GeneratedAndroidWebView {

    /* loaded from: classes.dex */
    public static final class ConsoleMessage {
        private ConsoleMessageLevel level;
        private Long lineNumber;
        private String message;
        private String sourceId;

        /* loaded from: classes.dex */
        public static final class Builder {
            private ConsoleMessageLevel level;
            private Long lineNumber;
            private String message;
            private String sourceId;

            public ConsoleMessage build() {
                ConsoleMessage consoleMessage = new ConsoleMessage();
                consoleMessage.setLineNumber(this.lineNumber);
                consoleMessage.setMessage(this.message);
                consoleMessage.setLevel(this.level);
                consoleMessage.setSourceId(this.sourceId);
                return consoleMessage;
            }

            public Builder setLevel(ConsoleMessageLevel consoleMessageLevel) {
                this.level = consoleMessageLevel;
                return this;
            }

            public Builder setLineNumber(Long l10) {
                this.lineNumber = l10;
                return this;
            }

            public Builder setMessage(String str) {
                this.message = str;
                return this;
            }

            public Builder setSourceId(String str) {
                this.sourceId = str;
                return this;
            }
        }

        ConsoleMessage() {
        }

        static ConsoleMessage fromList(ArrayList<Object> arrayList) {
            Long valueOf;
            ConsoleMessage consoleMessage = new ConsoleMessage();
            Object obj = arrayList.get(0);
            if (obj == null) {
                valueOf = null;
            } else {
                valueOf = Long.valueOf(obj instanceof Integer ? ((Integer) obj).intValue() : ((Long) obj).longValue());
            }
            consoleMessage.setLineNumber(valueOf);
            consoleMessage.setMessage((String) arrayList.get(1));
            consoleMessage.setLevel(ConsoleMessageLevel.values()[((Integer) arrayList.get(2)).intValue()]);
            consoleMessage.setSourceId((String) arrayList.get(3));
            return consoleMessage;
        }

        public ConsoleMessageLevel getLevel() {
            return this.level;
        }

        public Long getLineNumber() {
            return this.lineNumber;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setLevel(ConsoleMessageLevel consoleMessageLevel) {
            if (consoleMessageLevel == null) {
                throw new IllegalStateException("Nonnull field \"level\" is null.");
            }
            this.level = consoleMessageLevel;
        }

        public void setLineNumber(Long l10) {
            if (l10 == null) {
                throw new IllegalStateException("Nonnull field \"lineNumber\" is null.");
            }
            this.lineNumber = l10;
        }

        public void setMessage(String str) {
            if (str == null) {
                throw new IllegalStateException("Nonnull field \"message\" is null.");
            }
            this.message = str;
        }

        public void setSourceId(String str) {
            if (str == null) {
                throw new IllegalStateException("Nonnull field \"sourceId\" is null.");
            }
            this.sourceId = str;
        }

        ArrayList<Object> toList() {
            ArrayList<Object> arrayList = new ArrayList<>(4);
            arrayList.add(this.lineNumber);
            arrayList.add(this.message);
            ConsoleMessageLevel consoleMessageLevel = this.level;
            arrayList.add(consoleMessageLevel == null ? null : Integer.valueOf(consoleMessageLevel.index));
            arrayList.add(this.sourceId);
            return arrayList;
        }
    }

    /* loaded from: classes.dex */
    public enum ConsoleMessageLevel {
        DEBUG(0),
        ERROR(1),
        LOG(2),
        TIP(3),
        WARNING(4),
        UNKNOWN(5);
        
        final int index;

        ConsoleMessageLevel(int i10) {
            this.index = i10;
        }
    }

    /* loaded from: classes.dex */
    public interface CookieManagerHostApi {

        /* renamed from: io.flutter.plugins.webviewflutter.GeneratedAndroidWebView$CookieManagerHostApi$-CC  reason: invalid class name */
        /* loaded from: classes.dex */
        public abstract /* synthetic */ class CC {
            public static MessageCodec a() {
                return new StandardMessageCodec();
            }

            public static /* synthetic */ void b(CookieManagerHostApi cookieManagerHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                cookieManagerHostApi.attachInstance(valueOf);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void c(CookieManagerHostApi cookieManagerHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                String str = (String) arrayList2.get(1);
                String str2 = (String) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                cookieManagerHostApi.setCookie(valueOf, str, str2);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void d(CookieManagerHostApi cookieManagerHostApi, Object obj, final BasicMessageChannel.Reply reply) {
                final ArrayList arrayList = new ArrayList();
                Number number = (Number) ((ArrayList) obj).get(0);
                cookieManagerHostApi.removeAllCookies(number == null ? null : Long.valueOf(number.longValue()), new Result<Boolean>() { // from class: io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.CookieManagerHostApi.1
                    @Override // io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.Result
                    public void error(Throwable th) {
                        reply.reply(GeneratedAndroidWebView.wrapError(th));
                    }

                    @Override // io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.Result
                    public void success(Boolean bool) {
                        arrayList.add(0, bool);
                        reply.reply(arrayList);
                    }
                });
            }

            public static /* synthetic */ void e(CookieManagerHostApi cookieManagerHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                Boolean bool = (Boolean) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                cookieManagerHostApi.setAcceptThirdPartyCookies(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()), bool);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static void f(BinaryMessenger binaryMessenger, final CookieManagerHostApi cookieManagerHostApi) {
                BasicMessageChannel basicMessageChannel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.attachInstance", a());
                if (cookieManagerHostApi != null) {
                    basicMessageChannel.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.d
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.CookieManagerHostApi.CC.b(GeneratedAndroidWebView.CookieManagerHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel2 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie", a());
                if (cookieManagerHostApi != null) {
                    basicMessageChannel2.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.e
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.CookieManagerHostApi.CC.c(GeneratedAndroidWebView.CookieManagerHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel2.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel3 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.removeAllCookies", a());
                if (cookieManagerHostApi != null) {
                    basicMessageChannel3.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.f
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.CookieManagerHostApi.CC.d(GeneratedAndroidWebView.CookieManagerHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel3.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel4 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies", a());
                if (cookieManagerHostApi != null) {
                    basicMessageChannel4.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.g
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.CookieManagerHostApi.CC.e(GeneratedAndroidWebView.CookieManagerHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel4.setMessageHandler(null);
                }
            }
        }

        void attachInstance(Long l10);

        void removeAllCookies(Long l10, Result<Boolean> result);

        void setAcceptThirdPartyCookies(Long l10, Long l11, Boolean bool);

        void setCookie(Long l10, String str, String str2);
    }

    /* loaded from: classes.dex */
    public static class CustomViewCallbackFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public CustomViewCallbackFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.CustomViewCallbackFlutterApi.create", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.h
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.CustomViewCallbackFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface CustomViewCallbackHostApi {
        void onCustomViewHidden(Long l10);
    }

    /* loaded from: classes.dex */
    public static class DownloadListenerFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public DownloadListenerFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void onDownloadStart(Long l10, String str, String str2, String str3, String str4, Long l11, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.DownloadListenerFlutterApi.onDownloadStart", getCodec()).send(new ArrayList(Arrays.asList(l10, str, str2, str3, str4, l11)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.k
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.DownloadListenerFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface DownloadListenerHostApi {
        void create(Long l10);
    }

    /* loaded from: classes.dex */
    public enum FileChooserMode {
        OPEN(0),
        OPEN_MULTIPLE(1),
        SAVE(2);
        
        final int index;

        FileChooserMode(int i10) {
            this.index = i10;
        }
    }

    /* loaded from: classes.dex */
    public static class FileChooserParamsFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public FileChooserParamsFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, Boolean bool, List<String> list, FileChooserMode fileChooserMode, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.FileChooserParamsFlutterApi.create", getCodec()).send(new ArrayList(Arrays.asList(l10, bool, list, Integer.valueOf(fileChooserMode.index), str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.n
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.FileChooserParamsFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface FlutterAssetManagerHostApi {
        String getAssetFilePathByName(String str);

        List<String> list(String str);
    }

    /* loaded from: classes.dex */
    public static class FlutterError extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(String str, String str2, Object obj) {
            super(str2);
            this.code = str;
            this.details = obj;
        }
    }

    /* loaded from: classes.dex */
    public static class GeolocationPermissionsCallbackFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public GeolocationPermissionsCallbackFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackFlutterApi.create", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.s
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.GeolocationPermissionsCallbackFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface GeolocationPermissionsCallbackHostApi {
        void invoke(Long l10, String str, Boolean bool, Boolean bool2);
    }

    /* loaded from: classes.dex */
    public static class HttpAuthHandlerFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public HttpAuthHandlerFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerFlutterApi.create", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.v
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.HttpAuthHandlerFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface HttpAuthHandlerHostApi {
        void cancel(Long l10);

        void proceed(Long l10, String str, String str2);

        Boolean useHttpAuthUsernamePassword(Long l10);
    }

    /* loaded from: classes.dex */
    public interface InstanceManagerHostApi {
        void clear();
    }

    /* loaded from: classes.dex */
    public static class JavaObjectFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public JavaObjectFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void dispose(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.JavaObjectFlutterApi.dispose", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.c0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.JavaObjectFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface JavaObjectHostApi {
        void dispose(Long l10);
    }

    /* loaded from: classes.dex */
    public static class JavaScriptChannelFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public JavaScriptChannelFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void postMessage(Long l10, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.JavaScriptChannelFlutterApi.postMessage", getCodec()).send(new ArrayList(Arrays.asList(l10, str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.f0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.JavaScriptChannelFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface JavaScriptChannelHostApi {
        void create(Long l10, String str);
    }

    /* loaded from: classes.dex */
    public static class PermissionRequestFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public PermissionRequestFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, List<String> list, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.PermissionRequestFlutterApi.create", getCodec()).send(new ArrayList(Arrays.asList(l10, list)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.i0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.PermissionRequestFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface PermissionRequestHostApi {
        void deny(Long l10);

        void grant(Long l10, List<String> list);
    }

    /* loaded from: classes.dex */
    public interface Result<T> {
        void error(Throwable th);

        void success(T t9);
    }

    /* loaded from: classes.dex */
    public static class ViewFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public ViewFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.ViewFlutterApi.create", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.m0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.ViewFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public static class WebChromeClientFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public WebChromeClientFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return WebChromeClientFlutterApiCodec.INSTANCE;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static /* synthetic */ void lambda$onJsConfirm$9(Reply reply, Object obj) {
            reply.reply((Boolean) obj);
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static /* synthetic */ void lambda$onJsPrompt$10(Reply reply, Object obj) {
            reply.reply((String) obj);
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static /* synthetic */ void lambda$onShowFileChooser$1(Reply reply, Object obj) {
            reply.reply((List) obj);
        }

        public void onConsoleMessage(Long l10, ConsoleMessage consoleMessage, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onConsoleMessage", getCodec()).send(new ArrayList(Arrays.asList(l10, consoleMessage)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.x0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onGeolocationPermissionsHidePrompt(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onGeolocationPermissionsHidePrompt", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.t0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onGeolocationPermissionsShowPrompt(Long l10, Long l11, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onGeolocationPermissionsShowPrompt", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.r0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onHideCustomView(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onHideCustomView", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.s0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onJsAlert(Long l10, String str, String str2, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onJsAlert", getCodec()).send(new ArrayList(Arrays.asList(l10, str, str2)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.o0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onJsConfirm(Long l10, String str, String str2, final Reply<Boolean> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onJsConfirm", getCodec()).send(new ArrayList(Arrays.asList(l10, str, str2)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.q0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.lambda$onJsConfirm$9(GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this, obj);
                }
            });
        }

        public void onJsPrompt(Long l10, String str, String str2, String str3, final Reply<String> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onJsPrompt", getCodec()).send(new ArrayList(Arrays.asList(l10, str, str2, str3)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.p0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.lambda$onJsPrompt$10(GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this, obj);
                }
            });
        }

        public void onPermissionRequest(Long l10, Long l11, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onPermissionRequest", getCodec()).send(new ArrayList(Arrays.asList(l10, l11)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.n0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onProgressChanged(Long l10, Long l11, Long l12, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onProgressChanged", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.u0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onShowCustomView(Long l10, Long l11, Long l12, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onShowCustomView", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.w0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onShowFileChooser(Long l10, Long l11, Long l12, final Reply<List<String>> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebChromeClientFlutterApi.onShowFileChooser", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.v0
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebChromeClientFlutterApi.lambda$onShowFileChooser$1(GeneratedAndroidWebView.WebChromeClientFlutterApi.Reply.this, obj);
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class WebChromeClientFlutterApiCodec extends StandardMessageCodec {
        public static final WebChromeClientFlutterApiCodec INSTANCE = new WebChromeClientFlutterApiCodec();

        private WebChromeClientFlutterApiCodec() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public Object readValueOfType(byte b10, ByteBuffer byteBuffer) {
            return b10 != Byte.MIN_VALUE ? super.readValueOfType(b10, byteBuffer) : ConsoleMessage.fromList((ArrayList) readValue(byteBuffer));
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public void writeValue(ByteArrayOutputStream byteArrayOutputStream, Object obj) {
            if (!(obj instanceof ConsoleMessage)) {
                super.writeValue(byteArrayOutputStream, obj);
                return;
            }
            byteArrayOutputStream.write(128);
            writeValue(byteArrayOutputStream, ((ConsoleMessage) obj).toList());
        }
    }

    /* loaded from: classes.dex */
    public interface WebChromeClientHostApi {
        void create(Long l10);

        void setSynchronousReturnValueForOnConsoleMessage(Long l10, Boolean bool);

        void setSynchronousReturnValueForOnJsAlert(Long l10, Boolean bool);

        void setSynchronousReturnValueForOnJsConfirm(Long l10, Boolean bool);

        void setSynchronousReturnValueForOnJsPrompt(Long l10, Boolean bool);

        void setSynchronousReturnValueForOnShowFileChooser(Long l10, Boolean bool);
    }

    /* loaded from: classes.dex */
    public static final class WebResourceErrorData {
        private String description;
        private Long errorCode;

        /* loaded from: classes.dex */
        public static final class Builder {
            private String description;
            private Long errorCode;

            public WebResourceErrorData build() {
                WebResourceErrorData webResourceErrorData = new WebResourceErrorData();
                webResourceErrorData.setErrorCode(this.errorCode);
                webResourceErrorData.setDescription(this.description);
                return webResourceErrorData;
            }

            public Builder setDescription(String str) {
                this.description = str;
                return this;
            }

            public Builder setErrorCode(Long l10) {
                this.errorCode = l10;
                return this;
            }
        }

        WebResourceErrorData() {
        }

        static WebResourceErrorData fromList(ArrayList<Object> arrayList) {
            Long valueOf;
            WebResourceErrorData webResourceErrorData = new WebResourceErrorData();
            Object obj = arrayList.get(0);
            if (obj == null) {
                valueOf = null;
            } else {
                valueOf = Long.valueOf(obj instanceof Integer ? ((Integer) obj).intValue() : ((Long) obj).longValue());
            }
            webResourceErrorData.setErrorCode(valueOf);
            webResourceErrorData.setDescription((String) arrayList.get(1));
            return webResourceErrorData;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getErrorCode() {
            return this.errorCode;
        }

        public void setDescription(String str) {
            if (str == null) {
                throw new IllegalStateException("Nonnull field \"description\" is null.");
            }
            this.description = str;
        }

        public void setErrorCode(Long l10) {
            if (l10 == null) {
                throw new IllegalStateException("Nonnull field \"errorCode\" is null.");
            }
            this.errorCode = l10;
        }

        ArrayList<Object> toList() {
            ArrayList<Object> arrayList = new ArrayList<>(2);
            arrayList.add(this.errorCode);
            arrayList.add(this.description);
            return arrayList;
        }
    }

    /* loaded from: classes.dex */
    public static final class WebResourceRequestData {
        private Boolean hasGesture;
        private Boolean isForMainFrame;
        private Boolean isRedirect;
        private String method;
        private Map<String, String> requestHeaders;
        private String url;

        /* loaded from: classes.dex */
        public static final class Builder {
            private Boolean hasGesture;
            private Boolean isForMainFrame;
            private Boolean isRedirect;
            private String method;
            private Map<String, String> requestHeaders;
            private String url;

            public WebResourceRequestData build() {
                WebResourceRequestData webResourceRequestData = new WebResourceRequestData();
                webResourceRequestData.setUrl(this.url);
                webResourceRequestData.setIsForMainFrame(this.isForMainFrame);
                webResourceRequestData.setIsRedirect(this.isRedirect);
                webResourceRequestData.setHasGesture(this.hasGesture);
                webResourceRequestData.setMethod(this.method);
                webResourceRequestData.setRequestHeaders(this.requestHeaders);
                return webResourceRequestData;
            }

            public Builder setHasGesture(Boolean bool) {
                this.hasGesture = bool;
                return this;
            }

            public Builder setIsForMainFrame(Boolean bool) {
                this.isForMainFrame = bool;
                return this;
            }

            public Builder setIsRedirect(Boolean bool) {
                this.isRedirect = bool;
                return this;
            }

            public Builder setMethod(String str) {
                this.method = str;
                return this;
            }

            public Builder setRequestHeaders(Map<String, String> map) {
                this.requestHeaders = map;
                return this;
            }

            public Builder setUrl(String str) {
                this.url = str;
                return this;
            }
        }

        WebResourceRequestData() {
        }

        static WebResourceRequestData fromList(ArrayList<Object> arrayList) {
            WebResourceRequestData webResourceRequestData = new WebResourceRequestData();
            webResourceRequestData.setUrl((String) arrayList.get(0));
            webResourceRequestData.setIsForMainFrame((Boolean) arrayList.get(1));
            webResourceRequestData.setIsRedirect((Boolean) arrayList.get(2));
            webResourceRequestData.setHasGesture((Boolean) arrayList.get(3));
            webResourceRequestData.setMethod((String) arrayList.get(4));
            webResourceRequestData.setRequestHeaders((Map) arrayList.get(5));
            return webResourceRequestData;
        }

        public Boolean getHasGesture() {
            return this.hasGesture;
        }

        public Boolean getIsForMainFrame() {
            return this.isForMainFrame;
        }

        public Boolean getIsRedirect() {
            return this.isRedirect;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public String getUrl() {
            return this.url;
        }

        public void setHasGesture(Boolean bool) {
            if (bool == null) {
                throw new IllegalStateException("Nonnull field \"hasGesture\" is null.");
            }
            this.hasGesture = bool;
        }

        public void setIsForMainFrame(Boolean bool) {
            if (bool == null) {
                throw new IllegalStateException("Nonnull field \"isForMainFrame\" is null.");
            }
            this.isForMainFrame = bool;
        }

        public void setIsRedirect(Boolean bool) {
            this.isRedirect = bool;
        }

        public void setMethod(String str) {
            if (str == null) {
                throw new IllegalStateException("Nonnull field \"method\" is null.");
            }
            this.method = str;
        }

        public void setRequestHeaders(Map<String, String> map) {
            if (map == null) {
                throw new IllegalStateException("Nonnull field \"requestHeaders\" is null.");
            }
            this.requestHeaders = map;
        }

        public void setUrl(String str) {
            if (str == null) {
                throw new IllegalStateException("Nonnull field \"url\" is null.");
            }
            this.url = str;
        }

        ArrayList<Object> toList() {
            ArrayList<Object> arrayList = new ArrayList<>(6);
            arrayList.add(this.url);
            arrayList.add(this.isForMainFrame);
            arrayList.add(this.isRedirect);
            arrayList.add(this.hasGesture);
            arrayList.add(this.method);
            arrayList.add(this.requestHeaders);
            return arrayList;
        }
    }

    /* loaded from: classes.dex */
    public static final class WebResourceResponseData {
        private Long statusCode;

        /* loaded from: classes.dex */
        public static final class Builder {
            private Long statusCode;

            public WebResourceResponseData build() {
                WebResourceResponseData webResourceResponseData = new WebResourceResponseData();
                webResourceResponseData.setStatusCode(this.statusCode);
                return webResourceResponseData;
            }

            public Builder setStatusCode(Long l10) {
                this.statusCode = l10;
                return this;
            }
        }

        WebResourceResponseData() {
        }

        static WebResourceResponseData fromList(ArrayList<Object> arrayList) {
            Long valueOf;
            WebResourceResponseData webResourceResponseData = new WebResourceResponseData();
            Object obj = arrayList.get(0);
            if (obj == null) {
                valueOf = null;
            } else {
                valueOf = Long.valueOf(obj instanceof Integer ? ((Integer) obj).intValue() : ((Long) obj).longValue());
            }
            webResourceResponseData.setStatusCode(valueOf);
            return webResourceResponseData;
        }

        public Long getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Long l10) {
            if (l10 == null) {
                throw new IllegalStateException("Nonnull field \"statusCode\" is null.");
            }
            this.statusCode = l10;
        }

        ArrayList<Object> toList() {
            ArrayList<Object> arrayList = new ArrayList<>(1);
            arrayList.add(this.statusCode);
            return arrayList;
        }
    }

    /* loaded from: classes.dex */
    public interface WebSettingsHostApi {
        void create(Long l10, Long l11);

        String getUserAgentString(Long l10);

        void setAllowFileAccess(Long l10, Boolean bool);

        void setBuiltInZoomControls(Long l10, Boolean bool);

        void setDisplayZoomControls(Long l10, Boolean bool);

        void setDomStorageEnabled(Long l10, Boolean bool);

        void setJavaScriptCanOpenWindowsAutomatically(Long l10, Boolean bool);

        void setJavaScriptEnabled(Long l10, Boolean bool);

        void setLoadWithOverviewMode(Long l10, Boolean bool);

        void setMediaPlaybackRequiresUserGesture(Long l10, Boolean bool);

        void setSupportMultipleWindows(Long l10, Boolean bool);

        void setSupportZoom(Long l10, Boolean bool);

        void setTextZoom(Long l10, Long l11);

        void setUseWideViewPort(Long l10, Boolean bool);

        void setUserAgentString(Long l10, String str);
    }

    /* loaded from: classes.dex */
    public interface WebStorageHostApi {
        void create(Long l10);

        void deleteAllData(Long l10);
    }

    /* loaded from: classes.dex */
    public static class WebViewClientFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public WebViewClientFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return WebViewClientFlutterApiCodec.INSTANCE;
        }

        public void doUpdateVisitedHistory(Long l10, Long l11, String str, Boolean bool, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.doUpdateVisitedHistory", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, str, bool)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.e2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onPageFinished(Long l10, Long l11, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onPageFinished", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.d2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onPageStarted(Long l10, Long l11, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onPageStarted", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.a2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onReceivedError(Long l10, Long l11, Long l12, String str, String str2, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onReceivedError", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12, str, str2)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.f2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onReceivedHttpAuthRequest(Long l10, Long l11, Long l12, String str, String str2, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onReceivedHttpAuthRequest", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12, str, str2)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.g2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onReceivedHttpError(Long l10, Long l11, WebResourceRequestData webResourceRequestData, WebResourceResponseData webResourceResponseData, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onReceivedHttpError", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, webResourceRequestData, webResourceResponseData)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.c2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onReceivedRequestError(Long l10, Long l11, WebResourceRequestData webResourceRequestData, WebResourceErrorData webResourceErrorData, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.onReceivedRequestError", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, webResourceRequestData, webResourceErrorData)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.y1
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void requestLoading(Long l10, Long l11, WebResourceRequestData webResourceRequestData, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.requestLoading", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, webResourceRequestData)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.z1
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void urlLoading(Long l10, Long l11, String str, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewClientFlutterApi.urlLoading", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, str)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.b2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewClientFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class WebViewClientFlutterApiCodec extends StandardMessageCodec {
        public static final WebViewClientFlutterApiCodec INSTANCE = new WebViewClientFlutterApiCodec();

        private WebViewClientFlutterApiCodec() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public Object readValueOfType(byte b10, ByteBuffer byteBuffer) {
            switch (b10) {
                case Byte.MIN_VALUE:
                    return WebResourceErrorData.fromList((ArrayList) readValue(byteBuffer));
                case -127:
                    return WebResourceRequestData.fromList((ArrayList) readValue(byteBuffer));
                case -126:
                    return WebResourceResponseData.fromList((ArrayList) readValue(byteBuffer));
                default:
                    return super.readValueOfType(b10, byteBuffer);
            }
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public void writeValue(ByteArrayOutputStream byteArrayOutputStream, Object obj) {
            ArrayList<Object> list;
            if (obj instanceof WebResourceErrorData) {
                byteArrayOutputStream.write(128);
                list = ((WebResourceErrorData) obj).toList();
            } else if (obj instanceof WebResourceRequestData) {
                byteArrayOutputStream.write(129);
                list = ((WebResourceRequestData) obj).toList();
            } else if (!(obj instanceof WebResourceResponseData)) {
                super.writeValue(byteArrayOutputStream, obj);
                return;
            } else {
                byteArrayOutputStream.write(130);
                list = ((WebResourceResponseData) obj).toList();
            }
            writeValue(byteArrayOutputStream, list);
        }
    }

    /* loaded from: classes.dex */
    public interface WebViewClientHostApi {
        void create(Long l10);

        void setSynchronousReturnValueForShouldOverrideUrlLoading(Long l10, Boolean bool);
    }

    /* loaded from: classes.dex */
    public static class WebViewFlutterApi {
        private final BinaryMessenger binaryMessenger;

        /* loaded from: classes.dex */
        public interface Reply<T> {
            void reply(T t9);
        }

        public WebViewFlutterApi(BinaryMessenger binaryMessenger) {
            this.binaryMessenger = binaryMessenger;
        }

        static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public void create(Long l10, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewFlutterApi.create", getCodec()).send(new ArrayList(Collections.singletonList(l10)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.l2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewFlutterApi.Reply.this.reply(null);
                }
            });
        }

        public void onScrollChanged(Long l10, Long l11, Long l12, Long l13, Long l14, final Reply<Void> reply) {
            new BasicMessageChannel(this.binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewFlutterApi.onScrollChanged", getCodec()).send(new ArrayList(Arrays.asList(l10, l11, l12, l13, l14)), new BasicMessageChannel.Reply() { // from class: io.flutter.plugins.webviewflutter.k2
                @Override // io.flutter.plugin.common.BasicMessageChannel.Reply
                public final void reply(Object obj) {
                    GeneratedAndroidWebView.WebViewFlutterApi.Reply.this.reply(null);
                }
            });
        }
    }

    /* loaded from: classes.dex */
    public interface WebViewHostApi {

        /* renamed from: io.flutter.plugins.webviewflutter.GeneratedAndroidWebView$WebViewHostApi$-CC  reason: invalid class name */
        /* loaded from: classes.dex */
        public abstract /* synthetic */ class CC {
            public static /* synthetic */ void A(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.goForward(valueOf);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static void B(BinaryMessenger binaryMessenger, final WebViewHostApi webViewHostApi) {
                BasicMessageChannel basicMessageChannel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.create", a());
                if (webViewHostApi != null) {
                    basicMessageChannel.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.m2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.b(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel2 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadData", a());
                if (webViewHostApi != null) {
                    basicMessageChannel2.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.o2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.c(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel2.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel3 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadDataWithBaseUrl", a());
                if (webViewHostApi != null) {
                    basicMessageChannel3.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.v2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.n(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel3.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel4 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl", a());
                if (webViewHostApi != null) {
                    basicMessageChannel4.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.w2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.u(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel4.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel5 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl", a());
                if (webViewHostApi != null) {
                    basicMessageChannel5.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.y2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.v(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel5.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel6 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getUrl", a());
                if (webViewHostApi != null) {
                    basicMessageChannel6.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.z2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.w(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel6.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel7 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoBack", a());
                if (webViewHostApi != null) {
                    basicMessageChannel7.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.a3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.x(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel7.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel8 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoForward", a());
                if (webViewHostApi != null) {
                    basicMessageChannel8.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.b3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.y(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel8.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel9 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goBack", a());
                if (webViewHostApi != null) {
                    basicMessageChannel9.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.c3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.z(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel9.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel10 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goForward", a());
                if (webViewHostApi != null) {
                    basicMessageChannel10.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.d3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.A(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel10.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel11 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.reload", a());
                if (webViewHostApi != null) {
                    basicMessageChannel11.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.x2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.d(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel11.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel12 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.clearCache", a());
                if (webViewHostApi != null) {
                    basicMessageChannel12.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.e3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.e(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel12.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel13 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.evaluateJavascript", a());
                if (webViewHostApi != null) {
                    basicMessageChannel13.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.f3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.f(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel13.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel14 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getTitle", a());
                if (webViewHostApi != null) {
                    basicMessageChannel14.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.g3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.g(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel14.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel15 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo", a());
                if (webViewHostApi != null) {
                    basicMessageChannel15.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.h3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.h(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel15.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel16 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy", a());
                if (webViewHostApi != null) {
                    basicMessageChannel16.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.i3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.i(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel16.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel17 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollX", a());
                if (webViewHostApi != null) {
                    basicMessageChannel17.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.j3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.j(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel17.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel18 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollY", a());
                if (webViewHostApi != null) {
                    basicMessageChannel18.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.k3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.k(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel18.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel19 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollPosition", a());
                if (webViewHostApi != null) {
                    basicMessageChannel19.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.l3
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.l(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel19.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel20 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebContentsDebuggingEnabled", a());
                if (webViewHostApi != null) {
                    basicMessageChannel20.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.n2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.m(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel20.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel21 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebViewClient", a());
                if (webViewHostApi != null) {
                    basicMessageChannel21.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.p2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.o(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel21.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel22 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.addJavaScriptChannel", a());
                if (webViewHostApi != null) {
                    basicMessageChannel22.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.q2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.p(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel22.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel23 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.removeJavaScriptChannel", a());
                if (webViewHostApi != null) {
                    basicMessageChannel23.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.r2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.q(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel23.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel24 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setDownloadListener", a());
                if (webViewHostApi != null) {
                    basicMessageChannel24.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.s2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.r(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel24.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel25 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebChromeClient", a());
                if (webViewHostApi != null) {
                    basicMessageChannel25.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.t2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.s(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel25.setMessageHandler(null);
                }
                BasicMessageChannel basicMessageChannel26 = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setBackgroundColor", a());
                if (webViewHostApi != null) {
                    basicMessageChannel26.setMessageHandler(new BasicMessageChannel.MessageHandler() { // from class: io.flutter.plugins.webviewflutter.u2
                        @Override // io.flutter.plugin.common.BasicMessageChannel.MessageHandler
                        public final void onMessage(Object obj, BasicMessageChannel.Reply reply) {
                            GeneratedAndroidWebView.WebViewHostApi.CC.t(GeneratedAndroidWebView.WebViewHostApi.this, obj, reply);
                        }
                    });
                } else {
                    basicMessageChannel26.setMessageHandler(null);
                }
            }

            public static MessageCodec a() {
                return WebViewHostApiCodec.INSTANCE;
            }

            public static /* synthetic */ void b(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.create(valueOf);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void c(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                String str = (String) arrayList2.get(1);
                String str2 = (String) arrayList2.get(2);
                String str3 = (String) arrayList2.get(3);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.loadData(valueOf, str, str2, str3);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void d(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.reload(valueOf);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void e(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Boolean bool = (Boolean) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.clearCache(valueOf, bool);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void f(WebViewHostApi webViewHostApi, Object obj, final BasicMessageChannel.Reply reply) {
                final ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                webViewHostApi.evaluateJavascript(number == null ? null : Long.valueOf(number.longValue()), (String) arrayList2.get(1), new Result<String>() { // from class: io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.WebViewHostApi.1
                    @Override // io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.Result
                    public void error(Throwable th) {
                        reply.reply(GeneratedAndroidWebView.wrapError(th));
                    }

                    @Override // io.flutter.plugins.webviewflutter.GeneratedAndroidWebView.Result
                    public void success(String str) {
                        arrayList.add(0, str);
                        reply.reply(arrayList);
                    }
                });
            }

            public static /* synthetic */ void g(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.getTitle(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void h(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                Number number3 = (Number) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.scrollTo(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()), number3 == null ? null : Long.valueOf(number3.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void i(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                Number number3 = (Number) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.scrollBy(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()), number3 == null ? null : Long.valueOf(number3.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void j(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.getScrollX(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void k(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.getScrollY(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void l(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.getScrollPosition(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void m(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                ArrayList<Object> arrayList = new ArrayList<>();
                try {
                    webViewHostApi.setWebContentsDebuggingEnabled((Boolean) ((ArrayList) obj).get(0));
                    arrayList.add(0, null);
                } catch (Throwable th) {
                    arrayList = GeneratedAndroidWebView.wrapError(th);
                }
                reply.reply(arrayList);
            }

            public static /* synthetic */ void n(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                String str = (String) arrayList2.get(1);
                String str2 = (String) arrayList2.get(2);
                String str3 = (String) arrayList2.get(3);
                String str4 = (String) arrayList2.get(4);
                String str5 = (String) arrayList2.get(5);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.loadDataWithBaseUrl(valueOf, str, str2, str3, str4, str5);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void o(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.setWebViewClient(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void p(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.addJavaScriptChannel(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void q(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.removeJavaScriptChannel(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void r(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.setDownloadListener(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void s(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.setWebChromeClient(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void t(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                Number number2 = (Number) arrayList2.get(1);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.setBackgroundColor(valueOf, number2 == null ? null : Long.valueOf(number2.longValue()));
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void u(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                String str = (String) arrayList2.get(1);
                Map<String, String> map = (Map) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.loadUrl(valueOf, str, map);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void v(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                ArrayList arrayList2 = (ArrayList) obj;
                Number number = (Number) arrayList2.get(0);
                String str = (String) arrayList2.get(1);
                byte[] bArr = (byte[]) arrayList2.get(2);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.postUrl(valueOf, str, bArr);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }

            public static /* synthetic */ void w(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.getUrl(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void x(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.canGoBack(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void y(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                arrayList.add(0, webViewHostApi.canGoForward(valueOf));
                reply.reply(arrayList);
            }

            public static /* synthetic */ void z(WebViewHostApi webViewHostApi, Object obj, BasicMessageChannel.Reply reply) {
                Long valueOf;
                ArrayList<Object> arrayList = new ArrayList<>();
                Number number = (Number) ((ArrayList) obj).get(0);
                if (number == null) {
                    valueOf = null;
                } else {
                    try {
                        valueOf = Long.valueOf(number.longValue());
                    } catch (Throwable th) {
                        arrayList = GeneratedAndroidWebView.wrapError(th);
                    }
                }
                webViewHostApi.goBack(valueOf);
                arrayList.add(0, null);
                reply.reply(arrayList);
            }
        }

        void addJavaScriptChannel(Long l10, Long l11);

        Boolean canGoBack(Long l10);

        Boolean canGoForward(Long l10);

        void clearCache(Long l10, Boolean bool);

        void create(Long l10);

        void evaluateJavascript(Long l10, String str, Result<String> result);

        WebViewPoint getScrollPosition(Long l10);

        Long getScrollX(Long l10);

        Long getScrollY(Long l10);

        String getTitle(Long l10);

        String getUrl(Long l10);

        void goBack(Long l10);

        void goForward(Long l10);

        void loadData(Long l10, String str, String str2, String str3);

        void loadDataWithBaseUrl(Long l10, String str, String str2, String str3, String str4, String str5);

        void loadUrl(Long l10, String str, Map<String, String> map);

        void postUrl(Long l10, String str, byte[] bArr);

        void reload(Long l10);

        void removeJavaScriptChannel(Long l10, Long l11);

        void scrollBy(Long l10, Long l11, Long l12);

        void scrollTo(Long l10, Long l11, Long l12);

        void setBackgroundColor(Long l10, Long l11);

        void setDownloadListener(Long l10, Long l11);

        void setWebChromeClient(Long l10, Long l11);

        void setWebContentsDebuggingEnabled(Boolean bool);

        void setWebViewClient(Long l10, Long l11);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class WebViewHostApiCodec extends StandardMessageCodec {
        public static final WebViewHostApiCodec INSTANCE = new WebViewHostApiCodec();

        private WebViewHostApiCodec() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public Object readValueOfType(byte b10, ByteBuffer byteBuffer) {
            return b10 != Byte.MIN_VALUE ? super.readValueOfType(b10, byteBuffer) : WebViewPoint.fromList((ArrayList) readValue(byteBuffer));
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // io.flutter.plugin.common.StandardMessageCodec
        public void writeValue(ByteArrayOutputStream byteArrayOutputStream, Object obj) {
            if (!(obj instanceof WebViewPoint)) {
                super.writeValue(byteArrayOutputStream, obj);
                return;
            }
            byteArrayOutputStream.write(128);
            writeValue(byteArrayOutputStream, ((WebViewPoint) obj).toList());
        }
    }

    /* loaded from: classes.dex */
    public static final class WebViewPoint {

        /* renamed from: x  reason: collision with root package name */
        private Long f8770x;

        /* renamed from: y  reason: collision with root package name */
        private Long f8771y;

        /* loaded from: classes.dex */
        public static final class Builder {

            /* renamed from: x  reason: collision with root package name */
            private Long f8772x;

            /* renamed from: y  reason: collision with root package name */
            private Long f8773y;

            public WebViewPoint build() {
                WebViewPoint webViewPoint = new WebViewPoint();
                webViewPoint.setX(this.f8772x);
                webViewPoint.setY(this.f8773y);
                return webViewPoint;
            }

            public Builder setX(Long l10) {
                this.f8772x = l10;
                return this;
            }

            public Builder setY(Long l10) {
                this.f8773y = l10;
                return this;
            }
        }

        WebViewPoint() {
        }

        static WebViewPoint fromList(ArrayList<Object> arrayList) {
            Long valueOf;
            WebViewPoint webViewPoint = new WebViewPoint();
            Object obj = arrayList.get(0);
            Long l10 = null;
            if (obj == null) {
                valueOf = null;
            } else {
                valueOf = Long.valueOf(obj instanceof Integer ? ((Integer) obj).intValue() : ((Long) obj).longValue());
            }
            webViewPoint.setX(valueOf);
            Object obj2 = arrayList.get(1);
            if (obj2 != null) {
                l10 = Long.valueOf(obj2 instanceof Integer ? ((Integer) obj2).intValue() : ((Long) obj2).longValue());
            }
            webViewPoint.setY(l10);
            return webViewPoint;
        }

        public Long getX() {
            return this.f8770x;
        }

        public Long getY() {
            return this.f8771y;
        }

        public void setX(Long l10) {
            if (l10 == null) {
                throw new IllegalStateException("Nonnull field \"x\" is null.");
            }
            this.f8770x = l10;
        }

        public void setY(Long l10) {
            if (l10 == null) {
                throw new IllegalStateException("Nonnull field \"y\" is null.");
            }
            this.f8771y = l10;
        }

        ArrayList<Object> toList() {
            ArrayList<Object> arrayList = new ArrayList<>(2);
            arrayList.add(this.f8770x);
            arrayList.add(this.f8771y);
            return arrayList;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public static ArrayList<Object> wrapError(Throwable th) {
        Object obj;
        ArrayList<Object> arrayList = new ArrayList<>(3);
        if (th instanceof FlutterError) {
            FlutterError flutterError = (FlutterError) th;
            arrayList.add(flutterError.code);
            arrayList.add(flutterError.getMessage());
            obj = flutterError.details;
        } else {
            arrayList.add(th.toString());
            arrayList.add(th.getClass().getSimpleName());
            obj = "Cause: " + th.getCause() + ", Stacktrace: " + Log.getStackTraceString(th);
        }
        arrayList.add(obj);
        return arrayList;
    }
}
