package io.flutter.plugins.webviewflutter;

import android.content.Context;
import android.view.View;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
/* loaded from: classes.dex */
class FlutterViewFactory extends PlatformViewFactory {
    private final InstanceManager instanceManager;

    /* JADX INFO: Access modifiers changed from: package-private */
    public FlutterViewFactory(InstanceManager instanceManager) {
        super(StandardMessageCodec.INSTANCE);
        this.instanceManager = instanceManager;
    }

    @Override // io.flutter.plugin.platform.PlatformViewFactory
    public PlatformView create(Context context, int i10, Object obj) {
        Integer num = (Integer) obj;
        if (num != null) {
            final Object instanceManager = this.instanceManager.getInstance(num.intValue());
            if (instanceManager instanceof PlatformView) {
                return (PlatformView) instanceManager;
            }
            if (instanceManager instanceof View) {
                return new PlatformView() { // from class: io.flutter.plugins.webviewflutter.FlutterViewFactory.1
                    @Override // io.flutter.plugin.platform.PlatformView
                    public void dispose() {
                    }

                    @Override // io.flutter.plugin.platform.PlatformView
                    public View getView() {
                        return (View) instanceManager;
                    }

                    @Override // io.flutter.plugin.platform.PlatformView
                    public /* synthetic */ void onFlutterViewAttached(View view) {
                        io.flutter.plugin.platform.f.a(this, view);
                    }

                    @Override // io.flutter.plugin.platform.PlatformView
                    public /* synthetic */ void onFlutterViewDetached() {
                        io.flutter.plugin.platform.f.b(this);
                    }

                    @Override // io.flutter.plugin.platform.PlatformView
                    public /* synthetic */ void onInputConnectionLocked() {
                        io.flutter.plugin.platform.f.c(this);
                    }

                    @Override // io.flutter.plugin.platform.PlatformView
                    public /* synthetic */ void onInputConnectionUnlocked() {
                        io.flutter.plugin.platform.f.d(this);
                    }
                };
            }
            throw new IllegalStateException("Unable to find a PlatformView or View instance: " + obj + ", " + instanceManager);
        }
        throw new IllegalStateException("An identifier is required to retrieve a View instance.");
    }
}
