package io.flutter.plugins.videoplayer;

import io.flutter.plugin.common.EventChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
/* loaded from: classes.dex */
final class VideoPlayerEventCallbacks implements VideoPlayerCallbacks {
    private final EventChannel.EventSink eventSink;

    private VideoPlayerEventCallbacks(EventChannel.EventSink eventSink) {
        this.eventSink = eventSink;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static VideoPlayerEventCallbacks bindTo(EventChannel eventChannel) {
        final QueuingEventSink queuingEventSink = new QueuingEventSink();
        eventChannel.setStreamHandler(new EventChannel.StreamHandler() { // from class: io.flutter.plugins.videoplayer.VideoPlayerEventCallbacks.1
            @Override // io.flutter.plugin.common.EventChannel.StreamHandler
            public void onCancel(Object obj) {
                QueuingEventSink.this.setDelegate(null);
            }

            @Override // io.flutter.plugin.common.EventChannel.StreamHandler
            public void onListen(Object obj, EventChannel.EventSink eventSink) {
                QueuingEventSink.this.setDelegate(eventSink);
            }
        });
        return withSink(queuingEventSink);
    }

    static VideoPlayerEventCallbacks withSink(EventChannel.EventSink eventSink) {
        return new VideoPlayerEventCallbacks(eventSink);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onBufferingEnd() {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "bufferingEnd");
        this.eventSink.success(hashMap);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onBufferingStart() {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "bufferingStart");
        this.eventSink.success(hashMap);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onBufferingUpdate(long j10) {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "bufferingUpdate");
        hashMap.put("values", Collections.singletonList(Arrays.asList(0, Long.valueOf(j10))));
        this.eventSink.success(hashMap);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onCompleted() {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "completed");
        this.eventSink.success(hashMap);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onError(String str, String str2, Object obj) {
        this.eventSink.error(str, str2, obj);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onInitialized(int i10, int i11, long j10, int i12) {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "initialized");
        hashMap.put("width", Integer.valueOf(i10));
        hashMap.put("height", Integer.valueOf(i11));
        hashMap.put("duration", Long.valueOf(j10));
        if (i12 != 0) {
            hashMap.put("rotationCorrection", Integer.valueOf(i12));
        }
        this.eventSink.success(hashMap);
    }

    @Override // io.flutter.plugins.videoplayer.VideoPlayerCallbacks
    public void onIsPlayingStateUpdate(boolean z9) {
        HashMap hashMap = new HashMap();
        hashMap.put("event", "isPlayingStateUpdate");
        hashMap.put("isPlaying", Boolean.valueOf(z9));
        this.eventSink.success(hashMap);
    }
}
