package io.flutter.plugins.videoplayer;

import android.content.Context;
import android.view.Surface;
import io.flutter.view.TextureRegistry;
import p0.b;
import p0.b0;
import p0.t;
import w0.p;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class VideoPlayer {
    private p exoPlayer;
    private final VideoPlayerOptions options;
    private Surface surface;
    private final TextureRegistry.SurfaceTextureEntry textureEntry;
    private final VideoPlayerCallbacks videoPlayerEvents;

    VideoPlayer(p.b bVar, VideoPlayerCallbacks videoPlayerCallbacks, TextureRegistry.SurfaceTextureEntry surfaceTextureEntry, t tVar, VideoPlayerOptions videoPlayerOptions) {
        this.videoPlayerEvents = videoPlayerCallbacks;
        this.textureEntry = surfaceTextureEntry;
        this.options = videoPlayerOptions;
        p f10 = bVar.f();
        f10.H(tVar);
        f10.a();
        setUpVideoPlayer(f10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static VideoPlayer create(Context context, VideoPlayerCallbacks videoPlayerCallbacks, TextureRegistry.SurfaceTextureEntry surfaceTextureEntry, VideoAsset videoAsset, VideoPlayerOptions videoPlayerOptions) {
        return new VideoPlayer(new p.b(context).l(videoAsset.getMediaSourceFactory(context)), videoPlayerCallbacks, surfaceTextureEntry, videoAsset.getMediaItem(), videoPlayerOptions);
    }

    private static void setAudioAttributes(p pVar, boolean z9) {
        pVar.B(new b.e().b(3).a(), !z9);
    }

    private void setUpVideoPlayer(p pVar) {
        this.exoPlayer = pVar;
        Surface surface = new Surface(this.textureEntry.surfaceTexture());
        this.surface = surface;
        pVar.e(surface);
        setAudioAttributes(pVar, this.options.mixWithOthers);
        pVar.h(new ExoPlayerEventListener(pVar, this.videoPlayerEvents));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void dispose() {
        this.textureEntry.release();
        Surface surface = this.surface;
        if (surface != null) {
            surface.release();
        }
        p pVar = this.exoPlayer;
        if (pVar != null) {
            pVar.release();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public long getPosition() {
        return this.exoPlayer.I();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void pause() {
        this.exoPlayer.r(false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void play() {
        this.exoPlayer.r(true);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void seekTo(int i10) {
        this.exoPlayer.p(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void sendBufferingUpdate() {
        this.videoPlayerEvents.onBufferingUpdate(this.exoPlayer.t());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setLooping(boolean z9) {
        this.exoPlayer.A(z9 ? 2 : 0);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setPlaybackSpeed(double d10) {
        this.exoPlayer.c(new b0((float) d10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setVolume(double d10) {
        this.exoPlayer.d((float) Math.max(0.0d, Math.min(1.0d, d10)));
    }
}
