package io.flutter.plugins.videoplayer;

import android.content.Context;
import java.util.HashMap;
import java.util.Map;
import m1.f0;
import p0.t;
/* loaded from: classes.dex */
abstract class VideoAsset {
    protected final String assetUrl;

    /* loaded from: classes.dex */
    enum StreamingFormat {
        UNKNOWN,
        SMOOTH,
        DYNAMIC_ADAPTIVE,
        HTTP_LIVE
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public VideoAsset(String str) {
        this.assetUrl = str;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static VideoAsset fromAssetUrl(String str) {
        if (str.startsWith("asset:///")) {
            return new LocalVideoAsset(str);
        }
        throw new IllegalArgumentException("assetUrl must start with 'asset:///'");
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static VideoAsset fromRemoteUrl(String str, StreamingFormat streamingFormat, Map<String, String> map) {
        return new HttpVideoAsset(str, streamingFormat, new HashMap(map));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static VideoAsset fromRtspUrl(String str) {
        if (str.startsWith("rtsp://")) {
            return new RtspVideoAsset(str);
        }
        throw new IllegalArgumentException("rtspUrl must start with 'rtsp://'");
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public abstract t getMediaItem();

    /* JADX INFO: Access modifiers changed from: package-private */
    public abstract f0.a getMediaSourceFactory(Context context);
}
