package io.flutter.plugins.videoplayer;

import java.util.List;
import p0.a0;
import p0.b0;
import p0.c0;
import p0.d0;
import p0.i0;
import p0.k0;
import p0.l0;
import p0.p0;
import p0.t;
import p0.v;
import p0.w;
import w0.p;
/* loaded from: classes.dex */
final class ExoPlayerEventListener implements c0.d {
    private final VideoPlayerCallbacks events;
    private final p exoPlayer;
    private boolean isBuffering = false;
    private boolean isInitialized = false;

    /* JADX INFO: Access modifiers changed from: package-private */
    public ExoPlayerEventListener(p pVar, VideoPlayerCallbacks videoPlayerCallbacks) {
        this.exoPlayer = pVar;
        this.events = videoPlayerCallbacks;
    }

    private void sendInitialized() {
        int i10;
        int i11;
        int i12;
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        p0 k10 = this.exoPlayer.k();
        int i13 = k10.f11252a;
        int i14 = k10.f11253b;
        if (i13 != 0 && i14 != 0) {
            int i15 = k10.f11254c;
            if (i15 == 90 || i15 == 270) {
                i14 = i13;
                i13 = i14;
            }
            if (i15 == 180) {
                i12 = i15;
                i10 = i13;
                i11 = i14;
                this.events.onInitialized(i10, i11, this.exoPlayer.getDuration(), i12);
            }
        }
        i10 = i13;
        i11 = i14;
        i12 = 0;
        this.events.onInitialized(i10, i11, this.exoPlayer.getDuration(), i12);
    }

    private void setBuffering(boolean z9) {
        if (this.isBuffering == z9) {
            return;
        }
        this.isBuffering = z9;
        if (z9) {
            this.events.onBufferingStart();
        } else {
            this.events.onBufferingEnd();
        }
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onAudioAttributesChanged(p0.b bVar) {
        d0.a(this, bVar);
    }

    public /* bridge */ /* synthetic */ void onAudioSessionIdChanged(int i10) {
        d0.b(this, i10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onAvailableCommandsChanged(c0.b bVar) {
        d0.c(this, bVar);
    }

    @Override // p0.c0.d
    @Deprecated
    public /* bridge */ /* synthetic */ void onCues(List list) {
        d0.d(this, list);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onCues(r0.b bVar) {
        d0.e(this, bVar);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onDeviceInfoChanged(p0.k kVar) {
        d0.f(this, kVar);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onDeviceVolumeChanged(int i10, boolean z9) {
        d0.g(this, i10, z9);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onEvents(c0 c0Var, c0.c cVar) {
        d0.h(this, c0Var, cVar);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onIsLoadingChanged(boolean z9) {
        d0.i(this, z9);
    }

    @Override // p0.c0.d
    public void onIsPlayingChanged(boolean z9) {
        this.events.onIsPlayingStateUpdate(z9);
    }

    @Override // p0.c0.d
    @Deprecated
    public /* bridge */ /* synthetic */ void onLoadingChanged(boolean z9) {
        d0.j(this, z9);
    }

    public /* bridge */ /* synthetic */ void onMaxSeekToPreviousPositionChanged(long j10) {
        d0.k(this, j10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onMediaItemTransition(t tVar, int i10) {
        d0.l(this, tVar, i10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onMediaMetadataChanged(v vVar) {
        d0.m(this, vVar);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onMetadata(w wVar) {
        d0.n(this, wVar);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onPlayWhenReadyChanged(boolean z9, int i10) {
        d0.o(this, z9, i10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onPlaybackParametersChanged(b0 b0Var) {
        d0.p(this, b0Var);
    }

    @Override // p0.c0.d
    public void onPlaybackStateChanged(int i10) {
        if (i10 == 2) {
            setBuffering(true);
            this.events.onBufferingUpdate(this.exoPlayer.t());
        } else if (i10 == 3) {
            sendInitialized();
        } else if (i10 == 4) {
            this.events.onCompleted();
        }
        if (i10 != 2) {
            setBuffering(false);
        }
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onPlaybackSuppressionReasonChanged(int i10) {
        d0.q(this, i10);
    }

    @Override // p0.c0.d
    public void onPlayerError(a0 a0Var) {
        setBuffering(false);
        if (a0Var.f10927g == 1002) {
            this.exoPlayer.l();
            this.exoPlayer.a();
            return;
        }
        VideoPlayerCallbacks videoPlayerCallbacks = this.events;
        videoPlayerCallbacks.onError("VideoError", "Video player had error " + a0Var, null);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onPlayerErrorChanged(a0 a0Var) {
        d0.r(this, a0Var);
    }

    @Override // p0.c0.d
    @Deprecated
    public /* bridge */ /* synthetic */ void onPlayerStateChanged(boolean z9, int i10) {
        d0.s(this, z9, i10);
    }

    public /* bridge */ /* synthetic */ void onPlaylistMetadataChanged(v vVar) {
        d0.t(this, vVar);
    }

    @Override // p0.c0.d
    @Deprecated
    public /* bridge */ /* synthetic */ void onPositionDiscontinuity(int i10) {
        d0.u(this, i10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onPositionDiscontinuity(c0.e eVar, c0.e eVar2, int i10) {
        d0.v(this, eVar, eVar2, i10);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onRenderedFirstFrame() {
        d0.w(this);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onRepeatModeChanged(int i10) {
        d0.x(this, i10);
    }

    public /* bridge */ /* synthetic */ void onSeekBackIncrementChanged(long j10) {
        d0.y(this, j10);
    }

    public /* bridge */ /* synthetic */ void onSeekForwardIncrementChanged(long j10) {
        d0.z(this, j10);
    }

    public /* bridge */ /* synthetic */ void onShuffleModeEnabledChanged(boolean z9) {
        d0.A(this, z9);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onSkipSilenceEnabledChanged(boolean z9) {
        d0.B(this, z9);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onSurfaceSizeChanged(int i10, int i11) {
        d0.C(this, i10, i11);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onTimelineChanged(i0 i0Var, int i10) {
        d0.D(this, i0Var, i10);
    }

    public /* bridge */ /* synthetic */ void onTrackSelectionParametersChanged(k0 k0Var) {
        d0.E(this, k0Var);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onTracksChanged(l0 l0Var) {
        d0.F(this, l0Var);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onVideoSizeChanged(p0 p0Var) {
        d0.G(this, p0Var);
    }

    @Override // p0.c0.d
    public /* bridge */ /* synthetic */ void onVolumeChanged(float f10) {
        d0.H(this, f10);
    }
}
