package io.flutter.plugins.sharedpreferences;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import androidx.recyclerview.widget.RecyclerView;
import h0.d;
import h8.x;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
/* loaded from: classes.dex */
public final class SharedPreferencesPlugin implements FlutterPlugin, SharedPreferencesAsyncApi {
    private Context context;
    private SharedPreferencesListEncoder listEncoder;

    /* loaded from: classes.dex */
    public static final class ListEncoder implements SharedPreferencesListEncoder {
        @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesListEncoder
        public List<String> decode(String listString) {
            kotlin.jvm.internal.k.e(listString, "listString");
            try {
                Object readObject = new ObjectInputStream(new ByteArrayInputStream(Base64.decode(listString, 0))).readObject();
                kotlin.jvm.internal.k.c(readObject, "null cannot be cast to non-null type kotlin.collections.List<*>");
                ArrayList arrayList = new ArrayList();
                for (Object obj : (List) readObject) {
                    if (obj instanceof String) {
                        arrayList.add(obj);
                    }
                }
                return arrayList;
            } catch (RuntimeException e10) {
                throw new RuntimeException(e10);
            }
        }

        @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesListEncoder
        public String encode(List<String> list) {
            kotlin.jvm.internal.k.e(list, "list");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(list);
                objectOutputStream.flush();
                String encodeToString = Base64.encodeToString(byteArrayOutputStream.toByteArray(), 0);
                kotlin.jvm.internal.k.d(encodeToString, "encodeToString(byteStream.toByteArray(), 0)");
                return encodeToString;
            } catch (RuntimeException e10) {
                throw new RuntimeException(e10);
            }
        }
    }

    public SharedPreferencesPlugin() {
        this.listEncoder = new ListEncoder();
    }

    /* JADX WARN: 'this' call moved to the top of the method (can break code semantics) */
    public SharedPreferencesPlugin(SharedPreferencesListEncoder listEncoder) {
        this();
        kotlin.jvm.internal.k.e(listEncoder, "listEncoder");
        this.listEncoder = listEncoder;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final Object dataStoreSetString(String str, String str2, j8.d dVar) {
        e0.f sharedPreferencesDataStore;
        Object c10;
        d.a f10 = h0.f.f(str);
        Context context = this.context;
        if (context == null) {
            kotlin.jvm.internal.k.o("context");
            context = null;
        }
        sharedPreferencesDataStore = SharedPreferencesPluginKt.getSharedPreferencesDataStore(context);
        Object a10 = h0.g.a(sharedPreferencesDataStore, new SharedPreferencesPlugin$dataStoreSetString$2(f10, str2, null), dVar);
        c10 = k8.d.c();
        return a10 == c10 ? a10 : g8.q.f8031a;
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* JADX WARN: Removed duplicated region for block: B:10:0x0024  */
    /* JADX WARN: Removed duplicated region for block: B:16:0x0058  */
    /* JADX WARN: Removed duplicated region for block: B:26:0x007d  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x008b  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x00bc  */
    /* JADX WARN: Removed duplicated region for block: B:39:? A[RETURN, SYNTHETIC] */
    /* JADX WARN: Unsupported multi-entry loop pattern (BACK_EDGE: B:30:0x00a1 -> B:32:0x00a4). Please submit an issue!!! */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final Object getPrefs(List<String> list, j8.d dVar) {
        SharedPreferencesPlugin$getPrefs$1 sharedPreferencesPlugin$getPrefs$1;
        Object c10;
        int i10;
        Set<String> N;
        Map linkedHashMap;
        SharedPreferencesPlugin sharedPreferencesPlugin;
        Set set;
        Set<String> set2;
        SharedPreferencesPlugin sharedPreferencesPlugin2;
        Map map;
        Iterator it;
        Object transformPref;
        if (dVar instanceof SharedPreferencesPlugin$getPrefs$1) {
            sharedPreferencesPlugin$getPrefs$1 = (SharedPreferencesPlugin$getPrefs$1) dVar;
            int i11 = sharedPreferencesPlugin$getPrefs$1.label;
            if ((i11 & RecyclerView.UNDEFINED_DURATION) != 0) {
                sharedPreferencesPlugin$getPrefs$1.label = i11 - RecyclerView.UNDEFINED_DURATION;
                Object obj = sharedPreferencesPlugin$getPrefs$1.result;
                c10 = k8.d.c();
                i10 = sharedPreferencesPlugin$getPrefs$1.label;
                if (i10 != 0) {
                    g8.l.b(obj);
                    N = list != null ? x.N(list) : null;
                    linkedHashMap = new LinkedHashMap();
                    sharedPreferencesPlugin$getPrefs$1.L$0 = this;
                    sharedPreferencesPlugin$getPrefs$1.L$1 = N;
                    sharedPreferencesPlugin$getPrefs$1.L$2 = linkedHashMap;
                    sharedPreferencesPlugin$getPrefs$1.label = 1;
                    obj = readAllKeys(sharedPreferencesPlugin$getPrefs$1);
                    if (obj == c10) {
                        return c10;
                    }
                    sharedPreferencesPlugin = this;
                } else if (i10 == 1) {
                    linkedHashMap = (Map) sharedPreferencesPlugin$getPrefs$1.L$2;
                    N = (Set) sharedPreferencesPlugin$getPrefs$1.L$1;
                    sharedPreferencesPlugin = (SharedPreferencesPlugin) sharedPreferencesPlugin$getPrefs$1.L$0;
                    g8.l.b(obj);
                } else if (i10 != 2) {
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                } else {
                    d.a aVar = (d.a) sharedPreferencesPlugin$getPrefs$1.L$4;
                    it = (Iterator) sharedPreferencesPlugin$getPrefs$1.L$3;
                    map = (Map) sharedPreferencesPlugin$getPrefs$1.L$2;
                    set2 = (Set) sharedPreferencesPlugin$getPrefs$1.L$1;
                    sharedPreferencesPlugin2 = (SharedPreferencesPlugin) sharedPreferencesPlugin$getPrefs$1.L$0;
                    g8.l.b(obj);
                    if (sharedPreferencesPlugin2.preferencesFilter(aVar.toString(), obj, set2) && (transformPref = sharedPreferencesPlugin2.transformPref(obj)) != null) {
                        map.put(aVar.toString(), transformPref);
                    }
                    if (it.hasNext()) {
                        aVar = (d.a) it.next();
                        sharedPreferencesPlugin$getPrefs$1.L$0 = sharedPreferencesPlugin2;
                        sharedPreferencesPlugin$getPrefs$1.L$1 = set2;
                        sharedPreferencesPlugin$getPrefs$1.L$2 = map;
                        sharedPreferencesPlugin$getPrefs$1.L$3 = it;
                        sharedPreferencesPlugin$getPrefs$1.L$4 = aVar;
                        sharedPreferencesPlugin$getPrefs$1.label = 2;
                        obj = sharedPreferencesPlugin2.getValueByKey(aVar, sharedPreferencesPlugin$getPrefs$1);
                        if (obj == c10) {
                            return c10;
                        }
                        if (sharedPreferencesPlugin2.preferencesFilter(aVar.toString(), obj, set2)) {
                            map.put(aVar.toString(), transformPref);
                        }
                        if (it.hasNext()) {
                            return map;
                        }
                    }
                }
                set = (Set) obj;
                if (set != null) {
                    return linkedHashMap;
                }
                set2 = N;
                sharedPreferencesPlugin2 = sharedPreferencesPlugin;
                map = linkedHashMap;
                it = set.iterator();
                if (it.hasNext()) {
                }
            }
        }
        sharedPreferencesPlugin$getPrefs$1 = new SharedPreferencesPlugin$getPrefs$1(this, dVar);
        Object obj2 = sharedPreferencesPlugin$getPrefs$1.result;
        c10 = k8.d.c();
        i10 = sharedPreferencesPlugin$getPrefs$1.label;
        if (i10 != 0) {
        }
        set = (Set) obj2;
        if (set != null) {
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final Object getValueByKey(final d.a aVar, j8.d dVar) {
        e0.f sharedPreferencesDataStore;
        Context context = this.context;
        if (context == null) {
            kotlin.jvm.internal.k.o("context");
            context = null;
        }
        sharedPreferencesDataStore = SharedPreferencesPluginKt.getSharedPreferencesDataStore(context);
        final c9.e data = sharedPreferencesDataStore.getData();
        return c9.g.g(new c9.e() { // from class: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$getValueByKey$$inlined$map$1

            /* renamed from: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$getValueByKey$$inlined$map$1$2  reason: invalid class name */
            /* loaded from: classes.dex */
            public static final class AnonymousClass2 implements c9.f {
                final /* synthetic */ d.a $key$inlined;
                final /* synthetic */ c9.f $this_unsafeFlow$inlined;

                @kotlin.coroutines.jvm.internal.f(c = "io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$getValueByKey$$inlined$map$1$2", f = "SharedPreferencesPlugin.kt", l = {136}, m = "emit")
                /* renamed from: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$getValueByKey$$inlined$map$1$2$1  reason: invalid class name */
                /* loaded from: classes.dex */
                public static final class AnonymousClass1 extends kotlin.coroutines.jvm.internal.d {
                    Object L$0;
                    int label;
                    /* synthetic */ Object result;

                    public AnonymousClass1(j8.d dVar) {
                        super(dVar);
                    }

                    @Override // kotlin.coroutines.jvm.internal.a
                    public final Object invokeSuspend(Object obj) {
                        this.result = obj;
                        this.label |= RecyclerView.UNDEFINED_DURATION;
                        return AnonymousClass2.this.emit(null, this);
                    }
                }

                public AnonymousClass2(c9.f fVar, d.a aVar) {
                    this.$this_unsafeFlow$inlined = fVar;
                    this.$key$inlined = aVar;
                }

                /* JADX WARN: Removed duplicated region for block: B:10:0x0023  */
                /* JADX WARN: Removed duplicated region for block: B:14:0x0031  */
                @Override // c9.f
                /*
                    Code decompiled incorrectly, please refer to instructions dump.
                */
                public Object emit(Object obj, j8.d dVar) {
                    AnonymousClass1 anonymousClass1;
                    Object c10;
                    int i10;
                    if (dVar instanceof AnonymousClass1) {
                        anonymousClass1 = (AnonymousClass1) dVar;
                        int i11 = anonymousClass1.label;
                        if ((i11 & RecyclerView.UNDEFINED_DURATION) != 0) {
                            anonymousClass1.label = i11 - RecyclerView.UNDEFINED_DURATION;
                            Object obj2 = anonymousClass1.result;
                            c10 = k8.d.c();
                            i10 = anonymousClass1.label;
                            if (i10 != 0) {
                                g8.l.b(obj2);
                                c9.f fVar = this.$this_unsafeFlow$inlined;
                                Object b10 = ((h0.d) obj).b(this.$key$inlined);
                                anonymousClass1.label = 1;
                                if (fVar.emit(b10, anonymousClass1) == c10) {
                                    return c10;
                                }
                            } else if (i10 != 1) {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            } else {
                                g8.l.b(obj2);
                            }
                            return g8.q.f8031a;
                        }
                    }
                    anonymousClass1 = new AnonymousClass1(dVar);
                    Object obj22 = anonymousClass1.result;
                    c10 = k8.d.c();
                    i10 = anonymousClass1.label;
                    if (i10 != 0) {
                    }
                    return g8.q.f8031a;
                }
            }

            @Override // c9.e
            public Object collect(c9.f fVar, j8.d dVar2) {
                Object c10;
                Object collect = c9.e.this.collect(new AnonymousClass2(fVar, aVar), dVar2);
                c10 = k8.d.c();
                return collect == c10 ? collect : g8.q.f8031a;
            }
        }, dVar);
    }

    private final boolean preferencesFilter(String str, Object obj, Set<String> set) {
        return set == null ? (obj instanceof Boolean) || (obj instanceof Long) || (obj instanceof String) || (obj instanceof Double) : set.contains(str);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final Object readAllKeys(j8.d dVar) {
        e0.f sharedPreferencesDataStore;
        Context context = this.context;
        if (context == null) {
            kotlin.jvm.internal.k.o("context");
            context = null;
        }
        sharedPreferencesDataStore = SharedPreferencesPluginKt.getSharedPreferencesDataStore(context);
        final c9.e data = sharedPreferencesDataStore.getData();
        return c9.g.g(new c9.e() { // from class: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$readAllKeys$$inlined$map$1

            /* renamed from: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$readAllKeys$$inlined$map$1$2  reason: invalid class name */
            /* loaded from: classes.dex */
            public static final class AnonymousClass2 implements c9.f {
                final /* synthetic */ c9.f $this_unsafeFlow$inlined;

                @kotlin.coroutines.jvm.internal.f(c = "io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$readAllKeys$$inlined$map$1$2", f = "SharedPreferencesPlugin.kt", l = {136}, m = "emit")
                /* renamed from: io.flutter.plugins.sharedpreferences.SharedPreferencesPlugin$readAllKeys$$inlined$map$1$2$1  reason: invalid class name */
                /* loaded from: classes.dex */
                public static final class AnonymousClass1 extends kotlin.coroutines.jvm.internal.d {
                    Object L$0;
                    int label;
                    /* synthetic */ Object result;

                    public AnonymousClass1(j8.d dVar) {
                        super(dVar);
                    }

                    @Override // kotlin.coroutines.jvm.internal.a
                    public final Object invokeSuspend(Object obj) {
                        this.result = obj;
                        this.label |= RecyclerView.UNDEFINED_DURATION;
                        return AnonymousClass2.this.emit(null, this);
                    }
                }

                public AnonymousClass2(c9.f fVar) {
                    this.$this_unsafeFlow$inlined = fVar;
                }

                /* JADX WARN: Removed duplicated region for block: B:10:0x0023  */
                /* JADX WARN: Removed duplicated region for block: B:14:0x0031  */
                @Override // c9.f
                /*
                    Code decompiled incorrectly, please refer to instructions dump.
                */
                public Object emit(Object obj, j8.d dVar) {
                    AnonymousClass1 anonymousClass1;
                    Object c10;
                    int i10;
                    if (dVar instanceof AnonymousClass1) {
                        anonymousClass1 = (AnonymousClass1) dVar;
                        int i11 = anonymousClass1.label;
                        if ((i11 & RecyclerView.UNDEFINED_DURATION) != 0) {
                            anonymousClass1.label = i11 - RecyclerView.UNDEFINED_DURATION;
                            Object obj2 = anonymousClass1.result;
                            c10 = k8.d.c();
                            i10 = anonymousClass1.label;
                            if (i10 != 0) {
                                g8.l.b(obj2);
                                c9.f fVar = this.$this_unsafeFlow$inlined;
                                Set keySet = ((h0.d) obj).a().keySet();
                                anonymousClass1.label = 1;
                                if (fVar.emit(keySet, anonymousClass1) == c10) {
                                    return c10;
                                }
                            } else if (i10 != 1) {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            } else {
                                g8.l.b(obj2);
                            }
                            return g8.q.f8031a;
                        }
                    }
                    anonymousClass1 = new AnonymousClass1(dVar);
                    Object obj22 = anonymousClass1.result;
                    c10 = k8.d.c();
                    i10 = anonymousClass1.label;
                    if (i10 != 0) {
                    }
                    return g8.q.f8031a;
                }
            }

            @Override // c9.e
            public Object collect(c9.f fVar, j8.d dVar2) {
                Object c10;
                Object collect = c9.e.this.collect(new AnonymousClass2(fVar), dVar2);
                c10 = k8.d.c();
                return collect == c10 ? collect : g8.q.f8031a;
            }
        }, dVar);
    }

    private final void setUp(BinaryMessenger binaryMessenger, Context context) {
        this.context = context;
        try {
            SharedPreferencesAsyncApi.Companion.setUp(binaryMessenger, this);
        } catch (Exception e10) {
            Log.e(SharedPreferencesPluginKt.TAG, "Received exception while setting up SharedPreferencesPlugin", e10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final Object transformPref(Object obj) {
        boolean r10;
        if (obj instanceof String) {
            String str = (String) obj;
            r10 = y8.m.r(str, SharedPreferencesPluginKt.LIST_PREFIX, false, 2, null);
            if (r10) {
                SharedPreferencesListEncoder sharedPreferencesListEncoder = this.listEncoder;
                String substring = str.substring(40);
                kotlin.jvm.internal.k.d(substring, "this as java.lang.String).substring(startIndex)");
                return sharedPreferencesListEncoder.decode(substring);
            }
            return obj;
        }
        return obj;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void clear(List<String> list, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$clear$1(this, list, null), 1, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public Map<String, Object> getAll(List<String> list, SharedPreferencesPigeonOptions options) {
        Object b10;
        kotlin.jvm.internal.k.e(options, "options");
        b10 = z8.h.b(null, new SharedPreferencesPlugin$getAll$1(this, list, null), 1, null);
        return (Map) b10;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public Boolean getBool(String key, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        kotlin.jvm.internal.x xVar = new kotlin.jvm.internal.x();
        z8.h.b(null, new SharedPreferencesPlugin$getBool$1(key, this, xVar, null), 1, null);
        return (Boolean) xVar.f9339g;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public Double getDouble(String key, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        kotlin.jvm.internal.x xVar = new kotlin.jvm.internal.x();
        z8.h.b(null, new SharedPreferencesPlugin$getDouble$1(key, this, xVar, null), 1, null);
        return (Double) xVar.f9339g;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public Long getInt(String key, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        kotlin.jvm.internal.x xVar = new kotlin.jvm.internal.x();
        z8.h.b(null, new SharedPreferencesPlugin$getInt$1(key, this, xVar, null), 1, null);
        return (Long) xVar.f9339g;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public List<String> getKeys(List<String> list, SharedPreferencesPigeonOptions options) {
        Object b10;
        List<String> J;
        kotlin.jvm.internal.k.e(options, "options");
        b10 = z8.h.b(null, new SharedPreferencesPlugin$getKeys$prefs$1(this, list, null), 1, null);
        J = x.J(((Map) b10).keySet());
        return J;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public String getString(String key, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        kotlin.jvm.internal.x xVar = new kotlin.jvm.internal.x();
        z8.h.b(null, new SharedPreferencesPlugin$getString$1(key, this, xVar, null), 1, null);
        return (String) xVar.f9339g;
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public List<String> getStringList(String key, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        List list = (List) transformPref(getString(key, options));
        if (list != null) {
            ArrayList arrayList = new ArrayList();
            for (Object obj : list) {
                if (obj instanceof String) {
                    arrayList.add(obj);
                }
            }
            return arrayList;
        }
        return null;
    }

    @Override // io.flutter.embedding.engine.plugins.FlutterPlugin
    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        kotlin.jvm.internal.k.e(binding, "binding");
        BinaryMessenger binaryMessenger = binding.getBinaryMessenger();
        kotlin.jvm.internal.k.d(binaryMessenger, "binding.binaryMessenger");
        Context applicationContext = binding.getApplicationContext();
        kotlin.jvm.internal.k.d(applicationContext, "binding.applicationContext");
        setUp(binaryMessenger, applicationContext);
        new LegacySharedPreferencesPlugin().onAttachedToEngine(binding);
    }

    @Override // io.flutter.embedding.engine.plugins.FlutterPlugin
    public void onDetachedFromEngine(FlutterPlugin.FlutterPluginBinding binding) {
        kotlin.jvm.internal.k.e(binding, "binding");
        SharedPreferencesAsyncApi.Companion companion = SharedPreferencesAsyncApi.Companion;
        BinaryMessenger binaryMessenger = binding.getBinaryMessenger();
        kotlin.jvm.internal.k.d(binaryMessenger, "binding.binaryMessenger");
        companion.setUp(binaryMessenger, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void setBool(String key, boolean z9, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$setBool$1(key, this, z9, null), 1, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void setDouble(String key, double d10, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$setDouble$1(key, this, d10, null), 1, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void setInt(String key, long j10, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$setInt$1(key, this, j10, null), 1, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void setString(String key, String value, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(value, "value");
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$setString$1(this, key, value, null), 1, null);
    }

    @Override // io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi
    public void setStringList(String key, List<String> value, SharedPreferencesPigeonOptions options) {
        kotlin.jvm.internal.k.e(key, "key");
        kotlin.jvm.internal.k.e(value, "value");
        kotlin.jvm.internal.k.e(options, "options");
        z8.h.b(null, new SharedPreferencesPlugin$setStringList$1(this, key, SharedPreferencesPluginKt.LIST_PREFIX + this.listEncoder.encode(value), null), 1, null);
    }
}
