package io.flutter.plugins.imagepicker;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import io.flutter.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
/* loaded from: classes.dex */
class FileUtils {
    private static void copy(InputStream inputStream, OutputStream outputStream) {
        byte[] bArr = new byte[4096];
        while (true) {
            int read = inputStream.read(bArr);
            if (read == -1) {
                outputStream.flush();
                return;
            }
            outputStream.write(bArr, 0, read);
        }
    }

    private static String getBaseName(String str) {
        int lastIndexOf = str.lastIndexOf(46);
        return lastIndexOf < 0 ? str : str.substring(0, lastIndexOf);
    }

    private static String getImageExtension(Context context, Uri uri) {
        try {
            String extensionFromMimeType = uri.getScheme().equals("content") ? MimeTypeMap.getSingleton().getExtensionFromMimeType(context.getContentResolver().getType(uri)) : MimeTypeMap.getFileExtensionFromUrl(Uri.fromFile(new File(uri.getPath())).toString());
            if (extensionFromMimeType != null && !extensionFromMimeType.isEmpty()) {
                return "." + extensionFromMimeType;
            }
        } catch (Exception unused) {
        }
        return null;
    }

    private static String getImageName(Context context, Uri uri) {
        Cursor queryImageName = queryImageName(context, uri);
        if (queryImageName != null) {
            try {
                if (queryImageName.moveToFirst() && queryImageName.getColumnCount() >= 1) {
                    String string = queryImageName.getString(0);
                    queryImageName.close();
                    return string;
                }
            } catch (Throwable th) {
                try {
                    queryImageName.close();
                } catch (Throwable th2) {
                    th.addSuppressed(th2);
                }
                throw th;
            }
        }
        if (queryImageName != null) {
            queryImageName.close();
        }
        return null;
    }

    private static Cursor queryImageName(Context context, Uri uri) {
        return context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* JADX WARN: Removed duplicated region for block: B:17:0x007e A[Catch: IOException | SecurityException -> 0x0098, TRY_ENTER, TRY_LEAVE, TryCatch #3 {IOException | SecurityException -> 0x0098, blocks: (B:3:0x0001, B:17:0x007e, B:4:0x0009, B:6:0x002a, B:9:0x0044, B:10:0x0051, B:13:0x0068, B:15:0x0079, B:24:0x008b, B:23:0x0088, B:12:0x0058), top: B:33:0x0001 }] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public String getPathFromUri(Context context, Uri uri) {
        StringBuilder sb;
        FileOutputStream fileOutputStream;
        try {
            InputStream openInputStream = context.getContentResolver().openInputStream(uri);
            File file = new File(context.getCacheDir(), UUID.randomUUID().toString());
            file.mkdir();
            file.deleteOnExit();
            String imageName = getImageName(context, uri);
            String imageExtension = getImageExtension(context, uri);
            try {
                if (imageName != null) {
                    if (imageExtension != null) {
                        sb = new StringBuilder();
                        sb.append(getBaseName(imageName));
                        sb.append(imageExtension);
                    }
                    File file2 = new File(file, imageName);
                    fileOutputStream = new FileOutputStream(file2);
                    copy(openInputStream, fileOutputStream);
                    String path = file2.getPath();
                    fileOutputStream.close();
                    if (openInputStream != null) {
                        openInputStream.close();
                    }
                    return path;
                }
                Log.w("FileUtils", "Cannot get file name for " + uri);
                if (imageExtension == null) {
                    imageExtension = ".jpg";
                }
                sb = new StringBuilder();
                sb.append("image_picker");
                sb.append(imageExtension);
                copy(openInputStream, fileOutputStream);
                String path2 = file2.getPath();
                fileOutputStream.close();
                if (openInputStream != null) {
                }
                return path2;
            } catch (Throwable th) {
                try {
                    fileOutputStream.close();
                } catch (Throwable th2) {
                    th.addSuppressed(th2);
                }
                throw th;
            }
            imageName = sb.toString();
            File file22 = new File(file, imageName);
            fileOutputStream = new FileOutputStream(file22);
        } catch (IOException | SecurityException unused) {
            return null;
        }
    }
}
