package io.flutter.plugins.camera.media;

import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.media.MediaRecorder;
import io.flutter.plugins.camera.SdkCapabilityChecker;
/* loaded from: classes.dex */
public class MediaRecorderBuilder {
    private final CamcorderProfile camcorderProfile;
    private boolean enableAudio;
    private final EncoderProfiles encoderProfiles;
    private int mediaOrientation;
    private final RecordingParameters parameters;
    private final MediaRecorderFactory recorderFactory;

    /* loaded from: classes.dex */
    static class MediaRecorderFactory {
        MediaRecorderFactory() {
        }

        MediaRecorder makeMediaRecorder() {
            return new MediaRecorder();
        }
    }

    /* loaded from: classes.dex */
    public static class RecordingParameters {
        public final Integer audioBitrate;
        public final Integer fps;
        public final String outputFilePath;
        public final Integer videoBitrate;

        public RecordingParameters(String str) {
            this(str, null, null, null);
        }

        public RecordingParameters(String str, Integer num, Integer num2, Integer num3) {
            this.outputFilePath = str;
            this.fps = num;
            this.videoBitrate = num2;
            this.audioBitrate = num3;
        }
    }

    MediaRecorderBuilder(CamcorderProfile camcorderProfile, MediaRecorderFactory mediaRecorderFactory, RecordingParameters recordingParameters) {
        this.camcorderProfile = camcorderProfile;
        this.encoderProfiles = null;
        this.recorderFactory = mediaRecorderFactory;
        this.parameters = recordingParameters;
    }

    public MediaRecorderBuilder(CamcorderProfile camcorderProfile, RecordingParameters recordingParameters) {
        this(camcorderProfile, new MediaRecorderFactory(), recordingParameters);
    }

    MediaRecorderBuilder(EncoderProfiles encoderProfiles, MediaRecorderFactory mediaRecorderFactory, RecordingParameters recordingParameters) {
        this.encoderProfiles = encoderProfiles;
        this.camcorderProfile = null;
        this.recorderFactory = mediaRecorderFactory;
        this.parameters = recordingParameters;
    }

    public MediaRecorderBuilder(EncoderProfiles encoderProfiles, RecordingParameters recordingParameters) {
        this(encoderProfiles, new MediaRecorderFactory(), recordingParameters);
    }

    public MediaRecorder build() {
        int i10;
        int i11;
        EncoderProfiles encoderProfiles;
        MediaRecorder makeMediaRecorder = this.recorderFactory.makeMediaRecorder();
        if (this.enableAudio) {
            makeMediaRecorder.setAudioSource(1);
        }
        makeMediaRecorder.setVideoSource(2);
        if (!SdkCapabilityChecker.supportsEncoderProfiles() || (encoderProfiles = this.encoderProfiles) == null) {
            CamcorderProfile camcorderProfile = this.camcorderProfile;
            if (camcorderProfile != null) {
                makeMediaRecorder.setOutputFormat(camcorderProfile.fileFormat);
                if (this.enableAudio) {
                    makeMediaRecorder.setAudioEncoder(this.camcorderProfile.audioCodec);
                    Integer num = this.parameters.audioBitrate;
                    makeMediaRecorder.setAudioEncodingBitRate((num == null || num.intValue() <= 0) ? this.camcorderProfile.audioBitRate : this.parameters.audioBitrate.intValue());
                    makeMediaRecorder.setAudioSamplingRate(this.camcorderProfile.audioSampleRate);
                }
                makeMediaRecorder.setVideoEncoder(this.camcorderProfile.videoCodec);
                Integer num2 = this.parameters.videoBitrate;
                makeMediaRecorder.setVideoEncodingBitRate((num2 == null || num2.intValue() <= 0) ? this.camcorderProfile.videoBitRate : this.parameters.videoBitrate.intValue());
                Integer num3 = this.parameters.fps;
                makeMediaRecorder.setVideoFrameRate((num3 == null || num3.intValue() <= 0) ? this.camcorderProfile.videoFrameRate : this.parameters.fps.intValue());
                CamcorderProfile camcorderProfile2 = this.camcorderProfile;
                i10 = camcorderProfile2.videoFrameWidth;
                i11 = camcorderProfile2.videoFrameHeight;
            }
            makeMediaRecorder.setOutputFile(this.parameters.outputFilePath);
            makeMediaRecorder.setOrientationHint(this.mediaOrientation);
            makeMediaRecorder.prepare();
            return makeMediaRecorder;
        }
        makeMediaRecorder.setOutputFormat(encoderProfiles.getRecommendedFileFormat());
        EncoderProfiles.VideoProfile videoProfile = this.encoderProfiles.getVideoProfiles().get(0);
        if (this.enableAudio) {
            EncoderProfiles.AudioProfile audioProfile = this.encoderProfiles.getAudioProfiles().get(0);
            makeMediaRecorder.setAudioEncoder(audioProfile.getCodec());
            Integer num4 = this.parameters.audioBitrate;
            makeMediaRecorder.setAudioEncodingBitRate((num4 == null || num4.intValue() <= 0) ? audioProfile.getBitrate() : this.parameters.audioBitrate.intValue());
            makeMediaRecorder.setAudioSamplingRate(audioProfile.getSampleRate());
        }
        makeMediaRecorder.setVideoEncoder(videoProfile.getCodec());
        Integer num5 = this.parameters.videoBitrate;
        makeMediaRecorder.setVideoEncodingBitRate((num5 == null || num5.intValue() <= 0) ? videoProfile.getBitrate() : this.parameters.videoBitrate.intValue());
        Integer num6 = this.parameters.fps;
        makeMediaRecorder.setVideoFrameRate((num6 == null || num6.intValue() <= 0) ? videoProfile.getFrameRate() : this.parameters.fps.intValue());
        i10 = videoProfile.getWidth();
        i11 = videoProfile.getHeight();
        makeMediaRecorder.setVideoSize(i10, i11);
        makeMediaRecorder.setOutputFile(this.parameters.outputFilePath);
        makeMediaRecorder.setOrientationHint(this.mediaOrientation);
        makeMediaRecorder.prepare();
        return makeMediaRecorder;
    }

    public MediaRecorderBuilder setEnableAudio(boolean z9) {
        this.enableAudio = z9;
        return this;
    }

    public MediaRecorderBuilder setMediaOrientation(int i10) {
        this.mediaOrientation = i10;
        return this;
    }
}
