package io.flutter.embedding.android;

import android.view.KeyEvent;
import io.flutter.Log;
import io.flutter.embedding.android.KeyData;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.android.KeyboardMap;
import io.flutter.plugin.common.BinaryMessenger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
/* loaded from: classes.dex */
public class KeyEmbedderResponder implements KeyboardManager.Responder {
    private static final String TAG = "KeyEmbedderResponder";
    private final BinaryMessenger messenger;
    private final HashMap<Long, Long> pressingRecords = new HashMap<>();
    private final HashMap<Long, KeyboardMap.TogglingGoal> togglingGoals = new HashMap<>();
    private final KeyboardManager.CharacterCombiner characterCombiner = new KeyboardManager.CharacterCombiner();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: io.flutter.embedding.android.KeyEmbedderResponder$1  reason: invalid class name */
    /* loaded from: classes.dex */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$io$flutter$embedding$android$KeyData$Type;

        static {
            int[] iArr = new int[KeyData.Type.values().length];
            $SwitchMap$io$flutter$embedding$android$KeyData$Type = iArr;
            try {
                iArr[KeyData.Type.kDown.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                $SwitchMap$io$flutter$embedding$android$KeyData$Type[KeyData.Type.kUp.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            try {
                $SwitchMap$io$flutter$embedding$android$KeyData$Type[KeyData.Type.kRepeat.ordinal()] = 3;
            } catch (NoSuchFieldError unused3) {
            }
        }
    }

    public KeyEmbedderResponder(BinaryMessenger binaryMessenger) {
        KeyboardMap.TogglingGoal[] togglingGoals;
        this.messenger = binaryMessenger;
        for (KeyboardMap.TogglingGoal togglingGoal : KeyboardMap.getTogglingGoals()) {
            this.togglingGoals.put(Long.valueOf(togglingGoal.logicalKey), togglingGoal);
        }
    }

    private static KeyData.Type getEventType(KeyEvent keyEvent) {
        boolean z9 = keyEvent.getRepeatCount() > 0;
        int action = keyEvent.getAction();
        if (action == 0) {
            return z9 ? KeyData.Type.kRepeat : KeyData.Type.kDown;
        } else if (action == 1) {
            return KeyData.Type.kUp;
        } else {
            throw new AssertionError("Unexpected event type");
        }
    }

    private Long getLogicalKey(KeyEvent keyEvent) {
        Long l10 = KeyboardMap.keyCodeToLogical.get(Long.valueOf(keyEvent.getKeyCode()));
        return l10 != null ? l10 : Long.valueOf(keyOfPlane(keyEvent.getKeyCode(), KeyboardMap.kAndroidPlane));
    }

    private Long getPhysicalKey(KeyEvent keyEvent) {
        int scanCode;
        long scanCode2 = keyEvent.getScanCode();
        if (scanCode2 == 0) {
            scanCode = keyEvent.getKeyCode();
        } else {
            Long l10 = KeyboardMap.scanCodeToPhysical.get(Long.valueOf(scanCode2));
            if (l10 != null) {
                return l10;
            }
            scanCode = keyEvent.getScanCode();
        }
        return Long.valueOf(keyOfPlane(scanCode, KeyboardMap.kAndroidPlane));
    }

    /* JADX WARN: Removed duplicated region for block: B:39:0x00b8  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x00d4  */
    /* JADX WARN: Removed duplicated region for block: B:56:0x00fa  */
    /* JADX WARN: Removed duplicated region for block: B:67:0x0116  */
    /* JADX WARN: Removed duplicated region for block: B:71:0x0144 A[LOOP:2: B:69:0x013e->B:71:0x0144, LOOP_END] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private boolean handleEventImpl(KeyEvent keyEvent, KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        KeyboardMap.PressingGoal[] pressingGoalArr;
        boolean z9;
        KeyData.Type type;
        String str;
        Iterator<Runnable> it;
        KeyboardMap.TogglingGoal togglingGoal;
        char charValue;
        if (keyEvent.getScanCode() == 0 && keyEvent.getKeyCode() == 0) {
            return false;
        }
        Long physicalKey = getPhysicalKey(keyEvent);
        Long logicalKey = getLogicalKey(keyEvent);
        ArrayList<Runnable> arrayList = new ArrayList<>();
        for (KeyboardMap.PressingGoal pressingGoal : KeyboardMap.pressingGoals) {
            synchronizePressingKey(pressingGoal, (keyEvent.getMetaState() & pressingGoal.mask) != 0, logicalKey.longValue(), physicalKey.longValue(), keyEvent, arrayList);
        }
        for (KeyboardMap.TogglingGoal togglingGoal2 : this.togglingGoals.values()) {
            synchronizeTogglingKey(togglingGoal2, (keyEvent.getMetaState() & togglingGoal2.mask) != 0, logicalKey.longValue(), keyEvent);
        }
        int action = keyEvent.getAction();
        if (action == 0) {
            z9 = true;
        } else if (action != 1) {
            return false;
        } else {
            z9 = false;
        }
        Long l10 = this.pressingRecords.get(physicalKey);
        if (z9) {
            if (l10 != null) {
                if (keyEvent.getRepeatCount() > 0) {
                    type = KeyData.Type.kRepeat;
                    charValue = this.characterCombiner.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar()).charValue();
                    if (charValue != 0) {
                        str = "" + charValue;
                        if (type != KeyData.Type.kRepeat) {
                            updatePressingState(physicalKey, z9 ? logicalKey : null);
                        }
                        if (type == KeyData.Type.kDown && (togglingGoal = this.togglingGoals.get(logicalKey)) != null) {
                            togglingGoal.enabled = !togglingGoal.enabled;
                        }
                        KeyData keyData = new KeyData();
                        int source = keyEvent.getSource();
                        keyData.deviceType = source == 513 ? source != 1025 ? source != 16777232 ? source != 33554433 ? KeyData.DeviceType.kKeyboard : KeyData.DeviceType.kHdmi : KeyData.DeviceType.kJoystick : KeyData.DeviceType.kGamepad : KeyData.DeviceType.kDirectionalPad;
                        keyData.timestamp = keyEvent.getEventTime();
                        keyData.type = type;
                        keyData.logicalKey = logicalKey.longValue();
                        keyData.physicalKey = physicalKey.longValue();
                        keyData.character = str;
                        keyData.synthesized = false;
                        keyData.deviceType = KeyData.DeviceType.kKeyboard;
                        sendKeyEvent(keyData, onKeyEventHandledCallback);
                        it = arrayList.iterator();
                        while (it.hasNext()) {
                            it.next().run();
                        }
                        return true;
                    }
                } else {
                    synthesizeEvent(false, l10, physicalKey, keyEvent.getEventTime());
                }
            }
            type = KeyData.Type.kDown;
            charValue = this.characterCombiner.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar()).charValue();
            if (charValue != 0) {
            }
        } else if (l10 == null) {
            return false;
        } else {
            type = KeyData.Type.kUp;
        }
        str = null;
        if (type != KeyData.Type.kRepeat) {
        }
        if (type == KeyData.Type.kDown) {
            togglingGoal.enabled = !togglingGoal.enabled;
        }
        KeyData keyData2 = new KeyData();
        int source2 = keyEvent.getSource();
        keyData2.deviceType = source2 == 513 ? source2 != 1025 ? source2 != 16777232 ? source2 != 33554433 ? KeyData.DeviceType.kKeyboard : KeyData.DeviceType.kHdmi : KeyData.DeviceType.kJoystick : KeyData.DeviceType.kGamepad : KeyData.DeviceType.kDirectionalPad;
        keyData2.timestamp = keyEvent.getEventTime();
        keyData2.type = type;
        keyData2.logicalKey = logicalKey.longValue();
        keyData2.physicalKey = physicalKey.longValue();
        keyData2.character = str;
        keyData2.synthesized = false;
        keyData2.deviceType = KeyData.DeviceType.kKeyboard;
        sendKeyEvent(keyData2, onKeyEventHandledCallback);
        it = arrayList.iterator();
        while (it.hasNext()) {
        }
        return true;
    }

    private static long keyOfPlane(long j10, long j11) {
        return (j10 & KeyboardMap.kValueMask) | j11;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void lambda$sendKeyEvent$2(KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback, ByteBuffer byteBuffer) {
        Boolean bool = Boolean.FALSE;
        if (byteBuffer != null) {
            byteBuffer.rewind();
            if (byteBuffer.capacity() != 0) {
                bool = Boolean.valueOf(byteBuffer.get() != 0);
            }
        } else {
            Log.w(TAG, "A null reply was received when sending a key event to the framework.");
        }
        onKeyEventHandledCallback.onKeyEventHandled(bool.booleanValue());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void lambda$synchronizePressingKey$0(KeyboardMap.KeyPair keyPair, long j10, KeyEvent keyEvent) {
        synthesizeEvent(false, Long.valueOf(keyPair.logicalKey), Long.valueOf(j10), keyEvent.getEventTime());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void lambda$synchronizePressingKey$1(KeyboardMap.KeyPair keyPair, KeyEvent keyEvent) {
        synthesizeEvent(false, Long.valueOf(keyPair.logicalKey), Long.valueOf(keyPair.physicalKey), keyEvent.getEventTime());
    }

    private void sendKeyEvent(KeyData keyData, final KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        this.messenger.send(KeyData.CHANNEL, keyData.toBytes(), onKeyEventHandledCallback == null ? null : new BinaryMessenger.BinaryReply() { // from class: io.flutter.embedding.android.k
            @Override // io.flutter.plugin.common.BinaryMessenger.BinaryReply
            public final void reply(ByteBuffer byteBuffer) {
                KeyEmbedderResponder.lambda$sendKeyEvent$2(KeyboardManager.Responder.OnKeyEventHandledCallback.this, byteBuffer);
            }
        });
    }

    private void synthesizeEvent(boolean z9, Long l10, Long l11, long j10) {
        KeyData keyData = new KeyData();
        keyData.timestamp = j10;
        keyData.type = z9 ? KeyData.Type.kDown : KeyData.Type.kUp;
        keyData.logicalKey = l10.longValue();
        keyData.physicalKey = l11.longValue();
        keyData.character = null;
        keyData.synthesized = true;
        keyData.deviceType = KeyData.DeviceType.kKeyboard;
        if (l11.longValue() != 0 && l10.longValue() != 0) {
            if (!z9) {
                l10 = null;
            }
            updatePressingState(l11, l10);
        }
        sendKeyEvent(keyData, null);
    }

    public Map<Long, Long> getPressedState() {
        return Collections.unmodifiableMap(this.pressingRecords);
    }

    @Override // io.flutter.embedding.android.KeyboardManager.Responder
    public void handleEvent(KeyEvent keyEvent, KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        if (handleEventImpl(keyEvent, onKeyEventHandledCallback)) {
            return;
        }
        synthesizeEvent(true, 0L, 0L, 0L);
        onKeyEventHandledCallback.onKeyEventHandled(true);
    }

    void synchronizePressingKey(KeyboardMap.PressingGoal pressingGoal, boolean z9, long j10, final long j11, final KeyEvent keyEvent, ArrayList<Runnable> arrayList) {
        KeyboardMap.KeyPair[] keyPairArr = pressingGoal.keys;
        boolean[] zArr = new boolean[keyPairArr.length];
        Boolean[] boolArr = new Boolean[keyPairArr.length];
        boolean z10 = false;
        int i10 = 0;
        while (true) {
            KeyboardMap.KeyPair[] keyPairArr2 = pressingGoal.keys;
            boolean z11 = true;
            if (i10 >= keyPairArr2.length) {
                break;
            }
            final KeyboardMap.KeyPair keyPair = keyPairArr2[i10];
            boolean containsKey = this.pressingRecords.containsKey(Long.valueOf(keyPair.physicalKey));
            zArr[i10] = containsKey;
            if (keyPair.logicalKey == j10) {
                int i11 = AnonymousClass1.$SwitchMap$io$flutter$embedding$android$KeyData$Type[getEventType(keyEvent).ordinal()];
                if (i11 == 1) {
                    boolArr[i10] = Boolean.FALSE;
                    if (!z9) {
                        arrayList.add(new Runnable() { // from class: io.flutter.embedding.android.l
                            @Override // java.lang.Runnable
                            public final void run() {
                                KeyEmbedderResponder.this.lambda$synchronizePressingKey$0(keyPair, j11, keyEvent);
                            }
                        });
                    }
                } else if (i11 == 2) {
                    boolArr[i10] = Boolean.valueOf(zArr[i10]);
                } else if (i11 == 3) {
                    if (!z9) {
                        arrayList.add(new Runnable() { // from class: io.flutter.embedding.android.m
                            @Override // java.lang.Runnable
                            public final void run() {
                                KeyEmbedderResponder.this.lambda$synchronizePressingKey$1(keyPair, keyEvent);
                            }
                        });
                    }
                    boolArr[i10] = Boolean.valueOf(zArr[i10]);
                }
                z10 = true;
            } else {
                if (!z10 && !containsKey) {
                    z11 = false;
                }
                z10 = z11;
            }
            i10++;
        }
        if (z9) {
            for (int i12 = 0; i12 < pressingGoal.keys.length; i12++) {
                if (boolArr[i12] == null) {
                    if (z10) {
                        boolArr[i12] = Boolean.valueOf(zArr[i12]);
                    } else {
                        boolArr[i12] = Boolean.TRUE;
                        z10 = true;
                    }
                }
            }
            if (!z10) {
                boolArr[0] = Boolean.TRUE;
            }
        } else {
            for (int i13 = 0; i13 < pressingGoal.keys.length; i13++) {
                if (boolArr[i13] == null) {
                    boolArr[i13] = Boolean.FALSE;
                }
            }
        }
        for (int i14 = 0; i14 < pressingGoal.keys.length; i14++) {
            if (zArr[i14] != boolArr[i14].booleanValue()) {
                KeyboardMap.KeyPair keyPair2 = pressingGoal.keys[i14];
                synthesizeEvent(boolArr[i14].booleanValue(), Long.valueOf(keyPair2.logicalKey), Long.valueOf(keyPair2.physicalKey), keyEvent.getEventTime());
            }
        }
    }

    void synchronizeTogglingKey(KeyboardMap.TogglingGoal togglingGoal, boolean z9, long j10, KeyEvent keyEvent) {
        if (togglingGoal.logicalKey == j10 || togglingGoal.enabled == z9) {
            return;
        }
        boolean z10 = !this.pressingRecords.containsKey(Long.valueOf(togglingGoal.physicalKey));
        if (z10) {
            togglingGoal.enabled = !togglingGoal.enabled;
        }
        synthesizeEvent(z10, Long.valueOf(togglingGoal.logicalKey), Long.valueOf(togglingGoal.physicalKey), keyEvent.getEventTime());
        if (!z10) {
            togglingGoal.enabled = !togglingGoal.enabled;
        }
        synthesizeEvent(!z10, Long.valueOf(togglingGoal.logicalKey), Long.valueOf(togglingGoal.physicalKey), keyEvent.getEventTime());
    }

    void updatePressingState(Long l10, Long l11) {
        if (l11 != null) {
            if (this.pressingRecords.put(l10, l11) != null) {
                throw new AssertionError("The key was not empty");
            }
        } else if (this.pressingRecords.remove(l10) == null) {
            throw new AssertionError("The key was empty");
        }
    }
}
