package f1;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Pair;
import f1.g0;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
/* loaded from: classes.dex */
public abstract class g0 {

    /* renamed from: a  reason: collision with root package name */
    private static final Pattern f7581a = Pattern.compile("^\\D?(\\d+)$");

    /* renamed from: b  reason: collision with root package name */
    private static final HashMap f7582b = new HashMap();

    /* renamed from: c  reason: collision with root package name */
    private static int f7583c = -1;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class b {

        /* renamed from: a  reason: collision with root package name */
        public final String f7584a;

        /* renamed from: b  reason: collision with root package name */
        public final boolean f7585b;

        /* renamed from: c  reason: collision with root package name */
        public final boolean f7586c;

        public b(String str, boolean z9, boolean z10) {
            this.f7584a = str;
            this.f7585b = z9;
            this.f7586c = z10;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != b.class) {
                return false;
            }
            b bVar = (b) obj;
            return TextUtils.equals(this.f7584a, bVar.f7584a) && this.f7585b == bVar.f7585b && this.f7586c == bVar.f7586c;
        }

        public int hashCode() {
            return ((((this.f7584a.hashCode() + 31) * 31) + (this.f7585b ? 1231 : 1237)) * 31) + (this.f7586c ? 1231 : 1237);
        }
    }

    /* loaded from: classes.dex */
    public static class c extends Exception {
        private c(Throwable th) {
            super("Failed to query underlying media codecs", th);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface d {
        MediaCodecInfo a(int i10);

        boolean b(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities);

        boolean c(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities);

        int d();

        boolean e();
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class e implements d {
        private e() {
        }

        @Override // f1.g0.d
        public MediaCodecInfo a(int i10) {
            return MediaCodecList.getCodecInfoAt(i10);
        }

        @Override // f1.g0.d
        public boolean b(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return "secure-playback".equals(str) && "video/avc".equals(str2);
        }

        @Override // f1.g0.d
        public boolean c(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return false;
        }

        @Override // f1.g0.d
        public int d() {
            return MediaCodecList.getCodecCount();
        }

        @Override // f1.g0.d
        public boolean e() {
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class f implements d {

        /* renamed from: a  reason: collision with root package name */
        private final int f7587a;

        /* renamed from: b  reason: collision with root package name */
        private MediaCodecInfo[] f7588b;

        public f(boolean z9, boolean z10) {
            this.f7587a = (z9 || z10) ? 1 : 0;
        }

        private void f() {
            if (this.f7588b == null) {
                this.f7588b = new MediaCodecList(this.f7587a).getCodecInfos();
            }
        }

        @Override // f1.g0.d
        public MediaCodecInfo a(int i10) {
            f();
            return this.f7588b[i10];
        }

        @Override // f1.g0.d
        public boolean b(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return codecCapabilities.isFeatureSupported(str);
        }

        @Override // f1.g0.d
        public boolean c(String str, String str2, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return codecCapabilities.isFeatureRequired(str);
        }

        @Override // f1.g0.d
        public int d() {
            f();
            return this.f7588b.length;
        }

        @Override // f1.g0.d
        public boolean e() {
            return true;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface g {
        int a(Object obj);
    }

    private static Pair A(String str, String[] strArr) {
        StringBuilder sb;
        int parseInt;
        int parseInt2;
        int T;
        String str2;
        if (strArr.length >= 3) {
            try {
                parseInt = Integer.parseInt(strArr[1]);
                parseInt2 = Integer.parseInt(strArr[2]);
                T = T(parseInt);
            } catch (NumberFormatException unused) {
                sb = new StringBuilder();
            }
            if (T == -1) {
                str2 = "Unknown VP9 profile: " + parseInt;
                s0.o.h("MediaCodecUtil", str2);
                return null;
            }
            int S = S(parseInt2);
            if (S == -1) {
                sb = new StringBuilder();
                sb.append("Unknown VP9 level: ");
                sb.append(parseInt2);
                str2 = sb.toString();
                s0.o.h("MediaCodecUtil", str2);
                return null;
            }
            return new Pair(Integer.valueOf(T), Integer.valueOf(S));
        }
        sb = new StringBuilder();
        sb.append("Ignoring malformed VP9 codec string: ");
        sb.append(str);
        str2 = sb.toString();
        s0.o.h("MediaCodecUtil", str2);
        return null;
    }

    private static Integer B(String str) {
        int i10;
        if (str == null) {
            return null;
        }
        char c10 = 65535;
        switch (str.hashCode()) {
            case 70821:
                if (str.equals("H30")) {
                    c10 = 0;
                    break;
                }
                break;
            case 70914:
                if (str.equals("H60")) {
                    c10 = 1;
                    break;
                }
                break;
            case 70917:
                if (str.equals("H63")) {
                    c10 = 2;
                    break;
                }
                break;
            case 71007:
                if (str.equals("H90")) {
                    c10 = 3;
                    break;
                }
                break;
            case 71010:
                if (str.equals("H93")) {
                    c10 = 4;
                    break;
                }
                break;
            case 74665:
                if (str.equals("L30")) {
                    c10 = 5;
                    break;
                }
                break;
            case 74758:
                if (str.equals("L60")) {
                    c10 = 6;
                    break;
                }
                break;
            case 74761:
                if (str.equals("L63")) {
                    c10 = 7;
                    break;
                }
                break;
            case 74851:
                if (str.equals("L90")) {
                    c10 = '\b';
                    break;
                }
                break;
            case 74854:
                if (str.equals("L93")) {
                    c10 = '\t';
                    break;
                }
                break;
            case 2193639:
                if (str.equals("H120")) {
                    c10 = '\n';
                    break;
                }
                break;
            case 2193642:
                if (str.equals("H123")) {
                    c10 = 11;
                    break;
                }
                break;
            case 2193732:
                if (str.equals("H150")) {
                    c10 = '\f';
                    break;
                }
                break;
            case 2193735:
                if (str.equals("H153")) {
                    c10 = '\r';
                    break;
                }
                break;
            case 2193738:
                if (str.equals("H156")) {
                    c10 = 14;
                    break;
                }
                break;
            case 2193825:
                if (str.equals("H180")) {
                    c10 = 15;
                    break;
                }
                break;
            case 2193828:
                if (str.equals("H183")) {
                    c10 = 16;
                    break;
                }
                break;
            case 2193831:
                if (str.equals("H186")) {
                    c10 = 17;
                    break;
                }
                break;
            case 2312803:
                if (str.equals("L120")) {
                    c10 = 18;
                    break;
                }
                break;
            case 2312806:
                if (str.equals("L123")) {
                    c10 = 19;
                    break;
                }
                break;
            case 2312896:
                if (str.equals("L150")) {
                    c10 = 20;
                    break;
                }
                break;
            case 2312899:
                if (str.equals("L153")) {
                    c10 = 21;
                    break;
                }
                break;
            case 2312902:
                if (str.equals("L156")) {
                    c10 = 22;
                    break;
                }
                break;
            case 2312989:
                if (str.equals("L180")) {
                    c10 = 23;
                    break;
                }
                break;
            case 2312992:
                if (str.equals("L183")) {
                    c10 = 24;
                    break;
                }
                break;
            case 2312995:
                if (str.equals("L186")) {
                    c10 = 25;
                    break;
                }
                break;
        }
        switch (c10) {
            case 0:
                return 2;
            case 1:
                return 8;
            case 2:
                i10 = 32;
                break;
            case 3:
                i10 = 128;
                break;
            case 4:
                i10 = 512;
                break;
            case 5:
                return 1;
            case 6:
                return 4;
            case 7:
                return 16;
            case '\b':
                i10 = 64;
                break;
            case '\t':
                i10 = 256;
                break;
            case '\n':
                i10 = 2048;
                break;
            case 11:
                i10 = 8192;
                break;
            case '\f':
                i10 = 32768;
                break;
            case '\r':
                i10 = 131072;
                break;
            case 14:
                i10 = 524288;
                break;
            case 15:
                i10 = 2097152;
                break;
            case 16:
                i10 = 8388608;
                break;
            case 17:
                i10 = 33554432;
                break;
            case 18:
                i10 = 1024;
                break;
            case 19:
                i10 = 4096;
                break;
            case 20:
                i10 = 16384;
                break;
            case 21:
                i10 = 65536;
                break;
            case 22:
                i10 = 262144;
                break;
            case 23:
                i10 = 1048576;
                break;
            case 24:
                i10 = 4194304;
                break;
            case 25:
                i10 = 16777216;
                break;
            default:
                return null;
        }
        return Integer.valueOf(i10);
    }

    private static boolean C(MediaCodecInfo mediaCodecInfo) {
        return s0.j0.f12742a >= 29 && D(mediaCodecInfo);
    }

    private static boolean D(MediaCodecInfo mediaCodecInfo) {
        boolean isAlias;
        isAlias = mediaCodecInfo.isAlias();
        return isAlias;
    }

    private static boolean E(MediaCodecInfo mediaCodecInfo, String str, boolean z9, String str2) {
        if (mediaCodecInfo.isEncoder() || (!z9 && str.endsWith(".secure"))) {
            return false;
        }
        int i10 = s0.j0.f12742a;
        if (i10 >= 21 || !("CIPAACDecoder".equals(str) || "CIPMP3Decoder".equals(str) || "CIPVorbisDecoder".equals(str) || "CIPAMRNBDecoder".equals(str) || "AACDecoder".equals(str) || "MP3Decoder".equals(str))) {
            if (i10 < 24 && (("OMX.SEC.aac.dec".equals(str) || "OMX.Exynos.AAC.Decoder".equals(str)) && "samsung".equals(s0.j0.f12744c))) {
                String str3 = s0.j0.f12743b;
                if (str3.startsWith("zeroflte") || str3.startsWith("zerolte") || str3.startsWith("zenlte") || "SC-05G".equals(str3) || "marinelteatt".equals(str3) || "404SC".equals(str3) || "SC-04G".equals(str3) || "SCV31".equals(str3)) {
                    return false;
                }
            }
            if (i10 == 19 && "OMX.SEC.vp8.dec".equals(str) && "samsung".equals(s0.j0.f12744c)) {
                String str4 = s0.j0.f12743b;
                if (str4.startsWith("d2") || str4.startsWith("serrano") || str4.startsWith("jflte") || str4.startsWith("santos") || str4.startsWith("t0")) {
                    return false;
                }
            }
            if (i10 == 19 && s0.j0.f12743b.startsWith("jflte") && "OMX.qcom.video.decoder.vp8".equals(str)) {
                return false;
            }
            return (i10 <= 23 && "audio/eac3-joc".equals(str2) && "OMX.MTK.AUDIO.DECODER.DSPAC3".equals(str)) ? false : true;
        }
        return false;
    }

    private static boolean F(MediaCodecInfo mediaCodecInfo, String str) {
        return s0.j0.f12742a >= 29 ? G(mediaCodecInfo) : !H(mediaCodecInfo, str);
    }

    private static boolean G(MediaCodecInfo mediaCodecInfo) {
        boolean isHardwareAccelerated;
        isHardwareAccelerated = mediaCodecInfo.isHardwareAccelerated();
        return isHardwareAccelerated;
    }

    private static boolean H(MediaCodecInfo mediaCodecInfo, String str) {
        if (s0.j0.f12742a >= 29) {
            return I(mediaCodecInfo);
        }
        if (p0.y.o(str)) {
            return true;
        }
        String e10 = q6.b.e(mediaCodecInfo.getName());
        if (e10.startsWith("arc.")) {
            return false;
        }
        if (e10.startsWith("omx.google.") || e10.startsWith("omx.ffmpeg.")) {
            return true;
        }
        if ((e10.startsWith("omx.sec.") && e10.contains(".sw.")) || e10.equals("omx.qcom.video.decoder.hevcswvdec") || e10.startsWith("c2.android.") || e10.startsWith("c2.google.")) {
            return true;
        }
        return (e10.startsWith("omx.") || e10.startsWith("c2.")) ? false : true;
    }

    private static boolean I(MediaCodecInfo mediaCodecInfo) {
        boolean isSoftwareOnly;
        isSoftwareOnly = mediaCodecInfo.isSoftwareOnly();
        return isSoftwareOnly;
    }

    private static boolean J(MediaCodecInfo mediaCodecInfo) {
        if (s0.j0.f12742a >= 29) {
            return K(mediaCodecInfo);
        }
        String e10 = q6.b.e(mediaCodecInfo.getName());
        return (e10.startsWith("omx.google.") || e10.startsWith("c2.android.") || e10.startsWith("c2.google.")) ? false : true;
    }

    private static boolean K(MediaCodecInfo mediaCodecInfo) {
        boolean isVendor;
        isVendor = mediaCodecInfo.isVendor();
        return isVendor;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ int L(r rVar) {
        String str = rVar.f7641a;
        if (str.startsWith("OMX.google") || str.startsWith("c2.android")) {
            return 1;
        }
        return (s0.j0.f12742a >= 26 || !str.equals("OMX.MTK.AUDIO.DECODER.RAW")) ? 0 : -1;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ int M(r rVar) {
        return rVar.f7641a.startsWith("OMX.google") ? 1 : 0;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ int N(p0.p pVar, r rVar) {
        return rVar.l(pVar) ? 1 : 0;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ int O(g gVar, Object obj, Object obj2) {
        return gVar.a(obj2) - gVar.a(obj);
    }

    public static int P() {
        if (f7583c == -1) {
            int i10 = 0;
            r s9 = s("video/avc", false, false);
            if (s9 != null) {
                MediaCodecInfo.CodecProfileLevel[] g10 = s9.g();
                int length = g10.length;
                int i11 = 0;
                while (i10 < length) {
                    i11 = Math.max(h(g10[i10].level), i11);
                    i10++;
                }
                i10 = Math.max(i11, s0.j0.f12742a >= 21 ? 345600 : 172800);
            }
            f7583c = i10;
        }
        return f7583c;
    }

    private static int Q(int i10) {
        int i11 = 17;
        if (i10 != 17) {
            i11 = 20;
            if (i10 != 20) {
                i11 = 23;
                if (i10 != 23) {
                    i11 = 29;
                    if (i10 != 29) {
                        i11 = 39;
                        if (i10 != 39) {
                            i11 = 42;
                            if (i10 != 42) {
                                switch (i10) {
                                    case 1:
                                        return 1;
                                    case 2:
                                        return 2;
                                    case 3:
                                        return 3;
                                    case 4:
                                        return 4;
                                    case 5:
                                        return 5;
                                    case 6:
                                        return 6;
                                    default:
                                        return -1;
                                }
                            }
                        }
                    }
                }
            }
        }
        return i11;
    }

    private static void R(List list, final g gVar) {
        Collections.sort(list, new Comparator() { // from class: f1.f0
            @Override // java.util.Comparator
            public final int compare(Object obj, Object obj2) {
                int O;
                O = g0.O(g0.g.this, obj, obj2);
                return O;
            }
        });
    }

    private static int S(int i10) {
        if (i10 != 10) {
            if (i10 != 11) {
                if (i10 != 20) {
                    if (i10 != 21) {
                        if (i10 != 30) {
                            if (i10 != 31) {
                                if (i10 != 40) {
                                    if (i10 != 41) {
                                        if (i10 != 50) {
                                            if (i10 != 51) {
                                                switch (i10) {
                                                    case 60:
                                                        return 2048;
                                                    case 61:
                                                        return 4096;
                                                    case 62:
                                                        return 8192;
                                                    default:
                                                        return -1;
                                                }
                                            }
                                            return 512;
                                        }
                                        return 256;
                                    }
                                    return 128;
                                }
                                return 64;
                            }
                            return 32;
                        }
                        return 16;
                    }
                    return 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    private static int T(int i10) {
        if (i10 != 0) {
            if (i10 != 1) {
                if (i10 != 2) {
                    return i10 != 3 ? -1 : 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    private static void e(String str, List list) {
        if ("audio/raw".equals(str)) {
            if (s0.j0.f12742a < 26 && s0.j0.f12743b.equals("R9") && list.size() == 1 && ((r) list.get(0)).f7641a.equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                list.add(r.C("OMX.google.raw.decoder", "audio/raw", "audio/raw", null, false, true, false, false, false));
            }
            R(list, new g() { // from class: f1.d0
                @Override // f1.g0.g
                public final int a(Object obj) {
                    int L;
                    L = g0.L((r) obj);
                    return L;
                }
            });
        }
        int i10 = s0.j0.f12742a;
        if (i10 < 21 && list.size() > 1) {
            String str2 = ((r) list.get(0)).f7641a;
            if ("OMX.SEC.mp3.dec".equals(str2) || "OMX.SEC.MP3.Decoder".equals(str2) || "OMX.brcm.audio.mp3.decoder".equals(str2)) {
                R(list, new g() { // from class: f1.e0
                    @Override // f1.g0.g
                    public final int a(Object obj) {
                        int M;
                        M = g0.M((r) obj);
                        return M;
                    }
                });
            }
        }
        if (i10 >= 32 || list.size() <= 1 || !"OMX.qti.audio.decoder.flac".equals(((r) list.get(0)).f7641a)) {
            return;
        }
        list.add((r) list.remove(0));
    }

    private static int f(int i10) {
        switch (i10) {
            case 0:
                return 1;
            case 1:
                return 2;
            case 2:
                return 4;
            case 3:
                return 8;
            case 4:
                return 16;
            case 5:
                return 32;
            case 6:
                return 64;
            case 7:
                return 128;
            case 8:
                return 256;
            case 9:
                return 512;
            case 10:
                return 1024;
            case 11:
                return 2048;
            case 12:
                return 4096;
            case 13:
                return 8192;
            case 14:
                return 16384;
            case 15:
                return 32768;
            case 16:
                return 65536;
            case 17:
                return 131072;
            case 18:
                return 262144;
            case 19:
                return 524288;
            case 20:
                return 1048576;
            case 21:
                return 2097152;
            case 22:
                return 4194304;
            case 23:
                return 8388608;
            default:
                return -1;
        }
    }

    private static int g(int i10) {
        switch (i10) {
            case 10:
                return 1;
            case 11:
                return 4;
            case 12:
                return 8;
            case 13:
                return 16;
            default:
                switch (i10) {
                    case 20:
                        return 32;
                    case 21:
                        return 64;
                    case 22:
                        return 128;
                    default:
                        switch (i10) {
                            case 30:
                                return 256;
                            case 31:
                                return 512;
                            case 32:
                                return 1024;
                            default:
                                switch (i10) {
                                    case c6.k.f5348a4 /* 40 */:
                                        return 2048;
                                    case c6.k.f5354b4 /* 41 */:
                                        return 4096;
                                    case c6.k.f5360c4 /* 42 */:
                                        return 8192;
                                    default:
                                        switch (i10) {
                                            case 50:
                                                return 16384;
                                            case 51:
                                                return 32768;
                                            case 52:
                                                return 65536;
                                            default:
                                                return -1;
                                        }
                                }
                        }
                }
        }
    }

    private static int h(int i10) {
        if (i10 == 1 || i10 == 2) {
            return 25344;
        }
        switch (i10) {
            case 8:
            case 16:
            case 32:
                return 101376;
            case 64:
                return 202752;
            case 128:
            case 256:
                return 414720;
            case 512:
                return 921600;
            case 1024:
                return 1310720;
            case 2048:
            case 4096:
                return 2097152;
            case 8192:
                return 2228224;
            case 16384:
                return 5652480;
            case 32768:
            case 65536:
                return 9437184;
            case 131072:
            case 262144:
            case 524288:
                return 35651584;
            default:
                return -1;
        }
    }

    private static int i(int i10) {
        if (i10 != 66) {
            if (i10 != 77) {
                if (i10 != 88) {
                    if (i10 != 100) {
                        if (i10 != 110) {
                            if (i10 != 122) {
                                return i10 != 244 ? -1 : 64;
                            }
                            return 32;
                        }
                        return 16;
                    }
                    return 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    private static Integer j(String str) {
        int i10;
        if (str == null) {
            return null;
        }
        char c10 = 65535;
        switch (str.hashCode()) {
            case 1537:
                if (str.equals("01")) {
                    c10 = 0;
                    break;
                }
                break;
            case 1538:
                if (str.equals("02")) {
                    c10 = 1;
                    break;
                }
                break;
            case 1539:
                if (str.equals("03")) {
                    c10 = 2;
                    break;
                }
                break;
            case 1540:
                if (str.equals("04")) {
                    c10 = 3;
                    break;
                }
                break;
            case 1541:
                if (str.equals("05")) {
                    c10 = 4;
                    break;
                }
                break;
            case 1542:
                if (str.equals("06")) {
                    c10 = 5;
                    break;
                }
                break;
            case 1543:
                if (str.equals("07")) {
                    c10 = 6;
                    break;
                }
                break;
            case 1544:
                if (str.equals("08")) {
                    c10 = 7;
                    break;
                }
                break;
            case 1545:
                if (str.equals("09")) {
                    c10 = '\b';
                    break;
                }
                break;
            case 1567:
                if (str.equals("10")) {
                    c10 = '\t';
                    break;
                }
                break;
            case 1568:
                if (str.equals("11")) {
                    c10 = '\n';
                    break;
                }
                break;
            case 1569:
                if (str.equals("12")) {
                    c10 = 11;
                    break;
                }
                break;
            case 1570:
                if (str.equals("13")) {
                    c10 = '\f';
                    break;
                }
                break;
        }
        switch (c10) {
            case 0:
                return 1;
            case 1:
                return 2;
            case 2:
                return 4;
            case 3:
                return 8;
            case 4:
                i10 = 16;
                break;
            case 5:
                i10 = 32;
                break;
            case 6:
                i10 = 64;
                break;
            case 7:
                i10 = 128;
                break;
            case '\b':
                i10 = 256;
                break;
            case '\t':
                i10 = 512;
                break;
            case '\n':
                i10 = 1024;
                break;
            case 11:
                i10 = 2048;
                break;
            case '\f':
                i10 = 4096;
                break;
            default:
                return null;
        }
        return Integer.valueOf(i10);
    }

    private static Integer k(String str) {
        int i10;
        if (str == null) {
            return null;
        }
        char c10 = 65535;
        switch (str.hashCode()) {
            case 1536:
                if (str.equals("00")) {
                    c10 = 0;
                    break;
                }
                break;
            case 1537:
                if (str.equals("01")) {
                    c10 = 1;
                    break;
                }
                break;
            case 1538:
                if (str.equals("02")) {
                    c10 = 2;
                    break;
                }
                break;
            case 1539:
                if (str.equals("03")) {
                    c10 = 3;
                    break;
                }
                break;
            case 1540:
                if (str.equals("04")) {
                    c10 = 4;
                    break;
                }
                break;
            case 1541:
                if (str.equals("05")) {
                    c10 = 5;
                    break;
                }
                break;
            case 1542:
                if (str.equals("06")) {
                    c10 = 6;
                    break;
                }
                break;
            case 1543:
                if (str.equals("07")) {
                    c10 = 7;
                    break;
                }
                break;
            case 1544:
                if (str.equals("08")) {
                    c10 = '\b';
                    break;
                }
                break;
            case 1545:
                if (str.equals("09")) {
                    c10 = '\t';
                    break;
                }
                break;
            case 1567:
                if (str.equals("10")) {
                    c10 = '\n';
                    break;
                }
                break;
        }
        switch (c10) {
            case 0:
                return 1;
            case 1:
                return 2;
            case 2:
                return 4;
            case 3:
                return 8;
            case 4:
                i10 = 16;
                break;
            case 5:
                i10 = 32;
                break;
            case 6:
                i10 = 64;
                break;
            case 7:
                i10 = 128;
                break;
            case '\b':
                i10 = 256;
                break;
            case '\t':
                i10 = 512;
                break;
            case '\n':
                i10 = 1024;
                break;
            default:
                return null;
        }
        return Integer.valueOf(i10);
    }

    private static Pair l(String str, String[] strArr) {
        int Q;
        if (strArr.length != 3) {
            s0.o.h("MediaCodecUtil", "Ignoring malformed MP4A codec string: " + str);
            return null;
        }
        try {
            if ("audio/mp4a-latm".equals(p0.y.h(Integer.parseInt(strArr[1], 16))) && (Q = Q(Integer.parseInt(strArr[2]))) != -1) {
                return new Pair(Integer.valueOf(Q), 0);
            }
        } catch (NumberFormatException unused) {
            s0.o.h("MediaCodecUtil", "Ignoring malformed MP4A codec string: " + str);
        }
        return null;
    }

    public static String m(p0.p pVar) {
        Pair r10;
        if ("audio/eac3-joc".equals(pVar.f11208n)) {
            return "audio/eac3";
        }
        if (!"video/dolby-vision".equals(pVar.f11208n) || (r10 = r(pVar)) == null) {
            return null;
        }
        int intValue = ((Integer) r10.first).intValue();
        if (intValue == 16 || intValue == 256) {
            return "video/hevc";
        }
        if (intValue == 512) {
            return "video/avc";
        }
        if (intValue == 1024) {
            return "video/av01";
        }
        return null;
    }

    public static List n(x xVar, p0.p pVar, boolean z9, boolean z10) {
        String m10 = m(pVar);
        return m10 == null ? r6.v.y() : xVar.a(m10, z9, z10);
    }

    private static Pair o(String str, String[] strArr, p0.g gVar) {
        StringBuilder sb;
        int parseInt;
        int parseInt2;
        int parseInt3;
        StringBuilder sb2;
        int i10;
        String sb3;
        if (strArr.length >= 4) {
            try {
                parseInt = Integer.parseInt(strArr[1]);
                parseInt2 = Integer.parseInt(strArr[2].substring(0, 2));
                parseInt3 = Integer.parseInt(strArr[3]);
            } catch (NumberFormatException unused) {
                sb = new StringBuilder();
            }
            if (parseInt != 0) {
                sb2 = new StringBuilder();
                sb2.append("Unknown AV1 profile: ");
                sb2.append(parseInt);
            } else if (parseInt3 != 8 && parseInt3 != 10) {
                sb = new StringBuilder();
                sb.append("Unknown AV1 bit depth: ");
                sb.append(parseInt3);
                sb3 = sb.toString();
                s0.o.h("MediaCodecUtil", sb3);
                return null;
            } else {
                int i11 = parseInt3 != 8 ? (gVar == null || !(gVar.f10996d != null || (i10 = gVar.f10995c) == 7 || i10 == 6)) ? 2 : 4096 : 1;
                int f10 = f(parseInt2);
                if (f10 != -1) {
                    return new Pair(Integer.valueOf(i11), Integer.valueOf(f10));
                }
                sb2 = new StringBuilder();
                sb2.append("Unknown AV1 level: ");
                sb2.append(parseInt2);
            }
            sb3 = sb2.toString();
            s0.o.h("MediaCodecUtil", sb3);
            return null;
        }
        sb = new StringBuilder();
        sb.append("Ignoring malformed AV1 codec string: ");
        sb.append(str);
        sb3 = sb.toString();
        s0.o.h("MediaCodecUtil", sb3);
        return null;
    }

    private static Pair p(String str, String[] strArr) {
        StringBuilder sb;
        int parseInt;
        int i10;
        int i11;
        String str2;
        if (strArr.length >= 2) {
            try {
                if (strArr[1].length() == 6) {
                    i10 = Integer.parseInt(strArr[1].substring(0, 2), 16);
                    parseInt = Integer.parseInt(strArr[1].substring(4), 16);
                } else if (strArr.length < 3) {
                    s0.o.h("MediaCodecUtil", "Ignoring malformed AVC codec string: " + str);
                    return null;
                } else {
                    int parseInt2 = Integer.parseInt(strArr[1]);
                    parseInt = Integer.parseInt(strArr[2]);
                    i10 = parseInt2;
                }
                i11 = i(i10);
            } catch (NumberFormatException unused) {
                sb = new StringBuilder();
            }
            if (i11 == -1) {
                str2 = "Unknown AVC profile: " + i10;
                s0.o.h("MediaCodecUtil", str2);
                return null;
            }
            int g10 = g(parseInt);
            if (g10 == -1) {
                sb = new StringBuilder();
                sb.append("Unknown AVC level: ");
                sb.append(parseInt);
                str2 = sb.toString();
                s0.o.h("MediaCodecUtil", str2);
                return null;
            }
            return new Pair(Integer.valueOf(i11), Integer.valueOf(g10));
        }
        sb = new StringBuilder();
        sb.append("Ignoring malformed AVC codec string: ");
        sb.append(str);
        str2 = sb.toString();
        s0.o.h("MediaCodecUtil", str2);
        return null;
    }

    private static String q(MediaCodecInfo mediaCodecInfo, String str, String str2) {
        String[] supportedTypes;
        for (String str3 : mediaCodecInfo.getSupportedTypes()) {
            if (str3.equalsIgnoreCase(str2)) {
                return str3;
            }
        }
        if (str2.equals("video/dolby-vision")) {
            if ("OMX.MS.HEVCDV.Decoder".equals(str)) {
                return "video/hevcdv";
            }
            if ("OMX.RTK.video.decoder".equals(str) || "OMX.realtek.video.decoder.tunneled".equals(str)) {
                return "video/dv_hevc";
            }
            return null;
        } else if (str2.equals("audio/alac") && "OMX.lge.alac.decoder".equals(str)) {
            return "audio/x-lg-alac";
        } else {
            if (str2.equals("audio/flac") && "OMX.lge.flac.decoder".equals(str)) {
                return "audio/x-lg-flac";
            }
            if (str2.equals("audio/ac3") && "OMX.lge.ac3.decoder".equals(str)) {
                return "audio/lg-ac3";
            }
            return null;
        }
    }

    /* JADX WARN: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARN: Code restructure failed: missing block: B:37:0x0075, code lost:
        if (r3.equals("av01") == false) goto L11;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public static Pair r(p0.p pVar) {
        String str = pVar.f11204j;
        if (str == null) {
            return null;
        }
        String[] split = str.split("\\.");
        if ("video/dolby-vision".equals(pVar.f11208n)) {
            return y(pVar.f11204j, split);
        }
        char c10 = 0;
        String str2 = split[0];
        str2.hashCode();
        switch (str2.hashCode()) {
            case 3004662:
                break;
            case 3006243:
                if (str2.equals("avc1")) {
                    c10 = 1;
                    break;
                }
                c10 = 65535;
                break;
            case 3006244:
                if (str2.equals("avc2")) {
                    c10 = 2;
                    break;
                }
                c10 = 65535;
                break;
            case 3199032:
                if (str2.equals("hev1")) {
                    c10 = 3;
                    break;
                }
                c10 = 65535;
                break;
            case 3214780:
                if (str2.equals("hvc1")) {
                    c10 = 4;
                    break;
                }
                c10 = 65535;
                break;
            case 3356560:
                if (str2.equals("mp4a")) {
                    c10 = 5;
                    break;
                }
                c10 = 65535;
                break;
            case 3624515:
                if (str2.equals("vp09")) {
                    c10 = 6;
                    break;
                }
                c10 = 65535;
                break;
            default:
                c10 = 65535;
                break;
        }
        switch (c10) {
            case 0:
                return o(pVar.f11204j, split, pVar.A);
            case 1:
            case 2:
                return p(pVar.f11204j, split);
            case 3:
            case 4:
                return z(pVar.f11204j, split, pVar.A);
            case 5:
                return l(pVar.f11204j, split);
            case 6:
                return A(pVar.f11204j, split);
            default:
                return null;
        }
    }

    public static r s(String str, boolean z9, boolean z10) {
        List t9 = t(str, z9, z10);
        if (t9.isEmpty()) {
            return null;
        }
        return (r) t9.get(0);
    }

    public static synchronized List t(String str, boolean z9, boolean z10) {
        synchronized (g0.class) {
            b bVar = new b(str, z9, z10);
            HashMap hashMap = f7582b;
            List list = (List) hashMap.get(bVar);
            if (list != null) {
                return list;
            }
            int i10 = s0.j0.f12742a;
            ArrayList u9 = u(bVar, i10 >= 21 ? new f(z9, z10) : new e());
            if (z9 && u9.isEmpty() && 21 <= i10 && i10 <= 23) {
                u9 = u(bVar, new e());
                if (!u9.isEmpty()) {
                    s0.o.h("MediaCodecUtil", "MediaCodecList API didn't list secure decoder for: " + str + ". Assuming: " + ((r) u9.get(0)).f7641a);
                }
            }
            e(str, u9);
            r6.v u10 = r6.v.u(u9);
            hashMap.put(bVar, u10);
            return u10;
        }
    }

    /* JADX WARN: Can't wrap try/catch for region: R(7:28|(4:(2:72|73)|53|(9:56|57|58|59|60|61|62|64|65)|9)|32|33|34|36|9) */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x007f, code lost:
        if (r1.f7585b == false) goto L32;
     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x00a4, code lost:
        r0 = e;
     */
    /* JADX WARN: Code restructure failed: missing block: B:36:0x00a5, code lost:
        r1 = r11;
     */
    /* JADX WARN: Removed duplicated region for block: B:57:0x0101 A[Catch: Exception -> 0x014f, TRY_ENTER, TryCatch #1 {Exception -> 0x014f, blocks: (B:3:0x0008, B:5:0x001b, B:60:0x0120, B:8:0x002d, B:11:0x0038, B:54:0x00f9, B:57:0x0101, B:59:0x0107, B:61:0x012a, B:62:0x014d), top: B:69:0x0008 }] */
    /* JADX WARN: Removed duplicated region for block: B:82:0x012a A[ADDED_TO_REGION, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private static ArrayList u(b bVar, d dVar) {
        String q10;
        String str;
        String str2;
        int i10;
        boolean z9;
        int i11;
        MediaCodecInfo.CodecCapabilities capabilitiesForType;
        boolean b10;
        boolean c10;
        boolean z10;
        b bVar2 = bVar;
        try {
            ArrayList arrayList = new ArrayList();
            String str3 = bVar2.f7584a;
            int d10 = dVar.d();
            boolean e10 = dVar.e();
            int i12 = 0;
            while (i12 < d10) {
                MediaCodecInfo a10 = dVar.a(i12);
                if (!C(a10)) {
                    String name = a10.getName();
                    if (E(a10, name, e10, str3) && (q10 = q(a10, name, str3)) != null) {
                        try {
                            capabilitiesForType = a10.getCapabilitiesForType(q10);
                            b10 = dVar.b("tunneled-playback", q10, capabilitiesForType);
                            c10 = dVar.c("tunneled-playback", q10, capabilitiesForType);
                            z10 = bVar2.f7586c;
                        } catch (Exception e11) {
                            e = e11;
                            str = q10;
                            str2 = name;
                            i10 = i12;
                            z9 = e10;
                            i11 = d10;
                        }
                        if ((z10 || !c10) && (!z10 || b10)) {
                            boolean b11 = dVar.b("secure-playback", q10, capabilitiesForType);
                            boolean c11 = dVar.c("secure-playback", q10, capabilitiesForType);
                            boolean z11 = bVar2.f7585b;
                            if ((z11 || !c11) && (!z11 || b11)) {
                                boolean F = F(a10, str3);
                                boolean H = H(a10, str3);
                                boolean J = J(a10);
                                if (!e10 || bVar2.f7585b != b11) {
                                    if (!e10) {
                                        try {
                                        } catch (Exception e12) {
                                            e = e12;
                                            str = q10;
                                            i10 = i12;
                                            z9 = e10;
                                            i11 = d10;
                                            str2 = name;
                                            if (s0.j0.f12742a > 23) {
                                            }
                                            s0.o.c("MediaCodecUtil", "Failed to query codec " + str2 + " (" + str + ")");
                                            throw e;
                                        }
                                    }
                                    str = q10;
                                    i10 = i12;
                                    z9 = e10;
                                    i11 = d10;
                                    if (!z9 && b11) {
                                        StringBuilder sb = new StringBuilder();
                                        try {
                                            sb.append(name);
                                            sb.append(".secure");
                                            str2 = name;
                                        } catch (Exception e13) {
                                            e = e13;
                                            str2 = name;
                                        }
                                        try {
                                            arrayList.add(r.C(sb.toString(), str3, str, capabilitiesForType, F, H, J, false, true));
                                            return arrayList;
                                        } catch (Exception e14) {
                                            e = e14;
                                            if (s0.j0.f12742a > 23 || arrayList.isEmpty()) {
                                                s0.o.c("MediaCodecUtil", "Failed to query codec " + str2 + " (" + str + ")");
                                                throw e;
                                            }
                                            s0.o.c("MediaCodecUtil", "Skipping codec " + str2 + " (failed to query capabilities)");
                                            i12 = i10 + 1;
                                            bVar2 = bVar;
                                            d10 = i11;
                                            e10 = z9;
                                        }
                                    }
                                    i12 = i10 + 1;
                                    bVar2 = bVar;
                                    d10 = i11;
                                    e10 = z9;
                                }
                                str = q10;
                                i10 = i12;
                                z9 = e10;
                                i11 = d10;
                                arrayList.add(r.C(name, str3, q10, capabilitiesForType, F, H, J, false, false));
                                i12 = i10 + 1;
                                bVar2 = bVar;
                                d10 = i11;
                                e10 = z9;
                            }
                        }
                    }
                }
                i10 = i12;
                z9 = e10;
                i11 = d10;
                i12 = i10 + 1;
                bVar2 = bVar;
                d10 = i11;
                e10 = z9;
            }
            return arrayList;
        } catch (Exception e15) {
            throw new c(e15);
        }
    }

    public static List v(x xVar, p0.p pVar, boolean z9, boolean z10) {
        List a10 = xVar.a(pVar.f11208n, z9, z10);
        return r6.v.r().j(a10).j(n(xVar, pVar, z9, z10)).k();
    }

    public static List w(List list, final p0.p pVar) {
        ArrayList arrayList = new ArrayList(list);
        R(arrayList, new g() { // from class: f1.c0
            @Override // f1.g0.g
            public final int a(Object obj) {
                int N;
                N = g0.N(p0.p.this, (r) obj);
                return N;
            }
        });
        return arrayList;
    }

    public static r x() {
        return s("audio/raw", false, false);
    }

    private static Pair y(String str, String[] strArr) {
        StringBuilder sb;
        String str2;
        if (strArr.length < 3) {
            sb = new StringBuilder();
        } else {
            Matcher matcher = f7581a.matcher(strArr[1]);
            if (matcher.matches()) {
                str = matcher.group(1);
                Integer k10 = k(str);
                if (k10 == null) {
                    sb = new StringBuilder();
                    str2 = "Unknown Dolby Vision profile string: ";
                } else {
                    str = strArr[2];
                    Integer j10 = j(str);
                    if (j10 != null) {
                        return new Pair(k10, j10);
                    }
                    sb = new StringBuilder();
                    str2 = "Unknown Dolby Vision level string: ";
                }
                sb.append(str2);
                sb.append(str);
                s0.o.h("MediaCodecUtil", sb.toString());
                return null;
            }
            sb = new StringBuilder();
        }
        sb.append("Ignoring malformed Dolby Vision codec string: ");
        sb.append(str);
        s0.o.h("MediaCodecUtil", sb.toString());
        return null;
    }

    private static Pair z(String str, String[] strArr, p0.g gVar) {
        StringBuilder sb;
        String str2;
        if (strArr.length < 4) {
            sb = new StringBuilder();
        } else {
            int i10 = 1;
            Matcher matcher = f7581a.matcher(strArr[1]);
            if (matcher.matches()) {
                str = matcher.group(1);
                if (!"1".equals(str)) {
                    if (!"2".equals(str)) {
                        sb = new StringBuilder();
                        str2 = "Unknown HEVC profile string: ";
                        sb.append(str2);
                        sb.append(str);
                        s0.o.h("MediaCodecUtil", sb.toString());
                        return null;
                    }
                    i10 = (gVar == null || gVar.f10995c != 6) ? 2 : 4096;
                }
                str = strArr[3];
                Integer B = B(str);
                if (B == null) {
                    sb = new StringBuilder();
                    str2 = "Unknown HEVC level string: ";
                    sb.append(str2);
                    sb.append(str);
                    s0.o.h("MediaCodecUtil", sb.toString());
                    return null;
                }
                return new Pair(Integer.valueOf(i10), B);
            }
            sb = new StringBuilder();
        }
        sb.append("Ignoring malformed HEVC codec string: ");
        sb.append(str);
        s0.o.h("MediaCodecUtil", sb.toString());
        return null;
    }
}
