package e4;

import android.os.Build;
import android.os.StrictMode;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
/* loaded from: classes.dex */
public final class b implements Closeable {

    /* renamed from: g  reason: collision with root package name */
    private final File f7426g;

    /* renamed from: h  reason: collision with root package name */
    private final File f7427h;

    /* renamed from: i  reason: collision with root package name */
    private final File f7428i;

    /* renamed from: j  reason: collision with root package name */
    private final File f7429j;

    /* renamed from: k  reason: collision with root package name */
    private final int f7430k;

    /* renamed from: l  reason: collision with root package name */
    private long f7431l;

    /* renamed from: m  reason: collision with root package name */
    private final int f7432m;

    /* renamed from: o  reason: collision with root package name */
    private Writer f7434o;

    /* renamed from: q  reason: collision with root package name */
    private int f7436q;

    /* renamed from: n  reason: collision with root package name */
    private long f7433n = 0;

    /* renamed from: p  reason: collision with root package name */
    private final LinkedHashMap f7435p = new LinkedHashMap(0, 0.75f, true);

    /* renamed from: r  reason: collision with root package name */
    private long f7437r = 0;

    /* renamed from: s  reason: collision with root package name */
    final ThreadPoolExecutor f7438s = new ThreadPoolExecutor(0, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue(), new ThreadFactoryC0119b(null));

    /* renamed from: t  reason: collision with root package name */
    private final Callable f7439t = new a();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Callable {
        a() {
        }

        @Override // java.util.concurrent.Callable
        /* renamed from: a */
        public Void call() {
            synchronized (b.this) {
                if (b.this.f7434o == null) {
                    return null;
                }
                b.this.W();
                if (b.this.L()) {
                    b.this.T();
                    b.this.f7436q = 0;
                }
                return null;
            }
        }
    }

    /* renamed from: e4.b$b  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    private static final class ThreadFactoryC0119b implements ThreadFactory {
        private ThreadFactoryC0119b() {
        }

        /* synthetic */ ThreadFactoryC0119b(a aVar) {
            this();
        }

        @Override // java.util.concurrent.ThreadFactory
        public synchronized Thread newThread(Runnable runnable) {
            Thread thread;
            thread = new Thread(runnable, "glide-disk-lru-cache-thread");
            thread.setPriority(1);
            return thread;
        }
    }

    /* loaded from: classes.dex */
    public final class c {

        /* renamed from: a  reason: collision with root package name */
        private final d f7441a;

        /* renamed from: b  reason: collision with root package name */
        private final boolean[] f7442b;

        /* renamed from: c  reason: collision with root package name */
        private boolean f7443c;

        private c(d dVar) {
            this.f7441a = dVar;
            this.f7442b = dVar.f7449e ? null : new boolean[b.this.f7432m];
        }

        /* synthetic */ c(b bVar, d dVar, a aVar) {
            this(dVar);
        }

        public void a() {
            b.this.A(this, false);
        }

        public void b() {
            if (this.f7443c) {
                return;
            }
            try {
                a();
            } catch (IOException unused) {
            }
        }

        public void e() {
            b.this.A(this, true);
            this.f7443c = true;
        }

        public File f(int i10) {
            File k10;
            synchronized (b.this) {
                if (this.f7441a.f7450f != this) {
                    throw new IllegalStateException();
                }
                if (!this.f7441a.f7449e) {
                    this.f7442b[i10] = true;
                }
                k10 = this.f7441a.k(i10);
                b.this.f7426g.mkdirs();
            }
            return k10;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class d {

        /* renamed from: a  reason: collision with root package name */
        private final String f7445a;

        /* renamed from: b  reason: collision with root package name */
        private final long[] f7446b;

        /* renamed from: c  reason: collision with root package name */
        File[] f7447c;

        /* renamed from: d  reason: collision with root package name */
        File[] f7448d;

        /* renamed from: e  reason: collision with root package name */
        private boolean f7449e;

        /* renamed from: f  reason: collision with root package name */
        private c f7450f;

        /* renamed from: g  reason: collision with root package name */
        private long f7451g;

        private d(String str) {
            this.f7445a = str;
            this.f7446b = new long[b.this.f7432m];
            this.f7447c = new File[b.this.f7432m];
            this.f7448d = new File[b.this.f7432m];
            StringBuilder sb = new StringBuilder(str);
            sb.append('.');
            int length = sb.length();
            for (int i10 = 0; i10 < b.this.f7432m; i10++) {
                sb.append(i10);
                this.f7447c[i10] = new File(b.this.f7426g, sb.toString());
                sb.append(".tmp");
                this.f7448d[i10] = new File(b.this.f7426g, sb.toString());
                sb.setLength(length);
            }
        }

        /* synthetic */ d(b bVar, String str, a aVar) {
            this(str);
        }

        private IOException m(String[] strArr) {
            throw new IOException("unexpected journal line: " + Arrays.toString(strArr));
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void n(String[] strArr) {
            if (strArr.length != b.this.f7432m) {
                throw m(strArr);
            }
            for (int i10 = 0; i10 < strArr.length; i10++) {
                try {
                    this.f7446b[i10] = Long.parseLong(strArr[i10]);
                } catch (NumberFormatException unused) {
                    throw m(strArr);
                }
            }
        }

        public File j(int i10) {
            return this.f7447c[i10];
        }

        public File k(int i10) {
            return this.f7448d[i10];
        }

        public String l() {
            long[] jArr;
            StringBuilder sb = new StringBuilder();
            for (long j10 : this.f7446b) {
                sb.append(' ');
                sb.append(j10);
            }
            return sb.toString();
        }
    }

    /* loaded from: classes.dex */
    public final class e {

        /* renamed from: a  reason: collision with root package name */
        private final String f7453a;

        /* renamed from: b  reason: collision with root package name */
        private final long f7454b;

        /* renamed from: c  reason: collision with root package name */
        private final long[] f7455c;

        /* renamed from: d  reason: collision with root package name */
        private final File[] f7456d;

        private e(String str, long j10, File[] fileArr, long[] jArr) {
            this.f7453a = str;
            this.f7454b = j10;
            this.f7456d = fileArr;
            this.f7455c = jArr;
        }

        /* synthetic */ e(b bVar, String str, long j10, File[] fileArr, long[] jArr, a aVar) {
            this(str, j10, fileArr, jArr);
        }

        public File a(int i10) {
            return this.f7456d[i10];
        }
    }

    private b(File file, int i10, int i11, long j10) {
        this.f7426g = file;
        this.f7430k = i10;
        this.f7427h = new File(file, "journal");
        this.f7428i = new File(file, "journal.tmp");
        this.f7429j = new File(file, "journal.bkp");
        this.f7432m = i11;
        this.f7431l = j10;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public synchronized void A(c cVar, boolean z9) {
        d dVar = cVar.f7441a;
        if (dVar.f7450f != cVar) {
            throw new IllegalStateException();
        }
        if (z9 && !dVar.f7449e) {
            for (int i10 = 0; i10 < this.f7432m; i10++) {
                if (!cVar.f7442b[i10]) {
                    cVar.a();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i10);
                } else if (!dVar.k(i10).exists()) {
                    cVar.a();
                    return;
                }
            }
        }
        for (int i11 = 0; i11 < this.f7432m; i11++) {
            File k10 = dVar.k(i11);
            if (!z9) {
                D(k10);
            } else if (k10.exists()) {
                File j10 = dVar.j(i11);
                k10.renameTo(j10);
                long j11 = dVar.f7446b[i11];
                long length = j10.length();
                dVar.f7446b[i11] = length;
                this.f7433n = (this.f7433n - j11) + length;
            }
        }
        this.f7436q++;
        dVar.f7450f = null;
        if (dVar.f7449e || z9) {
            dVar.f7449e = true;
            this.f7434o.append((CharSequence) "CLEAN");
            this.f7434o.append(' ');
            this.f7434o.append((CharSequence) dVar.f7445a);
            this.f7434o.append((CharSequence) dVar.l());
            this.f7434o.append('\n');
            if (z9) {
                long j12 = this.f7437r;
                this.f7437r = 1 + j12;
                dVar.f7451g = j12;
            }
        } else {
            this.f7435p.remove(dVar.f7445a);
            this.f7434o.append((CharSequence) "REMOVE");
            this.f7434o.append(' ');
            this.f7434o.append((CharSequence) dVar.f7445a);
            this.f7434o.append('\n');
        }
        H(this.f7434o);
        if (this.f7433n > this.f7431l || L()) {
            this.f7438s.submit(this.f7439t);
        }
    }

    private static void D(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private synchronized c G(String str, long j10) {
        v();
        d dVar = (d) this.f7435p.get(str);
        if (j10 == -1 || (dVar != null && dVar.f7451g == j10)) {
            if (dVar == null) {
                dVar = new d(this, str, null);
                this.f7435p.put(str, dVar);
            } else if (dVar.f7450f != null) {
                return null;
            }
            c cVar = new c(this, dVar, null);
            dVar.f7450f = cVar;
            this.f7434o.append((CharSequence) "DIRTY");
            this.f7434o.append(' ');
            this.f7434o.append((CharSequence) str);
            this.f7434o.append('\n');
            H(this.f7434o);
            return cVar;
        }
        return null;
    }

    private static void H(Writer writer) {
        StrictMode.ThreadPolicy.Builder permitUnbufferedIo;
        if (Build.VERSION.SDK_INT < 26) {
            writer.flush();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        permitUnbufferedIo = new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo();
        StrictMode.setThreadPolicy(permitUnbufferedIo.build());
        try {
            writer.flush();
        } finally {
            StrictMode.setThreadPolicy(threadPolicy);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean L() {
        int i10 = this.f7436q;
        return i10 >= 2000 && i10 >= this.f7435p.size();
    }

    public static b M(File file, int i10, int i11, long j10) {
        if (j10 > 0) {
            if (i11 > 0) {
                File file2 = new File(file, "journal.bkp");
                if (file2.exists()) {
                    File file3 = new File(file, "journal");
                    if (file3.exists()) {
                        file2.delete();
                    } else {
                        V(file2, file3, false);
                    }
                }
                b bVar = new b(file, i10, i11, j10);
                if (bVar.f7427h.exists()) {
                    try {
                        bVar.P();
                        bVar.O();
                        return bVar;
                    } catch (IOException e10) {
                        PrintStream printStream = System.out;
                        printStream.println("DiskLruCache " + file + " is corrupt: " + e10.getMessage() + ", removing");
                        bVar.C();
                    }
                }
                file.mkdirs();
                b bVar2 = new b(file, i10, i11, j10);
                bVar2.T();
                return bVar2;
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    private void O() {
        D(this.f7428i);
        Iterator it = this.f7435p.values().iterator();
        while (it.hasNext()) {
            d dVar = (d) it.next();
            int i10 = 0;
            if (dVar.f7450f == null) {
                while (i10 < this.f7432m) {
                    this.f7433n += dVar.f7446b[i10];
                    i10++;
                }
            } else {
                dVar.f7450f = null;
                while (i10 < this.f7432m) {
                    D(dVar.j(i10));
                    D(dVar.k(i10));
                    i10++;
                }
                it.remove();
            }
        }
    }

    private void P() {
        e4.c cVar = new e4.c(new FileInputStream(this.f7427h), e4.d.f7464a);
        try {
            String g10 = cVar.g();
            String g11 = cVar.g();
            String g12 = cVar.g();
            String g13 = cVar.g();
            String g14 = cVar.g();
            if (!"libcore.io.DiskLruCache".equals(g10) || !"1".equals(g11) || !Integer.toString(this.f7430k).equals(g12) || !Integer.toString(this.f7432m).equals(g13) || !"".equals(g14)) {
                throw new IOException("unexpected journal header: [" + g10 + ", " + g11 + ", " + g13 + ", " + g14 + "]");
            }
            int i10 = 0;
            while (true) {
                try {
                    R(cVar.g());
                    i10++;
                } catch (EOFException unused) {
                    this.f7436q = i10 - this.f7435p.size();
                    if (cVar.c()) {
                        T();
                    } else {
                        this.f7434o = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.f7427h, true), e4.d.f7464a));
                    }
                    e4.d.a(cVar);
                    return;
                }
            }
        } catch (Throwable th) {
            e4.d.a(cVar);
            throw th;
        }
    }

    private void R(String str) {
        String substring;
        int indexOf = str.indexOf(32);
        if (indexOf == -1) {
            throw new IOException("unexpected journal line: " + str);
        }
        int i10 = indexOf + 1;
        int indexOf2 = str.indexOf(32, i10);
        if (indexOf2 == -1) {
            substring = str.substring(i10);
            if (indexOf == 6 && str.startsWith("REMOVE")) {
                this.f7435p.remove(substring);
                return;
            }
        } else {
            substring = str.substring(i10, indexOf2);
        }
        d dVar = (d) this.f7435p.get(substring);
        if (dVar == null) {
            dVar = new d(this, substring, null);
            this.f7435p.put(substring, dVar);
        }
        if (indexOf2 != -1 && indexOf == 5 && str.startsWith("CLEAN")) {
            String[] split = str.substring(indexOf2 + 1).split(" ");
            dVar.f7449e = true;
            dVar.f7450f = null;
            dVar.n(split);
        } else if (indexOf2 == -1 && indexOf == 5 && str.startsWith("DIRTY")) {
            dVar.f7450f = new c(this, dVar, null);
        } else if (indexOf2 == -1 && indexOf == 4 && str.startsWith("READ")) {
        } else {
            throw new IOException("unexpected journal line: " + str);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public synchronized void T() {
        Writer writer = this.f7434o;
        if (writer != null) {
            y(writer);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.f7428i), e4.d.f7464a));
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.f7430k));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.f7432m));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (d dVar : this.f7435p.values()) {
            bufferedWriter.write(dVar.f7450f != null ? "DIRTY " + dVar.f7445a + '\n' : "CLEAN " + dVar.f7445a + dVar.l() + '\n');
        }
        y(bufferedWriter);
        if (this.f7427h.exists()) {
            V(this.f7427h, this.f7429j, true);
        }
        V(this.f7428i, this.f7427h, false);
        this.f7429j.delete();
        this.f7434o = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.f7427h, true), e4.d.f7464a));
    }

    private static void V(File file, File file2, boolean z9) {
        if (z9) {
            D(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void W() {
        while (this.f7433n > this.f7431l) {
            U((String) ((Map.Entry) this.f7435p.entrySet().iterator().next()).getKey());
        }
    }

    private void v() {
        if (this.f7434o == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    private static void y(Writer writer) {
        StrictMode.ThreadPolicy.Builder permitUnbufferedIo;
        if (Build.VERSION.SDK_INT < 26) {
            writer.close();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        permitUnbufferedIo = new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo();
        StrictMode.setThreadPolicy(permitUnbufferedIo.build());
        try {
            writer.close();
        } finally {
            StrictMode.setThreadPolicy(threadPolicy);
        }
    }

    public void C() {
        close();
        e4.d.b(this.f7426g);
    }

    public c E(String str) {
        return G(str, -1L);
    }

    public synchronized e J(String str) {
        v();
        d dVar = (d) this.f7435p.get(str);
        if (dVar == null) {
            return null;
        }
        if (dVar.f7449e) {
            for (File file : dVar.f7447c) {
                if (!file.exists()) {
                    return null;
                }
            }
            this.f7436q++;
            this.f7434o.append((CharSequence) "READ");
            this.f7434o.append(' ');
            this.f7434o.append((CharSequence) str);
            this.f7434o.append('\n');
            if (L()) {
                this.f7438s.submit(this.f7439t);
            }
            return new e(this, str, dVar.f7451g, dVar.f7447c, dVar.f7446b, null);
        }
        return null;
    }

    public synchronized boolean U(String str) {
        v();
        d dVar = (d) this.f7435p.get(str);
        if (dVar != null && dVar.f7450f == null) {
            for (int i10 = 0; i10 < this.f7432m; i10++) {
                File j10 = dVar.j(i10);
                if (j10.exists() && !j10.delete()) {
                    throw new IOException("failed to delete " + j10);
                }
                this.f7433n -= dVar.f7446b[i10];
                dVar.f7446b[i10] = 0;
            }
            this.f7436q++;
            this.f7434o.append((CharSequence) "REMOVE");
            this.f7434o.append(' ');
            this.f7434o.append((CharSequence) str);
            this.f7434o.append('\n');
            this.f7435p.remove(str);
            if (L()) {
                this.f7438s.submit(this.f7439t);
            }
            return true;
        }
        return false;
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public synchronized void close() {
        if (this.f7434o == null) {
            return;
        }
        Iterator it = new ArrayList(this.f7435p.values()).iterator();
        while (it.hasNext()) {
            d dVar = (d) it.next();
            if (dVar.f7450f != null) {
                dVar.f7450f.a();
            }
        }
        W();
        y(this.f7434o);
        this.f7434o = null;
    }
}
