package e3;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
/* loaded from: classes.dex */
public final class o0 implements i3.k, g {

    /* renamed from: g  reason: collision with root package name */
    private final Context f7373g;

    /* renamed from: h  reason: collision with root package name */
    private final String f7374h;

    /* renamed from: i  reason: collision with root package name */
    private final File f7375i;

    /* renamed from: j  reason: collision with root package name */
    private final Callable f7376j;

    /* renamed from: k  reason: collision with root package name */
    private final int f7377k;

    /* renamed from: l  reason: collision with root package name */
    private final i3.k f7378l;

    /* renamed from: m  reason: collision with root package name */
    private f f7379m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f7380n;

    public o0(Context context, String str, File file, Callable callable, int i10, i3.k delegate) {
        kotlin.jvm.internal.k.e(context, "context");
        kotlin.jvm.internal.k.e(delegate, "delegate");
        this.f7373g = context;
        this.f7374h = str;
        this.f7375i = file;
        this.f7376j = callable;
        this.f7377k = i10;
        this.f7378l = delegate;
    }

    private final void b(File file, boolean z9) {
        ReadableByteChannel newChannel;
        String str;
        if (this.f7374h != null) {
            newChannel = Channels.newChannel(this.f7373g.getAssets().open(this.f7374h));
            str = "newChannel(context.assets.open(copyFromAssetPath))";
        } else if (this.f7375i != null) {
            newChannel = new FileInputStream(this.f7375i).getChannel();
            str = "FileInputStream(copyFromFile).channel";
        } else {
            Callable callable = this.f7376j;
            if (callable == null) {
                throw new IllegalStateException("copyFromAssetPath, copyFromFile and copyFromInputStream are all null!");
            }
            try {
                newChannel = Channels.newChannel((InputStream) callable.call());
                str = "newChannel(inputStream)";
            } catch (Exception e10) {
                throw new IOException("inputStreamCallable exception on call", e10);
            }
        }
        kotlin.jvm.internal.k.d(newChannel, str);
        File intermediateFile = File.createTempFile("room-copy-helper", ".tmp", this.f7373g.getCacheDir());
        intermediateFile.deleteOnExit();
        FileChannel output = new FileOutputStream(intermediateFile).getChannel();
        kotlin.jvm.internal.k.d(output, "output");
        g3.c.a(newChannel, output);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create directories for " + file.getAbsolutePath());
        }
        kotlin.jvm.internal.k.d(intermediateFile, "intermediateFile");
        c(intermediateFile, z9);
        if (intermediateFile.renameTo(file)) {
            return;
        }
        throw new IOException("Failed to move intermediate file (" + intermediateFile.getAbsolutePath() + ") to destination (" + file.getAbsolutePath() + ").");
    }

    private final void c(File file, boolean z9) {
        f fVar = this.f7379m;
        if (fVar == null) {
            kotlin.jvm.internal.k.o("databaseConfiguration");
            fVar = null;
        }
        fVar.getClass();
    }

    private final void k(boolean z9) {
        String databaseName = getDatabaseName();
        if (databaseName == null) {
            throw new IllegalStateException("Required value was null.".toString());
        }
        File databaseFile = this.f7373g.getDatabasePath(databaseName);
        f fVar = this.f7379m;
        f fVar2 = null;
        if (fVar == null) {
            kotlin.jvm.internal.k.o("databaseConfiguration");
            fVar = null;
        }
        boolean z10 = fVar.f7261s;
        File filesDir = this.f7373g.getFilesDir();
        kotlin.jvm.internal.k.d(filesDir, "context.filesDir");
        k3.a aVar = new k3.a(databaseName, filesDir, z10);
        try {
            k3.a.c(aVar, false, 1, null);
            if (!databaseFile.exists()) {
                try {
                    kotlin.jvm.internal.k.d(databaseFile, "databaseFile");
                    b(databaseFile, z9);
                    aVar.d();
                    return;
                } catch (IOException e10) {
                    throw new RuntimeException("Unable to copy database file.", e10);
                }
            }
            try {
                kotlin.jvm.internal.k.d(databaseFile, "databaseFile");
                int c10 = g3.b.c(databaseFile);
                if (c10 == this.f7377k) {
                    aVar.d();
                    return;
                }
                f fVar3 = this.f7379m;
                if (fVar3 == null) {
                    kotlin.jvm.internal.k.o("databaseConfiguration");
                } else {
                    fVar2 = fVar3;
                }
                if (fVar2.a(c10, this.f7377k)) {
                    aVar.d();
                    return;
                }
                if (this.f7373g.deleteDatabase(databaseName)) {
                    try {
                        b(databaseFile, z9);
                    } catch (IOException e11) {
                        Log.w("ROOM", "Unable to copy database file.", e11);
                    }
                } else {
                    Log.w("ROOM", "Failed to delete database file (" + databaseName + ") for a copy destructive migration.");
                }
                aVar.d();
                return;
            } catch (IOException e12) {
                Log.w("ROOM", "Unable to read database version.", e12);
                aVar.d();
                return;
            }
        } catch (Throwable th) {
            aVar.d();
            throw th;
        }
        aVar.d();
        throw th;
    }

    @Override // e3.g
    public i3.k a() {
        return this.f7378l;
    }

    @Override // i3.k, java.io.Closeable, java.lang.AutoCloseable
    public synchronized void close() {
        a().close();
        this.f7380n = false;
    }

    public final void g(f databaseConfiguration) {
        kotlin.jvm.internal.k.e(databaseConfiguration, "databaseConfiguration");
        this.f7379m = databaseConfiguration;
    }

    @Override // i3.k
    public String getDatabaseName() {
        return a().getDatabaseName();
    }

    @Override // i3.k
    public void setWriteAheadLoggingEnabled(boolean z9) {
        a().setWriteAheadLoggingEnabled(z9);
    }

    @Override // i3.k
    public i3.j w() {
        if (!this.f7380n) {
            k(true);
            this.f7380n = true;
        }
        return a().w();
    }
}
