package d4;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import androidx.core.app.n0;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
final class t implements PluginRegistry.ActivityResultListener, PluginRegistry.RequestPermissionsResultListener {

    /* renamed from: g  reason: collision with root package name */
    private final Context f6875g;

    /* renamed from: h  reason: collision with root package name */
    private b f6876h;

    /* renamed from: i  reason: collision with root package name */
    private Activity f6877i;

    /* renamed from: j  reason: collision with root package name */
    private int f6878j;

    /* renamed from: k  reason: collision with root package name */
    private Map f6879k;

    /* loaded from: classes.dex */
    interface a {
        void a(int i10);
    }

    /* loaded from: classes.dex */
    interface b {
        void a(Map map);
    }

    /* loaded from: classes.dex */
    interface c {
        void a(boolean z9);
    }

    public t(Context context) {
        this.f6875g = context;
    }

    private int a() {
        List c10 = v.c(this.f6875g, 21);
        if (c10 == null || c10.isEmpty()) {
            Log.d("permissions_handler", "Bluetooth permission missing in manifest");
            return 0;
        }
        return 1;
    }

    private int b() {
        int checkSelfPermission;
        if (Build.VERSION.SDK_INT < 33) {
            return n0.e(this.f6875g).a() ? 1 : 0;
        }
        checkSelfPermission = this.f6875g.checkSelfPermission("android.permission.POST_NOTIFICATIONS");
        if (checkSelfPermission == 0) {
            return 1;
        }
        return v.b(this.f6877i, "android.permission.POST_NOTIFICATIONS");
    }

    /* JADX WARN: Code restructure failed: missing block: B:58:0x00cb, code lost:
        if (r6 != false) goto L78;
     */
    /* JADX WARN: Code restructure failed: missing block: B:98:0x0163, code lost:
        if (r12 == 0) goto L78;
     */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r6v13, types: [int] */
    /* JADX WARN: Type inference failed for: r6v30 */
    /* JADX WARN: Type inference failed for: r6v32 */
    /* JADX WARN: Type inference failed for: r6v33 */
    /* JADX WARN: Type inference failed for: r6v34 */
    /* JADX WARN: Type inference failed for: r6v35 */
    /* JADX WARN: Type inference failed for: r6v36 */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private int d(int i10) {
        int i11;
        boolean isIgnoringBatteryOptimizations;
        boolean isExternalStorageManager;
        int i12;
        boolean canDrawOverlays;
        boolean canRequestPackageInstalls;
        boolean isNotificationPolicyAccessGranted;
        boolean canScheduleExactAlarms;
        if (i10 == 17) {
            return b();
        }
        if (i10 == 21) {
            return a();
        }
        if ((i10 == 30 || i10 == 28 || i10 == 29) && Build.VERSION.SDK_INT < 31) {
            return a();
        }
        if ((i10 == 37 || i10 == 0) && !e()) {
            return 0;
        }
        List<String> c10 = v.c(this.f6875g, i10);
        if (c10 == null) {
            Log.d("permissions_handler", "No android specific permissions needed for: " + i10);
            return 1;
        } else if (c10.size() == 0) {
            Log.d("permissions_handler", "No permissions found in manifest for: " + c10 + i10);
            if (i10 != 16 || Build.VERSION.SDK_INT >= 23) {
                if (i10 != 22 || Build.VERSION.SDK_INT >= 30) {
                    return Build.VERSION.SDK_INT < 23 ? 1 : 0;
                }
                return 2;
            }
            return 2;
        } else {
            if (this.f6875g.getApplicationInfo().targetSdkVersion >= 23) {
                HashSet hashSet = new HashSet();
                for (String str : c10) {
                    if (i10 == 16) {
                        String packageName = this.f6875g.getPackageName();
                        PowerManager powerManager = (PowerManager) this.f6875g.getSystemService("power");
                        if (powerManager != null) {
                            isIgnoringBatteryOptimizations = powerManager.isIgnoringBatteryOptimizations(packageName);
                        }
                        i11 = 0;
                        hashSet.add(i11);
                    } else {
                        if (i10 == 22) {
                            if (Build.VERSION.SDK_INT < 30) {
                                hashSet.add(2);
                            }
                            isExternalStorageManager = Environment.isExternalStorageManager();
                            i12 = isExternalStorageManager;
                        } else if (i10 == 23) {
                            canDrawOverlays = Settings.canDrawOverlays(this.f6875g);
                            i12 = canDrawOverlays;
                        } else {
                            if (i10 == 24) {
                                if (Build.VERSION.SDK_INT >= 26) {
                                    canRequestPackageInstalls = this.f6875g.getPackageManager().canRequestPackageInstalls();
                                    i12 = canRequestPackageInstalls;
                                }
                            } else if (i10 == 27) {
                                isNotificationPolicyAccessGranted = ((NotificationManager) this.f6875g.getSystemService("notification")).isNotificationPolicyAccessGranted();
                                i12 = isNotificationPolicyAccessGranted;
                            } else if (i10 == 34) {
                                if (Build.VERSION.SDK_INT >= 31) {
                                    canScheduleExactAlarms = ((AlarmManager) this.f6875g.getSystemService("alarm")).canScheduleExactAlarms();
                                    i12 = canScheduleExactAlarms;
                                }
                                i11 = 1;
                            } else {
                                if (i10 == 9 || i10 == 32) {
                                    int a10 = androidx.core.content.a.a(this.f6875g, str);
                                    if ((Build.VERSION.SDK_INT >= 34 ? androidx.core.content.a.a(this.f6875g, "android.permission.READ_MEDIA_VISUAL_USER_SELECTED") : a10) == 0 && a10 == -1) {
                                        i12 = 3;
                                    }
                                } else if (androidx.core.content.a.a(this.f6875g, str) != 0) {
                                }
                                i12 = v.b(this.f6877i, str);
                            }
                            hashSet.add(i11);
                        }
                        i11 = Integer.valueOf((int) i12);
                        hashSet.add(i11);
                    }
                }
                if (!hashSet.isEmpty()) {
                    return v.j(hashSet).intValue();
                }
            }
            return 1;
        }
    }

    private boolean e() {
        List c10 = v.c(this.f6875g, 37);
        boolean z9 = c10 != null && c10.contains("android.permission.WRITE_CALENDAR");
        boolean z10 = c10 != null && c10.contains("android.permission.READ_CALENDAR");
        if (z9 && z10) {
            return true;
        }
        if (!z9) {
            Log.d("permissions_handler", "android.permission.WRITE_CALENDAR missing in manifest");
        }
        if (!z10) {
            Log.d("permissions_handler", "android.permission.READ_CALENDAR missing in manifest");
        }
        return false;
    }

    private void f(String str, int i10) {
        if (this.f6877i == null) {
            return;
        }
        Intent intent = new Intent(str);
        if (!str.equals("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS")) {
            intent.setData(Uri.parse("package:" + this.f6877i.getPackageName()));
        }
        this.f6877i.startActivityForResult(intent, i10);
        this.f6878j++;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c(int i10, a aVar) {
        aVar.a(d(i10));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g(List list, b bVar, d4.b bVar2) {
        Map map;
        int i10;
        Map map2;
        int i11;
        int i12;
        int i13;
        String str;
        String str2;
        if (this.f6878j > 0) {
            str2 = "A request for permissions is already running, please wait for it to finish before doing another request (note that you can request multiple permissions at the same time).";
        } else if (this.f6877i != null) {
            this.f6876h = bVar;
            this.f6879k = new HashMap();
            this.f6878j = 0;
            ArrayList arrayList = new ArrayList();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Integer num = (Integer) it.next();
                if (d(num.intValue()) != 1) {
                    List c10 = v.c(this.f6877i, num.intValue());
                    if (c10 != null && !c10.isEmpty()) {
                        int i14 = Build.VERSION.SDK_INT;
                        if (i14 >= 23 && num.intValue() == 16) {
                            i13 = 209;
                            str = "android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
                        } else if (i14 >= 30 && num.intValue() == 22) {
                            i13 = 210;
                            str = "android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION";
                        } else if (i14 >= 23 && num.intValue() == 23) {
                            i13 = 211;
                            str = "android.settings.action.MANAGE_OVERLAY_PERMISSION";
                        } else if (i14 >= 26 && num.intValue() == 24) {
                            i13 = 212;
                            str = "android.settings.MANAGE_UNKNOWN_APP_SOURCES";
                        } else if (i14 >= 23 && num.intValue() == 27) {
                            i13 = 213;
                            str = "android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS";
                        } else if (i14 < 31 || num.intValue() != 34) {
                            if (num.intValue() != 37 && num.intValue() != 0) {
                                arrayList.addAll(c10);
                                i12 = this.f6878j + c10.size();
                            } else if (e()) {
                                arrayList.add("android.permission.WRITE_CALENDAR");
                                arrayList.add("android.permission.READ_CALENDAR");
                                i12 = this.f6878j + 2;
                            } else {
                                map = this.f6879k;
                                i10 = 0;
                            }
                            this.f6878j = i12;
                        } else {
                            i13 = 214;
                            str = "android.settings.REQUEST_SCHEDULE_EXACT_ALARM";
                        }
                        f(str, i13);
                    } else if (!this.f6879k.containsKey(num)) {
                        if (num.intValue() != 16 || Build.VERSION.SDK_INT >= 23) {
                            map2 = this.f6879k;
                            i11 = 0;
                        } else {
                            map2 = this.f6879k;
                            i11 = 2;
                        }
                        map2.put(num, i11);
                        if (num.intValue() == 22 && Build.VERSION.SDK_INT < 30) {
                            map = this.f6879k;
                            i10 = 2;
                        }
                        map = this.f6879k;
                        i10 = 0;
                    }
                    map.put(num, i10);
                } else if (!this.f6879k.containsKey(num)) {
                    map = this.f6879k;
                    i10 = 1;
                    map.put(num, i10);
                }
            }
            if (arrayList.size() > 0) {
                androidx.core.app.b.r(this.f6877i, (String[]) arrayList.toArray(new String[0]), 24);
            }
            b bVar3 = this.f6876h;
            if (bVar3 == null || this.f6878j != 0) {
                return;
            }
            bVar3.a(this.f6879k);
            return;
        } else {
            Log.d("permissions_handler", "Unable to detect current Activity.");
            str2 = "Unable to detect current Android Activity.";
        }
        bVar2.onError("PermissionHandler.PermissionManager", str2);
    }

    public void h(Activity activity) {
        this.f6877i = activity;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void i(int i10, c cVar, d4.b bVar) {
        Activity activity = this.f6877i;
        if (activity == null) {
            Log.d("permissions_handler", "Unable to detect current Activity.");
            bVar.onError("PermissionHandler.PermissionManager", "Unable to detect current Android Activity.");
            return;
        }
        List c10 = v.c(activity, i10);
        if (c10 == null) {
            Log.d("permissions_handler", "No android specific permissions needed for: " + i10);
            cVar.a(false);
        } else if (!c10.isEmpty()) {
            cVar.a(androidx.core.app.b.u(this.f6877i, (String) c10.get(0)));
        } else {
            Log.d("permissions_handler", "No permissions found in manifest for: " + i10 + " no need to show request rationale");
            cVar.a(false);
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // io.flutter.plugin.common.PluginRegistry.ActivityResultListener
    public boolean onActivityResult(int i10, int i11, Intent intent) {
        int i12;
        boolean canScheduleExactAlarms;
        boolean isNotificationPolicyAccessGranted;
        boolean canRequestPackageInstalls;
        boolean canDrawOverlays;
        boolean isExternalStorageManager;
        boolean isIgnoringBatteryOptimizations;
        Activity activity = this.f6877i;
        int i13 = 0;
        i13 = 0;
        if (activity == null) {
            return false;
        }
        if (this.f6879k == null) {
            this.f6878j = 0;
            return false;
        }
        int i14 = 23;
        if (i10 == 209) {
            if (Build.VERSION.SDK_INT >= 23) {
                String packageName = this.f6875g.getPackageName();
                PowerManager powerManager = (PowerManager) this.f6875g.getSystemService("power");
                if (powerManager != null) {
                    isIgnoringBatteryOptimizations = powerManager.isIgnoringBatteryOptimizations(packageName);
                    if (isIgnoringBatteryOptimizations) {
                        i13 = 1;
                    }
                }
            } else {
                i13 = 2;
            }
            i14 = 16;
            i12 = i13;
        } else if (i10 == 210) {
            if (Build.VERSION.SDK_INT < 30) {
                return false;
            }
            isExternalStorageManager = Environment.isExternalStorageManager();
            i14 = 22;
            i12 = isExternalStorageManager;
        } else if (i10 == 211) {
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            canDrawOverlays = Settings.canDrawOverlays(activity);
            i12 = canDrawOverlays;
        } else if (i10 == 212) {
            if (Build.VERSION.SDK_INT < 26) {
                return false;
            }
            canRequestPackageInstalls = activity.getPackageManager().canRequestPackageInstalls();
            i14 = 24;
            i12 = canRequestPackageInstalls;
        } else if (i10 == 213) {
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            isNotificationPolicyAccessGranted = ((NotificationManager) activity.getSystemService("notification")).isNotificationPolicyAccessGranted();
            i14 = 27;
            i12 = isNotificationPolicyAccessGranted;
        } else if (i10 != 214) {
            return false;
        } else {
            i14 = 34;
            AlarmManager alarmManager = (AlarmManager) activity.getSystemService("alarm");
            if (Build.VERSION.SDK_INT >= 31) {
                canScheduleExactAlarms = alarmManager.canScheduleExactAlarms();
                i12 = canScheduleExactAlarms;
            } else {
                i12 = 1;
            }
        }
        this.f6879k.put(Integer.valueOf(i14), Integer.valueOf(i12));
        int i15 = this.f6878j - 1;
        this.f6878j = i15;
        b bVar = this.f6876h;
        if (bVar != null && i15 == 0) {
            bVar.a(this.f6879k);
        }
        return true;
    }

    @Override // io.flutter.plugin.common.PluginRegistry.RequestPermissionsResultListener
    public boolean onRequestPermissionsResult(int i10, String[] strArr, int[] iArr) {
        int g10;
        Map map;
        int i11;
        Integer valueOf;
        if (i10 != 24) {
            this.f6878j = 0;
            return false;
        } else if (this.f6879k == null) {
            return false;
        } else {
            if (strArr.length == 0 && iArr.length == 0) {
                Log.w("permissions_handler", "onRequestPermissionsResult is called without results. This is probably caused by interfering request codes. If you see this error, please file an issue in flutter-permission-handler, including a list of plugins used by this application: https://github.com/Baseflow/flutter-permission-handler/issues");
                return false;
            }
            List asList = Arrays.asList(strArr);
            int indexOf = asList.indexOf("android.permission.WRITE_CALENDAR");
            if (indexOf >= 0) {
                int k10 = v.k(this.f6877i, "android.permission.WRITE_CALENDAR", iArr[indexOf]);
                this.f6879k.put(36, Integer.valueOf(k10));
                int indexOf2 = asList.indexOf("android.permission.READ_CALENDAR");
                if (indexOf2 >= 0) {
                    int intValue = v.i(Integer.valueOf(k10), Integer.valueOf(v.k(this.f6877i, "android.permission.READ_CALENDAR", iArr[indexOf2]))).intValue();
                    this.f6879k.put(37, Integer.valueOf(intValue));
                    this.f6879k.put(0, Integer.valueOf(intValue));
                }
            }
            for (int i12 = 0; i12 < strArr.length; i12++) {
                String str = strArr[i12];
                if (!str.equals("android.permission.WRITE_CALENDAR") && !str.equals("android.permission.READ_CALENDAR") && (g10 = v.g(str)) != 20) {
                    int i13 = iArr[i12];
                    if (g10 == 8) {
                        valueOf = v.i((Integer) this.f6879k.get(8), Integer.valueOf(v.k(this.f6877i, str, i13)));
                        map = this.f6879k;
                        i11 = 8;
                    } else if (g10 == 7) {
                        if (!this.f6879k.containsKey(7)) {
                            this.f6879k.put(7, Integer.valueOf(v.k(this.f6877i, str, i13)));
                        }
                        if (!this.f6879k.containsKey(14)) {
                            this.f6879k.put(14, Integer.valueOf(v.k(this.f6877i, str, i13)));
                        }
                    } else if (g10 == 4) {
                        int k11 = v.k(this.f6877i, str, i13);
                        if (!this.f6879k.containsKey(4)) {
                            map = this.f6879k;
                            i11 = 4;
                            valueOf = Integer.valueOf(k11);
                        }
                    } else if (g10 == 3) {
                        int k12 = v.k(this.f6877i, str, i13);
                        if (Build.VERSION.SDK_INT < 29 && !this.f6879k.containsKey(4)) {
                            this.f6879k.put(4, Integer.valueOf(k12));
                        }
                        if (!this.f6879k.containsKey(5)) {
                            this.f6879k.put(5, Integer.valueOf(k12));
                        }
                        this.f6879k.put(Integer.valueOf(g10), Integer.valueOf(k12));
                    } else if (g10 == 9 || g10 == 32) {
                        this.f6879k.put(Integer.valueOf(g10), Integer.valueOf(d(g10)));
                    } else if (!this.f6879k.containsKey(Integer.valueOf(g10))) {
                        this.f6879k.put(Integer.valueOf(g10), Integer.valueOf(v.k(this.f6877i, str, i13)));
                    }
                    map.put(i11, valueOf);
                }
            }
            int length = this.f6878j - iArr.length;
            this.f6878j = length;
            b bVar = this.f6876h;
            if (bVar == null || length != 0) {
                return true;
            }
            bVar.a(this.f6879k);
            return true;
        }
    }
}
