package com.journeyapps.barcodescanner;

import a7.j;
import a7.o;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.journeyapps.barcodescanner.a;
import java.util.ArrayList;
import java.util.List;
import v7.p;
/* loaded from: classes.dex */
public class ViewfinderView extends View {

    /* renamed from: t  reason: collision with root package name */
    protected static final String f6641t = ViewfinderView.class.getSimpleName();

    /* renamed from: u  reason: collision with root package name */
    protected static final int[] f6642u = {0, 64, 128, 192, 255, 192, 128, 64};

    /* renamed from: g  reason: collision with root package name */
    protected final Paint f6643g;

    /* renamed from: h  reason: collision with root package name */
    protected Bitmap f6644h;

    /* renamed from: i  reason: collision with root package name */
    protected int f6645i;

    /* renamed from: j  reason: collision with root package name */
    protected final int f6646j;

    /* renamed from: k  reason: collision with root package name */
    protected final int f6647k;

    /* renamed from: l  reason: collision with root package name */
    protected final int f6648l;

    /* renamed from: m  reason: collision with root package name */
    protected boolean f6649m;

    /* renamed from: n  reason: collision with root package name */
    protected int f6650n;

    /* renamed from: o  reason: collision with root package name */
    protected List f6651o;

    /* renamed from: p  reason: collision with root package name */
    protected List f6652p;

    /* renamed from: q  reason: collision with root package name */
    protected com.journeyapps.barcodescanner.a f6653q;

    /* renamed from: r  reason: collision with root package name */
    protected Rect f6654r;

    /* renamed from: s  reason: collision with root package name */
    protected p f6655s;

    /* loaded from: classes.dex */
    class a implements a.f {
        a() {
        }

        @Override // com.journeyapps.barcodescanner.a.f
        public void a() {
            ViewfinderView.this.b();
            ViewfinderView.this.invalidate();
        }

        @Override // com.journeyapps.barcodescanner.a.f
        public void b(Exception exc) {
        }

        @Override // com.journeyapps.barcodescanner.a.f
        public void c() {
        }

        @Override // com.journeyapps.barcodescanner.a.f
        public void d() {
        }

        @Override // com.journeyapps.barcodescanner.a.f
        public void e() {
        }
    }

    public ViewfinderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f6643g = new Paint(1);
        Resources resources = getResources();
        TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, o.f615n);
        this.f6645i = obtainStyledAttributes.getColor(o.f620s, resources.getColor(j.zxing_viewfinder_mask));
        this.f6646j = obtainStyledAttributes.getColor(o.f617p, resources.getColor(j.zxing_result_view));
        this.f6647k = obtainStyledAttributes.getColor(o.f618q, resources.getColor(j.zxing_viewfinder_laser));
        this.f6648l = obtainStyledAttributes.getColor(o.f616o, resources.getColor(j.zxing_possible_result_points));
        this.f6649m = obtainStyledAttributes.getBoolean(o.f619r, true);
        obtainStyledAttributes.recycle();
        this.f6650n = 0;
        this.f6651o = new ArrayList(20);
        this.f6652p = new ArrayList(20);
    }

    public void a(w6.p pVar) {
        if (this.f6651o.size() < 20) {
            this.f6651o.add(pVar);
        }
    }

    protected void b() {
        com.journeyapps.barcodescanner.a aVar = this.f6653q;
        if (aVar == null) {
            return;
        }
        Rect framingRect = aVar.getFramingRect();
        p previewSize = this.f6653q.getPreviewSize();
        if (framingRect == null || previewSize == null) {
            return;
        }
        this.f6654r = framingRect;
        this.f6655s = previewSize;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        p pVar;
        b();
        Rect rect = this.f6654r;
        if (rect == null || (pVar = this.f6655s) == null) {
            return;
        }
        int width = getWidth();
        int height = getHeight();
        this.f6643g.setColor(this.f6644h != null ? this.f6646j : this.f6645i);
        float f10 = width;
        canvas.drawRect(0.0f, 0.0f, f10, rect.top, this.f6643g);
        canvas.drawRect(0.0f, rect.top, rect.left, rect.bottom + 1, this.f6643g);
        canvas.drawRect(rect.right + 1, rect.top, f10, rect.bottom + 1, this.f6643g);
        canvas.drawRect(0.0f, rect.bottom + 1, f10, height, this.f6643g);
        if (this.f6644h != null) {
            this.f6643g.setAlpha(160);
            canvas.drawBitmap(this.f6644h, (Rect) null, rect, this.f6643g);
            return;
        }
        if (this.f6649m) {
            this.f6643g.setColor(this.f6647k);
            Paint paint = this.f6643g;
            int[] iArr = f6642u;
            paint.setAlpha(iArr[this.f6650n]);
            this.f6650n = (this.f6650n + 1) % iArr.length;
            int height2 = (rect.height() / 2) + rect.top;
            canvas.drawRect(rect.left + 2, height2 - 1, rect.right - 1, height2 + 2, this.f6643g);
        }
        float width2 = getWidth() / pVar.f14118g;
        float height3 = getHeight() / pVar.f14119h;
        if (!this.f6652p.isEmpty()) {
            this.f6643g.setAlpha(80);
            this.f6643g.setColor(this.f6648l);
            for (w6.p pVar2 : this.f6652p) {
                canvas.drawCircle((int) (pVar2.c() * width2), (int) (pVar2.d() * height3), 3.0f, this.f6643g);
            }
            this.f6652p.clear();
        }
        if (!this.f6651o.isEmpty()) {
            this.f6643g.setAlpha(160);
            this.f6643g.setColor(this.f6648l);
            for (w6.p pVar3 : this.f6651o) {
                canvas.drawCircle((int) (pVar3.c() * width2), (int) (pVar3.d() * height3), 6.0f, this.f6643g);
            }
            List list = this.f6651o;
            List list2 = this.f6652p;
            this.f6651o = list2;
            this.f6652p = list;
            list2.clear();
        }
        postInvalidateDelayed(80L, rect.left - 6, rect.top - 6, rect.right + 6, rect.bottom + 6);
    }

    public void setCameraPreview(com.journeyapps.barcodescanner.a aVar) {
        this.f6653q = aVar;
        aVar.i(new a());
    }

    public void setLaserVisibility(boolean z9) {
        this.f6649m = z9;
    }

    public void setMaskColor(int i10) {
        this.f6645i = i10;
    }
}
