package com.google.android.material.transformation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.r0;
import d6.c;
import d6.d;
import d6.e;
import d6.f;
import java.util.ArrayList;
import java.util.List;
/* loaded from: classes.dex */
public abstract class FabTransformationBehavior extends ExpandableTransformationBehavior {

    /* renamed from: c  reason: collision with root package name */
    private final Rect f6316c;

    /* renamed from: d  reason: collision with root package name */
    private final RectF f6317d;

    /* renamed from: e  reason: collision with root package name */
    private final RectF f6318e;

    /* renamed from: f  reason: collision with root package name */
    private final int[] f6319f;

    /* renamed from: g  reason: collision with root package name */
    private float f6320g;

    /* renamed from: h  reason: collision with root package name */
    private float f6321h;

    /* loaded from: classes.dex */
    class a extends AnimatorListenerAdapter {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ boolean f6322a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ View f6323b;

        /* renamed from: c  reason: collision with root package name */
        final /* synthetic */ View f6324c;

        a(boolean z9, View view, View view2) {
            this.f6322a = z9;
            this.f6323b = view;
            this.f6324c = view2;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            if (this.f6322a) {
                return;
            }
            this.f6323b.setVisibility(4);
            this.f6324c.setAlpha(1.0f);
            this.f6324c.setVisibility(0);
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationStart(Animator animator) {
            if (this.f6322a) {
                this.f6323b.setVisibility(0);
                this.f6324c.setAlpha(0.0f);
                this.f6324c.setVisibility(4);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: classes.dex */
    public static class b {

        /* renamed from: a  reason: collision with root package name */
        public d f6326a;

        /* renamed from: b  reason: collision with root package name */
        public f f6327b;
    }

    public FabTransformationBehavior() {
        this.f6316c = new Rect();
        this.f6317d = new RectF();
        this.f6318e = new RectF();
        this.f6319f = new int[2];
    }

    public FabTransformationBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f6316c = new Rect();
        this.f6317d = new RectF();
        this.f6318e = new RectF();
        this.f6319f = new int[2];
    }

    private ViewGroup K(View view) {
        View findViewById = view.findViewById(c6.f.mtrl_child_content_container);
        return findViewById != null ? a0(findViewById) : a0(view);
    }

    private void L(View view, b bVar, e eVar, e eVar2, float f10, float f11, float f12, float f13, RectF rectF) {
        float Q = Q(bVar, eVar, f10, f12);
        float Q2 = Q(bVar, eVar2, f11, f13);
        Rect rect = this.f6316c;
        view.getWindowVisibleDisplayFrame(rect);
        RectF rectF2 = this.f6317d;
        rectF2.set(rect);
        RectF rectF3 = this.f6318e;
        R(view, rectF3);
        rectF3.offset(Q, Q2);
        rectF3.intersect(rectF2);
        rectF.set(rectF3);
    }

    private void M(View view, RectF rectF) {
        R(view, rectF);
        rectF.offset(this.f6320g, this.f6321h);
    }

    private Pair N(float f10, float f11, boolean z9, b bVar) {
        e e10;
        d dVar;
        String str;
        int i10;
        if (f10 == 0.0f || f11 == 0.0f) {
            e10 = bVar.f6326a.e("translationXLinear");
            dVar = bVar.f6326a;
            str = "translationYLinear";
        } else if ((!z9 || f11 >= 0.0f) && (z9 || i10 <= 0)) {
            e10 = bVar.f6326a.e("translationXCurveDownwards");
            dVar = bVar.f6326a;
            str = "translationYCurveDownwards";
        } else {
            e10 = bVar.f6326a.e("translationXCurveUpwards");
            dVar = bVar.f6326a;
            str = "translationYCurveUpwards";
        }
        return new Pair(e10, dVar.e(str));
    }

    private float O(View view, View view2, f fVar) {
        float centerX;
        float centerX2;
        float f10;
        RectF rectF = this.f6317d;
        RectF rectF2 = this.f6318e;
        M(view, rectF);
        R(view2, rectF2);
        int i10 = fVar.f6901a & 7;
        if (i10 == 1) {
            centerX = rectF2.centerX();
            centerX2 = rectF.centerX();
        } else if (i10 == 3) {
            centerX = rectF2.left;
            centerX2 = rectF.left;
        } else if (i10 != 5) {
            f10 = 0.0f;
            return f10 + fVar.f6902b;
        } else {
            centerX = rectF2.right;
            centerX2 = rectF.right;
        }
        f10 = centerX - centerX2;
        return f10 + fVar.f6902b;
    }

    private float P(View view, View view2, f fVar) {
        float centerY;
        float centerY2;
        float f10;
        RectF rectF = this.f6317d;
        RectF rectF2 = this.f6318e;
        M(view, rectF);
        R(view2, rectF2);
        int i10 = fVar.f6901a & 112;
        if (i10 == 16) {
            centerY = rectF2.centerY();
            centerY2 = rectF.centerY();
        } else if (i10 == 48) {
            centerY = rectF2.top;
            centerY2 = rectF.top;
        } else if (i10 != 80) {
            f10 = 0.0f;
            return f10 + fVar.f6903c;
        } else {
            centerY = rectF2.bottom;
            centerY2 = rectF.bottom;
        }
        f10 = centerY - centerY2;
        return f10 + fVar.f6903c;
    }

    private float Q(b bVar, e eVar, float f10, float f11) {
        long c10 = eVar.c();
        long d10 = eVar.d();
        e e10 = bVar.f6326a.e("expansion");
        return d6.a.a(f10, f11, eVar.e().getInterpolation(((float) (((e10.c() + e10.d()) + 17) - c10)) / ((float) d10)));
    }

    private void R(View view, RectF rectF) {
        rectF.set(0.0f, 0.0f, view.getWidth(), view.getHeight());
        int[] iArr = this.f6319f;
        view.getLocationInWindow(iArr);
        rectF.offsetTo(iArr[0], iArr[1]);
        rectF.offset((int) (-view.getTranslationX()), (int) (-view.getTranslationY()));
    }

    private void S(View view, View view2, boolean z9, boolean z10, b bVar, List list, List list2) {
        ViewGroup K;
        ObjectAnimator ofFloat;
        if ((view2 instanceof ViewGroup) && (K = K(view2)) != null) {
            if (z9) {
                if (!z10) {
                    c.f6893a.set(K, Float.valueOf(0.0f));
                }
                ofFloat = ObjectAnimator.ofFloat(K, c.f6893a, 1.0f);
            } else {
                ofFloat = ObjectAnimator.ofFloat(K, c.f6893a, 0.0f);
            }
            bVar.f6326a.e("contentFade").a(ofFloat);
            list.add(ofFloat);
        }
    }

    private void T(View view, View view2, boolean z9, boolean z10, b bVar, List list, List list2) {
    }

    private void U(View view, View view2, boolean z9, b bVar, List list) {
        float O = O(view, view2, bVar.f6327b);
        float P = P(view, view2, bVar.f6327b);
        Pair N = N(O, P, z9, bVar);
        e eVar = (e) N.first;
        e eVar2 = (e) N.second;
        Property property = View.TRANSLATION_X;
        float[] fArr = new float[1];
        if (!z9) {
            O = this.f6320g;
        }
        fArr[0] = O;
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(view, property, fArr);
        Property property2 = View.TRANSLATION_Y;
        float[] fArr2 = new float[1];
        if (!z9) {
            P = this.f6321h;
        }
        fArr2[0] = P;
        ObjectAnimator ofFloat2 = ObjectAnimator.ofFloat(view, property2, fArr2);
        eVar.a(ofFloat);
        eVar2.a(ofFloat2);
        list.add(ofFloat);
        list.add(ofFloat2);
    }

    private void V(View view, View view2, boolean z9, boolean z10, b bVar, List list, List list2) {
        ObjectAnimator ofFloat;
        float v9 = r0.v(view2) - r0.v(view);
        if (z9) {
            if (!z10) {
                view2.setTranslationZ(-v9);
            }
            ofFloat = ObjectAnimator.ofFloat(view2, View.TRANSLATION_Z, 0.0f);
        } else {
            ofFloat = ObjectAnimator.ofFloat(view2, View.TRANSLATION_Z, -v9);
        }
        bVar.f6326a.e("elevation").a(ofFloat);
        list.add(ofFloat);
    }

    private void W(View view, View view2, boolean z9, boolean z10, b bVar, float f10, float f11, List list, List list2) {
    }

    private void X(View view, View view2, boolean z9, boolean z10, b bVar, List list, List list2) {
    }

    private void Y(View view, View view2, boolean z9, boolean z10, b bVar, List list, List list2, RectF rectF) {
        ObjectAnimator ofFloat;
        ObjectAnimator ofFloat2;
        float O = O(view, view2, bVar.f6327b);
        float P = P(view, view2, bVar.f6327b);
        Pair N = N(O, P, z9, bVar);
        e eVar = (e) N.first;
        e eVar2 = (e) N.second;
        if (z9) {
            if (!z10) {
                view2.setTranslationX(-O);
                view2.setTranslationY(-P);
            }
            ofFloat = ObjectAnimator.ofFloat(view2, View.TRANSLATION_X, 0.0f);
            ofFloat2 = ObjectAnimator.ofFloat(view2, View.TRANSLATION_Y, 0.0f);
            L(view2, bVar, eVar, eVar2, -O, -P, 0.0f, 0.0f, rectF);
        } else {
            ofFloat = ObjectAnimator.ofFloat(view2, View.TRANSLATION_X, -O);
            ofFloat2 = ObjectAnimator.ofFloat(view2, View.TRANSLATION_Y, -P);
        }
        eVar.a(ofFloat);
        eVar2.a(ofFloat2);
        list.add(ofFloat);
        list.add(ofFloat2);
    }

    private ViewGroup a0(View view) {
        if (view instanceof ViewGroup) {
            return (ViewGroup) view;
        }
        return null;
    }

    @Override // com.google.android.material.transformation.ExpandableTransformationBehavior
    protected AnimatorSet J(View view, View view2, boolean z9, boolean z10) {
        b Z = Z(view2.getContext(), z9);
        if (z9) {
            this.f6320g = view.getTranslationX();
            this.f6321h = view.getTranslationY();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        V(view, view2, z9, z10, Z, arrayList, arrayList2);
        RectF rectF = this.f6317d;
        Y(view, view2, z9, z10, Z, arrayList, arrayList2, rectF);
        float width = rectF.width();
        float height = rectF.height();
        U(view, view2, z9, Z, arrayList);
        X(view, view2, z9, z10, Z, arrayList, arrayList2);
        W(view, view2, z9, z10, Z, width, height, arrayList, arrayList2);
        T(view, view2, z9, z10, Z, arrayList, arrayList2);
        S(view, view2, z9, z10, Z, arrayList, arrayList2);
        AnimatorSet animatorSet = new AnimatorSet();
        d6.b.a(animatorSet, arrayList);
        animatorSet.addListener(new a(z9, view2, view));
        int size = arrayList2.size();
        for (int i10 = 0; i10 < size; i10++) {
            animatorSet.addListener((Animator.AnimatorListener) arrayList2.get(i10));
        }
        return animatorSet;
    }

    protected abstract b Z(Context context, boolean z9);

    @Override // com.google.android.material.transformation.ExpandableBehavior, androidx.coordinatorlayout.widget.CoordinatorLayout.b
    public boolean e(CoordinatorLayout coordinatorLayout, View view, View view2) {
        if (view.getVisibility() != 8) {
            return false;
        }
        throw new IllegalStateException("This behavior cannot be attached to a GONE view. Set the view to INVISIBLE instead.");
    }

    @Override // androidx.coordinatorlayout.widget.CoordinatorLayout.b
    public void g(CoordinatorLayout.e eVar) {
        if (eVar.f1908h == 0) {
            eVar.f1908h = 80;
        }
    }
}
