package com.google.android.material.theme;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.Keep;
import androidx.appcompat.app.l;
import androidx.appcompat.widget.d1;
import androidx.appcompat.widget.f;
import androidx.appcompat.widget.g;
import androidx.appcompat.widget.n0;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textview.MaterialTextView;
import f6.a;
@Keep
/* loaded from: classes.dex */
public class MaterialComponentsViewInflater extends l {
    private static int floatingToolbarItemBackgroundResId = -1;

    @Override // androidx.appcompat.app.l
    protected f createButton(Context context, AttributeSet attributeSet) {
        return shouldInflateAppCompatButton(context, attributeSet) ? new f(context, attributeSet) : new MaterialButton(context, attributeSet);
    }

    @Override // androidx.appcompat.app.l
    protected g createCheckBox(Context context, AttributeSet attributeSet) {
        return new a(context, attributeSet);
    }

    @Override // androidx.appcompat.app.l
    protected n0 createRadioButton(Context context, AttributeSet attributeSet) {
        return new l6.a(context, attributeSet);
    }

    @Override // androidx.appcompat.app.l
    protected d1 createTextView(Context context, AttributeSet attributeSet) {
        return new MaterialTextView(context, attributeSet);
    }

    protected boolean shouldInflateAppCompatButton(Context context, AttributeSet attributeSet) {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 == 23 || i10 == 24 || i10 == 25) {
            if (floatingToolbarItemBackgroundResId == -1) {
                floatingToolbarItemBackgroundResId = context.getResources().getIdentifier("floatingToolbarItemBackgroundDrawable", "^attr-private", "android");
            }
            int i11 = floatingToolbarItemBackgroundResId;
            if (i11 != 0 && i11 != -1) {
                for (int i12 = 0; i12 < attributeSet.getAttributeCount(); i12++) {
                    if (attributeSet.getAttributeNameResource(i12) == 16842964) {
                        if (floatingToolbarItemBackgroundResId == attributeSet.getAttributeListValue(i12, null, 0)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        return false;
    }
}
