package com.google.android.material.textview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.d1;
import c6.k;
import m6.b;
import m6.c;
/* loaded from: classes.dex */
public class MaterialTextView extends d1 {
    public MaterialTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public MaterialTextView(Context context, AttributeSet attributeSet, int i10) {
        this(context, attributeSet, i10, 0);
    }

    public MaterialTextView(Context context, AttributeSet attributeSet, int i10, int i11) {
        super(context, attributeSet, i10);
        int t9;
        if (s(context)) {
            Resources.Theme theme = context.getTheme();
            if (v(context, theme, attributeSet, i10, i11) || (t9 = t(theme, attributeSet, i10, i11)) == -1) {
                return;
            }
            r(theme, t9);
        }
    }

    private void r(Resources.Theme theme, int i10) {
        TypedArray obtainStyledAttributes = theme.obtainStyledAttributes(i10, k.f5370e2);
        int u9 = u(getContext(), obtainStyledAttributes, k.f5376f2, k.f5382g2);
        obtainStyledAttributes.recycle();
        if (u9 >= 0) {
            setLineHeight(u9);
        }
    }

    private static boolean s(Context context) {
        return b.b(context, c6.b.textAppearanceLineHeightEnabled, true);
    }

    private static int t(Resources.Theme theme, AttributeSet attributeSet, int i10, int i11) {
        TypedArray obtainStyledAttributes = theme.obtainStyledAttributes(attributeSet, k.f5388h2, i10, i11);
        int resourceId = obtainStyledAttributes.getResourceId(k.f5394i2, -1);
        obtainStyledAttributes.recycle();
        return resourceId;
    }

    private static int u(Context context, TypedArray typedArray, int... iArr) {
        int i10 = -1;
        for (int i11 = 0; i11 < iArr.length && i10 < 0; i11++) {
            i10 = c.c(context, typedArray, iArr[i11], -1);
        }
        return i10;
    }

    private static boolean v(Context context, Resources.Theme theme, AttributeSet attributeSet, int i10, int i11) {
        TypedArray obtainStyledAttributes = theme.obtainStyledAttributes(attributeSet, k.f5388h2, i10, i11);
        int u9 = u(context, obtainStyledAttributes, k.f5400j2, k.f5406k2);
        obtainStyledAttributes.recycle();
        return u9 != -1;
    }

    @Override // androidx.appcompat.widget.d1, android.widget.TextView
    public void setTextAppearance(Context context, int i10) {
        super.setTextAppearance(context, i10);
        if (s(context)) {
            r(context.getTheme(), i10);
        }
    }
}
