package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.appcompat.widget.d1;
import androidx.core.view.r0;
import androidx.core.widget.v;
import java.util.ArrayList;
import java.util.List;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class f {

    /* renamed from: a  reason: collision with root package name */
    private final Context f6276a;

    /* renamed from: b  reason: collision with root package name */
    private final TextInputLayout f6277b;

    /* renamed from: c  reason: collision with root package name */
    private LinearLayout f6278c;

    /* renamed from: d  reason: collision with root package name */
    private int f6279d;

    /* renamed from: e  reason: collision with root package name */
    private FrameLayout f6280e;

    /* renamed from: f  reason: collision with root package name */
    private int f6281f;

    /* renamed from: g  reason: collision with root package name */
    private Animator f6282g;

    /* renamed from: h  reason: collision with root package name */
    private final float f6283h;

    /* renamed from: i  reason: collision with root package name */
    private int f6284i;

    /* renamed from: j  reason: collision with root package name */
    private int f6285j;

    /* renamed from: k  reason: collision with root package name */
    private CharSequence f6286k;

    /* renamed from: l  reason: collision with root package name */
    private boolean f6287l;

    /* renamed from: m  reason: collision with root package name */
    private TextView f6288m;

    /* renamed from: n  reason: collision with root package name */
    private int f6289n;

    /* renamed from: o  reason: collision with root package name */
    private ColorStateList f6290o;

    /* renamed from: p  reason: collision with root package name */
    private CharSequence f6291p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f6292q;

    /* renamed from: r  reason: collision with root package name */
    private TextView f6293r;

    /* renamed from: s  reason: collision with root package name */
    private int f6294s;

    /* renamed from: t  reason: collision with root package name */
    private ColorStateList f6295t;

    /* renamed from: u  reason: collision with root package name */
    private Typeface f6296u;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a extends AnimatorListenerAdapter {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ int f6297a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ TextView f6298b;

        /* renamed from: c  reason: collision with root package name */
        final /* synthetic */ int f6299c;

        /* renamed from: d  reason: collision with root package name */
        final /* synthetic */ TextView f6300d;

        a(int i10, TextView textView, int i11, TextView textView2) {
            this.f6297a = i10;
            this.f6298b = textView;
            this.f6299c = i11;
            this.f6300d = textView2;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            f.this.f6284i = this.f6297a;
            f.this.f6282g = null;
            TextView textView = this.f6298b;
            if (textView != null) {
                textView.setVisibility(4);
                if (this.f6299c == 1 && f.this.f6288m != null) {
                    f.this.f6288m.setText((CharSequence) null);
                }
                TextView textView2 = this.f6300d;
                if (textView2 != null) {
                    textView2.setTranslationY(0.0f);
                    this.f6300d.setAlpha(1.0f);
                }
            }
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationStart(Animator animator) {
            TextView textView = this.f6300d;
            if (textView != null) {
                textView.setVisibility(0);
            }
        }
    }

    public f(TextInputLayout textInputLayout) {
        Context context = textInputLayout.getContext();
        this.f6276a = context;
        this.f6277b = textInputLayout;
        this.f6283h = context.getResources().getDimensionPixelSize(c6.d.design_textinput_caption_translate_y);
    }

    private void F(TextView textView, Typeface typeface) {
        if (textView != null) {
            textView.setTypeface(typeface);
        }
    }

    private void H(ViewGroup viewGroup, int i10) {
        if (i10 == 0) {
            viewGroup.setVisibility(8);
        }
    }

    private boolean I(TextView textView, CharSequence charSequence) {
        return r0.R(this.f6277b) && this.f6277b.isEnabled() && !(this.f6285j == this.f6284i && textView != null && TextUtils.equals(textView.getText(), charSequence));
    }

    private void L(int i10, int i11, boolean z9) {
        if (z9) {
            AnimatorSet animatorSet = new AnimatorSet();
            this.f6282g = animatorSet;
            ArrayList arrayList = new ArrayList();
            h(arrayList, this.f6292q, this.f6293r, 2, i10, i11);
            h(arrayList, this.f6287l, this.f6288m, 1, i10, i11);
            d6.b.a(animatorSet, arrayList);
            animatorSet.addListener(new a(i11, l(i10), i10, l(i11)));
            animatorSet.start();
        } else {
            y(i10, i11);
        }
        this.f6277b.Y();
        this.f6277b.c0(z9);
        this.f6277b.e0();
    }

    private boolean f() {
        return (this.f6278c == null || this.f6277b.getEditText() == null) ? false : true;
    }

    private void h(List list, boolean z9, TextView textView, int i10, int i11, int i12) {
        if (textView == null || !z9) {
            return;
        }
        if (i10 == i12 || i10 == i11) {
            list.add(i(textView, i12 == i10));
            if (i12 == i10) {
                list.add(j(textView));
            }
        }
    }

    private ObjectAnimator i(TextView textView, boolean z9) {
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(textView, View.ALPHA, z9 ? 1.0f : 0.0f);
        ofFloat.setDuration(167L);
        ofFloat.setInterpolator(d6.a.f6888a);
        return ofFloat;
    }

    private ObjectAnimator j(TextView textView) {
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(textView, View.TRANSLATION_Y, -this.f6283h, 0.0f);
        ofFloat.setDuration(217L);
        ofFloat.setInterpolator(d6.a.f6891d);
        return ofFloat;
    }

    private TextView l(int i10) {
        if (i10 != 1) {
            if (i10 != 2) {
                return null;
            }
            return this.f6293r;
        }
        return this.f6288m;
    }

    private boolean t(int i10) {
        return (i10 != 1 || this.f6288m == null || TextUtils.isEmpty(this.f6286k)) ? false : true;
    }

    private void y(int i10, int i11) {
        TextView l10;
        TextView l11;
        if (i10 == i11) {
            return;
        }
        if (i11 != 0 && (l11 = l(i11)) != null) {
            l11.setVisibility(0);
            l11.setAlpha(1.0f);
        }
        if (i10 != 0 && (l10 = l(i10)) != null) {
            l10.setVisibility(4);
            if (i10 == 1) {
                l10.setText((CharSequence) null);
            }
        }
        this.f6284i = i11;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void A(int i10) {
        this.f6289n = i10;
        TextView textView = this.f6288m;
        if (textView != null) {
            this.f6277b.Q(textView, i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void B(ColorStateList colorStateList) {
        this.f6290o = colorStateList;
        TextView textView = this.f6288m;
        if (textView == null || colorStateList == null) {
            return;
        }
        textView.setTextColor(colorStateList);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void C(int i10) {
        this.f6294s = i10;
        TextView textView = this.f6293r;
        if (textView != null) {
            v.n(textView, i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void D(boolean z9) {
        if (this.f6292q == z9) {
            return;
        }
        g();
        if (z9) {
            d1 d1Var = new d1(this.f6276a);
            this.f6293r = d1Var;
            d1Var.setId(c6.f.textinput_helper_text);
            Typeface typeface = this.f6296u;
            if (typeface != null) {
                this.f6293r.setTypeface(typeface);
            }
            this.f6293r.setVisibility(4);
            r0.p0(this.f6293r, 1);
            C(this.f6294s);
            E(this.f6295t);
            d(this.f6293r, 1);
        } else {
            s();
            x(this.f6293r, 1);
            this.f6293r = null;
            this.f6277b.Y();
            this.f6277b.e0();
        }
        this.f6292q = z9;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void E(ColorStateList colorStateList) {
        this.f6295t = colorStateList;
        TextView textView = this.f6293r;
        if (textView == null || colorStateList == null) {
            return;
        }
        textView.setTextColor(colorStateList);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void G(Typeface typeface) {
        if (typeface != this.f6296u) {
            this.f6296u = typeface;
            F(this.f6288m, typeface);
            F(this.f6293r, typeface);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void J(CharSequence charSequence) {
        g();
        this.f6286k = charSequence;
        this.f6288m.setText(charSequence);
        int i10 = this.f6284i;
        if (i10 != 1) {
            this.f6285j = 1;
        }
        L(i10, this.f6285j, I(this.f6288m, charSequence));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void K(CharSequence charSequence) {
        g();
        this.f6291p = charSequence;
        this.f6293r.setText(charSequence);
        int i10 = this.f6284i;
        if (i10 != 2) {
            this.f6285j = 2;
        }
        L(i10, this.f6285j, I(this.f6293r, charSequence));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void d(TextView textView, int i10) {
        if (this.f6278c == null && this.f6280e == null) {
            LinearLayout linearLayout = new LinearLayout(this.f6276a);
            this.f6278c = linearLayout;
            linearLayout.setOrientation(0);
            this.f6277b.addView(this.f6278c, -1, -2);
            FrameLayout frameLayout = new FrameLayout(this.f6276a);
            this.f6280e = frameLayout;
            this.f6278c.addView(frameLayout, -1, new FrameLayout.LayoutParams(-2, -2));
            this.f6278c.addView(new Space(this.f6276a), new LinearLayout.LayoutParams(0, 0, 1.0f));
            if (this.f6277b.getEditText() != null) {
                e();
            }
        }
        if (u(i10)) {
            this.f6280e.setVisibility(0);
            this.f6280e.addView(textView);
            this.f6281f++;
        } else {
            this.f6278c.addView(textView, i10);
        }
        this.f6278c.setVisibility(0);
        this.f6279d++;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e() {
        if (f()) {
            r0.B0(this.f6278c, r0.G(this.f6277b.getEditText()), 0, r0.F(this.f6277b.getEditText()), 0);
        }
    }

    void g() {
        Animator animator = this.f6282g;
        if (animator != null) {
            animator.cancel();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean k() {
        return t(this.f6285j);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public CharSequence m() {
        return this.f6286k;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int n() {
        TextView textView = this.f6288m;
        if (textView != null) {
            return textView.getCurrentTextColor();
        }
        return -1;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList o() {
        TextView textView = this.f6288m;
        if (textView != null) {
            return textView.getTextColors();
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public CharSequence p() {
        return this.f6291p;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int q() {
        TextView textView = this.f6293r;
        if (textView != null) {
            return textView.getCurrentTextColor();
        }
        return -1;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r() {
        this.f6286k = null;
        g();
        if (this.f6284i == 1) {
            this.f6285j = (!this.f6292q || TextUtils.isEmpty(this.f6291p)) ? 0 : 2;
        }
        L(this.f6284i, this.f6285j, I(this.f6288m, null));
    }

    void s() {
        g();
        int i10 = this.f6284i;
        if (i10 == 2) {
            this.f6285j = 0;
        }
        L(i10, this.f6285j, I(this.f6293r, null));
    }

    boolean u(int i10) {
        return i10 == 0 || i10 == 1;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean v() {
        return this.f6287l;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean w() {
        return this.f6292q;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void x(TextView textView, int i10) {
        ViewGroup viewGroup;
        FrameLayout frameLayout;
        if (this.f6278c == null) {
            return;
        }
        if (!u(i10) || (frameLayout = this.f6280e) == null) {
            viewGroup = this.f6278c;
        } else {
            int i11 = this.f6281f - 1;
            this.f6281f = i11;
            H(frameLayout, i11);
            viewGroup = this.f6280e;
        }
        viewGroup.removeView(textView);
        int i12 = this.f6279d - 1;
        this.f6279d = i12;
        H(this.f6278c, i12);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void z(boolean z9) {
        if (this.f6287l == z9) {
            return;
        }
        g();
        if (z9) {
            d1 d1Var = new d1(this.f6276a);
            this.f6288m = d1Var;
            d1Var.setId(c6.f.textinput_error);
            Typeface typeface = this.f6296u;
            if (typeface != null) {
                this.f6288m.setTypeface(typeface);
            }
            A(this.f6289n);
            B(this.f6290o);
            this.f6288m.setVisibility(4);
            r0.p0(this.f6288m, 1);
            d(this.f6288m, 0);
        } else {
            r();
            x(this.f6288m, 0);
            this.f6288m = null;
            this.f6277b.Y();
            this.f6277b.e0();
        }
        this.f6287l = z9;
    }
}
