package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Spinner;
import androidx.core.view.r0;
import com.google.android.material.textfield.TextInputLayout;
import p6.k;
import w.l;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class d extends com.google.android.material.textfield.e {

    /* renamed from: o  reason: collision with root package name */
    private static final boolean f6249o = true;

    /* renamed from: d  reason: collision with root package name */
    private final TextWatcher f6250d;

    /* renamed from: e  reason: collision with root package name */
    private final TextInputLayout.e f6251e;

    /* renamed from: f  reason: collision with root package name */
    private final TextInputLayout.f f6252f;

    /* renamed from: g  reason: collision with root package name */
    private boolean f6253g;

    /* renamed from: h  reason: collision with root package name */
    private boolean f6254h;

    /* renamed from: i  reason: collision with root package name */
    private long f6255i;

    /* renamed from: j  reason: collision with root package name */
    private StateListDrawable f6256j;

    /* renamed from: k  reason: collision with root package name */
    private p6.g f6257k;

    /* renamed from: l  reason: collision with root package name */
    private AccessibilityManager f6258l;

    /* renamed from: m  reason: collision with root package name */
    private ValueAnimator f6259m;

    /* renamed from: n  reason: collision with root package name */
    private ValueAnimator f6260n;

    /* loaded from: classes.dex */
    class a implements TextWatcher {

        /* renamed from: com.google.android.material.textfield.d$a$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        class RunnableC0091a implements Runnable {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ AutoCompleteTextView f6262g;

            RunnableC0091a(AutoCompleteTextView autoCompleteTextView) {
                this.f6262g = autoCompleteTextView;
            }

            @Override // java.lang.Runnable
            public void run() {
                boolean isPopupShowing = this.f6262g.isPopupShowing();
                d.this.z(isPopupShowing);
                d.this.f6253g = isPopupShowing;
            }
        }

        a() {
        }

        @Override // android.text.TextWatcher
        public void afterTextChanged(Editable editable) {
            d dVar = d.this;
            AutoCompleteTextView u9 = dVar.u(dVar.f6273a.getEditText());
            u9.post(new RunnableC0091a(u9));
        }

        @Override // android.text.TextWatcher
        public void beforeTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        }

        @Override // android.text.TextWatcher
        public void onTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        }
    }

    /* loaded from: classes.dex */
    class b extends TextInputLayout.e {
        b(TextInputLayout textInputLayout) {
            super(textInputLayout);
        }

        @Override // com.google.android.material.textfield.TextInputLayout.e, androidx.core.view.a
        public void g(View view, l lVar) {
            super.g(view, lVar);
            lVar.j0(Spinner.class.getName());
            if (lVar.U()) {
                lVar.u0(null);
            }
        }

        @Override // androidx.core.view.a
        public void h(View view, AccessibilityEvent accessibilityEvent) {
            super.h(view, accessibilityEvent);
            d dVar = d.this;
            AutoCompleteTextView u9 = dVar.u(dVar.f6273a.getEditText());
            if (accessibilityEvent.getEventType() == 1 && d.this.f6258l.isTouchExplorationEnabled()) {
                d.this.C(u9);
            }
        }
    }

    /* loaded from: classes.dex */
    class c implements TextInputLayout.f {
        c() {
        }

        @Override // com.google.android.material.textfield.TextInputLayout.f
        public void a(TextInputLayout textInputLayout) {
            AutoCompleteTextView u9 = d.this.u(textInputLayout.getEditText());
            d.this.A(u9);
            d.this.r(u9);
            d.this.B(u9);
            u9.setThreshold(0);
            u9.removeTextChangedListener(d.this.f6250d);
            u9.addTextChangedListener(d.this.f6250d);
            textInputLayout.setErrorIconDrawable((Drawable) null);
            textInputLayout.setTextInputAccessibilityDelegate(d.this.f6251e);
            textInputLayout.setEndIconVisible(true);
        }
    }

    /* renamed from: com.google.android.material.textfield.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    class View$OnClickListenerC0092d implements View.OnClickListener {
        View$OnClickListenerC0092d() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            d.this.C((AutoCompleteTextView) d.this.f6273a.getEditText());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class e implements View.OnTouchListener {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ AutoCompleteTextView f6267g;

        e(AutoCompleteTextView autoCompleteTextView) {
            this.f6267g = autoCompleteTextView;
        }

        @Override // android.view.View.OnTouchListener
        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                if (d.this.y()) {
                    d.this.f6253g = false;
                }
                d.this.C(this.f6267g);
                view.performClick();
            }
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class f implements View.OnFocusChangeListener {
        f() {
        }

        @Override // android.view.View.OnFocusChangeListener
        public void onFocusChange(View view, boolean z9) {
            d.this.f6273a.setEndIconActivated(z9);
            if (z9) {
                return;
            }
            d.this.z(false);
            d.this.f6253g = false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class g implements AutoCompleteTextView.OnDismissListener {
        g() {
        }

        @Override // android.widget.AutoCompleteTextView.OnDismissListener
        public void onDismiss() {
            d.this.f6253g = true;
            d.this.f6255i = System.currentTimeMillis();
            d.this.z(false);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class h extends AnimatorListenerAdapter {
        h() {
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            d dVar = d.this;
            dVar.f6275c.setChecked(dVar.f6254h);
            d.this.f6260n.start();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class i implements ValueAnimator.AnimatorUpdateListener {
        i() {
        }

        @Override // android.animation.ValueAnimator.AnimatorUpdateListener
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            d.this.f6275c.setAlpha(((Float) valueAnimator.getAnimatedValue()).floatValue());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public d(TextInputLayout textInputLayout) {
        super(textInputLayout);
        this.f6250d = new a();
        this.f6251e = new b(this.f6273a);
        this.f6252f = new c();
        this.f6253g = false;
        this.f6254h = false;
        this.f6255i = Long.MAX_VALUE;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void A(AutoCompleteTextView autoCompleteTextView) {
        Drawable drawable;
        if (f6249o) {
            int boxBackgroundMode = this.f6273a.getBoxBackgroundMode();
            if (boxBackgroundMode == 2) {
                drawable = this.f6257k;
            } else if (boxBackgroundMode != 1) {
                return;
            } else {
                drawable = this.f6256j;
            }
            autoCompleteTextView.setDropDownBackgroundDrawable(drawable);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void B(AutoCompleteTextView autoCompleteTextView) {
        autoCompleteTextView.setOnTouchListener(new e(autoCompleteTextView));
        autoCompleteTextView.setOnFocusChangeListener(new f());
        if (f6249o) {
            autoCompleteTextView.setOnDismissListener(new g());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void C(AutoCompleteTextView autoCompleteTextView) {
        if (autoCompleteTextView == null) {
            return;
        }
        if (y()) {
            this.f6253g = false;
        }
        if (this.f6253g) {
            this.f6253g = false;
            return;
        }
        if (f6249o) {
            z(!this.f6254h);
        } else {
            this.f6254h = !this.f6254h;
            this.f6275c.toggle();
        }
        if (!this.f6254h) {
            autoCompleteTextView.dismissDropDown();
            return;
        }
        autoCompleteTextView.requestFocus();
        autoCompleteTextView.showDropDown();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void r(AutoCompleteTextView autoCompleteTextView) {
        if (autoCompleteTextView.getKeyListener() != null) {
            return;
        }
        int boxBackgroundMode = this.f6273a.getBoxBackgroundMode();
        p6.g boxBackground = this.f6273a.getBoxBackground();
        int c10 = g6.a.c(autoCompleteTextView, c6.b.f5339f);
        int[][] iArr = {new int[]{16842919}, new int[0]};
        if (boxBackgroundMode == 2) {
            t(autoCompleteTextView, c10, iArr, boxBackground);
        } else if (boxBackgroundMode == 1) {
            s(autoCompleteTextView, c10, iArr, boxBackground);
        }
    }

    private void s(AutoCompleteTextView autoCompleteTextView, int i10, int[][] iArr, p6.g gVar) {
        int boxBackgroundColor = this.f6273a.getBoxBackgroundColor();
        int[] iArr2 = {g6.a.f(i10, boxBackgroundColor, 0.1f), boxBackgroundColor};
        if (f6249o) {
            r0.r0(autoCompleteTextView, new RippleDrawable(new ColorStateList(iArr, iArr2), gVar, gVar));
            return;
        }
        p6.g gVar2 = new p6.g(gVar.A());
        gVar2.R(new ColorStateList(iArr, iArr2));
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{gVar, gVar2});
        int G = r0.G(autoCompleteTextView);
        int paddingTop = autoCompleteTextView.getPaddingTop();
        int F = r0.F(autoCompleteTextView);
        int paddingBottom = autoCompleteTextView.getPaddingBottom();
        r0.r0(autoCompleteTextView, layerDrawable);
        r0.B0(autoCompleteTextView, G, paddingTop, F, paddingBottom);
    }

    private void t(AutoCompleteTextView autoCompleteTextView, int i10, int[][] iArr, p6.g gVar) {
        LayerDrawable layerDrawable;
        int c10 = g6.a.c(autoCompleteTextView, c6.b.colorSurface);
        p6.g gVar2 = new p6.g(gVar.A());
        int f10 = g6.a.f(i10, c10, 0.1f);
        gVar2.R(new ColorStateList(iArr, new int[]{f10, 0}));
        if (f6249o) {
            gVar2.setTint(c10);
            ColorStateList colorStateList = new ColorStateList(iArr, new int[]{f10, c10});
            p6.g gVar3 = new p6.g(gVar.A());
            gVar3.setTint(-1);
            layerDrawable = new LayerDrawable(new Drawable[]{new RippleDrawable(colorStateList, gVar2, gVar3), gVar});
        } else {
            layerDrawable = new LayerDrawable(new Drawable[]{gVar2, gVar});
        }
        r0.r0(autoCompleteTextView, layerDrawable);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public AutoCompleteTextView u(EditText editText) {
        if (editText instanceof AutoCompleteTextView) {
            return (AutoCompleteTextView) editText;
        }
        throw new RuntimeException("EditText needs to be an AutoCompleteTextView if an Exposed Dropdown Menu is being used.");
    }

    private ValueAnimator v(int i10, float... fArr) {
        ValueAnimator ofFloat = ValueAnimator.ofFloat(fArr);
        ofFloat.setInterpolator(d6.a.f6888a);
        ofFloat.setDuration(i10);
        ofFloat.addUpdateListener(new i());
        return ofFloat;
    }

    private p6.g w(float f10, float f11, float f12, int i10) {
        k m10 = k.a().z(f10).D(f10).r(f11).v(f11).m();
        p6.g l10 = p6.g.l(this.f6274b, f12);
        l10.setShapeAppearanceModel(m10);
        l10.T(0, i10, 0, i10);
        return l10;
    }

    private void x() {
        this.f6260n = v(67, 0.0f, 1.0f);
        ValueAnimator v9 = v(50, 1.0f, 0.0f);
        this.f6259m = v9;
        v9.addListener(new h());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean y() {
        long currentTimeMillis = System.currentTimeMillis() - this.f6255i;
        return currentTimeMillis < 0 || currentTimeMillis > 300;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void z(boolean z9) {
        if (this.f6254h != z9) {
            this.f6254h = z9;
            this.f6260n.cancel();
            this.f6259m.start();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.google.android.material.textfield.e
    public void a() {
        float dimensionPixelOffset = this.f6274b.getResources().getDimensionPixelOffset(c6.d.mtrl_shape_corner_size_small_component);
        float dimensionPixelOffset2 = this.f6274b.getResources().getDimensionPixelOffset(c6.d.mtrl_exposed_dropdown_menu_popup_elevation);
        int dimensionPixelOffset3 = this.f6274b.getResources().getDimensionPixelOffset(c6.d.mtrl_exposed_dropdown_menu_popup_vertical_padding);
        p6.g w9 = w(dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset2, dimensionPixelOffset3);
        p6.g w10 = w(0.0f, dimensionPixelOffset, dimensionPixelOffset2, dimensionPixelOffset3);
        this.f6257k = w9;
        StateListDrawable stateListDrawable = new StateListDrawable();
        this.f6256j = stateListDrawable;
        stateListDrawable.addState(new int[]{16842922}, w9);
        this.f6256j.addState(new int[0], w10);
        this.f6273a.setEndIconDrawable(h.a.b(this.f6274b, f6249o ? c6.e.mtrl_dropdown_arrow : c6.e.mtrl_ic_arrow_drop_down));
        TextInputLayout textInputLayout = this.f6273a;
        textInputLayout.setEndIconContentDescription(textInputLayout.getResources().getText(c6.i.exposed_dropdown_menu_content_description));
        this.f6273a.setEndIconOnClickListener(new View$OnClickListenerC0092d());
        this.f6273a.c(this.f6252f);
        x();
        r0.x0(this.f6275c, 2);
        this.f6258l = (AccessibilityManager) this.f6274b.getSystemService("accessibility");
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.google.android.material.textfield.e
    public boolean b(int i10) {
        return i10 != 0;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.google.android.material.textfield.e
    public boolean c() {
        return true;
    }
}
