package com.google.android.material.textfield;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.d1;
import androidx.appcompat.widget.k2;
import androidx.appcompat.widget.m1;
import androidx.core.view.r0;
import androidx.core.widget.v;
import c6.i;
import c6.j;
import com.google.android.material.internal.CheckableImageButton;
import java.util.Iterator;
import java.util.LinkedHashSet;
import p6.k;
import w.l;
/* loaded from: classes.dex */
public class TextInputLayout extends LinearLayout {

    /* renamed from: x0  reason: collision with root package name */
    private static final int f6187x0 = j.Widget_Design_TextInputLayout;
    private int A;
    private final int B;
    private int C;
    private final int D;
    private final int E;
    private int F;
    private int G;
    private final Rect H;
    private final Rect I;
    private final RectF J;
    private Typeface K;
    private final CheckableImageButton L;
    private ColorStateList M;
    private boolean N;
    private PorterDuff.Mode O;
    private boolean P;
    private Drawable Q;
    private View.OnLongClickListener R;
    private final LinkedHashSet S;
    private int T;
    private final SparseArray U;
    private final CheckableImageButton V;
    private final LinkedHashSet W;

    /* renamed from: a0  reason: collision with root package name */
    private ColorStateList f6188a0;

    /* renamed from: b0  reason: collision with root package name */
    private boolean f6189b0;

    /* renamed from: c0  reason: collision with root package name */
    private PorterDuff.Mode f6190c0;

    /* renamed from: d0  reason: collision with root package name */
    private boolean f6191d0;

    /* renamed from: e0  reason: collision with root package name */
    private Drawable f6192e0;

    /* renamed from: f0  reason: collision with root package name */
    private Drawable f6193f0;

    /* renamed from: g  reason: collision with root package name */
    private final FrameLayout f6194g;

    /* renamed from: g0  reason: collision with root package name */
    private final CheckableImageButton f6195g0;

    /* renamed from: h  reason: collision with root package name */
    private final FrameLayout f6196h;

    /* renamed from: h0  reason: collision with root package name */
    private View.OnLongClickListener f6197h0;

    /* renamed from: i  reason: collision with root package name */
    EditText f6198i;

    /* renamed from: i0  reason: collision with root package name */
    private ColorStateList f6199i0;

    /* renamed from: j  reason: collision with root package name */
    private CharSequence f6200j;

    /* renamed from: j0  reason: collision with root package name */
    private ColorStateList f6201j0;

    /* renamed from: k  reason: collision with root package name */
    private final com.google.android.material.textfield.f f6202k;

    /* renamed from: k0  reason: collision with root package name */
    private final int f6203k0;

    /* renamed from: l  reason: collision with root package name */
    boolean f6204l;

    /* renamed from: l0  reason: collision with root package name */
    private final int f6205l0;

    /* renamed from: m  reason: collision with root package name */
    private int f6206m;

    /* renamed from: m0  reason: collision with root package name */
    private int f6207m0;

    /* renamed from: n  reason: collision with root package name */
    private boolean f6208n;

    /* renamed from: n0  reason: collision with root package name */
    private int f6209n0;

    /* renamed from: o  reason: collision with root package name */
    private TextView f6210o;

    /* renamed from: o0  reason: collision with root package name */
    private final int f6211o0;

    /* renamed from: p  reason: collision with root package name */
    private int f6212p;

    /* renamed from: p0  reason: collision with root package name */
    private final int f6213p0;

    /* renamed from: q  reason: collision with root package name */
    private int f6214q;

    /* renamed from: q0  reason: collision with root package name */
    private final int f6215q0;

    /* renamed from: r  reason: collision with root package name */
    private ColorStateList f6216r;

    /* renamed from: r0  reason: collision with root package name */
    private boolean f6217r0;

    /* renamed from: s  reason: collision with root package name */
    private ColorStateList f6218s;

    /* renamed from: s0  reason: collision with root package name */
    final com.google.android.material.internal.a f6219s0;

    /* renamed from: t  reason: collision with root package name */
    private boolean f6220t;

    /* renamed from: t0  reason: collision with root package name */
    private boolean f6221t0;

    /* renamed from: u  reason: collision with root package name */
    private CharSequence f6222u;

    /* renamed from: u0  reason: collision with root package name */
    private ValueAnimator f6223u0;

    /* renamed from: v  reason: collision with root package name */
    private boolean f6224v;

    /* renamed from: v0  reason: collision with root package name */
    private boolean f6225v0;

    /* renamed from: w  reason: collision with root package name */
    private p6.g f6226w;

    /* renamed from: w0  reason: collision with root package name */
    private boolean f6227w0;

    /* renamed from: x  reason: collision with root package name */
    private p6.g f6228x;

    /* renamed from: y  reason: collision with root package name */
    private k f6229y;

    /* renamed from: z  reason: collision with root package name */
    private final int f6230z;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements TextWatcher {
        a() {
        }

        @Override // android.text.TextWatcher
        public void afterTextChanged(Editable editable) {
            TextInputLayout textInputLayout = TextInputLayout.this;
            textInputLayout.c0(!textInputLayout.f6227w0);
            TextInputLayout textInputLayout2 = TextInputLayout.this;
            if (textInputLayout2.f6204l) {
                textInputLayout2.V(editable.length());
            }
        }

        @Override // android.text.TextWatcher
        public void beforeTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        }

        @Override // android.text.TextWatcher
        public void onTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            TextInputLayout.this.V.performClick();
            TextInputLayout.this.V.jumpDrawablesToCurrentState();
        }
    }

    /* loaded from: classes.dex */
    class c implements Runnable {
        c() {
        }

        @Override // java.lang.Runnable
        public void run() {
            TextInputLayout.this.f6198i.requestLayout();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements ValueAnimator.AnimatorUpdateListener {
        d() {
        }

        @Override // android.animation.ValueAnimator.AnimatorUpdateListener
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            TextInputLayout.this.f6219s0.O(((Float) valueAnimator.getAnimatedValue()).floatValue());
        }
    }

    /* loaded from: classes.dex */
    public static class e extends androidx.core.view.a {

        /* renamed from: d  reason: collision with root package name */
        private final TextInputLayout f6235d;

        public e(TextInputLayout textInputLayout) {
            this.f6235d = textInputLayout;
        }

        @Override // androidx.core.view.a
        public void g(View view, l lVar) {
            super.g(view, lVar);
            EditText editText = this.f6235d.getEditText();
            Editable text = editText != null ? editText.getText() : null;
            CharSequence hint = this.f6235d.getHint();
            CharSequence error = this.f6235d.getError();
            CharSequence counterOverflowDescription = this.f6235d.getCounterOverflowDescription();
            boolean z9 = !TextUtils.isEmpty(text);
            boolean z10 = !TextUtils.isEmpty(hint);
            boolean z11 = !TextUtils.isEmpty(error);
            boolean z12 = false;
            boolean z13 = z11 || !TextUtils.isEmpty(counterOverflowDescription);
            if (z9) {
                lVar.E0(text);
            } else if (z10) {
                lVar.E0(hint);
            }
            if (z10) {
                lVar.u0(hint);
                if (!z9 && z10) {
                    z12 = true;
                }
                lVar.B0(z12);
            }
            if (z13) {
                if (!z11) {
                    error = counterOverflowDescription;
                }
                lVar.q0(error);
                lVar.o0(true);
            }
        }
    }

    /* loaded from: classes.dex */
    public interface f {
        void a(TextInputLayout textInputLayout);
    }

    /* loaded from: classes.dex */
    public interface g {
        void a(TextInputLayout textInputLayout, int i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class h extends b0.a {
        public static final Parcelable.Creator<h> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        CharSequence f6236i;

        /* renamed from: j  reason: collision with root package name */
        boolean f6237j;

        /* loaded from: classes.dex */
        static class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public h createFromParcel(Parcel parcel) {
                return new h(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public h createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new h(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public h[] newArray(int i10) {
                return new h[i10];
            }
        }

        h(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f6236i = (CharSequence) TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.f6237j = parcel.readInt() == 1;
        }

        h(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "TextInputLayout.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " error=" + ((Object) this.f6236i) + "}";
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            TextUtils.writeToParcel(this.f6236i, parcel, i10);
            parcel.writeInt(this.f6237j ? 1 : 0);
        }
    }

    public TextInputLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, c6.b.textInputStyle);
    }

    /* JADX WARN: Illegal instructions before constructor call */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r2v37 */
    /* JADX WARN: Type inference failed for: r2v38, types: [int, boolean] */
    /* JADX WARN: Type inference failed for: r2v71 */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public TextInputLayout(Context context, AttributeSet attributeSet, int i10) {
        super(com.google.android.material.internal.f.f(context, attributeSet, i10, r9), attributeSet, i10);
        ?? r22;
        int colorForState;
        int i11 = f6187x0;
        this.f6202k = new com.google.android.material.textfield.f(this);
        this.H = new Rect();
        this.I = new Rect();
        this.J = new RectF();
        this.S = new LinkedHashSet();
        this.T = 0;
        SparseArray sparseArray = new SparseArray();
        this.U = sparseArray;
        this.W = new LinkedHashSet();
        com.google.android.material.internal.a aVar = new com.google.android.material.internal.a(this);
        this.f6219s0 = aVar;
        Context context2 = getContext();
        setOrientation(1);
        setWillNotDraw(false);
        setAddStatesFromChildren(true);
        FrameLayout frameLayout = new FrameLayout(context2);
        this.f6194g = frameLayout;
        frameLayout.setAddStatesFromChildren(true);
        addView(frameLayout);
        FrameLayout frameLayout2 = new FrameLayout(context2);
        this.f6196h = frameLayout2;
        frameLayout2.setLayoutParams(new FrameLayout.LayoutParams(-2, -2, 8388629));
        frameLayout.addView(frameLayout2);
        TimeInterpolator timeInterpolator = d6.a.f6888a;
        aVar.T(timeInterpolator);
        aVar.Q(timeInterpolator);
        aVar.F(8388659);
        int[] iArr = c6.k.f5413l3;
        int i12 = c6.k.C3;
        int i13 = c6.k.A3;
        int i14 = c6.k.O3;
        int i15 = c6.k.S3;
        int i16 = c6.k.W3;
        k2 l10 = com.google.android.material.internal.f.l(context2, attributeSet, iArr, i10, i11, i12, i13, i14, i15, i16);
        this.f6220t = l10.a(c6.k.V3, true);
        setHint(l10.p(c6.k.f5425n3));
        this.f6221t0 = l10.a(c6.k.U3, true);
        this.f6229y = k.e(context2, attributeSet, i10, i11).m();
        this.f6230z = context2.getResources().getDimensionPixelOffset(c6.d.mtrl_textinput_box_label_cutout_padding);
        this.B = l10.e(c6.k.f5443q3, 0);
        int f10 = l10.f(c6.k.f5474w3, context2.getResources().getDimensionPixelSize(c6.d.mtrl_textinput_box_stroke_width_default));
        this.D = f10;
        this.E = l10.f(c6.k.f5479x3, context2.getResources().getDimensionPixelSize(c6.d.mtrl_textinput_box_stroke_width_focused));
        this.C = f10;
        float d10 = l10.d(c6.k.f5464u3, -1.0f);
        float d11 = l10.d(c6.k.f5459t3, -1.0f);
        float d12 = l10.d(c6.k.f5449r3, -1.0f);
        float d13 = l10.d(c6.k.f5454s3, -1.0f);
        k.b v9 = this.f6229y.v();
        if (d10 >= 0.0f) {
            v9.z(d10);
        }
        if (d11 >= 0.0f) {
            v9.D(d11);
        }
        if (d12 >= 0.0f) {
            v9.v(d12);
        }
        if (d13 >= 0.0f) {
            v9.r(d13);
        }
        this.f6229y = v9.m();
        ColorStateList b10 = m6.c.b(context2, l10, c6.k.f5431o3);
        if (b10 != null) {
            int defaultColor = b10.getDefaultColor();
            this.f6209n0 = defaultColor;
            this.G = defaultColor;
            if (b10.isStateful()) {
                this.f6211o0 = b10.getColorForState(new int[]{-16842910}, -1);
                colorForState = b10.getColorForState(new int[]{16843623}, -1);
            } else {
                ColorStateList a10 = h.a.a(context2, c6.c.mtrl_filled_background_color);
                this.f6211o0 = a10.getColorForState(new int[]{-16842910}, -1);
                colorForState = a10.getColorForState(new int[]{16843623}, -1);
            }
            this.f6213p0 = colorForState;
        } else {
            this.G = 0;
            this.f6209n0 = 0;
            this.f6211o0 = 0;
            this.f6213p0 = 0;
        }
        int i17 = c6.k.f5419m3;
        if (l10.s(i17)) {
            ColorStateList c10 = l10.c(i17);
            this.f6201j0 = c10;
            this.f6199i0 = c10;
        }
        int i18 = c6.k.f5469v3;
        ColorStateList b11 = m6.c.b(context2, l10, i18);
        if (b11 == null || !b11.isStateful()) {
            this.f6207m0 = l10.b(i18, 0);
            this.f6203k0 = androidx.core.content.a.b(context2, c6.c.mtrl_textinput_default_box_stroke_color);
            this.f6215q0 = androidx.core.content.a.b(context2, c6.c.mtrl_textinput_disabled_color);
            this.f6205l0 = androidx.core.content.a.b(context2, c6.c.mtrl_textinput_hovered_box_stroke_color);
        } else {
            this.f6203k0 = b11.getDefaultColor();
            this.f6215q0 = b11.getColorForState(new int[]{-16842910}, -1);
            this.f6205l0 = b11.getColorForState(new int[]{16843623}, -1);
            this.f6207m0 = b11.getColorForState(new int[]{16842908}, -1);
        }
        if (l10.n(i16, -1) != -1) {
            r22 = 0;
            setHintTextAppearance(l10.n(i16, 0));
        } else {
            r22 = 0;
        }
        int n10 = l10.n(i14, r22);
        boolean a11 = l10.a(c6.k.K3, r22);
        LayoutInflater from = LayoutInflater.from(getContext());
        int i19 = c6.h.design_text_input_end_icon;
        CheckableImageButton checkableImageButton = (CheckableImageButton) from.inflate(i19, frameLayout, (boolean) r22);
        this.f6195g0 = checkableImageButton;
        frameLayout.addView(checkableImageButton);
        checkableImageButton.setVisibility(8);
        int i20 = c6.k.L3;
        if (l10.s(i20)) {
            setErrorIconDrawable(l10.g(i20));
        }
        int i21 = c6.k.M3;
        if (l10.s(i21)) {
            setErrorIconTintList(m6.c.b(context2, l10, i21));
        }
        int i22 = c6.k.N3;
        if (l10.s(i22)) {
            setErrorIconTintMode(com.google.android.material.internal.g.c(l10.k(i22, -1), null));
        }
        checkableImageButton.setContentDescription(getResources().getText(i.error_icon_content_description));
        r0.x0(checkableImageButton, 2);
        checkableImageButton.setClickable(false);
        checkableImageButton.setPressable(false);
        checkableImageButton.setFocusable(false);
        int n11 = l10.n(i15, 0);
        boolean a12 = l10.a(c6.k.R3, false);
        CharSequence p10 = l10.p(c6.k.Q3);
        boolean a13 = l10.a(c6.k.f5484y3, false);
        setCounterMaxLength(l10.k(c6.k.f5489z3, -1));
        this.f6214q = l10.n(i12, 0);
        this.f6212p = l10.n(i13, 0);
        CheckableImageButton checkableImageButton2 = (CheckableImageButton) LayoutInflater.from(getContext()).inflate(c6.h.design_text_input_start_icon, (ViewGroup) frameLayout, false);
        this.L = checkableImageButton2;
        frameLayout.addView(checkableImageButton2);
        checkableImageButton2.setVisibility(8);
        setStartIconOnClickListener(null);
        setStartIconOnLongClickListener(null);
        int i23 = c6.k.f5378f4;
        if (l10.s(i23)) {
            setStartIconDrawable(l10.g(i23));
            int i24 = c6.k.f5372e4;
            if (l10.s(i24)) {
                setStartIconContentDescription(l10.p(i24));
            }
            setStartIconCheckable(l10.a(c6.k.f5366d4, true));
        }
        int i25 = c6.k.f5384g4;
        if (l10.s(i25)) {
            setStartIconTintList(m6.c.b(context2, l10, i25));
        }
        int i26 = c6.k.f5390h4;
        if (l10.s(i26)) {
            setStartIconTintMode(com.google.android.material.internal.g.c(l10.k(i26, -1), null));
        }
        setHelperTextEnabled(a12);
        setHelperText(p10);
        setHelperTextTextAppearance(n11);
        setErrorEnabled(a11);
        setErrorTextAppearance(n10);
        setCounterTextAppearance(this.f6214q);
        setCounterOverflowTextAppearance(this.f6212p);
        int i27 = c6.k.P3;
        if (l10.s(i27)) {
            setErrorTextColor(l10.c(i27));
        }
        int i28 = c6.k.T3;
        if (l10.s(i28)) {
            setHelperTextColor(l10.c(i28));
        }
        int i29 = c6.k.X3;
        if (l10.s(i29)) {
            setHintTextColor(l10.c(i29));
        }
        int i30 = c6.k.D3;
        if (l10.s(i30)) {
            setCounterTextColor(l10.c(i30));
        }
        int i31 = c6.k.B3;
        if (l10.s(i31)) {
            setCounterOverflowTextColor(l10.c(i31));
        }
        setCounterEnabled(a13);
        setBoxBackgroundMode(l10.k(c6.k.f5437p3, 0));
        CheckableImageButton checkableImageButton3 = (CheckableImageButton) LayoutInflater.from(getContext()).inflate(i19, (ViewGroup) frameLayout2, false);
        this.V = checkableImageButton3;
        frameLayout2.addView(checkableImageButton3);
        checkableImageButton3.setVisibility(8);
        sparseArray.append(-1, new com.google.android.material.textfield.b(this));
        sparseArray.append(0, new com.google.android.material.textfield.g(this));
        sparseArray.append(1, new com.google.android.material.textfield.h(this));
        sparseArray.append(2, new com.google.android.material.textfield.a(this));
        sparseArray.append(3, new com.google.android.material.textfield.d(this));
        int i32 = c6.k.H3;
        if (l10.s(i32)) {
            setEndIconMode(l10.k(i32, 0));
            int i33 = c6.k.G3;
            if (l10.s(i33)) {
                setEndIconDrawable(l10.g(i33));
            }
            int i34 = c6.k.F3;
            if (l10.s(i34)) {
                setEndIconContentDescription(l10.p(i34));
            }
            setEndIconCheckable(l10.a(c6.k.E3, true));
        } else {
            int i35 = c6.k.f5348a4;
            if (l10.s(i35)) {
                setEndIconMode(l10.a(i35, false) ? 1 : 0);
                setEndIconDrawable(l10.g(c6.k.Z3));
                setEndIconContentDescription(l10.p(c6.k.Y3));
                int i36 = c6.k.f5354b4;
                if (l10.s(i36)) {
                    setEndIconTintList(m6.c.b(context2, l10, i36));
                }
                int i37 = c6.k.f5360c4;
                if (l10.s(i37)) {
                    setEndIconTintMode(com.google.android.material.internal.g.c(l10.k(i37, -1), null));
                }
            }
        }
        if (!l10.s(c6.k.f5348a4)) {
            int i38 = c6.k.I3;
            if (l10.s(i38)) {
                setEndIconTintList(m6.c.b(context2, l10, i38));
            }
            int i39 = c6.k.J3;
            if (l10.s(i39)) {
                setEndIconTintMode(com.google.android.material.internal.g.c(l10.k(i39, -1), null));
            }
        }
        l10.w();
        r0.x0(this, 2);
    }

    private void A(Canvas canvas) {
        if (this.f6220t) {
            this.f6219s0.i(canvas);
        }
    }

    private void B(boolean z9) {
        ValueAnimator valueAnimator = this.f6223u0;
        if (valueAnimator != null && valueAnimator.isRunning()) {
            this.f6223u0.cancel();
        }
        if (z9 && this.f6221t0) {
            e(0.0f);
        } else {
            this.f6219s0.O(0.0f);
        }
        if (w() && ((com.google.android.material.textfield.c) this.f6226w).c0()) {
            u();
        }
        this.f6217r0 = true;
    }

    private boolean C() {
        return this.T != 0;
    }

    private boolean D() {
        return getStartIconDrawable() != null;
    }

    private boolean H() {
        return this.A == 1 && this.f6198i.getMinLines() <= 1;
    }

    private void J() {
        l();
        M();
        e0();
        if (this.A != 0) {
            b0();
        }
    }

    private void K() {
        if (w()) {
            RectF rectF = this.J;
            this.f6219s0.k(rectF);
            h(rectF);
            rectF.offset(-getPaddingLeft(), 0.0f);
            ((com.google.android.material.textfield.c) this.f6226w).i0(rectF);
        }
    }

    private static void L(ViewGroup viewGroup, boolean z9) {
        int childCount = viewGroup.getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = viewGroup.getChildAt(i10);
            childAt.setEnabled(z9);
            if (childAt instanceof ViewGroup) {
                L((ViewGroup) childAt, z9);
            }
        }
    }

    private void M() {
        if (R()) {
            r0.r0(this.f6198i, this.f6226w);
        }
    }

    private static void N(CheckableImageButton checkableImageButton, View.OnLongClickListener onLongClickListener) {
        boolean M = r0.M(checkableImageButton);
        boolean z9 = false;
        boolean z10 = onLongClickListener != null;
        z9 = (M || z10) ? true : true;
        checkableImageButton.setFocusable(z9);
        checkableImageButton.setClickable(M);
        checkableImageButton.setPressable(M);
        checkableImageButton.setLongClickable(z10);
        r0.x0(checkableImageButton, z9 ? 1 : 2);
    }

    private static void O(CheckableImageButton checkableImageButton, View.OnClickListener onClickListener, View.OnLongClickListener onLongClickListener) {
        checkableImageButton.setOnClickListener(onClickListener);
        N(checkableImageButton, onLongClickListener);
    }

    private static void P(CheckableImageButton checkableImageButton, View.OnLongClickListener onLongClickListener) {
        checkableImageButton.setOnLongClickListener(onLongClickListener);
        N(checkableImageButton, onLongClickListener);
    }

    private boolean R() {
        EditText editText = this.f6198i;
        return (editText == null || this.f6226w == null || editText.getBackground() != null || this.A == 0) ? false : true;
    }

    private void S(boolean z9) {
        if (!z9 || getEndIconDrawable() == null) {
            i();
            return;
        }
        Drawable mutate = androidx.core.graphics.drawable.a.r(getEndIconDrawable()).mutate();
        androidx.core.graphics.drawable.a.n(mutate, this.f6202k.n());
        this.V.setImageDrawable(mutate);
    }

    private void T(Rect rect) {
        p6.g gVar = this.f6228x;
        if (gVar != null) {
            int i10 = rect.bottom;
            gVar.setBounds(rect.left, i10 - this.E, rect.right, i10);
        }
    }

    private void U() {
        if (this.f6210o != null) {
            EditText editText = this.f6198i;
            V(editText == null ? 0 : editText.getText().length());
        }
    }

    private static void W(Context context, TextView textView, int i10, int i11, boolean z9) {
        textView.setContentDescription(context.getString(z9 ? i.character_counter_overflowed_content_description : i.character_counter_content_description, Integer.valueOf(i10), Integer.valueOf(i11)));
    }

    private void X() {
        ColorStateList colorStateList;
        ColorStateList colorStateList2;
        TextView textView = this.f6210o;
        if (textView != null) {
            Q(textView, this.f6208n ? this.f6212p : this.f6214q);
            if (!this.f6208n && (colorStateList2 = this.f6216r) != null) {
                this.f6210o.setTextColor(colorStateList2);
            }
            if (!this.f6208n || (colorStateList = this.f6218s) == null) {
                return;
            }
            this.f6210o.setTextColor(colorStateList);
        }
    }

    private boolean Z() {
        int max;
        if (this.f6198i != null && this.f6198i.getMeasuredHeight() < (max = Math.max(this.V.getMeasuredHeight(), this.L.getMeasuredHeight()))) {
            this.f6198i.setMinimumHeight(max);
            return true;
        }
        return false;
    }

    private boolean a0() {
        boolean z9;
        if (this.f6198i == null) {
            return false;
        }
        boolean z10 = true;
        if (D() && I() && this.L.getMeasuredWidth() > 0) {
            if (this.Q == null) {
                this.Q = new ColorDrawable();
                this.Q.setBounds(0, 0, (this.L.getMeasuredWidth() - this.f6198i.getPaddingLeft()) + androidx.core.view.l.a((ViewGroup.MarginLayoutParams) this.L.getLayoutParams()), 1);
            }
            Drawable[] a10 = v.a(this.f6198i);
            Drawable drawable = a10[0];
            Drawable drawable2 = this.Q;
            if (drawable != drawable2) {
                v.i(this.f6198i, drawable2, a10[1], a10[2], a10[3]);
                z9 = true;
            }
            z9 = false;
        } else {
            if (this.Q != null) {
                Drawable[] a11 = v.a(this.f6198i);
                v.i(this.f6198i, null, a11[1], a11[2], a11[3]);
                this.Q = null;
                z9 = true;
            }
            z9 = false;
        }
        CheckableImageButton endIconToUpdateDummyDrawable = getEndIconToUpdateDummyDrawable();
        if (endIconToUpdateDummyDrawable != null && endIconToUpdateDummyDrawable.getMeasuredWidth() > 0) {
            if (this.f6192e0 == null) {
                this.f6192e0 = new ColorDrawable();
                this.f6192e0.setBounds(0, 0, (endIconToUpdateDummyDrawable.getMeasuredWidth() - this.f6198i.getPaddingRight()) + androidx.core.view.l.b((ViewGroup.MarginLayoutParams) endIconToUpdateDummyDrawable.getLayoutParams()), 1);
            }
            Drawable[] a12 = v.a(this.f6198i);
            Drawable drawable3 = a12[2];
            Drawable drawable4 = this.f6192e0;
            if (drawable3 != drawable4) {
                this.f6193f0 = drawable3;
                v.i(this.f6198i, a12[0], a12[1], drawable4, a12[3]);
            } else {
                z10 = z9;
            }
        } else if (this.f6192e0 == null) {
            return z9;
        } else {
            Drawable[] a13 = v.a(this.f6198i);
            if (a13[2] == this.f6192e0) {
                v.i(this.f6198i, a13[0], a13[1], this.f6193f0, a13[3]);
            } else {
                z10 = z9;
            }
            this.f6192e0 = null;
        }
        return z10;
    }

    private void b0() {
        if (this.A != 1) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.f6194g.getLayoutParams();
            int r10 = r();
            if (r10 != layoutParams.topMargin) {
                layoutParams.topMargin = r10;
                this.f6194g.requestLayout();
            }
        }
    }

    private void d0(boolean z9, boolean z10) {
        ColorStateList colorStateList;
        com.google.android.material.internal.a aVar;
        TextView textView;
        boolean isEnabled = isEnabled();
        EditText editText = this.f6198i;
        boolean z11 = true;
        boolean z12 = (editText == null || TextUtils.isEmpty(editText.getText())) ? false : true;
        EditText editText2 = this.f6198i;
        z11 = (editText2 == null || !editText2.hasFocus()) ? false : false;
        boolean k10 = this.f6202k.k();
        ColorStateList colorStateList2 = this.f6199i0;
        if (colorStateList2 != null) {
            this.f6219s0.E(colorStateList2);
            this.f6219s0.K(this.f6199i0);
        }
        if (!isEnabled) {
            this.f6219s0.E(ColorStateList.valueOf(this.f6215q0));
            this.f6219s0.K(ColorStateList.valueOf(this.f6215q0));
        } else if (k10) {
            this.f6219s0.E(this.f6202k.o());
        } else {
            if (this.f6208n && (textView = this.f6210o) != null) {
                aVar = this.f6219s0;
                colorStateList = textView.getTextColors();
            } else if (z11 && (colorStateList = this.f6201j0) != null) {
                aVar = this.f6219s0;
            }
            aVar.E(colorStateList);
        }
        if (z12 || (isEnabled() && (z11 || k10))) {
            if (z10 || this.f6217r0) {
                v(z9);
            }
        } else if (z10 || !this.f6217r0) {
            B(z9);
        }
    }

    private void f() {
        p6.g gVar = this.f6226w;
        if (gVar == null) {
            return;
        }
        gVar.setShapeAppearanceModel(this.f6229y);
        if (s()) {
            this.f6226w.V(this.C, this.F);
        }
        int m10 = m();
        this.G = m10;
        this.f6226w.R(ColorStateList.valueOf(m10));
        if (this.T == 3) {
            this.f6198i.getBackground().invalidateSelf();
        }
        g();
        invalidate();
    }

    private void g() {
        if (this.f6228x == null) {
            return;
        }
        if (t()) {
            this.f6228x.R(ColorStateList.valueOf(this.F));
        }
        invalidate();
    }

    private com.google.android.material.textfield.e getEndIconDelegate() {
        com.google.android.material.textfield.e eVar = (com.google.android.material.textfield.e) this.U.get(this.T);
        return eVar != null ? eVar : (com.google.android.material.textfield.e) this.U.get(0);
    }

    private CheckableImageButton getEndIconToUpdateDummyDrawable() {
        if (this.f6195g0.getVisibility() == 0) {
            return this.f6195g0;
        }
        if (C() && E()) {
            return this.V;
        }
        return null;
    }

    private void h(RectF rectF) {
        float f10 = rectF.left;
        int i10 = this.f6230z;
        rectF.left = f10 - i10;
        rectF.top -= i10;
        rectF.right += i10;
        rectF.bottom += i10;
    }

    private void i() {
        j(this.V, this.f6189b0, this.f6188a0, this.f6191d0, this.f6190c0);
    }

    private void j(CheckableImageButton checkableImageButton, boolean z9, ColorStateList colorStateList, boolean z10, PorterDuff.Mode mode) {
        Drawable drawable = checkableImageButton.getDrawable();
        if (drawable != null && (z9 || z10)) {
            drawable = androidx.core.graphics.drawable.a.r(drawable).mutate();
            if (z9) {
                androidx.core.graphics.drawable.a.o(drawable, colorStateList);
            }
            if (z10) {
                androidx.core.graphics.drawable.a.p(drawable, mode);
            }
        }
        if (checkableImageButton.getDrawable() != drawable) {
            checkableImageButton.setImageDrawable(drawable);
        }
    }

    private void k() {
        j(this.L, this.N, this.M, this.P, this.O);
    }

    private void l() {
        int i10 = this.A;
        if (i10 == 0) {
            this.f6226w = null;
        } else if (i10 == 1) {
            this.f6226w = new p6.g(this.f6229y);
            this.f6228x = new p6.g();
            return;
        } else if (i10 != 2) {
            throw new IllegalArgumentException(this.A + " is illegal; only @BoxBackgroundMode constants are supported.");
        } else {
            this.f6226w = (!this.f6220t || (this.f6226w instanceof com.google.android.material.textfield.c)) ? new p6.g(this.f6229y) : new com.google.android.material.textfield.c(this.f6229y);
        }
        this.f6228x = null;
    }

    private int m() {
        return this.A == 1 ? g6.a.e(g6.a.d(this, c6.b.colorSurface, 0), this.G) : this.G;
    }

    private Rect n(Rect rect) {
        int i10;
        int i11;
        int i12;
        EditText editText = this.f6198i;
        if (editText != null) {
            Rect rect2 = this.I;
            rect2.bottom = rect.bottom;
            int i13 = this.A;
            if (i13 == 1) {
                rect2.left = rect.left + editText.getCompoundPaddingLeft();
                i10 = rect.top + this.B;
            } else if (i13 == 2) {
                rect2.left = rect.left + editText.getPaddingLeft();
                rect2.top = rect.top - r();
                i11 = rect.right;
                i12 = this.f6198i.getPaddingRight();
                rect2.right = i11 - i12;
                return rect2;
            } else {
                rect2.left = rect.left + editText.getCompoundPaddingLeft();
                i10 = getPaddingTop();
            }
            rect2.top = i10;
            i11 = rect.right;
            i12 = this.f6198i.getCompoundPaddingRight();
            rect2.right = i11 - i12;
            return rect2;
        }
        throw new IllegalStateException();
    }

    private int o(Rect rect, Rect rect2, float f10) {
        return this.A == 1 ? (int) (rect2.top + f10) : rect.bottom - this.f6198i.getCompoundPaddingBottom();
    }

    private int p(Rect rect, float f10) {
        return H() ? (int) (rect.centerY() - (f10 / 2.0f)) : rect.top + this.f6198i.getCompoundPaddingTop();
    }

    private Rect q(Rect rect) {
        if (this.f6198i != null) {
            Rect rect2 = this.I;
            float q10 = this.f6219s0.q();
            rect2.left = rect.left + this.f6198i.getCompoundPaddingLeft();
            rect2.top = p(rect, q10);
            rect2.right = rect.right - this.f6198i.getCompoundPaddingRight();
            rect2.bottom = o(rect, rect2, q10);
            return rect2;
        }
        throw new IllegalStateException();
    }

    private int r() {
        float m10;
        if (this.f6220t) {
            int i10 = this.A;
            if (i10 == 0 || i10 == 1) {
                m10 = this.f6219s0.m();
            } else if (i10 != 2) {
                return 0;
            } else {
                m10 = this.f6219s0.m() / 2.0f;
            }
            return (int) m10;
        }
        return 0;
    }

    private boolean s() {
        return this.A == 2 && t();
    }

    private void setEditText(EditText editText) {
        if (this.f6198i != null) {
            throw new IllegalArgumentException("We already have an EditText, can only have one");
        }
        if (this.T != 3 && !(editText instanceof TextInputEditText)) {
            Log.i("TextInputLayout", "EditText added is not a TextInputEditText. Please switch to using that class instead.");
        }
        this.f6198i = editText;
        J();
        setTextInputAccessibilityDelegate(new e(this));
        this.f6219s0.U(this.f6198i.getTypeface());
        this.f6219s0.M(this.f6198i.getTextSize());
        int gravity = this.f6198i.getGravity();
        this.f6219s0.F((gravity & (-113)) | 48);
        this.f6219s0.L(gravity);
        this.f6198i.addTextChangedListener(new a());
        if (this.f6199i0 == null) {
            this.f6199i0 = this.f6198i.getHintTextColors();
        }
        if (this.f6220t) {
            if (TextUtils.isEmpty(this.f6222u)) {
                CharSequence hint = this.f6198i.getHint();
                this.f6200j = hint;
                setHint(hint);
                this.f6198i.setHint((CharSequence) null);
            }
            this.f6224v = true;
        }
        if (this.f6210o != null) {
            V(this.f6198i.getText().length());
        }
        Y();
        this.f6202k.e();
        this.L.bringToFront();
        this.f6196h.bringToFront();
        this.f6195g0.bringToFront();
        x();
        d0(false, true);
    }

    private void setErrorIconVisible(boolean z9) {
        this.f6195g0.setVisibility(z9 ? 0 : 8);
        this.f6196h.setVisibility(z9 ? 8 : 0);
        if (C()) {
            return;
        }
        a0();
    }

    private void setHintInternal(CharSequence charSequence) {
        if (TextUtils.equals(charSequence, this.f6222u)) {
            return;
        }
        this.f6222u = charSequence;
        this.f6219s0.S(charSequence);
        if (this.f6217r0) {
            return;
        }
        K();
    }

    private boolean t() {
        return this.C > -1 && this.F != 0;
    }

    private void u() {
        if (w()) {
            ((com.google.android.material.textfield.c) this.f6226w).f0();
        }
    }

    private void v(boolean z9) {
        ValueAnimator valueAnimator = this.f6223u0;
        if (valueAnimator != null && valueAnimator.isRunning()) {
            this.f6223u0.cancel();
        }
        if (z9 && this.f6221t0) {
            e(1.0f);
        } else {
            this.f6219s0.O(1.0f);
        }
        this.f6217r0 = false;
        if (w()) {
            K();
        }
    }

    private boolean w() {
        return this.f6220t && !TextUtils.isEmpty(this.f6222u) && (this.f6226w instanceof com.google.android.material.textfield.c);
    }

    private void x() {
        Iterator it = this.S.iterator();
        while (it.hasNext()) {
            ((f) it.next()).a(this);
        }
    }

    private void y(int i10) {
        Iterator it = this.W.iterator();
        while (it.hasNext()) {
            ((g) it.next()).a(this, i10);
        }
    }

    private void z(Canvas canvas) {
        p6.g gVar = this.f6228x;
        if (gVar != null) {
            Rect bounds = gVar.getBounds();
            bounds.top = bounds.bottom - this.C;
            this.f6228x.draw(canvas);
        }
    }

    public boolean E() {
        return this.f6196h.getVisibility() == 0 && this.V.getVisibility() == 0;
    }

    public boolean F() {
        return this.f6202k.w();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean G() {
        return this.f6224v;
    }

    public boolean I() {
        return this.L.getVisibility() == 0;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* JADX WARN: Code restructure failed: missing block: B:7:0x0015, code lost:
        if (r3.getTextColors().getDefaultColor() == (-65281)) goto L8;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void Q(TextView textView, int i10) {
        boolean z9 = true;
        try {
            v.n(textView, i10);
            if (Build.VERSION.SDK_INT >= 23) {
            }
            z9 = false;
        } catch (Exception unused) {
        }
        if (z9) {
            v.n(textView, j.TextAppearance_AppCompat_Caption);
            textView.setTextColor(androidx.core.content.a.b(getContext(), c6.c.design_error));
        }
    }

    void V(int i10) {
        boolean z9 = this.f6208n;
        if (this.f6206m == -1) {
            this.f6210o.setText(String.valueOf(i10));
            this.f6210o.setContentDescription(null);
            this.f6208n = false;
        } else {
            if (r0.o(this.f6210o) == 1) {
                r0.p0(this.f6210o, 0);
            }
            this.f6208n = i10 > this.f6206m;
            W(getContext(), this.f6210o, i10, this.f6206m, this.f6208n);
            if (z9 != this.f6208n) {
                X();
                if (this.f6208n) {
                    r0.p0(this.f6210o, 1);
                }
            }
            this.f6210o.setText(getContext().getString(i.character_counter_pattern, Integer.valueOf(i10), Integer.valueOf(this.f6206m)));
        }
        if (this.f6198i == null || z9 == this.f6208n) {
            return;
        }
        c0(false);
        e0();
        Y();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void Y() {
        Drawable background;
        TextView textView;
        int currentTextColor;
        EditText editText = this.f6198i;
        if (editText == null || this.A != 0 || (background = editText.getBackground()) == null) {
            return;
        }
        if (m1.a(background)) {
            background = background.mutate();
        }
        if (this.f6202k.k()) {
            currentTextColor = this.f6202k.n();
        } else if (!this.f6208n || (textView = this.f6210o) == null) {
            androidx.core.graphics.drawable.a.c(background);
            this.f6198i.refreshDrawableState();
            return;
        } else {
            currentTextColor = textView.getCurrentTextColor();
        }
        background.setColorFilter(androidx.appcompat.widget.k.e(currentTextColor, PorterDuff.Mode.SRC_IN));
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i10, ViewGroup.LayoutParams layoutParams) {
        if (!(view instanceof EditText)) {
            super.addView(view, i10, layoutParams);
            return;
        }
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(layoutParams);
        layoutParams2.gravity = (layoutParams2.gravity & (-113)) | 16;
        this.f6194g.addView(view, layoutParams2);
        this.f6194g.setLayoutParams(layoutParams);
        b0();
        setEditText((EditText) view);
    }

    public void c(f fVar) {
        this.S.add(fVar);
        if (this.f6198i != null) {
            fVar.a(this);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c0(boolean z9) {
        d0(z9, false);
    }

    public void d(g gVar) {
        this.W.add(gVar);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void dispatchProvideAutofillStructure(ViewStructure viewStructure, int i10) {
        EditText editText;
        if (this.f6200j == null || (editText = this.f6198i) == null) {
            super.dispatchProvideAutofillStructure(viewStructure, i10);
            return;
        }
        boolean z9 = this.f6224v;
        this.f6224v = false;
        CharSequence hint = editText.getHint();
        this.f6198i.setHint(this.f6200j);
        try {
            super.dispatchProvideAutofillStructure(viewStructure, i10);
        } finally {
            this.f6198i.setHint(hint);
            this.f6224v = z9;
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void dispatchRestoreInstanceState(SparseArray sparseArray) {
        this.f6227w0 = true;
        super.dispatchRestoreInstanceState(sparseArray);
        this.f6227w0 = false;
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        super.draw(canvas);
        A(canvas);
        z(canvas);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        if (this.f6225v0) {
            return;
        }
        boolean z9 = true;
        this.f6225v0 = true;
        super.drawableStateChanged();
        int[] drawableState = getDrawableState();
        com.google.android.material.internal.a aVar = this.f6219s0;
        boolean R = aVar != null ? aVar.R(drawableState) | false : false;
        c0((r0.R(this) && isEnabled()) ? false : false);
        Y();
        e0();
        if (R) {
            invalidate();
        }
        this.f6225v0 = false;
    }

    void e(float f10) {
        if (this.f6219s0.r() == f10) {
            return;
        }
        if (this.f6223u0 == null) {
            ValueAnimator valueAnimator = new ValueAnimator();
            this.f6223u0 = valueAnimator;
            valueAnimator.setInterpolator(d6.a.f6889b);
            this.f6223u0.setDuration(167L);
            this.f6223u0.addUpdateListener(new d());
        }
        this.f6223u0.setFloatValues(this.f6219s0.r(), f10);
        this.f6223u0.start();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e0() {
        TextView textView;
        EditText editText;
        EditText editText2;
        if (this.f6226w == null || this.A == 0) {
            return;
        }
        boolean z9 = false;
        boolean z10 = isFocused() || ((editText2 = this.f6198i) != null && editText2.hasFocus());
        boolean z11 = isHovered() || ((editText = this.f6198i) != null && editText.isHovered());
        this.F = !isEnabled() ? this.f6215q0 : this.f6202k.k() ? this.f6202k.n() : (!this.f6208n || (textView = this.f6210o) == null) ? z10 ? this.f6207m0 : z11 ? this.f6205l0 : this.f6203k0 : textView.getCurrentTextColor();
        S(this.f6202k.k() && getEndIconDelegate().c());
        if (getErrorIconDrawable() != null && this.f6202k.v() && this.f6202k.k()) {
            z9 = true;
        }
        setErrorIconVisible(z9);
        this.C = ((z11 || z10) && isEnabled()) ? this.E : this.D;
        if (this.A == 1) {
            this.G = !isEnabled() ? this.f6211o0 : z11 ? this.f6213p0 : this.f6209n0;
        }
        f();
    }

    @Override // android.widget.LinearLayout, android.view.View
    public int getBaseline() {
        EditText editText = this.f6198i;
        return editText != null ? editText.getBaseline() + getPaddingTop() + r() : super.getBaseline();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public p6.g getBoxBackground() {
        int i10 = this.A;
        if (i10 == 1 || i10 == 2) {
            return this.f6226w;
        }
        throw new IllegalStateException();
    }

    public int getBoxBackgroundColor() {
        return this.G;
    }

    public int getBoxBackgroundMode() {
        return this.A;
    }

    public float getBoxCornerRadiusBottomEnd() {
        return this.f6226w.r();
    }

    public float getBoxCornerRadiusBottomStart() {
        return this.f6226w.s();
    }

    public float getBoxCornerRadiusTopEnd() {
        return this.f6226w.D();
    }

    public float getBoxCornerRadiusTopStart() {
        return this.f6226w.C();
    }

    public int getBoxStrokeColor() {
        return this.f6207m0;
    }

    public int getCounterMaxLength() {
        return this.f6206m;
    }

    CharSequence getCounterOverflowDescription() {
        TextView textView;
        if (this.f6204l && this.f6208n && (textView = this.f6210o) != null) {
            return textView.getContentDescription();
        }
        return null;
    }

    public ColorStateList getCounterOverflowTextColor() {
        return this.f6216r;
    }

    public ColorStateList getCounterTextColor() {
        return this.f6216r;
    }

    public ColorStateList getDefaultHintTextColor() {
        return this.f6199i0;
    }

    public EditText getEditText() {
        return this.f6198i;
    }

    public CharSequence getEndIconContentDescription() {
        return this.V.getContentDescription();
    }

    public Drawable getEndIconDrawable() {
        return this.V.getDrawable();
    }

    public int getEndIconMode() {
        return this.T;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public CheckableImageButton getEndIconView() {
        return this.V;
    }

    public CharSequence getError() {
        if (this.f6202k.v()) {
            return this.f6202k.m();
        }
        return null;
    }

    public int getErrorCurrentTextColors() {
        return this.f6202k.n();
    }

    public Drawable getErrorIconDrawable() {
        return this.f6195g0.getDrawable();
    }

    final int getErrorTextCurrentColor() {
        return this.f6202k.n();
    }

    public CharSequence getHelperText() {
        if (this.f6202k.w()) {
            return this.f6202k.p();
        }
        return null;
    }

    public int getHelperTextCurrentTextColor() {
        return this.f6202k.q();
    }

    public CharSequence getHint() {
        if (this.f6220t) {
            return this.f6222u;
        }
        return null;
    }

    final float getHintCollapsedTextHeight() {
        return this.f6219s0.m();
    }

    final int getHintCurrentCollapsedTextColor() {
        return this.f6219s0.n();
    }

    public ColorStateList getHintTextColor() {
        return this.f6201j0;
    }

    @Deprecated
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.V.getContentDescription();
    }

    @Deprecated
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.V.getDrawable();
    }

    public CharSequence getStartIconContentDescription() {
        return this.L.getContentDescription();
    }

    public Drawable getStartIconDrawable() {
        return this.L.getDrawable();
    }

    public Typeface getTypeface() {
        return this.K;
    }

    @Override // android.widget.LinearLayout, android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        EditText editText = this.f6198i;
        if (editText != null) {
            Rect rect = this.H;
            com.google.android.material.internal.b.a(this, editText, rect);
            T(rect);
            if (this.f6220t) {
                this.f6219s0.C(n(rect));
                this.f6219s0.J(q(rect));
                this.f6219s0.z();
                if (!w() || this.f6217r0) {
                    return;
                }
                K();
            }
        }
    }

    @Override // android.widget.LinearLayout, android.view.View
    protected void onMeasure(int i10, int i11) {
        super.onMeasure(i10, i11);
        boolean Z = Z();
        boolean a02 = a0();
        if (Z || a02) {
            this.f6198i.post(new c());
        }
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof h)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        h hVar = (h) parcelable;
        super.onRestoreInstanceState(hVar.a());
        setError(hVar.f6236i);
        if (hVar.f6237j) {
            this.V.post(new b());
        }
        requestLayout();
    }

    @Override // android.view.View
    public Parcelable onSaveInstanceState() {
        h hVar = new h(super.onSaveInstanceState());
        if (this.f6202k.k()) {
            hVar.f6236i = getError();
        }
        hVar.f6237j = C() && this.V.isChecked();
        return hVar;
    }

    public void setBoxBackgroundColor(int i10) {
        if (this.G != i10) {
            this.G = i10;
            this.f6209n0 = i10;
            f();
        }
    }

    public void setBoxBackgroundColorResource(int i10) {
        setBoxBackgroundColor(androidx.core.content.a.b(getContext(), i10));
    }

    public void setBoxBackgroundMode(int i10) {
        if (i10 == this.A) {
            return;
        }
        this.A = i10;
        if (this.f6198i != null) {
            J();
        }
    }

    public void setBoxStrokeColor(int i10) {
        if (this.f6207m0 != i10) {
            this.f6207m0 = i10;
            e0();
        }
    }

    public void setCounterEnabled(boolean z9) {
        if (this.f6204l != z9) {
            if (z9) {
                d1 d1Var = new d1(getContext());
                this.f6210o = d1Var;
                d1Var.setId(c6.f.textinput_counter);
                Typeface typeface = this.K;
                if (typeface != null) {
                    this.f6210o.setTypeface(typeface);
                }
                this.f6210o.setMaxLines(1);
                this.f6202k.d(this.f6210o, 2);
                X();
                U();
            } else {
                this.f6202k.x(this.f6210o, 2);
                this.f6210o = null;
            }
            this.f6204l = z9;
        }
    }

    public void setCounterMaxLength(int i10) {
        if (this.f6206m != i10) {
            if (i10 <= 0) {
                i10 = -1;
            }
            this.f6206m = i10;
            if (this.f6204l) {
                U();
            }
        }
    }

    public void setCounterOverflowTextAppearance(int i10) {
        if (this.f6212p != i10) {
            this.f6212p = i10;
            X();
        }
    }

    public void setCounterOverflowTextColor(ColorStateList colorStateList) {
        if (this.f6218s != colorStateList) {
            this.f6218s = colorStateList;
            X();
        }
    }

    public void setCounterTextAppearance(int i10) {
        if (this.f6214q != i10) {
            this.f6214q = i10;
            X();
        }
    }

    public void setCounterTextColor(ColorStateList colorStateList) {
        if (this.f6216r != colorStateList) {
            this.f6216r = colorStateList;
            X();
        }
    }

    public void setDefaultHintTextColor(ColorStateList colorStateList) {
        this.f6199i0 = colorStateList;
        this.f6201j0 = colorStateList;
        if (this.f6198i != null) {
            c0(false);
        }
    }

    @Override // android.view.View
    public void setEnabled(boolean z9) {
        L(this, z9);
        super.setEnabled(z9);
    }

    public void setEndIconActivated(boolean z9) {
        this.V.setActivated(z9);
    }

    public void setEndIconCheckable(boolean z9) {
        this.V.setCheckable(z9);
    }

    public void setEndIconContentDescription(int i10) {
        setEndIconContentDescription(i10 != 0 ? getResources().getText(i10) : null);
    }

    public void setEndIconContentDescription(CharSequence charSequence) {
        if (getEndIconContentDescription() != charSequence) {
            this.V.setContentDescription(charSequence);
        }
    }

    public void setEndIconDrawable(int i10) {
        setEndIconDrawable(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    public void setEndIconDrawable(Drawable drawable) {
        this.V.setImageDrawable(drawable);
    }

    public void setEndIconMode(int i10) {
        int i11 = this.T;
        this.T = i10;
        setEndIconVisible(i10 != 0);
        if (getEndIconDelegate().b(this.A)) {
            getEndIconDelegate().a();
            i();
            y(i11);
            return;
        }
        throw new IllegalStateException("The current box background mode " + this.A + " is not supported by the end icon mode " + i10);
    }

    public void setEndIconOnClickListener(View.OnClickListener onClickListener) {
        O(this.V, onClickListener, this.f6197h0);
    }

    public void setEndIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.f6197h0 = onLongClickListener;
        P(this.V, onLongClickListener);
    }

    public void setEndIconTintList(ColorStateList colorStateList) {
        if (this.f6188a0 != colorStateList) {
            this.f6188a0 = colorStateList;
            this.f6189b0 = true;
            i();
        }
    }

    public void setEndIconTintMode(PorterDuff.Mode mode) {
        if (this.f6190c0 != mode) {
            this.f6190c0 = mode;
            this.f6191d0 = true;
            i();
        }
    }

    public void setEndIconVisible(boolean z9) {
        if (E() != z9) {
            this.V.setVisibility(z9 ? 0 : 4);
            a0();
        }
    }

    public void setError(CharSequence charSequence) {
        if (!this.f6202k.v()) {
            if (TextUtils.isEmpty(charSequence)) {
                return;
            }
            setErrorEnabled(true);
        }
        if (TextUtils.isEmpty(charSequence)) {
            this.f6202k.r();
        } else {
            this.f6202k.J(charSequence);
        }
    }

    public void setErrorEnabled(boolean z9) {
        this.f6202k.z(z9);
    }

    public void setErrorIconDrawable(int i10) {
        setErrorIconDrawable(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    public void setErrorIconDrawable(Drawable drawable) {
        this.f6195g0.setImageDrawable(drawable);
        setErrorIconVisible(drawable != null && this.f6202k.v());
    }

    public void setErrorIconTintList(ColorStateList colorStateList) {
        Drawable drawable = this.f6195g0.getDrawable();
        if (drawable != null) {
            drawable = androidx.core.graphics.drawable.a.r(drawable).mutate();
            androidx.core.graphics.drawable.a.o(drawable, colorStateList);
        }
        if (this.f6195g0.getDrawable() != drawable) {
            this.f6195g0.setImageDrawable(drawable);
        }
    }

    public void setErrorIconTintMode(PorterDuff.Mode mode) {
        Drawable drawable = this.f6195g0.getDrawable();
        if (drawable != null) {
            drawable = androidx.core.graphics.drawable.a.r(drawable).mutate();
            androidx.core.graphics.drawable.a.p(drawable, mode);
        }
        if (this.f6195g0.getDrawable() != drawable) {
            this.f6195g0.setImageDrawable(drawable);
        }
    }

    public void setErrorTextAppearance(int i10) {
        this.f6202k.A(i10);
    }

    public void setErrorTextColor(ColorStateList colorStateList) {
        this.f6202k.B(colorStateList);
    }

    public void setHelperText(CharSequence charSequence) {
        if (TextUtils.isEmpty(charSequence)) {
            if (F()) {
                setHelperTextEnabled(false);
                return;
            }
            return;
        }
        if (!F()) {
            setHelperTextEnabled(true);
        }
        this.f6202k.K(charSequence);
    }

    public void setHelperTextColor(ColorStateList colorStateList) {
        this.f6202k.E(colorStateList);
    }

    public void setHelperTextEnabled(boolean z9) {
        this.f6202k.D(z9);
    }

    public void setHelperTextTextAppearance(int i10) {
        this.f6202k.C(i10);
    }

    public void setHint(CharSequence charSequence) {
        if (this.f6220t) {
            setHintInternal(charSequence);
            sendAccessibilityEvent(2048);
        }
    }

    public void setHintAnimationEnabled(boolean z9) {
        this.f6221t0 = z9;
    }

    public void setHintEnabled(boolean z9) {
        if (z9 != this.f6220t) {
            this.f6220t = z9;
            if (z9) {
                CharSequence hint = this.f6198i.getHint();
                if (!TextUtils.isEmpty(hint)) {
                    if (TextUtils.isEmpty(this.f6222u)) {
                        setHint(hint);
                    }
                    this.f6198i.setHint((CharSequence) null);
                }
                this.f6224v = true;
            } else {
                this.f6224v = false;
                if (!TextUtils.isEmpty(this.f6222u) && TextUtils.isEmpty(this.f6198i.getHint())) {
                    this.f6198i.setHint(this.f6222u);
                }
                setHintInternal(null);
            }
            if (this.f6198i != null) {
                b0();
            }
        }
    }

    public void setHintTextAppearance(int i10) {
        this.f6219s0.D(i10);
        this.f6201j0 = this.f6219s0.l();
        if (this.f6198i != null) {
            c0(false);
            b0();
        }
    }

    public void setHintTextColor(ColorStateList colorStateList) {
        if (this.f6201j0 != colorStateList) {
            if (this.f6199i0 == null) {
                this.f6219s0.E(colorStateList);
            }
            this.f6201j0 = colorStateList;
            if (this.f6198i != null) {
                c0(false);
            }
        }
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(int i10) {
        setPasswordVisibilityToggleContentDescription(i10 != 0 ? getResources().getText(i10) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(CharSequence charSequence) {
        this.V.setContentDescription(charSequence);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(int i10) {
        setPasswordVisibilityToggleDrawable(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(Drawable drawable) {
        this.V.setImageDrawable(drawable);
    }

    @Deprecated
    public void setPasswordVisibilityToggleEnabled(boolean z9) {
        if (z9 && this.T != 1) {
            setEndIconMode(1);
        } else if (z9) {
        } else {
            setEndIconMode(0);
        }
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintList(ColorStateList colorStateList) {
        this.f6188a0 = colorStateList;
        this.f6189b0 = true;
        i();
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintMode(PorterDuff.Mode mode) {
        this.f6190c0 = mode;
        this.f6191d0 = true;
        i();
    }

    public void setStartIconCheckable(boolean z9) {
        this.L.setCheckable(z9);
    }

    public void setStartIconContentDescription(int i10) {
        setStartIconContentDescription(i10 != 0 ? getResources().getText(i10) : null);
    }

    public void setStartIconContentDescription(CharSequence charSequence) {
        if (getStartIconContentDescription() != charSequence) {
            this.L.setContentDescription(charSequence);
        }
    }

    public void setStartIconDrawable(int i10) {
        setStartIconDrawable(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    public void setStartIconDrawable(Drawable drawable) {
        this.L.setImageDrawable(drawable);
        if (drawable != null) {
            setStartIconVisible(true);
            k();
            return;
        }
        setStartIconVisible(false);
        setStartIconOnClickListener(null);
        setStartIconOnLongClickListener(null);
        setStartIconContentDescription((CharSequence) null);
    }

    public void setStartIconOnClickListener(View.OnClickListener onClickListener) {
        O(this.L, onClickListener, this.R);
    }

    public void setStartIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.R = onLongClickListener;
        P(this.L, onLongClickListener);
    }

    public void setStartIconTintList(ColorStateList colorStateList) {
        if (this.M != colorStateList) {
            this.M = colorStateList;
            this.N = true;
            k();
        }
    }

    public void setStartIconTintMode(PorterDuff.Mode mode) {
        if (this.O != mode) {
            this.O = mode;
            this.P = true;
            k();
        }
    }

    public void setStartIconVisible(boolean z9) {
        if (I() != z9) {
            this.L.setVisibility(z9 ? 0 : 8);
            a0();
        }
    }

    public void setTextInputAccessibilityDelegate(e eVar) {
        EditText editText = this.f6198i;
        if (editText != null) {
            r0.n0(editText, eVar);
        }
    }

    public void setTypeface(Typeface typeface) {
        if (typeface != this.K) {
            this.K = typeface;
            this.f6219s0.U(typeface);
            this.f6202k.G(typeface);
            TextView textView = this.f6210o;
            if (textView != null) {
                textView.setTypeface(typeface);
            }
        }
    }
}
