package com.google.android.material.snackbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.core.view.r0;
import c6.k;
import com.google.android.material.internal.f;
/* loaded from: classes.dex */
public abstract class d extends FrameLayout {

    /* renamed from: l  reason: collision with root package name */
    private static final View.OnTouchListener f6177l = new a();

    /* renamed from: g  reason: collision with root package name */
    private c f6178g;

    /* renamed from: h  reason: collision with root package name */
    private b f6179h;

    /* renamed from: i  reason: collision with root package name */
    private int f6180i;

    /* renamed from: j  reason: collision with root package name */
    private final float f6181j;

    /* renamed from: k  reason: collision with root package name */
    private final float f6182k;

    /* loaded from: classes.dex */
    static class a implements View.OnTouchListener {
        a() {
        }

        @Override // android.view.View.OnTouchListener
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return true;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public d(Context context, AttributeSet attributeSet) {
        super(f.f(context, attributeSet, 0, 0), attributeSet);
        TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, k.J2);
        int i10 = k.O2;
        if (obtainStyledAttributes.hasValue(i10)) {
            r0.v0(this, obtainStyledAttributes.getDimensionPixelSize(i10, 0));
        }
        this.f6180i = obtainStyledAttributes.getInt(k.M2, 0);
        this.f6181j = obtainStyledAttributes.getFloat(k.N2, 1.0f);
        this.f6182k = obtainStyledAttributes.getFloat(k.L2, 1.0f);
        obtainStyledAttributes.recycle();
        setOnTouchListener(f6177l);
        setFocusable(true);
    }

    float getActionTextColorAlpha() {
        return this.f6182k;
    }

    int getAnimationMode() {
        return this.f6180i;
    }

    float getBackgroundOverlayColorAlpha() {
        return this.f6181j;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        b bVar = this.f6179h;
        if (bVar != null) {
            bVar.onViewAttachedToWindow(this);
        }
        r0.k0(this);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        b bVar = this.f6179h;
        if (bVar != null) {
            bVar.onViewDetachedFromWindow(this);
        }
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        c cVar = this.f6178g;
        if (cVar != null) {
            cVar.a(this, i10, i11, i12, i13);
        }
    }

    void setAnimationMode(int i10) {
        this.f6180i = i10;
    }

    void setOnAttachStateChangeListener(b bVar) {
        this.f6179h = bVar;
    }

    @Override // android.view.View
    public void setOnClickListener(View.OnClickListener onClickListener) {
        setOnTouchListener(onClickListener != null ? null : f6177l);
        super.setOnClickListener(onClickListener);
    }

    void setOnLayoutChangeListener(c cVar) {
        this.f6178g = cVar;
    }
}
